/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.dom4j.Document;
import org.dom4j.Node;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.databeans.ComponentPropertyDefinition;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.XMLHelper;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.deliver.applications.actions.InfoGlueComponent;
import org.infoglue.deliver.applications.databeans.ComponentBinding;
import org.infoglue.deliver.applications.databeans.ComponentDeliveryContext;
import org.infoglue.deliver.applications.databeans.Slot;
import org.infoglue.deliver.applications.databeans.WebPage;
import org.infoglue.deliver.controllers.kernel.impl.simple.ContentDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.FormDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.InfoGlueHashSet;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.PageEditorHelper;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;
import org.infoglue.deliver.util.Support;
import org.infoglue.deliver.util.Timer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlInfosetBuilder;
import org.xmlpull.v1.builder.xpath.Xb1XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentLogic {
    private static final Logger logger = Logger.getLogger((String)ComponentLogic.class.getName());
    private static final DOMBuilder domBuilder = new DOMBuilder();
    private final String separator = System.getProperty("line.separator");
    private TemplateController templateController = null;
    private InfoGlueComponent infoGlueComponent = null;
    private boolean useInheritance = true;
    private boolean useRepositoryInheritance = true;
    private boolean useStructureInheritance = true;
    private boolean useEditOnSight = true;
    private boolean threatFoldersAsContents = false;
    private ComponentDeliveryContext componentDeliveryContext;
    private static String parser = null;
    Map cachedXPathObjects = new HashMap();
    private static PageEditorHelper pageEditorHelper = new PageEditorHelper();

    public ComponentLogic(TemplateController templateController, InfoGlueComponent infoGlueComponent) {
        this.templateController = templateController;
        this.infoGlueComponent = infoGlueComponent;
        this.componentDeliveryContext = ComponentDeliveryContext.getComponentDeliveryContext(templateController.getDeliveryContext(), infoGlueComponent);
        this.componentDeliveryContext.addUsedContent("content_" + infoGlueComponent.getContentId());
    }

    public List getBoundFolderContents(String propertyName, boolean searchRecursive, String sortAttribute, String sortOrder) throws Exception {
        return this.getBoundFolderContents(propertyName, searchRecursive, sortAttribute, sortOrder, false);
    }

    public List getBoundFolderContents(String propertyName, boolean searchRecursive, String sortAttribute, String sortOrder, boolean includeFolders) throws Exception {
        return this.getBoundFolderContents(propertyName, searchRecursive, sortAttribute, sortOrder, includeFolders, true, true);
    }

    public List getBoundFolderContents(String propertyName, boolean searchRecursive, String sortAttribute, String sortOrder, boolean includeFolders, boolean useRepositoryInheritance) throws Exception {
        return this.getBoundFolderContents(propertyName, searchRecursive, sortAttribute, sortOrder, includeFolders, useRepositoryInheritance, true);
    }

    public List getBoundFolderContents(String propertyName, boolean searchRecursive, String sortAttribute, String sortOrder, boolean includeFolders, boolean useRepositoryInheritance, boolean useStructureInheritance) throws Exception {
        List childContents = new ArrayList();
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, this.useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            childContents = this.templateController.getChildContents(contentId, searchRecursive, sortAttribute, sortOrder, includeFolders);
        }
        return childContents;
    }

    public List getBoundCategoryContents(String categoryAttribute, String typeAttribute) throws Exception {
        Map categoryComponent = this.getInheritedComponentProperty(this.infoGlueComponent, categoryAttribute, this.useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
        Map attributeComponent = this.getInheritedComponentProperty(this.infoGlueComponent, typeAttribute, this.useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
        if (categoryComponent != null && attributeComponent != null) {
            String attr = (String)attributeComponent.get("path");
            Integer categoryId = this.getSingleBindingAsInteger(categoryComponent);
            List contentVersionsByCategory = this.templateController.getContentVersionsByCategory(categoryId, attr);
            return contentVersionsByCategory;
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getAssets(String propertyName, boolean useInheritance, boolean useRepositoryInheritance) throws Exception {
        return this.getAssets(propertyName, useInheritance, useRepositoryInheritance, true);
    }

    public List getContentAssets(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) throws Exception {
        List assets = new ArrayList();
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        assets = this.templateController.getAssets(contentId);
        return assets;
    }

    public List getAssets(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) throws Exception {
        ArrayList<DigitalAssetVO> assets = new ArrayList<DigitalAssetVO>();
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        if (property != null) {
            List bindings = (List)property.get("bindings");
            for (ComponentBinding componentBinding : bindings) {
                Integer boundContentId = componentBinding.getEntityId();
                String assetKey = componentBinding.getAssetKey();
                if (assetKey != null && !assetKey.equals("")) {
                    assets.add(this.templateController.getAsset(boundContentId, assetKey));
                    continue;
                }
                assets.addAll(this.templateController.getAssets(boundContentId));
            }
        }
        return assets;
    }

    public Collection getAssetUrls(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) throws Exception {
        ArrayList<String> assetUrls = new ArrayList<String>();
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        if (property != null) {
            List bindings = (List)property.get("bindings");
            for (ComponentBinding componentBinding : bindings) {
                Integer boundContentId = componentBinding.getEntityId();
                String assetKey = componentBinding.getAssetKey();
                if (assetKey != null && !assetKey.equals("")) {
                    assetUrls.add(this.templateController.getAssetUrl(boundContentId, assetKey));
                    continue;
                }
                assetUrls.addAll(this.templateController.getAssetUrls(boundContentId));
            }
        }
        return assetUrls;
    }

    public String getAssetUrl(String propertyName) throws Exception {
        String assetUrl = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, this.useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
        Integer contentId = this.getContentId(property);
        String assetKey = this.getAssetKey(property);
        if (contentId != null && (assetKey == null || "".equals(assetKey))) {
            assetUrl = this.templateController.getAssetUrl(contentId);
        } else if (contentId != null) {
            assetUrl = this.templateController.getAssetUrl(contentId, assetKey);
        }
        return assetUrl;
    }

    public String getAssetUrl(String propertyName, boolean useInheritance) throws Exception {
        return this.getAssetUrl(propertyName, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getAssetUrl(String propertyName, boolean useInheritance, boolean useRepositoryInheritance) throws Exception {
        return this.getAssetUrl(propertyName, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getAssetUrl(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) throws Exception {
        String assetUrl = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        String assetKey = this.getAssetKey(property);
        if (contentId != null && (assetKey == null || assetKey.equals(""))) {
            assetUrl = this.templateController.getAssetUrl(contentId);
        } else if (contentId != null) {
            assetUrl = this.templateController.getAssetUrl(contentId, assetKey);
        }
        return assetUrl;
    }

    public String getAssetUrl(String propertyName, String assetKey) throws Exception {
        String assetUrl = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, this.useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            assetUrl = this.templateController.getAssetUrl(contentId, assetKey);
        }
        return assetUrl;
    }

    public String getAssetUrl(String propertyName, String assetKey, boolean useInheritance) throws Exception {
        return this.getAssetUrl(propertyName, assetKey, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getAssetUrl(String propertyName, String assetKey, boolean useInheritance, boolean useRepositoryInheritance) throws Exception {
        return this.getAssetUrl(propertyName, assetKey, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getAssetUrl(String propertyName, String assetKey, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) throws Exception {
        String assetUrl = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            assetUrl = this.templateController.getAssetUrl(contentId, assetKey);
        }
        return assetUrl;
    }

    public String getAssetThumbnailUrl(String propertyName, int width, int height) throws Exception {
        return this.getAssetThumbnailUrl(propertyName, width, height, this.useInheritance, this.useStructureInheritance);
    }

    public String getAssetThumbnailUrl(String propertyName, int width, int height, boolean useInheritance) throws Exception {
        return this.getAssetThumbnailUrl(propertyName, width, height, useInheritance, this.useStructureInheritance);
    }

    public String getAssetThumbnailUrl(String propertyName, int width, int height, boolean useInheritance, boolean useStructureInheritance) throws Exception {
        return this.getAssetThumbnailUrl(propertyName, width, height, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getAssetThumbnailUrl(String propertyName, int width, int height, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) throws Exception {
        String assetUrl = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            assetUrl = this.templateController.getAssetThumbnailUrl(contentId, width, height);
        }
        return assetUrl;
    }

    public String getAssetThumbnailUrl(String propertyName, String assetKey, int width, int height) throws Exception {
        return this.getAssetThumbnailUrl(propertyName, assetKey, width, height, this.useInheritance);
    }

    public String getAssetThumbnailUrl(String propertyName, String assetKey, int width, int height, boolean useInheritance) throws Exception {
        return this.getAssetThumbnailUrl(propertyName, assetKey, width, height, useInheritance, true, true);
    }

    public String getAssetThumbnailUrl(String propertyName, String assetKey, int width, int height, boolean useInheritance, boolean useRepositoryInheritance) throws Exception {
        return this.getAssetThumbnailUrl(propertyName, assetKey, width, height, useInheritance, useRepositoryInheritance, true);
    }

    public String getAssetThumbnailUrl(String propertyName, String assetKey, int width, int height, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) throws Exception {
        String assetUrl = "";
        try {
            Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
            Integer contentId = this.getContentId(property);
            if (contentId != null) {
                assetUrl = this.templateController.getAssetThumbnailUrl(contentId, assetKey, width, height);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return assetUrl;
    }

    public String getAssetThumbnailUrl(Integer contentId, int width, int height) throws Exception {
        String assetUrl = this.templateController.getAssetThumbnailUrl(contentId, width, height);
        return assetUrl;
    }

    public String getAssetThumbnailUrl(Integer contentId, String assetKey, int width, int height) throws Exception {
        String assetUrl = this.templateController.getAssetThumbnailUrl(contentId, assetKey, width, height);
        return assetUrl;
    }

    public String getAssetUrl(Integer contentId, String assetKey) {
        String assetUrl = this.templateController.getAssetUrl(contentId, assetKey);
        return assetUrl;
    }

    public String getContentAttribute(String propertyName, String attributeName) {
        return this.getContentAttribute(propertyName, attributeName, !this.useEditOnSight, this.useInheritance);
    }

    public String getContentAttribute(String propertyName, String attributeName, boolean disableEditOnSight) {
        return this.getContentAttribute(propertyName, attributeName, disableEditOnSight, this.useInheritance);
    }

    public List getAssignedCategories(String propertyName, String categoryKey, Integer languageId, boolean useInheritance, boolean useLanguageFallback) {
        return this.getAssignedCategories(propertyName, categoryKey, languageId, useInheritance, useLanguageFallback, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getAssignedCategories(String propertyName, String categoryKey, Integer languageId, boolean useInheritance, boolean useLanguageFallback, boolean useRepositoryInheritance) {
        return this.getAssignedCategories(propertyName, categoryKey, languageId, useInheritance, useLanguageFallback, useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getAssignedCategories(String propertyName, String categoryKey, Integer languageId, boolean useInheritance, boolean useLanguageFallback, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        List assignedCategories = new ArrayList();
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            assignedCategories = this.templateController.getAssignedCategories(contentId, categoryKey, languageId, useLanguageFallback);
        }
        return assignedCategories;
    }

    public String getContentAttribute(String propertyName, String attributeName, boolean disableEditOnSight, boolean useInheritance) {
        return this.getContentAttribute(propertyName, attributeName, disableEditOnSight, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getContentAttribute(String propertyName, String attributeName, boolean disableEditOnSight, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getContentAttribute(propertyName, attributeName, disableEditOnSight, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getContentAttribute(String propertyName, String attributeName, boolean disableEditOnSight, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        String attributeValue = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            attributeValue = disableEditOnSight ? this.templateController.getContentAttribute(contentId, attributeName, disableEditOnSight) : this.templateController.getContentAttribute(contentId, attributeName);
        }
        return attributeValue;
    }

    public String getContentAttribute(String propertyName, Integer languageId, String attributeName, boolean disableEditOnSight, boolean useInheritance) {
        return this.getContentAttribute(propertyName, languageId, attributeName, disableEditOnSight, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getContentAttribute(String propertyName, Integer languageId, String attributeName, boolean disableEditOnSight, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getContentAttribute(propertyName, languageId, attributeName, disableEditOnSight, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getContentAttribute(String propertyName, Integer languageId, String attributeName, boolean disableEditOnSight, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        String attributeValue = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            attributeValue = this.templateController.getContentAttribute(contentId, languageId, attributeName, disableEditOnSight);
        }
        return attributeValue;
    }

    public String getParsedContentAttribute(String propertyName, String attributeName) {
        return this.getParsedContentAttribute(propertyName, attributeName, !this.useEditOnSight, this.useInheritance);
    }

    public String getParsedContentAttribute(String propertyName, String attributeName, boolean disableEditOnSight, boolean useInheritance) {
        return this.getParsedContentAttribute(propertyName, attributeName, disableEditOnSight, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getParsedContentAttribute(String propertyName, String attributeName, boolean disableEditOnSight, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getParsedContentAttribute(propertyName, attributeName, disableEditOnSight, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getParsedContentAttribute(String propertyName, String attributeName, boolean disableEditOnSight, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        String attributeValue = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            attributeValue = this.templateController.getParsedContentAttribute(contentId, attributeName, disableEditOnSight);
        }
        return attributeValue;
    }

    public String getParsedContentAttribute(String propertyName, Integer languageId, String attributeName, boolean disableEditOnSight, boolean useInheritance) {
        return this.getParsedContentAttribute(propertyName, languageId, attributeName, disableEditOnSight, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getParsedContentAttribute(String propertyName, Integer languageId, String attributeName, boolean disableEditOnSight, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getParsedContentAttribute(propertyName, languageId, attributeName, disableEditOnSight, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getParsedContentAttribute(String propertyName, Integer languageId, String attributeName, boolean disableEditOnSight, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        String attributeValue = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            attributeValue = this.templateController.getParsedContentAttribute(contentId, languageId, attributeName, disableEditOnSight);
        }
        return attributeValue;
    }

    public List getFormAttributes(String propertyName, String attributeName) {
        return this.getFormAttributes(propertyName, attributeName, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getFormAttributes(String propertyName, String attributeName, boolean useRepositoryInheritance) {
        return this.getFormAttributes(propertyName, attributeName, useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getFormAttributes(String propertyName, String attributeName, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        List formAttributes = new ArrayList();
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, this.useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            String formDefinition = this.templateController.getContentAttribute(contentId, attributeName, true);
            formAttributes = FormDeliveryController.getFormDeliveryController().getContentTypeAttributes(formDefinition);
        }
        return formAttributes;
    }

    public String getPropertyValue(String propertyName) throws SystemException {
        return this.getPropertyValue(propertyName, true);
    }

    public String getPropertyValue(String propertyName, boolean useLangaugeFallback) throws SystemException {
        return this.getPropertyValue(propertyName, useLangaugeFallback, this.useInheritance);
    }

    public String getPropertyValue(String propertyName, boolean useLangaugeFallback, boolean useInheritance) throws SystemException {
        return this.getPropertyValue(propertyName, useLangaugeFallback, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPropertyValue(String propertyName, boolean useLangaugeFallback, boolean useInheritance, boolean useRepositoryInheritance) throws SystemException {
        return this.getPropertyValue(propertyName, useLangaugeFallback, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPropertyValue(String propertyName, boolean useLangaugeFallback, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) throws SystemException {
        String propertyValue = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        if (property != null && property != null) {
            propertyValue = (String)property.get("path");
        }
        if (propertyValue == null || propertyValue.equals("")) {
            try {
                ContentVO contentVO = this.templateController.getContent(this.infoGlueComponent.getContentId());
                LanguageVO masterLanguage = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(this.templateController.getDatabase(), contentVO.getRepositoryId());
                ComponentPropertyDefinition propertyDefinition = this.getComponentPropertyDefinition(this.infoGlueComponent.getContentId(), propertyName, this.templateController.getSiteNodeId(), masterLanguage.getId(), this.templateController.getContentId(), this.templateController.getDatabase(), this.templateController.getPrincipal());
                if (propertyDefinition != null) {
                    propertyValue = propertyDefinition.getDefaultValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (propertyValue != null) {
            propertyValue = propertyValue.replaceAll("igbr", this.separator);
        }
        return propertyValue;
    }

    public String getPropertyValue(String propertyName, boolean useLangaugeFallback, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance, boolean useComponentInheritance, InfoGlueComponent component) throws SystemException {
        String propertyValue = "";
        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), this.templateController.getLanguageId());
        Map property = this.getInheritedComponentProperty(component, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance, useComponentInheritance);
        if (property != null && property != null && (propertyValue = (String)property.get("path")) == null) {
            for (String string : property.keySet()) {
            }
        }
        if (propertyValue == null || propertyValue.equals("")) {
            try {
                ContentVO contentVO = this.templateController.getContent(component.getContentId());
                LanguageVO masterLanguage = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(this.templateController.getDatabase(), contentVO.getRepositoryId());
                ComponentPropertyDefinition propertyDefinition = this.getComponentPropertyDefinition(component.getContentId(), propertyName, this.templateController.getSiteNodeId(), masterLanguage.getId(), this.templateController.getContentId(), this.templateController.getDatabase(), this.templateController.getPrincipal());
                if (propertyDefinition != null) {
                    propertyValue = propertyDefinition.getDefaultValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (propertyValue != null) {
            propertyValue = propertyValue.replaceAll("igbr", this.separator);
        }
        return propertyValue;
    }

    public String getPropertyValue(Integer siteNodeId, String propertyName, boolean useLangaugeFallback, boolean useInheritance) throws SystemException {
        String propertyValue = "";
        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), this.templateController.getLanguageId());
        Map property = this.getInheritedComponentProperty(siteNodeId, this.infoGlueComponent, propertyName, useInheritance);
        if (property != null && property != null && (propertyValue = (String)property.get("path")) == null) {
            for (String string : property.keySet()) {
            }
        }
        if (propertyValue == null || propertyValue.equals("")) {
            try {
                ContentVO contentVO = this.templateController.getContent(this.infoGlueComponent.getContentId());
                LanguageVO masterLanguage = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(this.templateController.getDatabase(), contentVO.getRepositoryId());
                ComponentPropertyDefinition propertyDefinition = this.getComponentPropertyDefinition(this.infoGlueComponent.getContentId(), propertyName, this.templateController.getSiteNodeId(), masterLanguage.getId(), this.templateController.getContentId(), this.templateController.getDatabase(), this.templateController.getPrincipal());
                if (propertyDefinition != null) {
                    propertyValue = propertyDefinition.getDefaultValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (propertyValue != null) {
            propertyValue = propertyValue.replaceAll("igbr", this.separator);
        }
        return propertyValue;
    }

    public String getPropertyValue(Integer siteNodeId, String propertyName, boolean useLangaugeFallback, boolean useInheritance, InfoGlueComponent component) throws SystemException {
        String propertyValue = "";
        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), this.templateController.getLanguageId());
        Map property = this.getInheritedComponentProperty(siteNodeId, component, propertyName, useInheritance);
        if (property != null && property != null && (propertyValue = (String)property.get("path")) == null) {
            for (String string : property.keySet()) {
            }
        }
        if (propertyValue == null || propertyValue.equals("")) {
            try {
                ContentVO contentVO = this.templateController.getContent(component.getContentId());
                LanguageVO masterLanguage = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(this.templateController.getDatabase(), contentVO.getRepositoryId());
                ComponentPropertyDefinition propertyDefinition = this.getComponentPropertyDefinition(component.getContentId(), propertyName, this.templateController.getSiteNodeId(), masterLanguage.getId(), this.templateController.getContentId(), this.templateController.getDatabase(), this.templateController.getPrincipal());
                if (propertyDefinition != null) {
                    propertyValue = propertyDefinition.getDefaultValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (propertyValue != null) {
            propertyValue = propertyValue.replaceAll("igbr", this.separator);
        }
        return propertyValue;
    }

    public ContentVO getBoundContent(String propertyName) {
        return this.getBoundContent(propertyName, true);
    }

    public ContentVO getBoundContent(String propertyName, boolean useInheritance) {
        return this.getBoundContent(propertyName, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public ContentVO getBoundContent(String propertyName, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getBoundContent(propertyName, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public ContentVO getBoundContent(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        ContentVO content = null;
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            content = this.templateController.getContent(contentId);
        }
        return content;
    }

    public ContentVO getBoundContentWithDetailSiteNodeId(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        ContentVO content = null;
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Map detailSiteNodeIdProperty = this.getInheritedComponentProperty(this.infoGlueComponent, String.valueOf(propertyName) + "_detailSiteNodeId", useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            content = this.templateController.getContent(contentId);
        }
        if (detailSiteNodeIdProperty != null && detailSiteNodeIdProperty.get("path") != null && !detailSiteNodeIdProperty.get("path").equals("Undefined")) {
            content.getExtraProperties().put("detailSiteNodeId", new Integer((String)detailSiteNodeIdProperty.get("path")));
        }
        return content;
    }

    public ContentVO getBoundContent(Integer siteNodeId, String propertyName, boolean useInheritance) {
        ContentVO content = null;
        Map property = this.getInheritedComponentProperty(siteNodeId, this.infoGlueComponent, propertyName, useInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            content = this.templateController.getContent(contentId);
        }
        return content;
    }

    public ContentVO getBoundContentWithDetailSiteNodeId(Integer siteNodeId, String propertyName, boolean useInheritance) {
        ContentVO content = null;
        Map property = this.getInheritedComponentProperty(siteNodeId, this.infoGlueComponent, propertyName, useInheritance);
        Map detailSiteNodeIdProperty = this.getInheritedComponentProperty(this.infoGlueComponent, String.valueOf(propertyName) + "_detailSiteNodeId", useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            content = this.templateController.getContent(contentId);
        }
        if (detailSiteNodeIdProperty != null && detailSiteNodeIdProperty.get("path") != null && !detailSiteNodeIdProperty.get("path").equals("Undefined")) {
            content.getExtraProperties().put("detailSiteNodeId", new Integer((String)detailSiteNodeIdProperty.get("path")));
        }
        return content;
    }

    public List<ContentVO> getBoundContents(Integer siteNodeId, String propertyName, boolean useInheritance) {
        ArrayList<ContentVO> contents = new ArrayList();
        Map property = this.getInheritedComponentProperty(siteNodeId, this.infoGlueComponent, propertyName, useInheritance);
        contents = this.getBoundContents(property);
        return contents;
    }

    public Integer getBoundContentId(String propertyName) {
        return this.getBoundContentId(propertyName, true);
    }

    public Integer getBoundContentId(String propertyName, boolean useInheritance) {
        return this.getBoundContentId(propertyName, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public Integer getBoundContentId(String propertyName, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getBoundContentId(propertyName, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public Integer getBoundContentId(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        Integer contentId = null;
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        contentId = this.getContentId(property);
        return contentId;
    }

    public List getBoundContents(String propertyName) {
        return this.getBoundContents(propertyName, this.useInheritance);
    }

    public List getBoundContents(String propertyName, boolean useInheritance) {
        return this.getBoundContents(propertyName, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getBoundContents(String propertyName, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getBoundContents(propertyName, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getBoundContents(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        List<Object> contents = new ArrayList();
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        contents = this.getBoundContents(property);
        return contents;
    }

    public List getChildContents(String propertyName) {
        return this.getChildContents(propertyName, this.useInheritance, false, "id", "asc", false);
    }

    public List getChildContents(String propertyName, boolean useInheritance, boolean searchRecursive, String sortAttribute, String sortOrder, boolean includeFolders) {
        return this.getChildContents(propertyName, useInheritance, searchRecursive, sortAttribute, sortOrder, includeFolders, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getChildContents(String propertyName, boolean useInheritance, boolean searchRecursive, String sortAttribute, String sortOrder, boolean includeFolders, boolean useRepositoryInheritance) {
        return this.getChildContents(propertyName, useInheritance, searchRecursive, sortAttribute, sortOrder, includeFolders, useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getChildContents(String propertyName, boolean useInheritance, boolean searchRecursive, String sortAttribute, String sortOrder, boolean includeFolders, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        ArrayList childContents = new ArrayList();
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        if (property != null) {
            List bindings = (List)property.get("bindings");
            Iterator bindingsIterator = bindings.iterator();
            while (bindingsIterator.hasNext()) {
                Integer contentId = ((ComponentBinding)bindingsIterator.next()).getEntityId();
                childContents.addAll(this.templateController.getChildContents(contentId, searchRecursive, sortAttribute, sortOrder, includeFolders));
            }
        }
        return childContents;
    }

    public WebPage getBoundPage(String propertyName) {
        return this.getBoundPage(propertyName, this.useInheritance);
    }

    public WebPage getBoundPage(String propertyName, boolean useInheritance) {
        return this.getBoundPage(propertyName, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public WebPage getBoundPage(String propertyName, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getBoundPage(propertyName, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public WebPage getBoundPage(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        WebPage webPage = null;
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        webPage = this.getBoundPage(property);
        return webPage;
    }

    public List getBoundPages(String propertyName) {
        return this.getBoundPages(propertyName, this.useInheritance);
    }

    public List getBoundPages(String propertyName, boolean useInheritance) {
        return this.getBoundPages(propertyName, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getBoundPages(String propertyName, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getBoundPages(propertyName, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getBoundPages(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        List pages = new ArrayList();
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        pages = this.getBoundPages(property);
        return pages;
    }

    public SiteNodeVO getBoundSiteNode(String propertyName, boolean useInheritance) {
        return this.getBoundSiteNode(propertyName, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public SiteNodeVO getBoundSiteNode(String propertyName, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getBoundSiteNode(propertyName, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public SiteNodeVO getBoundSiteNode(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        SiteNodeVO siteNodeVO = null;
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer siteNodeId = this.getSiteNodeId(property);
        if (siteNodeId != null) {
            siteNodeVO = this.templateController.getSiteNode(siteNodeId);
        }
        return siteNodeVO;
    }

    public SiteNodeVO getBoundSiteNode(Integer targetSiteNodeId, String propertyName, boolean useInheritance) {
        SiteNodeVO siteNodeVO = null;
        Map property = this.getInheritedComponentProperty(targetSiteNodeId, this.infoGlueComponent, propertyName, useInheritance);
        Integer siteNodeId = this.getSiteNodeId(property);
        if (siteNodeId != null) {
            siteNodeVO = this.templateController.getSiteNode(siteNodeId);
        }
        return siteNodeVO;
    }

    public List<SiteNodeVO> getBoundSiteNodes(Integer targetSiteNodeId, String propertyName, boolean useInheritance) {
        ArrayList<SiteNodeVO> siteNodeVOList = new ArrayList();
        Map property = this.getInheritedComponentProperty(targetSiteNodeId, this.infoGlueComponent, propertyName, useInheritance);
        siteNodeVOList = this.getBoundSiteNodes(property);
        return siteNodeVOList;
    }

    public List getChildPages(String propertyName) {
        return this.getChildPages(propertyName, this.useInheritance);
    }

    public List getChildPages(String propertyName, boolean useInheritance) {
        return this.getChildPages(propertyName, useInheritance, false, false);
    }

    public List getChildPages(String propertyName, boolean useInheritance, boolean escapeHTML) {
        return this.getChildPages(propertyName, this.useInheritance, escapeHTML, false);
    }

    public List getChildPages(String propertyName, boolean useInheritance, boolean escapeHTML, boolean hideUnauthorizedPages) {
        return this.getChildPages(propertyName, useInheritance, escapeHTML, hideUnauthorizedPages, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getChildPages(String propertyName, boolean useInheritance, boolean escapeHTML, boolean hideUnauthorizedPages, boolean useRepositoryInheritance) {
        return this.getChildPages(propertyName, useInheritance, escapeHTML, hideUnauthorizedPages, useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getChildPages(String propertyName, boolean useInheritance, boolean escapeHTML, boolean hideUnauthorizedPages, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        ArrayList childPages = new ArrayList();
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        if (property != null) {
            List bindings = (List)property.get("bindings");
            Iterator bindingsIterator = bindings.iterator();
            while (bindingsIterator.hasNext()) {
                Integer siteNodeId = ((ComponentBinding)bindingsIterator.next()).getEntityId();
                childPages.addAll(this.getChildPages(siteNodeId));
            }
        }
        return childPages;
    }

    public List getChildPages(Integer siteNodeId) {
        List pages = this.templateController.getChildPages(siteNodeId);
        for (WebPage webPage : pages) {
            webPage.setUrl(this.getPageUrl(webPage.getSiteNodeId()));
        }
        return pages;
    }

    public String getPageUrl(String propertyName) throws Exception {
        return this.getPageUrl(propertyName, this.useInheritance);
    }

    public String getPageUrl(String propertyName, boolean useInheritance) {
        return this.getPageUrl(propertyName, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageUrl(String propertyName, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getPageUrl(propertyName, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageUrl(String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        String pageUrl = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer siteNodeId = this.getSiteNodeId(property);
        if (siteNodeId != null) {
            pageUrl = this.getPageUrl(siteNodeId, this.templateController.getLanguageId(), this.templateController.getContentId());
        }
        return pageUrl;
    }

    public String getPageUrl(Integer siteNodeId) {
        String pageUrl = "";
        pageUrl = this.getPageUrl(siteNodeId, this.templateController.getLanguageId(), null);
        return pageUrl;
    }

    public String getPageUrl(String propertyName, Integer contentId) {
        return this.getPageUrl(propertyName, contentId, this.useInheritance);
    }

    public String getPageUrl(String propertyName, Integer contentId, boolean useInheritance) {
        return this.getPageUrl(propertyName, contentId, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageUrl(String propertyName, Integer contentId, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getPageUrl(propertyName, contentId, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageUrl(String propertyName, Integer contentId, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        String pageUrl = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer siteNodeId = this.getSiteNodeId(property);
        if (siteNodeId != null) {
            pageUrl = this.getPageUrl(siteNodeId, this.templateController.getLanguageId(), contentId);
        }
        return pageUrl;
    }

    public String getPageUrl(String propertyName, Integer contentId, Integer languageId, boolean useInheritance) {
        return this.getPageUrl(propertyName, contentId, languageId, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageUrl(String propertyName, Integer contentId, Integer languageId, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getPageUrl(propertyName, contentId, languageId, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageUrl(String propertyName, Integer contentId, Integer languageId, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        String pageUrl = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer siteNodeId = this.getSiteNodeId(property);
        if (siteNodeId != null) {
            pageUrl = this.getPageUrl(siteNodeId, languageId, contentId);
        }
        return pageUrl;
    }

    public String getPageAsDigitalAssetUrl(String propertyName) throws Exception {
        return this.getPageAsDigitalAssetUrl(propertyName, this.useInheritance, "");
    }

    public String getPageAsDigitalAssetUrl(String propertyName, boolean useInheritance, String fileSuffix) {
        return this.getPageAsDigitalAssetUrl(propertyName, useInheritance, fileSuffix, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageAsDigitalAssetUrl(String propertyName, boolean useInheritance, String fileSuffix, boolean useRepositoryInheritance) {
        return this.getPageAsDigitalAssetUrl(propertyName, useInheritance, fileSuffix, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageAsDigitalAssetUrl(String propertyName, boolean useInheritance, String fileSuffix, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        String pageUrl = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer siteNodeId = this.getSiteNodeId(property);
        if (siteNodeId != null) {
            pageUrl = this.getPageAsDigitalAssetUrl(siteNodeId, this.templateController.getLanguageId(), this.templateController.getContentId(), fileSuffix);
        }
        return pageUrl;
    }

    public String getPageAsDigitalAssetUrl(String propertyName, Integer languageId, Integer contentId, boolean useInheritance, String fileSuffix, boolean cacheUrl) {
        return this.getPageAsDigitalAssetUrl(propertyName, languageId, contentId, useInheritance, fileSuffix, cacheUrl, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageAsDigitalAssetUrl(String propertyName, Integer languageId, Integer contentId, boolean useInheritance, String fileSuffix, boolean cacheUrl, boolean useRepositoryInheritance) {
        return this.getPageAsDigitalAssetUrl(propertyName, languageId, contentId, useInheritance, fileSuffix, cacheUrl, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageAsDigitalAssetUrl(String propertyName, Integer languageId, Integer contentId, boolean useInheritance, String fileSuffix, boolean cacheUrl, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        String pageUrl = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer siteNodeId = this.getSiteNodeId(property);
        if (siteNodeId != null) {
            pageUrl = this.getPageAsDigitalAssetUrl(siteNodeId, languageId, contentId, fileSuffix, cacheUrl);
        }
        return pageUrl;
    }

    public String getPageAsDigitalAssetUrl(Integer siteNodeId, Integer languageId, Integer contentId, String fileSuffix) {
        String pageUrl = this.getPageAsDigitalAssetUrl(siteNodeId, languageId, contentId, fileSuffix, true);
        return pageUrl;
    }

    public String getPageAsDigitalAssetUrl(Integer siteNodeId, Integer languageId, Integer contentId, String fileSuffix, boolean cacheUrl) {
        String pageUrl = this.templateController.getPageAsDigitalAssetUrl(siteNodeId, languageId, contentId, fileSuffix, cacheUrl);
        return pageUrl;
    }

    public String getPageNavTitle(String propertyName) {
        return this.getPageNavTitle(propertyName, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageNavTitle(String propertyName, boolean useRepositoryInheritance) {
        return this.getPageNavTitle(propertyName, useRepositoryInheritance, this.useStructureInheritance);
    }

    public String getPageNavTitle(String propertyName, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        String pageUrl = "";
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, this.useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer siteNodeId = this.getSiteNodeId(property);
        if (siteNodeId != null) {
            pageUrl = this.templateController.getPageNavTitle(siteNodeId);
        }
        return pageUrl;
    }

    public List getRelatedPages(String propertyName, String attributeName) {
        return this.getRelatedPages(propertyName, attributeName, this.useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getRelatedPages(String propertyName, String attributeName, boolean useInheritance) {
        return this.getRelatedPages(propertyName, attributeName, useInheritance, this.useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getRelatedPages(String propertyName, String attributeName, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getRelatedPages(propertyName, attributeName, useInheritance, useRepositoryInheritance, this.useStructureInheritance);
    }

    public List getRelatedPages(String propertyName, String attributeName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        List relatedPages = new ArrayList();
        Map property = this.getInheritedComponentProperty(this.infoGlueComponent, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance);
        Integer contentId = this.getContentId(property);
        if (contentId != null) {
            relatedPages = this.templateController.getRelatedPages(contentId, attributeName);
        }
        return relatedPages;
    }

    public Map AgetInheritedComponentProperty(InfoGlueComponent component, String propertyName, boolean useInheritance, boolean useRepositoryInheritance) {
        return this.getInheritedComponentProperty(component, propertyName, useInheritance, useRepositoryInheritance, true);
    }

    public Map getInheritedComponentProperty(InfoGlueComponent component, String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance) {
        return this.getInheritedComponentProperty(component, propertyName, useInheritance, useRepositoryInheritance, useStructureInheritance, true);
    }

    public Map getInheritedComponentProperty(InfoGlueComponent component, String propertyName, boolean useInheritance, boolean useRepositoryInheritance, boolean useStructureInheritance, boolean useComponentInheritance) {
        Map property = null;
        InfoGlueHashSet contentVersionIdList = new InfoGlueHashSet();
        if (this.templateController.getDeliveryContext().getUsedPageMetaInfoContentVersionIdSet().size() > 0) {
            contentVersionIdList.addAll(this.templateController.getDeliveryContext().getUsedPageMetaInfoContentVersionIdSet());
        }
        try {
            String key = this.templateController.getSiteNodeId() + "_" + this.templateController.getLanguageId() + "_" + component.getName() + "_" + component.getSlotName() + "_" + component.getContentId() + "_" + component.getId() + "_" + component.getIsInherited() + "_" + propertyName + "_" + useInheritance + "_" + useRepositoryInheritance + "_" + useStructureInheritance + "_" + useComponentInheritance;
            String versionKey = String.valueOf(key) + "_contentVersionIds";
            Object propertyCandidate = CacheController.getCachedObjectFromAdvancedCache("componentPropertyCache", key);
            Set propertyCandidateVersions = (Set)CacheController.getCachedObjectFromAdvancedCache("componentPropertyCache", versionKey);
            if (propertyCandidate != null) {
                property = propertyCandidate instanceof NullObject ? null : (Map)propertyCandidate;
                if (propertyCandidateVersions != null) {
                    contentVersionIdList.addAll(propertyCandidateVersions);
                }
            } else {
                property = this.getComponentProperty(propertyName, useInheritance, useStructureInheritance, contentVersionIdList, useRepositoryInheritance);
                if (property == null) {
                    property = (Map)component.getProperties().get(propertyName);
                    InfoGlueComponent parentComponent = component.getParentComponent();
                    while (property == null && parentComponent != null && useComponentInheritance) {
                        property = (Map)parentComponent.getProperties().get(propertyName);
                        parentComponent = parentComponent.getParentComponent();
                    }
                }
                InfoGlueHashSet groups = new InfoGlueHashSet();
                for (Integer contentVersionId : contentVersionIdList) {
                    ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId, this.templateController.getDatabase());
                    groups.add("contentVersion_" + contentVersionId);
                    groups.add("content_" + contentVersion.getValueObject().getContentId());
                }
                CacheController.cacheObjectInAdvancedCacheWithGroupsAsSet("componentPropertyCache", key, property, groups, true);
                CacheController.cacheObjectInAdvancedCacheWithGroupsAsSet("componentPropertyCache", versionKey, contentVersionIdList, groups, true);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Error getting property:" + propertyName), (Throwable)e);
        }
        for (Integer currentContentVersionId : contentVersionIdList) {
            this.templateController.getDeliveryContext().addUsedContentVersion("contentVersion_" + currentContentVersionId);
        }
        return property;
    }

    public Map getInheritedComponentProperty(Integer siteNodeId, InfoGlueComponent component, String propertyName, boolean useInheritance) {
        try {
            Map property1 = this.getComponentProperty(siteNodeId, propertyName, useInheritance);
            if (property1 != null) {
                return property1;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List getInheritedComponentProperties(String propertyName, boolean useInheritance) {
        return this.getInheritedComponentProperties(this.templateController.getSiteNodeId(), propertyName, useInheritance);
    }

    public List getInheritedComponentProperties(String propertyName, boolean useInheritance, boolean skipRepositoryInheritance) {
        return this.getInheritedComponentProperties(this.templateController.getSiteNodeId(), propertyName, useInheritance, skipRepositoryInheritance);
    }

    public List getInheritedComponentProperties(Integer siteNodeId, String propertyName, boolean useInheritance) {
        return this.getInheritedComponentProperties(siteNodeId, propertyName, useInheritance, false);
    }

    public List getInheritedComponentProperties(Integer siteNodeId, String propertyName, boolean useInheritance, boolean skipRepositoryInheritance) {
        try {
            List properties = this.getComponentProperties(siteNodeId, propertyName, useInheritance, skipRepositoryInheritance);
            if (properties != null) {
                return properties;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getHasDefinedProperty(Integer siteNodeId, Integer languageId, String propertyName, boolean useInheritance) {
        Map property = this.getComponentProperty(siteNodeId, languageId, propertyName, useInheritance);
        return property != null;
    }

    public Map getComponentProperty(Integer siteNodeId, Integer languageId, String propertyName, boolean useInheritance) {
        Map componentProperty = this.getComponentProperty(siteNodeId, languageId, propertyName);
        SiteNodeVO parentSiteNodeVO = this.templateController.getParentSiteNode(siteNodeId);
        while (componentProperty == null && useInheritance && parentSiteNodeVO != null) {
            componentProperty = this.getComponentProperty(parentSiteNodeVO.getId(), languageId, propertyName);
            parentSiteNodeVO = this.templateController.getParentSiteNode(parentSiteNodeVO.getId());
        }
        return componentProperty;
    }

    public Map getComponentProperty(Integer siteNodeId, Integer languageId, String propertyName) {
        HashMap<String, Object> property = null;
        InfoGlueHashSet contentVersionIdList = new InfoGlueHashSet();
        try {
            String componentPropertiesXML = this.getPageComponentsString(this.templateController, siteNodeId, languageId, new Integer(-1), contentVersionIdList);
            String key = siteNodeId + "_" + languageId + "_" + propertyName;
            String versionKey = String.valueOf(key) + "_contentVersionIds";
            Object propertyCandidate = CacheController.getCachedObjectFromAdvancedCache("componentPropertyCache", key);
            Set propertyCandidateVersions = (Set)CacheController.getCachedObjectFromAdvancedCache("componentPropertyCache", versionKey);
            if (propertyCandidate != null) {
                property = propertyCandidate instanceof NullObject ? null : (HashMap<String, Object>)propertyCandidate;
                if (propertyCandidateVersions != null) {
                    contentVersionIdList.addAll(propertyCandidateVersions);
                }
            } else {
                logger.info((Object)("Have to fetch property from XML...:" + key));
                if (componentPropertiesXML != null && componentPropertiesXML.length() > 0) {
                    org.w3c.dom.Document document = XMLHelper.readDocumentFromByteArray(componentPropertiesXML.getBytes("UTF-8"));
                    String propertyXPath = "//component/properties/property[@name='" + propertyName + "']";
                    NodeList anl = XPathAPI.selectNodeList((org.w3c.dom.Node)document.getDocumentElement(), (String)propertyXPath);
                    int i = 0;
                    while (i < anl.getLength()) {
                        Element propertyElement = (Element)anl.item(i);
                        String name = propertyElement.getAttribute("name");
                        String type = propertyElement.getAttribute("type");
                        String entity = propertyElement.getAttribute("entity");
                        boolean isMultipleBinding = new Boolean(propertyElement.getAttribute("multiple"));
                        String value = null;
                        if (type.equalsIgnoreCase("textfield") || type.equalsIgnoreCase("textarea") || type.equalsIgnoreCase("select")) {
                            value = propertyElement.getAttribute("path");
                            Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), languageId);
                            if (propertyElement.hasAttribute("path_" + locale.getLanguage())) {
                                value = propertyElement.getAttribute("path_" + locale.getLanguage());
                            }
                            if (value != null) {
                                value = value.replaceAll("igbr", this.separator);
                            }
                        }
                        property = new HashMap<String, Object>();
                        property.put("name", name);
                        property.put("path", value);
                        property.put("type", type);
                        ArrayList<ComponentBinding> bindings = new ArrayList<ComponentBinding>();
                        NodeList bindingNodeList = propertyElement.getElementsByTagName("binding");
                        int j = 0;
                        while (j < bindingNodeList.getLength()) {
                            Element bindingElement = (Element)bindingNodeList.item(j);
                            String entityName = bindingElement.getAttribute("entity");
                            String entityId = bindingElement.getAttribute("entityId");
                            String assetKey = bindingElement.getAttribute("assetKey");
                            ComponentBinding componentBinding = new ComponentBinding();
                            componentBinding.setEntityClass(entity);
                            componentBinding.setEntityId(new Integer(entityId));
                            componentBinding.setAssetKey(assetKey);
                            bindings.add(componentBinding);
                            ++j;
                        }
                        property.put("bindings", bindings);
                        ++i;
                    }
                    if (property != null && contentVersionIdList.size() > 0) {
                        InfoGlueHashSet groups = new InfoGlueHashSet();
                        for (Integer contentVersionId : contentVersionIdList) {
                            ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId, this.templateController.getDatabase());
                            groups.add("contentVersion_" + contentVersionId);
                            groups.add("content_" + contentVersion.getValueObject().getContentId());
                        }
                        CacheController.cacheObjectInAdvancedCacheWithGroupsAsSet("componentPropertyCache", key, property, groups, true);
                        CacheController.cacheObjectInAdvancedCacheWithGroupsAsSet("componentPropertyCache", versionKey, contentVersionIdList, groups, true);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Error getting property:" + e.getMessage()), (Throwable)e);
        }
        for (Integer currentContentVersionId : contentVersionIdList) {
            this.templateController.getDeliveryContext().addUsedContentVersion("contentVersion_" + currentContentVersionId);
        }
        return property;
    }

    public String getPageUrl(Integer siteNodeId, Integer languageId, Integer contentId) {
        String pageUrl = this.templateController.getPageUrl(siteNodeId, languageId, contentId);
        return pageUrl;
    }

    public String getPageNavTitle(Integer siteNodeId) {
        String navTitle = "";
        navTitle = this.templateController.getPageNavTitle(siteNodeId);
        return navTitle;
    }

    private Map getComponentProperty(String propertyName, boolean useInheritance, boolean useStructureInheritance, Set contentVersionIdList, boolean useRepositoryInheritance) throws Exception {
        Map property;
        block7: {
            property = (Map)this.infoGlueComponent.getProperties().get(propertyName);
            if (useInheritance) {
                try {
                    if (property != null) break block7;
                    NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(this.templateController.getSiteNodeId(), this.templateController.getLanguageId(), this.templateController.getContentId());
                    SiteNodeVO parentSiteNodeVO = nodeDeliveryController.getSiteNode(this.templateController.getDatabase(), this.templateController.getSiteNodeId()).getValueObject();
                    while (property == null && parentSiteNodeVO != null) {
                        property = this.getInheritedComponentProperty(this.templateController, parentSiteNodeVO.getId(), this.templateController.getLanguageId(), this.templateController.getContentId(), this.infoGlueComponent.getId(), propertyName, contentVersionIdList);
                        if (useStructureInheritance) {
                            SiteNodeVO newParentSiteNodeVO = nodeDeliveryController.getParentSiteNode(this.templateController.getDatabase(), parentSiteNodeVO.getId());
                            if (newParentSiteNodeVO == null && useRepositoryInheritance) {
                                Integer parentRepositoryId = this.templateController.getParentRepositoryId(parentSiteNodeVO.getRepositoryId());
                                logger.info((Object)("parentRepositoryId:" + parentRepositoryId));
                                if (parentRepositoryId != null) {
                                    newParentSiteNodeVO = this.templateController.getRepositoryRootSiteNode(parentRepositoryId);
                                }
                            }
                            parentSiteNodeVO = newParentSiteNodeVO;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return property;
    }

    private Map getComponentProperty(Integer siteNodeId, String propertyName, boolean useInheritance) throws Exception {
        InfoGlueHashSet contentVersionIdList = new InfoGlueHashSet();
        Map property = this.getInheritedComponentProperty(this.templateController, siteNodeId, this.templateController.getLanguageId(), this.templateController.getContentId(), this.infoGlueComponent.getId(), propertyName, contentVersionIdList);
        if (useInheritance && property == null) {
            try {
                NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(siteNodeId, this.templateController.getLanguageId(), this.templateController.getContentId());
                SiteNodeVO parentSiteNodeVO = nodeDeliveryController.getSiteNode(this.templateController.getDatabase(), siteNodeId).getValueObject();
                while (property == null && parentSiteNodeVO != null) {
                    property = this.getInheritedComponentProperty(this.templateController, parentSiteNodeVO.getId(), this.templateController.getLanguageId(), this.templateController.getContentId(), this.infoGlueComponent.getId(), propertyName, contentVersionIdList);
                    SiteNodeVO newParentSiteNodeVO = nodeDeliveryController.getParentSiteNode(this.templateController.getDatabase(), parentSiteNodeVO.getId());
                    if (newParentSiteNodeVO == null) {
                        Integer parentRepositoryId = this.templateController.getParentRepositoryId(parentSiteNodeVO.getRepositoryId());
                        logger.info((Object)("parentRepositoryId:" + parentRepositoryId));
                        if (parentRepositoryId != null) {
                            newParentSiteNodeVO = this.templateController.getRepositoryRootSiteNode(parentRepositoryId);
                        }
                    }
                    parentSiteNodeVO = newParentSiteNodeVO;
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Error getting component property: " + propertyName + " on siteNode " + siteNodeId), (Throwable)e);
            }
        }
        for (Integer currentContentVersionId : contentVersionIdList) {
            this.templateController.getDeliveryContext().addUsedContentVersion("contentVersion_" + currentContentVersionId);
        }
        return property;
    }

    private Map getInheritedComponentProperty(TemplateController templateController, Integer siteNodeId, Integer languageId, Integer contentId, Integer componentId, String propertyName, Set contentVersionIdList) throws Exception {
        Map property;
        block9: {
            block8: {
                String key = "inherited_" + templateController.getSiteNodeId() + "_" + siteNodeId + "_" + languageId + "_" + componentId + "_" + propertyName;
                String versionKey = String.valueOf(key) + "_contentVersionIds";
                Object propertyCandidate = CacheController.getCachedObjectFromAdvancedCache("componentPropertyCache", key);
                Set propertyCandidateVersions = (Set)CacheController.getCachedObjectFromAdvancedCache("componentPropertyCache", versionKey);
                property = null;
                if (propertyCandidate == null) break block8;
                property = propertyCandidate instanceof NullObject ? null : (Map)propertyCandidate;
                if (propertyCandidateVersions == null) break block9;
                contentVersionIdList.addAll(propertyCandidateVersions);
                for (Integer currentContentVersionId : propertyCandidateVersions) {
                    templateController.getDeliveryContext().addUsedContentVersion("contentVersion_" + currentContentVersionId);
                }
                break block9;
            }
            String inheritedPageComponentsXML = this.getPageComponentsString(templateController, siteNodeId, languageId, contentId, contentVersionIdList);
            if (logger.isDebugEnabled()) {
                logger.info((Object)("Checking for property " + propertyName + " on siteNodeId " + siteNodeId));
                logger.info((Object)("Have to fetch property from XML...:" + contentVersionIdList.size()));
            }
            if (inheritedPageComponentsXML != null && inheritedPageComponentsXML.length() > 0) {
                property = this.parseProperties(inheritedPageComponentsXML, componentId, propertyName, siteNodeId, languageId);
            }
            if (property != null && contentVersionIdList.size() > 0) {
                InfoGlueHashSet groups = new InfoGlueHashSet();
                for (Integer contentVersionId : contentVersionIdList) {
                    ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId, this.templateController.getDatabase());
                    groups.add("contentVersion_" + contentVersionId);
                    groups.add("content_" + contentVersion.getValueObject().getContentId());
                }
            } else if (property == null && contentVersionIdList.size() > 0) {
                InfoGlueHashSet groups = new InfoGlueHashSet();
                for (Integer contentVersionId : contentVersionIdList) {
                    ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId, this.templateController.getDatabase());
                    groups.add("contentVersion_" + contentVersionId);
                    groups.add("content_" + contentVersion.getValueObject().getContentId());
                }
            }
        }
        return property;
    }

    private Map parseProperties(String inheritedPageComponentsXML, Integer componentId, String propertyName, Integer siteNodeId, Integer languageId) throws Exception {
        if (parser == null) {
            parser = CmsPropertyHandler.getPropertiesParser();
        }
        if (parser != null && parser.equalsIgnoreCase("xalan")) {
            return this.parsePropertiesWithXalan(inheritedPageComponentsXML, componentId, propertyName, siteNodeId, languageId);
        }
        if (parser != null && parser.equalsIgnoreCase("dom4j")) {
            return this.parsePropertiesWithDOM4J(inheritedPageComponentsXML, componentId, propertyName, siteNodeId, languageId);
        }
        return this.parsePropertiesWithXPP3(inheritedPageComponentsXML, componentId, propertyName, siteNodeId, languageId);
    }

    private Map parsePropertiesWithXalan(String inheritedPageComponentsXML, Integer componentId, String propertyName, Integer siteNodeId, Integer languageId) throws Exception {
        HashMap<String, Object> property = null;
        org.w3c.dom.Document document = XMLHelper.readDocumentFromByteArray(inheritedPageComponentsXML.getBytes("UTF-8"));
        String propertyXPath = "//component[@id=" + componentId + "]/properties/property[@name='" + propertyName + "']";
        NodeList anl = XPathAPI.selectNodeList((org.w3c.dom.Node)document.getDocumentElement(), (String)propertyXPath);
        if (anl == null || anl.getLength() == 0) {
            String globalPropertyXPath = "//component/properties/property[@name='" + propertyName + "'][1]";
            anl = XPathAPI.selectNodeList((org.w3c.dom.Node)document.getDocumentElement(), (String)globalPropertyXPath);
        }
        int i = 0;
        while (i < anl.getLength()) {
            Element propertyElement = (Element)anl.item(i);
            String name = propertyElement.getAttribute("name");
            String type = propertyElement.getAttribute("type");
            String entity = propertyElement.getAttribute("entity");
            boolean isMultipleBinding = new Boolean(propertyElement.getAttribute("multiple"));
            String value = null;
            if (type.equalsIgnoreCase("textfield") || type.equalsIgnoreCase("textarea") || type.equalsIgnoreCase("select")) {
                value = propertyElement.getAttribute("path");
                Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), languageId);
                Locale masterLocale = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(this.templateController.getDatabase(), siteNodeId).getLocale();
                if (propertyElement.hasAttribute("path_" + locale.getLanguage())) {
                    value = propertyElement.getAttribute("path_" + locale.getLanguage());
                }
                if ((value == null || value.equals("")) && propertyElement.hasAttribute("path_" + masterLocale.getLanguage())) {
                    value = propertyElement.getAttribute("path_" + masterLocale.getLanguage());
                }
                if (value != null) {
                    value = value.replaceAll("igbr", this.separator);
                }
            } else {
                value = this.getComponentPropertyValue(inheritedPageComponentsXML, componentId, languageId, name);
            }
            property = new HashMap<String, Object>();
            property.put("name", name);
            property.put("path", value);
            property.put("type", type);
            ArrayList<ComponentBinding> bindings = new ArrayList<ComponentBinding>();
            NodeList bindingNodeList = propertyElement.getElementsByTagName("binding");
            int j = 0;
            while (j < bindingNodeList.getLength()) {
                Element bindingElement = (Element)bindingNodeList.item(j);
                String entityName = bindingElement.getAttribute("entity");
                String entityId = bindingElement.getAttribute("entityId");
                String assetKey = bindingElement.getAttribute("assetKey");
                ComponentBinding componentBinding = new ComponentBinding();
                componentBinding.setEntityClass(entity);
                componentBinding.setEntityId(new Integer(entityId));
                componentBinding.setAssetKey(assetKey);
                bindings.add(componentBinding);
                ++j;
            }
            property.put("bindings", bindings);
            ++i;
        }
        return property;
    }

    private Map parsePropertiesWithDOM4J(String inheritedPageComponentsXML, Integer componentId, String propertyName, Integer siteNodeId, Integer languageId) throws Exception {
        HashMap<String, Object> property = null;
        Document document = domBuilder.getDocument(inheritedPageComponentsXML);
        String propertyXPath = "//component[@id=" + componentId + "]/properties/property[@name='" + propertyName + "']";
        List anl = document.getRootElement().selectNodes(propertyXPath);
        if (anl == null || anl.size() == 0) {
            String globalPropertyXPath = "//component/properties/property[@name='" + propertyName + "'][1]";
            anl = document.getRootElement().selectNodes(globalPropertyXPath);
        }
        for (org.dom4j.Element propertyElement : anl) {
            Locale locale;
            String name = propertyElement.attributeValue("name");
            String type = propertyElement.attributeValue("type");
            String entity = propertyElement.attributeValue("entity");
            boolean isMultipleBinding = new Boolean(propertyElement.attributeValue("multiple"));
            String value = null;
            if (type.equalsIgnoreCase("textfield") || type.equalsIgnoreCase("textarea") || type.equalsIgnoreCase("select")) {
                value = propertyElement.attributeValue("path");
                locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), languageId);
                Locale masterLocale = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(this.templateController.getDatabase(), siteNodeId).getLocale();
                if (propertyElement.attributeValue("path_" + locale.getLanguage()) != null && !propertyElement.attributeValue("path_" + locale.getLanguage()).equals("")) {
                    value = propertyElement.attributeValue("path_" + locale.getLanguage());
                }
                if ((value == null || value.equals("")) && propertyElement.attributeValue("path_" + masterLocale.getLanguage()) != null && !propertyElement.attributeValue("path_" + masterLocale.getLanguage()).equals("")) {
                    value = propertyElement.attributeValue("path_" + masterLocale.getLanguage());
                }
                if (value != null) {
                    value = value.replaceAll("igbr", this.separator);
                }
            } else {
                locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), languageId);
                String componentXPath = "//component[@id=" + componentId + "]/properties/property[@name='" + name + "']";
                List propertyNL = document.getRootElement().selectNodes(componentXPath);
                for (org.dom4j.Element propertyElement2 : propertyNL) {
                    String id = propertyElement2.attributeValue("type");
                    String path = propertyElement2.attributeValue("path");
                    if (propertyElement2.attributeValue("path_" + locale.getLanguage()) != null && !propertyElement2.attributeValue("path_" + locale.getLanguage()).equals("")) {
                        path = propertyElement2.attributeValue("path_" + locale.getLanguage());
                    }
                    if ((value = path) == null) continue;
                    value = value.replaceAll("igbr", this.separator);
                }
            }
            property = new HashMap<String, Object>();
            property.put("name", name);
            property.put("path", value);
            property.put("type", type);
            ArrayList<ComponentBinding> bindings = new ArrayList<ComponentBinding>();
            List bindingNodeList = propertyElement.elements("binding");
            for (org.dom4j.Element bindingElement : bindingNodeList) {
                String entityName = bindingElement.attributeValue("entity");
                String entityId = bindingElement.attributeValue("entityId");
                String assetKey = bindingElement.attributeValue("assetKey");
                ComponentBinding componentBinding = new ComponentBinding();
                componentBinding.setEntityClass(entity);
                componentBinding.setEntityId(new Integer(entityId));
                componentBinding.setAssetKey(assetKey);
                bindings.add(componentBinding);
            }
            property.put("bindings", bindings);
        }
        return property;
    }

    private Map parsePropertiesWithXPP3(String inheritedPageComponentsXML, Integer componentId, String propertyName, Integer siteNodeId, Integer languageId) throws Exception {
        List anl;
        HashMap<String, Object> property = null;
        XmlInfosetBuilder builder = XmlInfosetBuilder.newInstance();
        XmlDocument doc = builder.parseReader((Reader)new StringReader(inheritedPageComponentsXML));
        String propertyXPath = "//component[@id=" + componentId + "]/properties/property[@name='" + propertyName + "']";
        Xb1XPath xpathObject = (Xb1XPath)this.cachedXPathObjects.get(propertyXPath);
        if (xpathObject == null) {
            xpathObject = new Xb1XPath(propertyXPath);
            this.cachedXPathObjects.put(propertyXPath, xpathObject);
        }
        if ((anl = xpathObject.selectNodes((Object)doc)) == null || anl.size() == 0) {
            String globalPropertyXPath = "//component/properties/property[@name='" + propertyName + "'][1]";
            Xb1XPath globalXpathObject = new Xb1XPath(globalPropertyXPath);
            anl = globalXpathObject.selectNodes((Object)doc);
        }
        for (XmlElement infosetItem : anl) {
            Locale locale;
            String name = infosetItem.getAttributeValue(infosetItem.getNamespaceName(), "name");
            String type = infosetItem.getAttributeValue(infosetItem.getNamespaceName(), "type");
            String entity = infosetItem.getAttributeValue(infosetItem.getNamespaceName(), "entity");
            boolean isMultipleBinding = new Boolean(infosetItem.getAttributeValue(infosetItem.getNamespaceName(), "multiple"));
            String value = null;
            if (type.equalsIgnoreCase("textfield") || type.equalsIgnoreCase("textarea") || type.equalsIgnoreCase("select")) {
                value = infosetItem.getAttributeValue(infosetItem.getNamespaceName(), "path");
                locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), languageId);
                Locale masterLocale = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(this.templateController.getDatabase(), siteNodeId).getLocale();
                if (infosetItem.attribute("path_" + locale.getLanguage()) != null) {
                    value = infosetItem.getAttributeValue(infosetItem.getNamespaceName(), "path_" + locale.getLanguage());
                }
                if ((value == null || value.equals("")) && infosetItem.attribute("path_" + masterLocale.getLanguage()) != null) {
                    value = infosetItem.getAttributeValue(infosetItem.getNamespaceName(), "path_" + masterLocale.getLanguage());
                }
                if (value != null) {
                    value = value.replaceAll("igbr", this.separator);
                }
            } else {
                locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), languageId);
                String componentXPath = "//component[@id=" + componentId + "]/properties/property[@name='" + name + "']";
                Xb1XPath globalXpathObject = new Xb1XPath(componentXPath);
                List propertyNL = globalXpathObject.selectNodes((Object)doc);
                for (XmlElement propertyElement2 : propertyNL) {
                    String id = propertyElement2.getAttributeValue(infosetItem.getNamespaceName(), "type");
                    String path = propertyElement2.getAttributeValue(infosetItem.getNamespaceName(), "path");
                    if (propertyElement2.attribute("path_" + locale.getLanguage()) != null) {
                        path = propertyElement2.getAttributeValue(infosetItem.getNamespaceName(), "path_" + locale.getLanguage());
                    }
                    if ((value = path) == null) continue;
                    value = value.replaceAll("igbr", this.separator);
                }
            }
            property = new HashMap<String, Object>();
            property.put("name", name);
            property.put("path", value);
            property.put("type", type);
            ArrayList<ComponentBinding> bindings = new ArrayList<ComponentBinding>();
            for (XmlElement bindingElement : infosetItem.elements(infosetItem.getNamespace(), "binding")) {
                String entityName = bindingElement.getAttributeValue(infosetItem.getNamespaceName(), "entity");
                String entityId = bindingElement.getAttributeValue(infosetItem.getNamespaceName(), "entityId");
                String assetKey = bindingElement.getAttributeValue(infosetItem.getNamespaceName(), "assetKey");
                ComponentBinding componentBinding = new ComponentBinding();
                componentBinding.setEntityClass(entity);
                componentBinding.setEntityId(new Integer(entityId));
                componentBinding.setAssetKey(assetKey);
                bindings.add(componentBinding);
            }
            property.put("bindings", bindings);
        }
        return property;
    }

    private List getComponentProperties(Integer siteNodeId, String propertyName, boolean useInheritance, boolean skipRepositoryInheritance) throws Exception {
        List properties = this.getInheritedComponentProperties(this.templateController, siteNodeId, this.templateController.getLanguageId(), this.templateController.getContentId(), this.infoGlueComponent.getId(), propertyName);
        if (useInheritance) {
            try {
                NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(siteNodeId, this.templateController.getLanguageId(), this.templateController.getContentId());
                SiteNodeVO parentSiteNodeVO = nodeDeliveryController.getSiteNode(this.templateController.getDatabase(), siteNodeId).getValueObject();
                while (properties == null || properties.size() == 0 && parentSiteNodeVO != null) {
                    Integer parentRepositoryId;
                    properties = this.getInheritedComponentProperties(this.templateController, parentSiteNodeVO.getId(), this.templateController.getLanguageId(), this.templateController.getContentId(), this.infoGlueComponent.getId(), propertyName);
                    SiteNodeVO newParentSiteNodeVO = nodeDeliveryController.getParentSiteNode(this.templateController.getDatabase(), parentSiteNodeVO.getId());
                    if (newParentSiteNodeVO == null && !skipRepositoryInheritance && (parentRepositoryId = this.templateController.getParentRepositoryId(parentSiteNodeVO.getRepositoryId())) != null) {
                        newParentSiteNodeVO = this.templateController.getRepositoryRootSiteNode(parentRepositoryId);
                    }
                    parentSiteNodeVO = newParentSiteNodeVO;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    private List getInheritedComponentProperties(TemplateController templateController, Integer siteNodeId, Integer languageId, Integer contentId, Integer componentId, String propertyName) throws Exception {
        InfoGlueHashSet contentVersionIdList = new InfoGlueHashSet();
        String inheritedPageComponentsXML = this.getPageComponentsString(templateController, siteNodeId, languageId, contentId, contentVersionIdList);
        String key = "all_" + siteNodeId + "_" + languageId + "_" + propertyName;
        String versionKey = String.valueOf(key) + "_contentVersionIds";
        ArrayList properties = (ArrayList)CacheController.getCachedObjectFromAdvancedCache("componentPropertyCache", key);
        Set propertyCandidateVersions = (Set)CacheController.getCachedObjectFromAdvancedCache("componentPropertyCache", versionKey);
        if (properties != null) {
            if (propertyCandidateVersions != null) {
                contentVersionIdList.addAll(propertyCandidateVersions);
            }
        } else {
            properties = new ArrayList();
            if (inheritedPageComponentsXML != null && inheritedPageComponentsXML.length() > 0) {
                org.w3c.dom.Document document = XMLHelper.readDocumentFromByteArray(inheritedPageComponentsXML.getBytes("UTF-8"));
                String globalPropertyXPath = "//component/properties/property[@name='" + propertyName + "']";
                NodeList anl = XPathAPI.selectNodeList((org.w3c.dom.Node)document.getDocumentElement(), (String)globalPropertyXPath);
                int i = 0;
                while (i < anl.getLength()) {
                    Element propertyElement = (Element)anl.item(i);
                    String name = propertyElement.getAttribute("name");
                    String type = propertyElement.getAttribute("type");
                    String entity = propertyElement.getAttribute("entity");
                    boolean isMultipleBinding = new Boolean(propertyElement.getAttribute("multiple"));
                    String value = null;
                    if (type.equalsIgnoreCase("textfield") || type.equalsIgnoreCase("textarea") || type.equalsIgnoreCase("select")) {
                        value = propertyElement.getAttribute("path");
                        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(templateController.getDatabase(), languageId);
                        if (propertyElement.hasAttribute("path_" + locale.getLanguage())) {
                            value = propertyElement.getAttribute("path_" + locale.getLanguage());
                        }
                        if (value != null) {
                            value = value.replaceAll("igbr", this.separator);
                        }
                    } else {
                        value = this.getComponentPropertyValue(propertyElement, languageId, name);
                    }
                    HashMap<String, Object> property = new HashMap<String, Object>();
                    property.put("name", name);
                    property.put("path", value);
                    property.put("type", type);
                    ArrayList bindings = new ArrayList();
                    NodeList bindingNodeList = propertyElement.getElementsByTagName("binding");
                    int j = 0;
                    while (j < bindingNodeList.getLength()) {
                        Element bindingElement = (Element)bindingNodeList.item(j);
                        String entityName = bindingElement.getAttribute("entity");
                        String entityId = bindingElement.getAttribute("entityId");
                        String assetKey = bindingElement.getAttribute("assetKey");
                        ComponentBinding componentBinding = new ComponentBinding();
                        componentBinding.setEntityClass(entity);
                        componentBinding.setEntityId(new Integer(entityId));
                        componentBinding.setAssetKey(assetKey);
                        ++j;
                    }
                    property.put("bindings", bindings);
                    properties.add(property);
                    ++i;
                }
            }
            if (properties != null && contentVersionIdList.size() > 0) {
                InfoGlueHashSet groups = new InfoGlueHashSet();
                for (Integer contentVersionId : contentVersionIdList) {
                    ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId, this.templateController.getDatabase());
                    groups.add("contentVersion_" + contentVersionId);
                    groups.add("content_" + contentVersion.getValueObject().getContentId());
                }
                CacheController.cacheObjectInAdvancedCacheWithGroupsAsSet("componentPropertyCache", key, properties, groups, true);
                CacheController.cacheObjectInAdvancedCacheWithGroupsAsSet("componentPropertyCache", versionKey, contentVersionIdList, groups, true);
            }
        }
        for (Integer currentContentVersionId : contentVersionIdList) {
            templateController.getDeliveryContext().addUsedContentVersion("contentVersion_" + currentContentVersionId);
        }
        return properties;
    }

    private String getComponentPropertiesString(TemplateController templateController, Integer siteNodeId, Integer languageId, Integer contentId) throws SystemException, Exception {
        String template = null;
        try {
            template = templateController.getContentAttribute(contentId, "ComponentStructure", true);
            if (template == null) {
                throw new SystemException("There was no component properties bound to this page which makes it impossible to render.");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return template;
    }

    public String getComponentPropertyValue(Integer siteNodeId, Integer componentId, Integer languageId, Integer contentId, String name) throws Exception {
        InfoGlueHashSet contentVersionIdList = new InfoGlueHashSet();
        String componentXML = this.getPageComponentsString(this.templateController, siteNodeId, languageId, contentId, contentVersionIdList);
        String value = "Undefined";
        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), languageId);
        org.w3c.dom.Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentXPath = "//component[@id=" + componentId + "]/properties/property[@name='" + name + "']";
        NodeList anl = XPathAPI.selectNodeList((org.w3c.dom.Node)document.getDocumentElement(), (String)componentXPath);
        int i = 0;
        while (i < anl.getLength()) {
            ComponentPropertyDefinition propertyDefinition;
            Element property = (Element)anl.item(i);
            String componentContentId = property.getAttribute("contentId");
            String id = property.getAttribute("type");
            String path = property.getAttribute("path");
            if (property.hasAttribute("path_" + locale.getLanguage())) {
                path = property.getAttribute("path_" + locale.getLanguage());
            }
            if ((value = path) == null && (propertyDefinition = this.getComponentPropertyDefinition(new Integer(componentContentId), name, siteNodeId, languageId, contentId, this.templateController.getDatabase(), this.templateController.getPrincipal())) != null) {
                value = propertyDefinition.getDefaultValue();
            }
            ++i;
        }
        if (value != null) {
            value = value.replaceAll("igbr", this.separator);
        }
        return value;
    }

    private String getComponentPropertyValue(String componentXML, Integer componentId, Integer languageId, String name) throws Exception {
        String value = "Undefined";
        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), languageId);
        org.w3c.dom.Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentXPath = "//component[@id=" + componentId + "]/properties/property[@name='" + name + "']";
        NodeList anl = XPathAPI.selectNodeList((org.w3c.dom.Node)document.getDocumentElement(), (String)componentXPath);
        int i = 0;
        while (i < anl.getLength()) {
            ComponentPropertyDefinition propertyDefinition;
            Element property = (Element)anl.item(i);
            String componentContentId = property.getAttribute("contentId");
            String id = property.getAttribute("type");
            String path = property.getAttribute("path");
            if (property.hasAttribute("path_" + locale.getLanguage())) {
                path = property.getAttribute("path_" + locale.getLanguage());
            }
            if ((value = path) == null && (propertyDefinition = this.getComponentPropertyDefinition(new Integer(componentContentId), name, this.templateController.getSiteNodeId(), languageId, this.templateController.getContentId(), this.templateController.getDatabase(), this.templateController.getPrincipal())) != null) {
                value = propertyDefinition.getDefaultValue();
            }
            ++i;
        }
        if (value != null) {
            value = value.replaceAll("igbr", this.separator);
        }
        return value;
    }

    private String getComponentPropertyValue(Element property, Integer languageId, String name) throws Exception {
        ComponentPropertyDefinition propertyDefinition;
        String value = "Undefined";
        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.templateController.getDatabase(), languageId);
        String componentContentId = property.getAttribute("contentId");
        String id = property.getAttribute("type");
        String path = property.getAttribute("path");
        if (property.hasAttribute("path_" + locale.getLanguage())) {
            path = property.getAttribute("path_" + locale.getLanguage());
        }
        if ((value = path) == null && (propertyDefinition = this.getComponentPropertyDefinition(new Integer(componentContentId), name, this.templateController.getSiteNodeId(), languageId, this.templateController.getContentId(), this.templateController.getDatabase(), this.templateController.getPrincipal())) != null) {
            value = propertyDefinition.getDefaultValue();
        }
        if (value != null) {
            value = value.replaceAll("igbr", this.separator);
        }
        return value;
    }

    public List getChildComponents() {
        return this.getChildComponents(this.getInfoGlueComponent(), null);
    }

    public List getChildComponents(String slotId) {
        return this.getChildComponents(this.getInfoGlueComponent(), slotId);
    }

    public List getChildComponents(String slotId, boolean searchRecursive, String propertyFilterStrings) {
        ArrayList filters = null;
        if (propertyFilterStrings != null && !propertyFilterStrings.equals("")) {
            filters = new ArrayList();
            String[] filtersArray = propertyFilterStrings.split(",");
            int i = 0;
            while (i < filtersArray.length) {
                String nameValuePair = filtersArray[i];
                String[] pair = nameValuePair.split("=");
                String name = pair[0];
                String value = pair[1];
                HashMap<String, String> nameValues = new HashMap<String, String>();
                nameValues.put("name", name);
                nameValues.put("value", value);
                filters.add(nameValues);
                ++i;
            }
        }
        return this.getChildComponents(this.getInfoGlueComponent(), slotId, searchRecursive, filters);
    }

    public List getChildComponents(InfoGlueComponent component, String slotId) {
        ArrayList childComponents = new ArrayList();
        List slotList = component.getSlotList();
        for (Slot slot : slotList) {
            if (slotId != null && !slotId.equalsIgnoreCase(slot.getId())) continue;
            childComponents.addAll(slot.getComponents());
        }
        return childComponents;
    }

    public List getChildComponents(InfoGlueComponent component, String slotId, boolean searchRecursive, List filters) {
        ArrayList childComponents = new ArrayList();
        List slotList = component.getSlotList();
        for (Slot slot : slotList) {
            if (slotId != null && !slotId.equalsIgnoreCase(slot.getId())) continue;
            List slotChildComponents = slot.getComponents();
            childComponents.addAll(slotChildComponents);
            if (!searchRecursive) continue;
            for (InfoGlueComponent slotChildComponent : slotChildComponents) {
                List subChildComponents = this.getChildComponents(slotChildComponent, slotId, searchRecursive, filters);
                childComponents.addAll(subChildComponents);
            }
        }
        if (filters != null && filters.size() > 0) {
            Iterator childComponentsIterator = childComponents.iterator();
            while (childComponentsIterator.hasNext()) {
                InfoGlueComponent childComponent = (InfoGlueComponent)childComponentsIterator.next();
                boolean deleteComponent = true;
                for (Map filter : filters) {
                    String name = (String)filter.get("name");
                    String value = (String)filter.get("value");
                    try {
                        String propertyValue = this.getComponentPropertyValue(this.templateController.getSiteNodeId(), childComponent.getId(), this.templateController.getLanguageId(), this.templateController.getContentId(), name);
                        if (!propertyValue.trim().equalsIgnoreCase(value.trim())) continue;
                        deleteComponent = false;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!deleteComponent) continue;
                childComponentsIterator.remove();
            }
        }
        return childComponents;
    }

    protected String getPageComponentsString(TemplateController templateController, Integer siteNodeId, Integer languageId, Integer contentId, Set usedContentVersionId) throws SystemException, Exception {
        if (siteNodeId == null || siteNodeId <= 0) {
            return null;
        }
        String cacheName = "componentEditorCache";
        String cacheKey = "pageComponentString_" + siteNodeId + "_" + languageId + "_" + contentId;
        String versionKey = String.valueOf(cacheKey) + "_contentVersionId";
        String cachedPageComponentsString = (String)CacheController.getCachedObject(cacheName, cacheKey);
        Set contentVersionIds = (Set)CacheController.getCachedObjectFromAdvancedCache("contentVersionCache", versionKey);
        if (cachedPageComponentsString != null) {
            if (usedContentVersionId != null && contentVersionIds != null) {
                usedContentVersionId.addAll(contentVersionIds);
            }
            return cachedPageComponentsString;
        }
        String pageComponentsString = null;
        ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getBoundContent(templateController.getDatabase(), templateController.getPrincipal(), siteNodeId, languageId, true, "Meta information", templateController.getDeliveryContext());
        if (contentVO == null) {
            throw new SystemException("There was no Meta Information bound to this page [" + siteNodeId + "] which makes it impossible to render.");
        }
        Integer masterLanguageId = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(templateController.getDatabase(), siteNodeId).getId();
        pageComponentsString = templateController.getContentAttributeWithReturningId(contentVO.getContentId(), masterLanguageId, "ComponentStructure", true, usedContentVersionId);
        if ((pageComponentsString = this.appendPagePartTemplates(pageComponentsString, templateController)) == null) {
            throw new SystemException("There was no Meta Information bound to this page [" + siteNodeId + "] which makes it impossible to render.");
        }
        CacheController.cacheObject(cacheName, cacheKey, pageComponentsString);
        if (usedContentVersionId != null && usedContentVersionId.size() > 0) {
            InfoGlueHashSet groups = new InfoGlueHashSet();
            for (Integer contentVersionId : usedContentVersionId) {
                ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId, this.templateController.getDatabase());
                groups.add("contentVersion_" + contentVersionId);
                groups.add("content_" + contentVersion.getValueObject().getContentId());
            }
            CacheController.cacheObjectInAdvancedCacheWithGroupsAsSet("contentVersionCache", versionKey, usedContentVersionId, groups, true);
        }
        return pageComponentsString;
    }

    public InfoGlueComponent getInfoGlueComponent() {
        return this.infoGlueComponent;
    }

    public boolean getUseInheritance() {
        return this.useInheritance;
    }

    public void setUseInheritance(boolean useInheritance) {
        this.useInheritance = useInheritance;
    }

    public boolean getUseEditOnSight() {
        return this.useEditOnSight;
    }

    public void setUseEditOnSight(boolean useEditOnSight) {
        this.useEditOnSight = useEditOnSight;
    }

    public boolean getThreatFoldersAsContents() {
        return this.threatFoldersAsContents;
    }

    public void setThreatFoldersAsContents(boolean threatFoldersAsContents) {
        this.threatFoldersAsContents = threatFoldersAsContents;
        this.templateController.setThreatFoldersAsContents(threatFoldersAsContents);
    }

    public ComponentDeliveryContext getComponentDeliveryContext() {
        return this.componentDeliveryContext;
    }

    public String getContentAttributeMapValue(String propertyName, String attributeName, String keyName) {
        String mapValue = "";
        try {
            mapValue = (String)Support.convertTextToProperties(this.getContentAttribute(propertyName, attributeName, true, true)).get(keyName);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get getContentAttributeMapValue ( " + propertyName + ", " + attributeName + ", " + keyName + " ) ; " + e.getMessage()), (Throwable)e);
        }
        if (mapValue == null) {
            mapValue = "";
        }
        return mapValue;
    }

    public String getRenderedTextUrl(String text) {
        return this.templateController.getRenderedTextUrl(text, null);
    }

    public String getRenderedTextUrl(String fontConfigPropertyName, String text) {
        return this.getRenderedTextUrl(fontConfigPropertyName, text, (Map)null);
    }

    public String getRenderedTextUrl(String fontConfigPropertyName, String text, String renderAttributes) {
        return this.getRenderedTextUrl(fontConfigPropertyName, text, Support.convertTextToMap(renderAttributes, "=", ","));
    }

    public String getRenderedTextUrl(String fontConfigPropertyName, String text, Map renderAttributes) {
        String assetUrl = "";
        try {
            Map property = this.getInheritedComponentProperty(this.infoGlueComponent, fontConfigPropertyName, true, true, this.useRepositoryInheritance);
            if (property != null) {
                List bindings = (List)property.get("bindings");
                Iterator bindingsIterator = bindings.iterator();
                if (bindingsIterator.hasNext()) {
                    Integer contentId = ((ComponentBinding)bindingsIterator.next()).getEntityId();
                    assetUrl = this.templateController.getRenderedTextUrl(contentId, text, renderAttributes);
                }
            } else {
                assetUrl = this.templateController.getRenderedTextUrl(text, renderAttributes);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get getRenderedTextUrl As ImageUrl:" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    public Integer getContentId(Map property) {
        List bindings;
        Integer boundContentId = null;
        if (property != null && (bindings = (List)property.get("bindings")).size() > 0) {
            ComponentBinding componentBinding = (ComponentBinding)bindings.get(0);
            boundContentId = componentBinding.getEntityId();
        }
        return boundContentId;
    }

    public String getAssetKey(Map property) {
        List bindings;
        String assetKey = null;
        if (property != null && (bindings = (List)property.get("bindings")).size() > 0) {
            ComponentBinding componentBinding = (ComponentBinding)bindings.get(0);
            assetKey = componentBinding.getAssetKey();
        }
        return assetKey;
    }

    private Integer getSingleBindingAsInteger(Map componentProperty) {
        List bindings = (List)componentProperty.get("bindings");
        return bindings.size() > 0 ? new Integer((String)bindings.get(0)) : new Integer(0);
    }

    public List<ContentVO> getBoundContents(Map property) {
        ArrayList<ContentVO> contents = new ArrayList<ContentVO>();
        if (property != null) {
            List bindings = (List)property.get("bindings");
            for (ComponentBinding componentBinding : bindings) {
                Integer contentId = componentBinding.getEntityId();
                contents.add(this.templateController.getContent(contentId));
            }
        }
        return contents;
    }

    public Integer getSiteNodeId(Map property) {
        List bindings;
        Integer siteNodeId = null;
        if (property != null && (bindings = (List)property.get("bindings")).size() > 0) {
            ComponentBinding componentBinding = (ComponentBinding)bindings.get(0);
            siteNodeId = componentBinding.getEntityId();
        }
        return siteNodeId;
    }

    public List<SiteNodeVO> getBoundSiteNodes(Map property) {
        ArrayList<SiteNodeVO> siteNodeVOList = new ArrayList<SiteNodeVO>();
        if (property != null) {
            List bindings = (List)property.get("bindings");
            for (ComponentBinding componentBinding : bindings) {
                Integer siteNodeId = componentBinding.getEntityId();
                SiteNodeVO siteNodeVO = this.templateController.getSiteNode(siteNodeId);
                if (siteNodeVO == null) continue;
                siteNodeVOList.add(siteNodeVO);
            }
        }
        return siteNodeVOList;
    }

    public List getBoundPages(Map property) {
        ArrayList<WebPage> pages = new ArrayList<WebPage>();
        if (property != null) {
            List bindings = (List)property.get("bindings");
            for (ComponentBinding componentBinding : bindings) {
                Integer siteNodeId = componentBinding.getEntityId();
                SiteNodeVO siteNode = this.templateController.getSiteNode(siteNodeId);
                if (siteNode == null) continue;
                WebPage webPage = new WebPage();
                webPage.setSiteNodeId(siteNodeId);
                webPage.setLanguageId(this.templateController.getLanguageId());
                webPage.setContentId(null);
                webPage.setNavigationTitle(this.getPageNavTitle(siteNodeId));
                webPage.setMetaInfoContentId(siteNode.getMetaInfoContentId());
                webPage.setUrl(this.getPageUrl(siteNodeId));
                pages.add(webPage);
            }
        }
        return pages;
    }

    public WebPage getBoundPage(Map property) {
        List bindings;
        Iterator bindingsIterator;
        WebPage webPage = null;
        if (property != null && (bindingsIterator = (bindings = (List)property.get("bindings")).iterator()).hasNext()) {
            webPage = new WebPage();
            ComponentBinding componentBinding = (ComponentBinding)bindingsIterator.next();
            Integer siteNodeId = componentBinding.getEntityId();
            SiteNodeVO siteNode = this.templateController.getSiteNode(siteNodeId);
            if (siteNode != null) {
                webPage.setSiteNodeId(siteNodeId);
                webPage.setLanguageId(this.templateController.getLanguageId());
                webPage.setContentId(null);
                webPage.setNavigationTitle(this.getPageNavTitle(siteNodeId));
                webPage.setMetaInfoContentId(siteNode.getMetaInfoContentId());
                webPage.setUrl(this.getPageUrl(siteNodeId));
            }
        }
        return webPage;
    }

    private ComponentPropertyDefinition getComponentPropertyDefinition(Integer componentContentId, String propertyName, Integer siteNodeId, Integer languageId, Integer contentId, Database db, InfoGluePrincipal principal) throws Exception {
        ComponentPropertyDefinition propertyDefinition = null;
        Timer timer = new Timer();
        timer.setActive(false);
        try {
            Document document = pageEditorHelper.getComponentPropertiesDOM4JDocument(siteNodeId, languageId, componentContentId, db, principal);
            if (document != null) {
                timer.printElapsedTime("Read document");
                String propertyXPath = "//property[@name='" + propertyName + "']";
                Node node = document.selectSingleNode(propertyXPath);
                timer.printElapsedTime("Set property xpath");
                if (node != null) {
                    org.dom4j.Element element = (org.dom4j.Element)node;
                    String name = element.attributeValue("name");
                    String displayName = element.attributeValue("displayName");
                    String type = element.attributeValue("type");
                    String entity = element.attributeValue("entity");
                    String multiple = element.attributeValue("multiple");
                    String assetBinding = element.attributeValue("assetBinding");
                    String isPuffContentForPage = element.attributeValue("isPuffContentForPage");
                    String allowedContTypeDefNames = element.attributeValue("allowedContentTypeDefinitionNames");
                    String description = element.attributeValue("description");
                    String defaultValue = element.attributeValue("defaultValue");
                    String dataProvider = element.attributeValue("dataProvider");
                    String dataProviderParameters = element.attributeValue("dataProviderParameters");
                    String WYSIWYGEnabled = element.attributeValue("WYSIWYGEnabled");
                    String WYSIWYGToolbar = element.attributeValue("WYSIWYGToolbar");
                    String autoCreatContent = element.attributeValue("autoCreatContent");
                    String autoCreatContentMethod = element.attributeValue("autoCreatContentMethod");
                    String autoCreatContentPath = element.attributeValue("autoCreatContentPath");
                    String customMarkup = element.attributeValue("customMarkup");
                    propertyDefinition = new ComponentPropertyDefinition(name, displayName, type, entity, new Boolean(multiple), new Boolean(assetBinding), new Boolean(isPuffContentForPage), allowedContTypeDefNames, description, defaultValue, new Boolean(WYSIWYGEnabled), WYSIWYGToolbar, dataProvider, dataProviderParameters, new Boolean(autoCreatContent), autoCreatContentMethod, autoCreatContentPath, customMarkup);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("The property " + propertyName + " on component with contentId: " + componentContentId + " had a incorrect xml defining it's properties:" + e.getMessage()), (Throwable)e);
        }
        return propertyDefinition;
    }

    protected String appendPagePartTemplates(String componentXML, TemplateController templateController) throws Exception {
        String resultComponentXML = componentXML;
        ArrayList entries = new ArrayList();
        int isPagePartReferenceIndex = componentXML.indexOf("isPagePartReference");
        while (isPagePartReferenceIndex > -1) {
            int tagStartIndex = componentXML.lastIndexOf("<component ", isPagePartReferenceIndex);
            int n = componentXML.indexOf(">", isPagePartReferenceIndex);
            String componentString = componentXML.substring(tagStartIndex, n);
            int contentIdIndex = componentString.indexOf(" contentId=");
            String contentId = componentString.substring(contentIdIndex + 12, componentString.indexOf("\"", contentIdIndex + 12));
            int idIndex = componentString.indexOf(" id=");
            String id = componentString.substring(idIndex + 5, componentString.indexOf("\"", idIndex + 5));
            int nameIndex = componentString.indexOf(" name=");
            String name = componentString.substring(nameIndex + 7, componentString.indexOf("\"", nameIndex + 7));
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("contentId", contentId);
            entry.put("id", id);
            entry.put("name", name);
            entries.add(entry);
            isPagePartReferenceIndex = componentXML.indexOf("isPagePartReference", isPagePartReferenceIndex + 20);
        }
        for (Map map : entries) {
            String newComponentXML;
            String contentIdString = (String)map.get("contentId");
            Integer contentId = new Integer(contentIdString);
            String id = (String)map.get("id");
            String name = (String)map.get("name");
            ContentTypeDefinitionVO contentTypeDefinitionVO = ContentDeliveryController.getContentDeliveryController().getContentTypeDefinitionVO(templateController.getDatabase(), contentId);
            if (contentTypeDefinitionVO == null || !contentTypeDefinitionVO.getName().equals("PagePartTemplate")) continue;
            String pagePartString = templateController.getContentAttribute(contentId, "ComponentStructure", true);
            if (pagePartString == null || pagePartString.equals("")) {
                ContentVO contentVO = ContentDeliveryController.getContentDeliveryController().getContentVO(templateController.getDatabase(), contentId, templateController.getDeliveryContext());
                LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId(), templateController.getDatabase());
                pagePartString = templateController.getContentAttribute(contentId, masterLanguageVO.getId(), "ComponentStructure", true);
            }
            pagePartString = pagePartString.replaceFirst(" id=\".*?\"", " id=\"" + id + "\"");
            pagePartString = pagePartString.replaceFirst(" name=\".*?\"", " name=\"" + name + "\"");
            pagePartString = pagePartString.replaceFirst(" pagePartTemplateContentId=\".*?\"", " pagePartTemplateContentId=\"" + contentId + "\"");
            pagePartString = pagePartString.substring(pagePartString.indexOf("<component "));
            pagePartString = pagePartString.substring(0, pagePartString.lastIndexOf("</components>"));
            resultComponentXML = newComponentXML = componentXML.replaceAll("<component contentId=\"" + contentId + ".*?</component>", pagePartString);
        }
        return resultComponentXML;
    }
}

