/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.URLComposer;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import webwork.action.ActionContext;

public class BasicURLComposer
extends URLComposer {
    private static final Logger logger = Logger.getLogger((String)BasicURLComposer.class.getName());

    public String composeDigitalAssetUrl(String dnsName, Integer siteNodeId, Integer contentId, Integer languageId, String assetKey, DeliveryContext deliveryContext) {
        String useDNSNameInUrls;
        String disableEmptyUrls = CmsPropertyHandler.getDisableEmptyUrls();
        if (siteNodeId == null || contentId == null || languageId == null || assetKey == null) {
            return "";
        }
        String assetUrl = "";
        String enableNiceURI = CmsPropertyHandler.getEnableNiceURI();
        if (enableNiceURI == null || enableNiceURI.equalsIgnoreCase("")) {
            enableNiceURI = "false";
        }
        if ((useDNSNameInUrls = CmsPropertyHandler.getUseDNSNameInURI()) == null || useDNSNameInUrls.equalsIgnoreCase("")) {
            useDNSNameInUrls = "false";
        }
        if (enableNiceURI.equalsIgnoreCase("true") || useDNSNameInUrls.equalsIgnoreCase("false")) {
            StringBuffer sb = new StringBuffer(256);
            if (deliveryContext.getUseFullUrl()) {
                String originalUrl = deliveryContext.getHttpServletRequest().getRequestURL().toString();
                int indexOfProtocol = originalUrl.indexOf("://");
                int indexFirstSlash = originalUrl.indexOf("/", indexOfProtocol + 3);
                String base = originalUrl.substring(0, indexFirstSlash);
                sb.append(base);
            }
            String servletContext = CmsPropertyHandler.getServletContext();
            sb.append(servletContext);
            if (!sb.toString().endsWith("/")) {
                sb.append("/");
            }
            sb.append("DownloadProtectedAsset.action?siteNodeId=" + siteNodeId + "&contentId=" + contentId + "&languageId=" + languageId + "&assetKey=" + assetKey);
            assetUrl = sb.toString();
        } else {
            String operatingMode = CmsPropertyHandler.getOperatingMode();
            String keyword = "";
            if (operatingMode.equalsIgnoreCase("0")) {
                keyword = "working=";
            } else if (operatingMode.equalsIgnoreCase("2")) {
                keyword = "preview=";
            }
            if (operatingMode.equalsIgnoreCase("3")) {
                keyword = "live=";
            }
            if (dnsName != null) {
                int startIndex = dnsName.indexOf(keyword);
                if (startIndex != -1) {
                    int endIndex = dnsName.indexOf(",", startIndex);
                    dnsName = endIndex > -1 ? dnsName.substring(startIndex, endIndex) : dnsName.substring(startIndex);
                    dnsName = dnsName.split("=")[1];
                } else {
                    int endIndex = dnsName.indexOf(",");
                    dnsName = endIndex > -1 ? dnsName.substring(0, endIndex) : dnsName.substring(0);
                }
            }
            String context = CmsPropertyHandler.getServletContext();
            assetUrl = String.valueOf(dnsName) + context + "/DownloadProtectedAsset.action?siteNodeId=" + siteNodeId + "&contentId=" + contentId + "&languageId=" + languageId + "&assetKey=" + assetKey;
        }
        return assetUrl;
    }

    public String composeDigitalAssetUrl(String dnsName, String filename, DeliveryContext deliveryContext) {
        String folderName = null;
        if (filename != null && filename.indexOf("_") > -1) {
            String assetId = filename.substring(0, filename.indexOf("_"));
            try {
                folderName = "" + new Integer(assetId) / 1000;
            }
            catch (Exception e) {
                logger.error((Object)("A problem parsing assetId[" + assetId + "]:" + e.getMessage()));
                folderName = "0";
            }
        }
        return this.composeDigitalAssetUrl(dnsName, folderName, filename, deliveryContext);
    }

    public String composeDigitalAssetUrl(String dnsName, String folderName, String filename, DeliveryContext deliveryContext) {
        String useDNSNameInUrls;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("folderName:" + folderName));
        }
        String disableEmptyUrls = CmsPropertyHandler.getDisableEmptyUrls();
        if ((filename == null || filename.equals("")) && (disableEmptyUrls == null || disableEmptyUrls.equalsIgnoreCase("yes"))) {
            return "";
        }
        String assetUrl = "";
        String enableNiceURI = CmsPropertyHandler.getEnableNiceURI();
        if (enableNiceURI == null || enableNiceURI.equalsIgnoreCase("")) {
            enableNiceURI = "false";
        }
        if ((useDNSNameInUrls = CmsPropertyHandler.getUseDNSNameInURI()) == null || useDNSNameInUrls.equalsIgnoreCase("")) {
            useDNSNameInUrls = "false";
        }
        if (enableNiceURI.equalsIgnoreCase("true") || useDNSNameInUrls.equalsIgnoreCase("false")) {
            StringBuffer sb = new StringBuffer(256);
            if (deliveryContext.getUseFullUrl()) {
                String originalUrl = deliveryContext.getHttpServletRequest().getRequestURL().toString();
                int indexOfProtocol = originalUrl.indexOf("://");
                int indexFirstSlash = originalUrl.indexOf("/", indexOfProtocol + 3);
                String base = originalUrl.substring(0, indexFirstSlash);
                sb.append(base);
            }
            String servletContext = CmsPropertyHandler.getServletContext();
            String digitalAssetPath = CmsPropertyHandler.getDigitalAssetBaseUrl();
            if (!digitalAssetPath.startsWith("/")) {
                digitalAssetPath = "/" + digitalAssetPath;
            }
            if (digitalAssetPath.indexOf(servletContext) == -1) {
                sb.append(servletContext);
            }
            sb.append(digitalAssetPath);
            if (!sb.toString().endsWith("/")) {
                sb.append("/");
            }
            if (folderName != null) {
                sb.append(folderName);
                if (!sb.toString().endsWith("/")) {
                    sb.append("/");
                }
            }
            sb.append(filename);
            assetUrl = sb.toString();
        } else {
            String operatingMode = CmsPropertyHandler.getOperatingMode();
            String keyword = "";
            if (operatingMode.equalsIgnoreCase("0")) {
                keyword = "working=";
            } else if (operatingMode.equalsIgnoreCase("2")) {
                keyword = "preview=";
            }
            if (operatingMode.equalsIgnoreCase("3")) {
                keyword = "live=";
            }
            if (dnsName != null) {
                int startIndex = dnsName.indexOf(keyword);
                if (startIndex != -1) {
                    int endIndex = dnsName.indexOf(",", startIndex);
                    dnsName = endIndex > -1 ? dnsName.substring(startIndex, endIndex) : dnsName.substring(startIndex);
                    dnsName = dnsName.split("=")[1];
                } else {
                    int endIndex = dnsName.indexOf(",");
                    dnsName = endIndex > -1 ? dnsName.substring(0, endIndex) : dnsName.substring(0);
                }
            }
            String context = CmsPropertyHandler.getServletContext();
            assetUrl = folderName != null ? String.valueOf(dnsName) + context + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/" + folderName + "/" + filename : String.valueOf(dnsName) + context + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/" + filename;
        }
        return assetUrl;
    }

    public String composePageUrl(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, Integer contentId, DeliveryContext deliveryContext) throws SystemException {
        String useDNSNameInUrls;
        if (siteNodeId == null || siteNodeId == -1) {
            logger.warn((Object)("composePageUrl was called with siteNodeId:" + siteNodeId + " from the page with key: " + deliveryContext.getPageKey() + " (siteNodeId=" + deliveryContext.getSiteNodeId() + ")"));
            return "";
        }
        String enableNiceURI = CmsPropertyHandler.getEnableNiceURI();
        if (enableNiceURI == null || enableNiceURI.equalsIgnoreCase("")) {
            enableNiceURI = "false";
        }
        if ((useDNSNameInUrls = CmsPropertyHandler.getUseDNSNameInURI()) == null || useDNSNameInUrls.equalsIgnoreCase("")) {
            useDNSNameInUrls = "false";
        }
        if (enableNiceURI.equalsIgnoreCase("true") && deliveryContext.getHttpServletRequest().getRequestURI().indexOf("!renderDecoratedPage") == -1 && !deliveryContext.getDisableNiceUri()) {
            String dnsName;
            String context = CmsPropertyHandler.getServletContext();
            SiteNode siteNode = SiteNodeController.getSiteNodeWithId(siteNodeId, db, true);
            SiteNode currentSiteNode = SiteNodeController.getSiteNodeWithId(deliveryContext.getSiteNodeId(), db, true);
            if (!siteNode.getRepository().getId().equals(currentSiteNode.getRepository().getId())) {
                dnsName = siteNode.getRepository().getDnsName();
                logger.info((Object)("dnsName:" + dnsName + " for siteNode " + siteNode.getName()));
                String operatingMode = CmsPropertyHandler.getOperatingMode();
                String keyword = "";
                if (operatingMode.equalsIgnoreCase("0")) {
                    keyword = "working=";
                } else if (operatingMode.equalsIgnoreCase("2")) {
                    keyword = "preview=";
                }
                if (operatingMode.equalsIgnoreCase("3")) {
                    keyword = "live=";
                }
                String repositoryPath = null;
                int pathStartIndex = dnsName.indexOf("path=");
                if (pathStartIndex != -1) {
                    repositoryPath = dnsName.substring(pathStartIndex + 5);
                }
                logger.info((Object)("repositoryPath in constructing new url:" + repositoryPath));
                if (dnsName != null) {
                    int startIndex = dnsName.indexOf(keyword);
                    if (startIndex != -1) {
                        int endIndex = dnsName.indexOf(",", startIndex);
                        dnsName = endIndex > -1 ? dnsName.substring(startIndex, endIndex) : dnsName.substring(startIndex);
                        dnsName = dnsName.split("=")[1];
                    } else {
                        int endIndex = dnsName.indexOf(",");
                        dnsName = endIndex > -1 ? dnsName.substring(0, endIndex) : dnsName.substring(0);
                    }
                }
                context = repositoryPath != null ? (context.startsWith("/") ? String.valueOf(dnsName) + context + "/" + repositoryPath : String.valueOf(dnsName) + "/" + context + "/" + repositoryPath) : (context.startsWith("/") ? String.valueOf(dnsName) + context : String.valueOf(dnsName) + "/" + context);
            } else {
                dnsName = siteNode.getRepository().getDnsName();
                String repositoryPath = null;
                int pathStartIndex = dnsName.indexOf("path=");
                if (pathStartIndex != -1) {
                    repositoryPath = dnsName.substring(pathStartIndex + 5);
                }
                logger.info((Object)("repositoryPath in constructing new url:" + repositoryPath));
                if (repositoryPath != null) {
                    context = String.valueOf(context) + "/" + repositoryPath;
                }
            }
            StringBuffer sb = new StringBuffer(256);
            if (deliveryContext.getUseFullUrl()) {
                String originalUrl = deliveryContext.getHttpServletRequest().getRequestURL().toString();
                int indexOfProtocol = originalUrl.indexOf("://");
                int indexFirstSlash = originalUrl.indexOf("/", indexOfProtocol + 3);
                String base = originalUrl.substring(0, indexFirstSlash);
                sb.append(base);
            }
            sb.append(context);
            try {
                String navigationPath = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId).getPageNavigationPath(db, infoGluePrincipal, siteNodeId, languageId, contentId, deliveryContext);
                if (navigationPath != null && navigationPath.startsWith("/") && sb.toString().endsWith("/")) {
                    sb.append(navigationPath.substring(1));
                } else {
                    sb.append(navigationPath);
                }
                if (sb.toString().endsWith(context) && !sb.toString().endsWith("/")) {
                    sb.append("/");
                }
                boolean addedContent = false;
                if (contentId != null && contentId != -1) {
                    sb.append("?contentId=").append(String.valueOf(contentId));
                    addedContent = true;
                }
                if (languageId != null && languageId != -1 && deliveryContext.getLanguageId().intValue() != languageId.intValue()) {
                    if (addedContent) {
                        sb.append(this.getRequestArgumentDelimiter());
                    } else {
                        sb.append("?");
                    }
                    sb.append("languageId=").append(String.valueOf(languageId));
                }
                return !sb.toString().equals("") ? sb.toString() : "/";
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (!useDNSNameInUrls.equalsIgnoreCase("false")) {
            if (siteNodeId == null) {
                siteNodeId = new Integer(-1);
            }
            if (languageId == null) {
                languageId = new Integer(-1);
            }
            if (contentId == null) {
                contentId = new Integer(-1);
            }
            String arguments = "siteNodeId=" + siteNodeId + this.getRequestArgumentDelimiter() + "languageId=" + languageId + this.getRequestArgumentDelimiter() + "contentId=" + contentId;
            SiteNode siteNode = SiteNodeController.getSiteNodeWithId(siteNodeId, db, true);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            String operatingMode = CmsPropertyHandler.getOperatingMode();
            String keyword = "";
            if (operatingMode.equalsIgnoreCase("0")) {
                keyword = "working=";
            } else if (operatingMode.equalsIgnoreCase("2")) {
                keyword = "preview=";
            }
            if (operatingMode.equalsIgnoreCase("3")) {
                keyword = "live=";
            }
            if (dnsName != null) {
                int endIndex;
                int startIndex = dnsName.indexOf(keyword);
                if (startIndex != -1) {
                    endIndex = dnsName.indexOf(",", startIndex);
                    dnsName = endIndex > -1 ? dnsName.substring(startIndex, endIndex) : dnsName.substring(startIndex);
                    dnsName = dnsName.split("=")[1];
                } else {
                    endIndex = dnsName.indexOf(",");
                    dnsName = endIndex > -1 ? dnsName.substring(0, endIndex) : dnsName.substring(0);
                }
            }
            String context = CmsPropertyHandler.getServletContext();
            String url = String.valueOf(dnsName) + context + "/" + CmsPropertyHandler.getApplicationBaseAction() + "?" + arguments;
            if (deliveryContext.getHttpServletRequest().getRequestURI().indexOf("!renderDecoratedPage") > -1) {
                String componentRendererUrl = CmsPropertyHandler.getComponentRendererUrl();
                if (componentRendererUrl.endsWith("/")) {
                    componentRendererUrl = String.valueOf(componentRendererUrl) + "/";
                }
                url = String.valueOf(componentRendererUrl) + CmsPropertyHandler.getComponentRendererAction() + "?" + arguments;
            }
            return url;
        }
        StringBuffer sb = new StringBuffer(256);
        if (deliveryContext.getUseFullUrl()) {
            String originalUrl = deliveryContext.getHttpServletRequest().getRequestURL().toString();
            int indexOfProtocol = originalUrl.indexOf("://");
            int indexFirstSlash = originalUrl.indexOf("/", indexOfProtocol + 3);
            String base = originalUrl.substring(0, indexFirstSlash);
            sb.append(base);
        }
        String servletContext = CmsPropertyHandler.getServletContext();
        if (siteNodeId == null) {
            siteNodeId = new Integer(-1);
        }
        if (languageId == null) {
            languageId = new Integer(-1);
        }
        if (contentId == null) {
            contentId = new Integer(-1);
        }
        String arguments = "siteNodeId=" + siteNodeId + this.getRequestArgumentDelimiter() + "languageId=" + languageId + this.getRequestArgumentDelimiter() + "contentId=" + contentId;
        if (deliveryContext.getHttpServletRequest().getRequestURI().indexOf("!renderDecoratedPage") > -1) {
            sb.append(String.valueOf(servletContext) + "/" + CmsPropertyHandler.getComponentRendererAction() + "?" + arguments);
        } else {
            sb.append(String.valueOf(servletContext) + "/" + CmsPropertyHandler.getApplicationBaseAction() + "?" + arguments);
        }
        return sb.toString();
    }

    public String composePageUrlAfterLanguageChange(Database db, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Integer languageId, Integer contentId, DeliveryContext deliveryContext) throws SystemException {
        String pageUrl = this.composePageUrl(db, infoGluePrincipal, siteNodeId, languageId, contentId, deliveryContext);
        String enableNiceURI = CmsPropertyHandler.getEnableNiceURI();
        if (enableNiceURI == null || enableNiceURI.equalsIgnoreCase("")) {
            enableNiceURI = "false";
        }
        if (enableNiceURI.equalsIgnoreCase("true") && !deliveryContext.getDisableNiceUri()) {
            if (pageUrl.indexOf("?") == -1) {
                pageUrl = String.valueOf(pageUrl) + "?languageId=" + String.valueOf(languageId);
            } else if (pageUrl.indexOf("languageId=") == -1) {
                pageUrl = String.valueOf(pageUrl) + this.getRequestArgumentDelimiter() + "languageId=" + String.valueOf(languageId);
            }
        }
        return pageUrl;
    }

    private String getRequestArgumentDelimiter() {
        String requestArgumentDelimiter = CmsPropertyHandler.getRequestArgumentDelimiter();
        if (requestArgumentDelimiter == null || requestArgumentDelimiter.equalsIgnoreCase("") || !requestArgumentDelimiter.equalsIgnoreCase("&") && !requestArgumentDelimiter.equalsIgnoreCase("&amp;")) {
            requestArgumentDelimiter = "&";
        }
        return requestArgumentDelimiter;
    }

    public String composePageBaseUrl(String dnsName) {
        String useDNSNameInUrls = CmsPropertyHandler.getUseDNSNameInURI();
        if (useDNSNameInUrls == null || useDNSNameInUrls.equalsIgnoreCase("")) {
            useDNSNameInUrls = "false";
        }
        if (!useDNSNameInUrls.equalsIgnoreCase("false")) {
            String operatingMode = CmsPropertyHandler.getOperatingMode();
            String keyword = "";
            if (operatingMode.equalsIgnoreCase("0")) {
                keyword = "working=";
            } else if (operatingMode.equalsIgnoreCase("2")) {
                keyword = "preview=";
            }
            if (operatingMode.equalsIgnoreCase("3")) {
                keyword = "live=";
            }
            if (dnsName != null) {
                int startIndex = dnsName.indexOf(keyword);
                if (startIndex != -1) {
                    int endIndex = dnsName.indexOf(",", startIndex);
                    dnsName = endIndex > -1 ? dnsName.substring(startIndex, endIndex) : dnsName.substring(startIndex);
                    dnsName = dnsName.split("=")[1];
                } else {
                    int endIndex = dnsName.indexOf(",");
                    dnsName = endIndex > -1 ? dnsName.substring(0, endIndex) : dnsName.substring(0);
                }
            }
            String context = CmsPropertyHandler.getServletContext();
            return String.valueOf(dnsName) + context + "/" + CmsPropertyHandler.getApplicationBaseAction();
        }
        if (ActionContext.getRequest().getRequestURI().indexOf("!renderDecoratedPage") > -1) {
            return "/" + CmsPropertyHandler.getComponentRendererUrl();
        }
        return "/" + CmsPropertyHandler.getApplicationBaseAction();
    }
}

