/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import java.awt.Color;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.dom4j.Document;
import org.dom4j.Element;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.databeans.ReferenceBean;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryConditions;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.ExportImportController;
import org.infoglue.cms.controllers.kernel.impl.simple.ExtendedSearchController;
import org.infoglue.cms.controllers.kernel.impl.simple.ExtendedSearchCriterias;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.InfoGluePrincipalControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.SearchController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.WorkflowController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.ContentTypeAttribute;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.io.FileHelper;
import org.infoglue.cms.security.AuthenticationModule;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.DesEncryptionHelper;
import org.infoglue.cms.util.DocumentConverterHelper;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.cms.util.sorters.SiteNodeComparator;
import org.infoglue.deliver.applications.databeans.ComponentProperty;
import org.infoglue.deliver.applications.databeans.DatabaseWrapper;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.applications.databeans.WebPage;
import org.infoglue.deliver.controllers.kernel.URLComposer;
import org.infoglue.deliver.controllers.kernel.impl.simple.ComponentLogic;
import org.infoglue.deliver.controllers.kernel.impl.simple.ContentDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.EditOnSiteBasicTemplateController;
import org.infoglue.deliver.controllers.kernel.impl.simple.ExtranetController;
import org.infoglue.deliver.controllers.kernel.impl.simple.FormDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.IntegrationDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.RepositoryDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;
import org.infoglue.deliver.invokers.DecoratedComponentBasedHTMLPageInvoker;
import org.infoglue.deliver.util.BrowserBean;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.HttpHelper;
import org.infoglue.deliver.util.MathHelper;
import org.infoglue.deliver.util.ObjectConverter;
import org.infoglue.deliver.util.VelocityTemplateProcessor;
import org.infoglue.deliver.util.charts.ChartHelper;
import org.infoglue.deliver.util.forms.FormHelper;
import org.infoglue.deliver.util.graphics.AdvancedImageRenderer;
import org.infoglue.deliver.util.graphics.ColorHelper;
import org.infoglue.deliver.util.graphics.FOPHelper;
import org.infoglue.deliver.util.graphics.FontHelper;
import org.infoglue.deliver.util.graphics.ImageRenderer;
import org.infoglue.deliver.util.rss.RssHelper;
import org.infoglue.deliver.util.webservices.InfoGlueWebServices;
import org.infoglue.deliver.util.webservices.WebServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTemplateController
implements TemplateController {
    private static final DOMBuilder domBuilder = new DOMBuilder();
    private static final Logger logger = Logger.getLogger((String)BasicTemplateController.class.getName());
    private URLComposer urlComposer = null;
    public static final String META_INFO_BINDING_NAME = "Meta information";
    public static final String TEMPLATE_ATTRIBUTE_NAME = "Template";
    public static final String TITLE_ATTRIBUTE_NAME = "Title";
    public static final String NAV_TITLE_ATTRIBUTE_NAME = "NavigationTitle";
    protected static final boolean USE_LANGUAGE_FALLBACK = true;
    protected static final boolean DO_NOT_USE_LANGUAGE_FALLBACK = false;
    protected static final boolean USE_INHERITANCE = true;
    protected static final boolean DO_NOT_USE_INHERITANCE = false;
    protected Integer siteNodeId = null;
    protected Integer languageId = null;
    protected Integer contentId = null;
    protected HttpServletRequest request = null;
    protected DeliveryContext deliveryContext = null;
    protected BrowserBean browserBean = null;
    protected NodeDeliveryController nodeDeliveryController = null;
    protected ContentDeliveryController contentDeliveryController = null;
    protected IntegrationDeliveryController integrationDeliveryController = null;
    protected ComponentLogic componentLogic = null;
    protected InfoGluePrincipal infoGluePrincipal = null;
    protected Map templateLogicContext = new HashMap();
    protected boolean persistedContext = false;
    protected DatabaseWrapper databaseWrapper = null;
    private boolean threatFoldersAsContents = false;
    private HashMap cachedBindings = new HashMap();

    public BasicTemplateController(DatabaseWrapper databaseWrapper, InfoGluePrincipal infoGluePrincipal) {
        this.databaseWrapper = databaseWrapper;
        this.infoGluePrincipal = infoGluePrincipal;
        this.urlComposer = URLComposer.getURLComposer();
    }

    @Override
    public Database getDatabase() throws SystemException {
        if (this.databaseWrapper.getDatabase() == null || this.databaseWrapper.getDatabase().isClosed() || !this.databaseWrapper.getDatabase().isActive()) {
            this.beginTransaction();
        }
        return this.databaseWrapper.getDatabase();
    }

    @Override
    public DatabaseWrapper getDatabaseWrapper() {
        return this.databaseWrapper;
    }

    @Override
    public void commitDatabase() throws SystemException {
        logger.debug((Object)"Committing database in the middle of the run....");
        try {
            this.databaseWrapper.getDatabase().commit();
            this.databaseWrapper.getDatabase().close();
            logger.info((Object)"Closed transaction...");
            this.databaseWrapper.setDatabase(CastorDatabaseService.getDatabase());
            this.beginTransaction();
            logger.info((Object)"Begun a new transaction...");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to commit an transaction. Reason:" + e.getMessage(), e);
        }
    }

    public void closeTransaction() throws SystemException {
        try {
            this.databaseWrapper.getDatabase().commit();
            logger.info((Object)"Closed transaction...");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to commit an transaction. Reason:" + e.getMessage(), e);
        }
    }

    private void beginTransaction() throws SystemException {
        try {
            this.databaseWrapper.getDatabase().begin();
            logger.info((Object)"Started new transaction...");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to begin an transaction. Reason:" + e.getMessage(), e);
        }
    }

    @Override
    public void addToContext(String name, Object object) {
        this.templateLogicContext.put(name, object);
    }

    protected void addToContext(Map context) {
        this.templateLogicContext.putAll(context);
    }

    public Object getFromContext(String name) {
        return this.templateLogicContext.get(name);
    }

    @Override
    public void setStandardRequestParameters(Integer siteNodeId, Integer languageId, Integer contentId) {
        this.siteNodeId = siteNodeId;
        this.languageId = languageId;
        this.contentId = contentId;
    }

    @Override
    public void setHttpRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void setBrowserBean(BrowserBean browserBean) {
        this.browserBean = browserBean;
    }

    @Override
    public String getTemplateAttributeName() {
        return TEMPLATE_ATTRIBUTE_NAME;
    }

    @Override
    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    @Override
    public Integer getLanguageId() {
        return this.languageId;
    }

    @Override
    public Integer getContentId() {
        return this.contentId;
    }

    @Override
    public ComponentLogic getComponentLogic() {
        return this.componentLogic;
    }

    @Override
    public void setComponentLogic(ComponentLogic componentLogic) {
        this.componentLogic = componentLogic;
    }

    @Override
    public VisualFormatter getVisualFormatter() {
        return new VisualFormatter();
    }

    @Override
    public ColorHelper getColorHelper() {
        return new ColorHelper();
    }

    public FormHelper getFormHelper() {
        return new FormHelper();
    }

    @Override
    public FontHelper getFontHelper() {
        return new FontHelper();
    }

    @Override
    public MathHelper getMathHelper() {
        return new MathHelper();
    }

    public HttpHelper getHTTPHelper() {
        return new HttpHelper();
    }

    @Override
    public ChartHelper getChartHelper() {
        return new ChartHelper(this);
    }

    @Override
    public WebServiceHelper getWebServiceHelper() {
        return new WebServiceHelper();
    }

    public InfoGlueWebServices getInfoGlueWebServiceHelper() {
        return new InfoGlueWebServices();
    }

    @Override
    public NumberFormat getNumberFormatHelper() throws SystemException {
        return NumberFormat.getInstance(LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.getDatabase(), this.languageId));
    }

    @Override
    public DesEncryptionHelper getDesEncryptionHelper() {
        return new DesEncryptionHelper();
    }

    @Override
    public RssHelper getRssHelper() {
        return new RssHelper();
    }

    @Override
    public DocumentConverterHelper getDocumentTransformerHelper() {
        return new DocumentConverterHelper();
    }

    @Override
    public ObjectConverter getObjectConverter() {
        return new ObjectConverter();
    }

    public Map getContentAttributes(Integer contentId) {
        HashMap<String, String> result = new HashMap<String, String>();
        ContentTypeDefinitionVO typeDefinitionVO = this.getContentTypeDefinitionVO(contentId);
        List contentAttributes = this.getContentAttributes(typeDefinitionVO.getSchemaValue());
        for (ContentTypeAttribute contentTypeAttribute : contentAttributes) {
            String name = contentTypeAttribute.getName();
            result.put(name, this.getContentAttribute(contentId, name));
        }
        return result;
    }

    public Map getParsedContentAttributes(Integer contentId) {
        HashMap<String, String> result = new HashMap<String, String>();
        ContentTypeDefinitionVO typeDefinitionVO = this.getContentTypeDefinitionVO(contentId);
        List contentAttributes = this.getContentAttributes(typeDefinitionVO.getSchemaValue());
        for (ContentTypeAttribute contentTypeAttribute : contentAttributes) {
            String name = contentTypeAttribute.getName();
            result.put(name, this.getParsedContentAttribute(contentId, name));
        }
        return result;
    }

    @Override
    public ContentVO getContent() {
        ContentVO content = null;
        try {
            content = ContentDeliveryController.getContentDeliveryController().getContentVO(this.getDatabase(), this.contentId, this.deliveryContext);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get the current content:" + e.getMessage()), (Throwable)e);
        }
        return content;
    }

    @Override
    public ContentVO getContent(Integer contentId) {
        ContentVO content = null;
        try {
            content = ContentDeliveryController.getContentDeliveryController().getContentVO(this.getDatabase(), contentId, this.deliveryContext);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get the content with id " + contentId + ":" + e.getMessage()));
        }
        return content;
    }

    @Override
    public ContentVersionVO getContentVersionById(Integer contentVersionId) {
        ContentVersionVO contentVersionVO = null;
        try {
            contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId, this.getDatabase()).getValueObject();
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get the contentVersion with contentVersionId " + contentVersionId + ":" + e.getMessage()), (Throwable)e);
        }
        return contentVersionVO;
    }

    @Override
    public ContentVersionVO getContentVersion(Integer contentId) {
        ContentVersionVO contentVersionVO = null;
        try {
            contentVersionVO = ContentDeliveryController.getContentDeliveryController().getContentVersionVO(this.getDatabase(), this.siteNodeId, contentId, this.languageId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get the contentVersion with contentId " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return contentVersionVO;
    }

    @Override
    public ContentVersionVO getContentVersion(Integer contentId, Integer languageId, boolean useLanguageFallback) {
        ContentVersionVO contentVersionVO = null;
        try {
            contentVersionVO = ContentDeliveryController.getContentDeliveryController().getContentVersionVO(this.getDatabase(), this.siteNodeId, contentId, languageId, useLanguageFallback, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get the contentVersion with contentId " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return contentVersionVO;
    }

    @Override
    public List getContentVersions(Integer contentId, Integer languageId) {
        List contentVersions = new ArrayList();
        try {
            contentVersions = ContentDeliveryController.getContentDeliveryController().getContentVersionVOList(this.getDatabase(), this.siteNodeId, contentId, languageId, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)("An error occurred trying to get the contentVersion with contentId " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return contentVersions;
    }

    @Override
    public InfoGluePrincipal getPrincipal() {
        return this.infoGluePrincipal;
    }

    public List getAllRoles() throws Exception {
        return RoleControllerProxy.getController(this.getDatabase()).getAllRoles();
    }

    public List getAllGroups() throws Exception {
        return GroupControllerProxy.getController(this.getDatabase()).getAllGroups();
    }

    @Override
    public InfoGluePrincipal getPrincipal(String userName) {
        if (userName == null || userName.equals("")) {
            return null;
        }
        InfoGluePrincipal infoGluePrincipal = null;
        try {
            infoGluePrincipal = UserControllerProxy.getController(this.getDatabase()).getUser(userName);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when getting principal:" + e.getMessage()), (Throwable)e);
        }
        return infoGluePrincipal;
    }

    @Override
    public String getPrincipalPropertyValue(String propertyName) {
        return this.getPrincipalPropertyValue(propertyName, true);
    }

    @Override
    public Map getPrincipalPropertyHashValues(String propertyName) {
        return this.getPrincipalPropertyHashValues(propertyName, true);
    }

    @Override
    public String getPrincipalPropertyValue(InfoGluePrincipal infoGluePrincipal, String propertyName) {
        return this.getPrincipalPropertyValue(infoGluePrincipal, propertyName, true);
    }

    @Override
    public Map getPrincipalPropertyHashValues(InfoGluePrincipal infoGluePrincipal, String propertyName) {
        return this.getPrincipalPropertyHashValues(infoGluePrincipal, propertyName, true);
    }

    @Override
    public String getPrincipalPropertyValue(InfoGluePrincipal infoGluePrincipal, String propertyName, boolean escapeSpecialCharacters) {
        String value = "";
        try {
            value = this.getPrincipalPropertyValue(infoGluePrincipal, propertyName, escapeSpecialCharacters, false);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public String getPrincipalPropertyValue(InfoGluePrincipal infoGluePrincipal, String propertyName, boolean escapeSpecialCharacters, boolean findLargestValue) {
        String value = "";
        try {
            value = InfoGluePrincipalControllerProxy.getController().getPrincipalPropertyValue(this.getDatabase(), infoGluePrincipal, propertyName, this.languageId, this.siteNodeId, true, escapeSpecialCharacters, findLargestValue);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public String getPrincipalPropertyValue(String propertyName, boolean escapeSpecialCharacters) {
        String value = "";
        try {
            InfoGluePrincipal infoGluePrincipal = this.getPrincipal();
            value = this.getPrincipalPropertyValue(propertyName, escapeSpecialCharacters, false);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public String getPrincipalPropertyValue(String propertyName, boolean escapeSpecialCharacters, boolean findLargestValue) {
        String value = "";
        try {
            InfoGluePrincipal infoGluePrincipal = this.getPrincipal();
            value = InfoGluePrincipalControllerProxy.getController().getPrincipalPropertyValue(this.getDatabase(), infoGluePrincipal, propertyName, this.languageId, this.siteNodeId, true, escapeSpecialCharacters, findLargestValue);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public Map getPrincipalPropertyHashValues(InfoGluePrincipal infoGluePrincipal, String propertyName, boolean escapeSpecialCharacters) {
        Map value = new HashMap();
        try {
            value = InfoGluePrincipalControllerProxy.getController().getPrincipalPropertyHashValues(this.getDatabase(), infoGluePrincipal, propertyName, this.languageId, this.siteNodeId, true, escapeSpecialCharacters);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public Map getPrincipalPropertyHashValues(String propertyName, boolean escapeSpecialCharacters) {
        Map value = new HashMap();
        try {
            InfoGluePrincipal infoGluePrincipal = this.getPrincipal();
            value = this.getPrincipalPropertyHashValues(this.infoGluePrincipal, propertyName, escapeSpecialCharacters);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public boolean getHasPrincipalGroup(InfoGluePrincipal infoGluePrincipal, String groupName) {
        boolean isValid = false;
        for (InfoGlueGroup infoglueGroup : infoGluePrincipal.getGroups()) {
            if (!infoglueGroup.getName().equalsIgnoreCase(groupName)) continue;
            isValid = true;
        }
        return isValid;
    }

    public List getPrincipalGroupRelatedContents(String groupName, String propertyName) {
        return this.getPrincipalGroupRelatedContents(this.infoGluePrincipal, groupName, propertyName);
    }

    public List getPrincipalGroupRelatedContents(InfoGluePrincipal infoGluePrincipal, String groupName, String propertyName) {
        List contents = new ArrayList();
        try {
            if (this.getHasPrincipalGroup(infoGluePrincipal, groupName)) {
                contents = GroupPropertiesController.getController().getRelatedContents(groupName, this.languageId, propertyName);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return contents;
    }

    public List getPrincipalGroupRelatedPages(String groupName, String propertyName) {
        return this.getPrincipalGroupRelatedPages(this.infoGluePrincipal, groupName, propertyName);
    }

    public List getPrincipalGroupRelatedPages(String groupName, String propertyName, boolean escapeHTML) {
        return this.getPrincipalGroupRelatedPages(this.infoGluePrincipal, groupName, propertyName, escapeHTML);
    }

    public List getPrincipalGroupRelatedPages(InfoGluePrincipal infoGluePrincipal, String groupName, String propertyName) {
        return this.getPrincipalGroupRelatedPages(this.infoGluePrincipal, groupName, propertyName, false);
    }

    public List getPrincipalGroupRelatedPages(InfoGluePrincipal infoGluePrincipal, String groupName, String propertyName, boolean escapeHTML) {
        ArrayList<WebPage> pages = new ArrayList<WebPage>();
        try {
            if (this.getHasPrincipalGroup(infoGluePrincipal, groupName)) {
                List siteNodeVOList = GroupPropertiesController.getController().getRelatedSiteNodes(groupName, this.languageId, propertyName);
                for (SiteNodeVO siteNodeVO : siteNodeVOList) {
                    try {
                        WebPage webPage = new WebPage();
                        webPage.setSiteNodeId(siteNodeVO.getSiteNodeId());
                        webPage.setLanguageId(this.languageId);
                        webPage.setContentId(null);
                        webPage.setNavigationTitle(this.nodeDeliveryController.getPageNavigationTitle(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, true, this.deliveryContext, escapeHTML));
                        webPage.setMetaInfoContentId(this.nodeDeliveryController.getMetaInfoContentId(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), META_INFO_BINDING_NAME, true, this.deliveryContext));
                        webPage.setUrl(this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, this.deliveryContext));
                        pages.add(webPage);
                    }
                    catch (Exception e) {
                        logger.info((Object)("An error occurred when looking up one of the related pages:" + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return pages;
    }

    public List getPrincipalGroupCategories(String groupName, String propertyName) {
        return this.getPrincipalGroupCategories(this.infoGluePrincipal, groupName, propertyName);
    }

    public List getPrincipalGroupCategories(InfoGluePrincipal infoGluePrincipal, String groupName, String propertyName) {
        List categories = new ArrayList();
        try {
            if (this.getHasPrincipalGroup(infoGluePrincipal, groupName)) {
                categories = GroupPropertiesController.getController().getRelatedCategories(groupName, this.languageId, propertyName);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return categories;
    }

    public boolean getHasPrincipalRole(InfoGluePrincipal infoGluePrincipal, String roleName) {
        boolean isValid = false;
        for (InfoGlueRole infoglueRole : infoGluePrincipal.getRoles()) {
            if (!infoglueRole.getName().equalsIgnoreCase(roleName)) continue;
            isValid = true;
        }
        return isValid;
    }

    public List getPrincipalRoleRelatedContents(String roleName, String propertyName) {
        return this.getPrincipalRoleRelatedContents(this.infoGluePrincipal, roleName, propertyName);
    }

    public List getPrincipalRoleRelatedContents(InfoGluePrincipal infoGluePrincipal, String roleName, String propertyName) {
        List contents = new ArrayList();
        try {
            if (this.getHasPrincipalRole(infoGluePrincipal, roleName)) {
                contents = RolePropertiesController.getController().getRelatedContents(roleName, this.languageId, propertyName);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return contents;
    }

    public List getPrincipalRoleRelatedPages(String roleName, String propertyName) {
        return this.getPrincipalRoleRelatedPages(this.infoGluePrincipal, roleName, propertyName);
    }

    public List getPrincipalRoleRelatedPages(String roleName, String propertyName, boolean escapeHTML) {
        return this.getPrincipalRoleRelatedPages(this.infoGluePrincipal, roleName, propertyName, escapeHTML);
    }

    public List getPrincipalRoleRelatedPages(InfoGluePrincipal infoGluePrincipal, String roleName, String propertyName) {
        return this.getPrincipalRoleRelatedPages(this.infoGluePrincipal, roleName, propertyName, false);
    }

    public List getPrincipalRoleRelatedPages(InfoGluePrincipal infoGluePrincipal, String roleName, String propertyName, boolean escapeHTML) {
        ArrayList<WebPage> pages = new ArrayList<WebPage>();
        try {
            if (this.getHasPrincipalRole(infoGluePrincipal, roleName)) {
                List siteNodeVOList = GroupPropertiesController.getController().getRelatedSiteNodes(roleName, this.languageId, propertyName);
                for (SiteNodeVO siteNodeVO : siteNodeVOList) {
                    try {
                        WebPage webPage = new WebPage();
                        webPage.setSiteNodeId(siteNodeVO.getSiteNodeId());
                        webPage.setLanguageId(this.languageId);
                        webPage.setContentId(null);
                        webPage.setNavigationTitle(this.nodeDeliveryController.getPageNavigationTitle(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, true, this.deliveryContext, escapeHTML));
                        webPage.setMetaInfoContentId(this.nodeDeliveryController.getMetaInfoContentId(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), META_INFO_BINDING_NAME, true, this.deliveryContext));
                        webPage.setUrl(this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, this.deliveryContext));
                        pages.add(webPage);
                    }
                    catch (Exception e) {
                        logger.info((Object)("An error occurred when looking up one of the related pages:" + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return pages;
    }

    public List getPrincipalRoleCategories(String roleName, String propertyName) {
        return this.getPrincipalRoleCategories(this.infoGluePrincipal, roleName, propertyName);
    }

    public List getPrincipalRoleCategories(InfoGluePrincipal infoGluePrincipal, String roleName, String propertyName) {
        List categories = new ArrayList();
        try {
            if (this.getHasPrincipalRole(infoGluePrincipal, roleName)) {
                categories = GroupPropertiesController.getController().getRelatedCategories(roleName, this.languageId, propertyName);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return categories;
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    @Override
    public Enumeration getRequestParamenterNames() {
        return this.request.getParameterNames();
    }

    @Override
    public String getRequestParameter(String parameterName) {
        String value = "";
        try {
            value = this.request.getParameter(parameterName);
            if (value == null) {
                value = "";
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get parameterName " + parameterName + " from request:" + e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public String[] getRequestParameterValues(String parameterName) {
        String[] value = null;
        try {
            value = this.request.getParameterValues(parameterName);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get parameterName " + parameterName + " from request:" + e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public BrowserBean getBrowserBean() {
        return this.browserBean;
    }

    @Override
    public void setDeliveryControllers(NodeDeliveryController nodeDeliveryController, ContentDeliveryController contentDeliveryController, IntegrationDeliveryController integrationDeliveryController) {
        this.nodeDeliveryController = nodeDeliveryController;
        this.contentDeliveryController = contentDeliveryController;
        this.integrationDeliveryController = integrationDeliveryController;
    }

    @Override
    public List getAssignedCategories(Integer contentId, String categoryKey, Integer languageId, boolean useLanguageFallback) {
        List assignedCategories = new ArrayList();
        this.deliveryContext.addUsedContent("content_" + contentId);
        try {
            assignedCategories = ContentDeliveryController.getContentDeliveryController().getAssignedCategoryVOsForContentVersionId(this.getDatabase(), contentId, languageId, categoryKey, this.siteNodeId, useLanguageFallback, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assignedCategories=" + categoryKey + " on content " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assignedCategories;
    }

    @Override
    public String getCategoryPath(Integer categoryId) {
        String categoryPath = null;
        try {
            categoryPath = CategoryController.getController().getCategoryPath(categoryId, this.getDatabase());
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the path for categoryId " + categoryId + ":" + e.getMessage()), (Throwable)e);
        }
        return categoryPath;
    }

    @Override
    public String getContentAttribute(String contentBindningName, String attributeName, boolean clean) {
        return this.getContentAttribute(contentBindningName, attributeName);
    }

    @Override
    public String getContentAttribute(String attributeName, boolean clean) {
        return this.getContentAttribute(attributeName);
    }

    @Override
    public String getContentAttribute(Integer contentId, String attributeName, boolean clean) {
        return this.getContentAttribute(contentId, attributeName);
    }

    @Override
    public String getContentAttribute(Integer contentId, Integer languageId, String attributeName, boolean clean) {
        return this.getContentAttribute(contentId, languageId, attributeName);
    }

    @Override
    public String getContentAttribute(ContentVersionVO contentVersionValue, String attributeName, boolean clean) {
        return this.getContentAttribute(contentVersionValue, attributeName);
    }

    @Override
    public String getMetaInfoContentAttribute(Integer contentId, Integer languageId, String attributeName, boolean clean) {
        return this.getMetaInfoContentAttribute(contentId, languageId, attributeName);
    }

    @Override
    public String getContentAttributeWithReturningId(Integer contentId, Integer languageId, String attributeName, boolean clean, Set contentVersionId) {
        return this.getContentAttribute(contentId, languageId, attributeName, contentVersionId);
    }

    @Override
    public String getContentAttribute(String attributeName) {
        String attributeValue = "";
        try {
            attributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), this.contentId, this.languageId, attributeName, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, false);
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on content " + this.contentId + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    @Override
    public String getContentAttribute(String contentBindningName, String attributeName) {
        String attributeValue = "";
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            if (contentVO != null) {
                attributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentVO.getContentId(), this.languageId, attributeName, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, false);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on contentBindning " + contentBindningName + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    @Override
    public String getContentAttribute(Integer contentId, String attributeName) {
        String attributeValue = "";
        this.deliveryContext.addUsedContent("content_" + contentId);
        try {
            attributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentId, this.languageId, attributeName, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, false);
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on content " + contentId + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    public String getContentAttributeValue(Integer contentId, String attributeName, boolean escapeHTML) {
        return this.getContentAttributeValue(contentId, this.getLanguageId(), attributeName, escapeHTML);
    }

    public String getContentAttributeValue(Integer contentId, String attributeName, boolean clean, boolean escapeHTML) {
        return this.getContentAttributeValue(contentId, this.getLanguageId(), attributeName, escapeHTML);
    }

    public String getContentAttributeValue(Integer contentId, Integer languageId, String attributeName, boolean escapeHTML) {
        String attributeValue = "";
        this.deliveryContext.addUsedContent("content_" + contentId);
        try {
            attributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentId, languageId, attributeName, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, escapeHTML);
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on content " + contentId + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    @Override
    public String getContentAttribute(Integer contentId, Integer languageId, String attributeName) {
        String attributeValue = "";
        this.deliveryContext.addUsedContent("content_" + contentId);
        try {
            attributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentId, languageId, attributeName, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, false);
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on content " + contentId + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    public String getMetaInfoContentAttribute(Integer contentId, Integer languageId, String attributeName) {
        String attributeValue = "";
        this.deliveryContext.addUsedContent("content_" + contentId);
        try {
            attributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentId, languageId, attributeName, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, false, true);
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on content " + contentId + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    public String getContentAttribute(Integer contentId, Integer languageId, String attributeName, Set contentVersionId) {
        String attributeValue = "";
        this.deliveryContext.addUsedContent("content_" + contentId);
        try {
            attributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentId, languageId, attributeName, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, false, contentVersionId);
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on content " + contentId + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    public String getContentAttribute(ContentVersionVO version, String attributeName) {
        try {
            return ContentDeliveryController.getContentDeliveryController().getAttributeValue(this.getDatabase(), version, attributeName, false);
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on content version" + version.getId() + "\nReason:" + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    @Override
    public String getContentAttributeUsingLanguageFallback(Integer contentId, String attributeName, boolean disableEditOnSight) {
        logger.info((Object)("getContentAttributeUsingLanguageFallback: " + contentId + ":" + attributeName + ":" + disableEditOnSight));
        String attributeValue = "";
        try {
            attributeValue = this.getContentAttribute(contentId, attributeName, true);
            if (attributeValue != null && attributeValue.trim().equals("")) {
                LanguageVO masteLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(this.getDatabase(), this.siteNodeId);
                attributeValue = this.getContentAttribute(contentId, masteLanguageVO.getLanguageId(), attributeName, disableEditOnSight);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on content " + contentId + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    @Override
    public String getParsedContentAttribute(String attributeName) {
        String attributeValue = "";
        try {
            if (this.contentId != null) {
                String unparsedAttributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), this.contentId, this.languageId, attributeName, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, false);
                logger.info((Object)("Found unparsedAttributeValue:" + unparsedAttributeValue));
                this.templateLogicContext.put("inlineContentId", this.contentId);
                HashMap<String, TemplateController> context = new HashMap<String, TemplateController>();
                context.put("inheritedTemplateLogic", this);
                context.put("templateLogic", this.getTemplateController(this.siteNodeId, this.languageId, this.contentId, this.request, this.infoGluePrincipal, this.deliveryContext));
                context.putAll(this.templateLogicContext);
                StringWriter cacheString = new StringWriter();
                PrintWriter cachedStream = new PrintWriter(cacheString);
                new VelocityTemplateProcessor().renderTemplate(context, cachedStream, unparsedAttributeValue, true);
                attributeValue = cacheString.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on sent in content with id:" + this.contentId + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    @Override
    public String getParsedContentAttribute(String contentBindningName, String attributeName) {
        logger.info((Object)("getParsedContentAttribute:" + contentBindningName + ":" + attributeName));
        String attributeValue = "";
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            if (contentVO != null) {
                logger.info((Object)("contentVO:" + contentVO.getContentId()));
                String unparsedAttributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentVO.getId(), this.languageId, attributeName, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, false);
                logger.info((Object)("Found unparsedAttributeValue:" + unparsedAttributeValue));
                this.templateLogicContext.put("inlineContentId", contentVO.getId());
                HashMap<String, TemplateController> context = new HashMap<String, TemplateController>();
                context.put("inheritedTemplateLogic", this);
                context.put("templateLogic", this.getTemplateController(this.siteNodeId, this.languageId, contentVO.getId(), this.request, this.infoGluePrincipal, this.deliveryContext));
                context.putAll(this.templateLogicContext);
                StringWriter cacheString = new StringWriter();
                PrintWriter cachedStream = new PrintWriter(cacheString);
                new VelocityTemplateProcessor().renderTemplate(context, cachedStream, unparsedAttributeValue, true);
                attributeValue = cacheString.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on contentBindning " + contentBindningName + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    @Override
    public String getParsedContentAttribute(Integer contentId, String attributeName) {
        String attributeValue = "";
        try {
            if (contentId != null) {
                String unparsedAttributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentId, this.languageId, attributeName, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, false);
                logger.info((Object)("Found unparsedAttributeValue:" + unparsedAttributeValue));
                this.templateLogicContext.put("inlineContentId", contentId);
                HashMap<String, TemplateController> context = new HashMap<String, TemplateController>();
                context.put("inheritedTemplateLogic", this);
                context.put("templateLogic", this.getTemplateController(this.siteNodeId, this.languageId, contentId, this.request, this.infoGluePrincipal, this.deliveryContext));
                context.putAll(this.templateLogicContext);
                StringWriter cacheString = new StringWriter();
                PrintWriter cachedStream = new PrintWriter(cacheString);
                new VelocityTemplateProcessor().renderTemplate(context, cachedStream, unparsedAttributeValue, true);
                attributeValue = cacheString.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on content with id " + contentId + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    public String getParsedContentAttribute(Integer contentId, Integer languageId, String attributeName) {
        String attributeValue = "";
        try {
            if (contentId != null) {
                String unparsedAttributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentId, languageId, attributeName, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, false);
                logger.info((Object)("Found unparsedAttributeValue:" + unparsedAttributeValue));
                this.templateLogicContext.put("inlineContentId", contentId);
                HashMap<String, TemplateController> context = new HashMap<String, TemplateController>();
                context.put("inheritedTemplateLogic", this);
                context.put("templateLogic", this.getTemplateController(this.siteNodeId, languageId, contentId, this.request, this.infoGluePrincipal, this.deliveryContext));
                context.putAll(this.templateLogicContext);
                StringWriter cacheString = new StringWriter();
                PrintWriter cachedStream = new PrintWriter(cacheString);
                new VelocityTemplateProcessor().renderTemplate(context, cachedStream, unparsedAttributeValue, true);
                attributeValue = cacheString.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on content with id " + contentId + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    public String getParsedContentAttribute(ContentVersionVO contentVersionVO, String attributeName) {
        String attributeValue = "";
        try {
            if (this.contentId != null) {
                String unparsedAttributeValue = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentVersionVO, attributeName, false);
                logger.info((Object)("Found unparsedAttributeValue:" + unparsedAttributeValue));
                this.templateLogicContext.put("inlineContentId", this.contentId);
                HashMap<String, TemplateController> context = new HashMap<String, TemplateController>();
                context.put("inheritedTemplateLogic", this);
                context.put("templateLogic", this.getTemplateController(this.siteNodeId, this.languageId, this.contentId, this.request, this.infoGluePrincipal, this.deliveryContext));
                context.putAll(this.templateLogicContext);
                StringWriter cacheString = new StringWriter();
                PrintWriter cachedStream = new PrintWriter(cacheString);
                new VelocityTemplateProcessor().renderTemplate(context, cachedStream, unparsedAttributeValue, true);
                attributeValue = cacheString.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get attributeName=" + attributeName + " on content with id " + this.contentId + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return attributeValue;
    }

    @Override
    public String getParsedText(String text) {
        String parsedText = "";
        try {
            if (text != null) {
                String unparsedAttributeValue = text;
                HashMap<String, TemplateController> context = new HashMap<String, TemplateController>();
                context.put("inheritedTemplateLogic", this);
                context.put("templateLogic", this.getTemplateController(this.siteNodeId, this.languageId, this.contentId, this.request, this.infoGluePrincipal, this.deliveryContext));
                context.putAll(this.templateLogicContext);
                StringWriter cacheString = new StringWriter();
                PrintWriter cachedStream = new PrintWriter(cacheString);
                new VelocityTemplateProcessor().renderTemplate(context, cachedStream, unparsedAttributeValue, true);
                parsedText = cacheString.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to parse text=" + text + "\nReason:" + e.getMessage()), (Throwable)e);
        }
        return parsedText;
    }

    @Override
    public String getParsedContentAttribute(String attributeName, boolean clean) {
        return this.getParsedContentAttribute(attributeName);
    }

    @Override
    public String getParsedContentAttribute(String contentBindningName, String attributeName, boolean clean) {
        return this.getParsedContentAttribute(contentBindningName, attributeName);
    }

    @Override
    public String getParsedContentAttribute(Integer contentId, String attributeName, boolean clean) {
        return this.getParsedContentAttribute(contentId, attributeName);
    }

    @Override
    public String getParsedContentAttribute(Integer contentId, Integer languageId, String attributeName, boolean clean) {
        return this.getParsedContentAttribute(contentId, languageId, attributeName);
    }

    @Override
    public String getParsedContentAttribute(ContentVersionVO contentVersionVO, String attributeName, boolean clean) {
        return this.getParsedContentAttribute(contentVersionVO, attributeName);
    }

    @Override
    public Collection getAssetKeys(String contentBindningName) {
        Collection assetKeys = new ArrayList();
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            assetKeys = ContentDeliveryController.getContentDeliveryController().getAssetKeys(this.getDatabase(), contentVO.getContentId(), this.languageId, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetKeys on content with id: " + this.contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetKeys;
    }

    @Override
    public Collection getAssetKeys(Integer contentId) {
        Collection assetKeys = new ArrayList();
        try {
            assetKeys = ContentDeliveryController.getContentDeliveryController().getAssetKeys(this.getDatabase(), contentId, this.languageId, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetKeys on content with id: " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetKeys;
    }

    @Override
    public Collection getAssetIds(Integer contentId) {
        Collection assetKeys = new ArrayList();
        try {
            assetKeys = ContentDeliveryController.getContentDeliveryController().getAssetIds(this.getDatabase(), contentId, this.languageId, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetKeys on content with id: " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetKeys;
    }

    @Override
    public DigitalAssetVO getAsset(Integer contentId, String assetKey) {
        DigitalAssetVO digitalAssetVO = null;
        try {
            digitalAssetVO = ContentDeliveryController.getContentDeliveryController().getAsset(this.getDatabase(), contentId, this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get asset on content with id: " + contentId + " and assetKey:" + assetKey + ":" + e.getMessage()), (Throwable)e);
        }
        return digitalAssetVO;
    }

    @Override
    public List getAssets(Integer contentId) {
        List assets = new ArrayList();
        try {
            assets = ContentDeliveryController.getContentDeliveryController().getAssets(this.getDatabase(), contentId, this.languageId, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetKeys on content with id: " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assets;
    }

    public Collection getContentTypeDefinitionAttributes(String schemaValue) {
        List attributes = new ArrayList();
        try {
            attributes = ContentTypeDefinitionController.getController().getContentTypeAttributes(schemaValue);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get attributes on content with id: " + this.contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return attributes;
    }

    @Override
    public Collection getContentTypeDefinitionAssetKeys(String schemaValue) {
        List assetKeys = new ArrayList();
        try {
            assetKeys = ContentTypeDefinitionController.getController().getDefinedAssetKeys(schemaValue);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetKeys on content with id: " + this.contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetKeys;
    }

    @Override
    public Collection getContentTypeDefinitionCategories(String schemaValue) {
        List categories = new ArrayList();
        try {
            categories = ContentTypeDefinitionController.getController().getDefinedCategoryKeys(schemaValue);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetKeys on content with id: " + this.contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return categories;
    }

    @Override
    public String getAssetThumbnailUrl(Integer contentId, int width, int height) {
        String assetThumbnailUrl = "";
        try {
            assetThumbnailUrl = ContentDeliveryController.getContentDeliveryController().getAssetThumbnailUrl(this.getDatabase(), contentId, this.languageId, this.siteNodeId, true, width, height, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetThumbnailUrl on contentId " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetThumbnailUrl;
    }

    @Override
    public String getAssetThumbnailUrl(Integer contentId, String assetKey, int width, int height) {
        String assetThumbnailUrl = "";
        try {
            assetThumbnailUrl = ContentDeliveryController.getContentDeliveryController().getAssetThumbnailUrl(this.getDatabase(), contentId, this.languageId, assetKey, this.siteNodeId, true, width, height, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetThumbnailUrl on contentId " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetThumbnailUrl;
    }

    @Override
    public String getAssetThumbnailUrlForAssetWithId(Integer digitalAssetId, int width, int height) {
        String assetThumbnailUrl = "";
        try {
            assetThumbnailUrl = ContentDeliveryController.getContentDeliveryController().getAssetThumbnailUrl(this.getDatabase(), digitalAssetId, this.siteNodeId, width, height, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetThumbnailUrl on contentId " + this.contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetThumbnailUrl;
    }

    @Override
    public String getAssetThumbnailUrl(String contentBindningName, int width, int height) {
        String assetUrl = "";
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            assetUrl = ContentDeliveryController.getContentDeliveryController().getAssetThumbnailUrl(this.getDatabase(), contentVO.getContentId(), this.languageId, this.siteNodeId, true, width, height, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on contentBindningName " + contentBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getAssetThumbnailUrl(String contentBindningName, String assetKey, int width, int height) {
        String assetThumbnailUrl = "";
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            assetThumbnailUrl = ContentDeliveryController.getContentDeliveryController().getAssetThumbnailUrl(this.getDatabase(), contentVO.getContentId(), this.languageId, assetKey, this.siteNodeId, true, width, height, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on contentBindningName " + contentBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return assetThumbnailUrl;
    }

    @Override
    public String getAssetUrl(String contentBindningName) {
        String assetUrl = "";
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            assetUrl = ContentDeliveryController.getContentDeliveryController().getAssetUrl(this.getDatabase(), contentVO.getContentId(), this.languageId, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on contentBindningName " + contentBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getEncodedUrl(String s, String enc) {
        String ret = "";
        try {
            ret = URLEncoder.encode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("An error occurred trying to encode the url: " + s + " with encoding: " + enc + ": " + e.getMessage()), (Throwable)e);
        }
        return ret;
    }

    @Override
    public String getAssetUrl(Integer contentId) {
        String assetUrl = "";
        try {
            assetUrl = ContentDeliveryController.getContentDeliveryController().getAssetUrl(this.getDatabase(), contentId, this.languageId, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on content with id: " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public List getAssetUrls(Integer contentId) {
        ArrayList<String> assetUrls = new ArrayList<String>();
        try {
            List digitalAssetVOList = this.getAssets(contentId);
            for (DigitalAssetVO digitalAssetVO : digitalAssetVOList) {
                String assetUrl = this.getAssetUrlForAssetWithId(digitalAssetVO.getId());
                assetUrls.add(assetUrl);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrls on content with id: " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrls;
    }

    @Override
    public String getAssetUrl(Integer contentId, String assetKey) {
        String assetUrl = "";
        try {
            assetUrl = ContentDeliveryController.getContentDeliveryController().getAssetUrl(this.getDatabase(), contentId, this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on content with id: " + contentId + " and assetKey:" + assetKey + " : " + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    public String getProtectedAssetUrl(Integer contentId, String assetKey) {
        String assetUrl = "";
        try {
            assetUrl = ContentDeliveryController.getContentDeliveryController().getAssetUrl(this.getDatabase(), contentId, this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on content with id: " + contentId + " and assetKey:" + assetKey + " : " + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getAssetUrlForAssetWithId(Integer digitalAssetId) {
        String assetUrl = "";
        try {
            assetUrl = ContentDeliveryController.getContentDeliveryController().getAssetUrl(this.getDatabase(), digitalAssetId, this.siteNodeId, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on content with digitalAssetId:" + digitalAssetId + " : " + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getAssetUrl(String contentBindningName, int index) {
        String assetUrl = "";
        try {
            List contentVOList = this.nodeDeliveryController.getBoundContents(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, true, true, this.deliveryContext);
            if (contentVOList != null && contentVOList.size() > index) {
                ContentVO contentVO = (ContentVO)contentVOList.get(index);
                assetUrl = ContentDeliveryController.getContentDeliveryController().getAssetUrl(this.getDatabase(), contentVO.getContentId(), this.languageId, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on contentBindningName " + contentBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getAssetUrl(String contentBindningName, String assetKey) {
        String assetUrl = "";
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            assetUrl = ContentDeliveryController.getContentDeliveryController().getAssetUrl(this.getDatabase(), contentVO.getContentId(), this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on contentBindningName " + contentBindningName + " with assetKey " + assetKey + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    public String getAssetUrl(InfoGluePrincipal principal, String assetKey, Integer languageId, Integer siteNodeId, boolean useLanguageFallback) {
        String assetUrl = "";
        try {
            assetUrl = ExtranetController.getController().getPrincipalAssetUrl(this.getDatabase(), principal, assetKey, languageId, siteNodeId, useLanguageFallback, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on principal " + principal.getName() + " with assetKey " + assetKey + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    public String getAssetThumbnailUrl(InfoGluePrincipal principal, String assetKey, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, int width, int height) {
        String assetUrl = "";
        try {
            assetUrl = ExtranetController.getController().getPrincipalThumbnailAssetUrl(this.getDatabase(), principal, assetKey, languageId, siteNodeId, useLanguageFallback, width, height, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on principal " + principal.getName() + " with assetKey " + assetKey + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getInlineAssetUrl(String assetKey) {
        String assetUrl = "";
        try {
            Integer inlineContentId = this.contentId;
            if (inlineContentId == null || inlineContentId == -1) {
                inlineContentId = (Integer)this.templateLogicContext.get("inlineContentId");
            }
            logger.info((Object)("getInlineAssetUrl:" + inlineContentId + ":" + this.languageId + ":" + assetKey + ":" + this.siteNodeId));
            assetUrl = ContentDeliveryController.getContentDeliveryController().getAssetUrl(this.getDatabase(), inlineContentId, this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on content with id: " + this.contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getInlineAssetUrl(Integer contentId, String assetKey) {
        String assetUrl = "";
        try {
            Integer inlineContentId = contentId;
            logger.info((Object)("getInlineAssetUrl:" + inlineContentId + ":" + this.languageId + ":" + assetKey + ":" + this.siteNodeId));
            assetUrl = ContentDeliveryController.getContentDeliveryController().getAssetUrl(this.getDatabase(), inlineContentId, this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("\nError on url: " + this.getOriginalFullURL() + "\nAn error occurred trying to get InlineAssetUrl for contentId: " + contentId + " with assetKey: " + assetKey + "\nReason:" + e.getMessage()));
        }
        return assetUrl;
    }

    @Override
    public Integer getAssetFileSize(Integer contentId) {
        Integer AssetFileSize = null;
        try {
            AssetFileSize = ContentDeliveryController.getContentDeliveryController().getAssetFileSize(this.getDatabase(), contentId, this.languageId, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get AssetFileSize on content with id: " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return AssetFileSize;
    }

    @Override
    public Integer getAssetFileSize(Integer contentId, String assetKey) {
        Integer AssetFileSize = null;
        try {
            AssetFileSize = ContentDeliveryController.getContentDeliveryController().getAssetFileSize(this.getDatabase(), contentId, this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get AssetFileSize on content with id: " + contentId + " and assetKey:" + assetKey + " : " + e.getMessage()), (Throwable)e);
        }
        return AssetFileSize;
    }

    @Override
    public Integer getAssetFileSize(String contentBindningName, int index) {
        Integer AssetFileSize = null;
        try {
            List contentVOList = this.nodeDeliveryController.getBoundContents(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, true, true, this.deliveryContext);
            if (contentVOList != null && contentVOList.size() > index) {
                ContentVO contentVO = (ContentVO)contentVOList.get(index);
                AssetFileSize = ContentDeliveryController.getContentDeliveryController().getAssetFileSize(this.getDatabase(), contentVO.getContentId(), this.languageId, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get AssetFileSize on contentBindningName " + contentBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return AssetFileSize;
    }

    public Integer getAssetFileSizeForAssetWithId(Integer digitalAssetId) {
        Integer assetFileSize = null;
        try {
            DigitalAssetVO digitalAsset = DigitalAssetController.getDigitalAssetVOWithId(digitalAssetId);
            if (digitalAsset != null) {
                assetFileSize = digitalAsset.getAssetFileSize();
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetFileSize with digitalAssetId " + digitalAssetId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetFileSize;
    }

    @Override
    public Integer getAssetFileSize(String contentBindningName, String assetKey) {
        Integer AssetFileSize = null;
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            AssetFileSize = ContentDeliveryController.getContentDeliveryController().getAssetFileSize(this.getDatabase(), contentVO.getContentId(), this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get AssetFileSize on contentBindningName " + contentBindningName + " with assetKey " + assetKey + ":" + e.getMessage()), (Throwable)e);
        }
        return AssetFileSize;
    }

    @Override
    public List getRelatedContentsByQualifyer(String qualifyerXML) {
        List relatedContentVOList = new ArrayList();
        try {
            relatedContentVOList = this.getRelatedContentsFromXML(qualifyerXML);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related contents from qualifyer: " + qualifyerXML + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedContentVOList;
    }

    @Override
    public List getRelatedContents(String attributeName) {
        List relatedContentVOList = new ArrayList();
        try {
            String qualifyerXML = this.getContentAttribute(attributeName, true);
            relatedContentVOList = this.getRelatedContentsFromXML(qualifyerXML);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related contents on contentId " + this.contentId + " with relationName " + attributeName + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedContentVOList;
    }

    @Override
    public List getRelatedContents(String bindingName, String attributeName) {
        List relatedContentVOList = new ArrayList();
        try {
            String qualifyerXML = this.getContentAttribute(bindingName, attributeName, true);
            relatedContentVOList = this.getRelatedContentsFromXML(qualifyerXML);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related contents on contentId " + this.contentId + " with relationName " + attributeName + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedContentVOList;
    }

    @Override
    public List getRelatedContents(Integer contentId, String attributeName) {
        List relatedContentVOList = new ArrayList();
        try {
            logger.info((Object)("contentId " + this.contentId + " with relationName " + attributeName));
            String qualifyerXML = this.getContentAttribute(contentId, attributeName, true);
            relatedContentVOList = this.getRelatedContentsFromXML(qualifyerXML);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related contents on contentId " + this.contentId + " with relationName " + attributeName + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedContentVOList;
    }

    @Override
    public List getRelatedContents(Integer contentId, String attributeName, boolean useAttributeLanguageFallBack) {
        List relatedContentVOList = new ArrayList();
        try {
            logger.info((Object)("contentId " + this.contentId + " with relationName " + attributeName));
            String qualifyerXML = null;
            qualifyerXML = useAttributeLanguageFallBack ? this.getContentAttributeUsingLanguageFallback(contentId, attributeName, true) : this.getContentAttribute(contentId, attributeName, true);
            relatedContentVOList = this.getRelatedContentsFromXML(qualifyerXML);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related contents on contentId " + this.contentId + " with relationName " + attributeName + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedContentVOList;
    }

    public List getRelatedContents(InfoGluePrincipal infogluePrincipal, String attributeName) {
        List relatedContentVOList = new ArrayList();
        try {
            String qualifyerXML = this.getPrincipalPropertyValue(infogluePrincipal, attributeName, false);
            relatedContentVOList = this.getRelatedContentsFromXML(qualifyerXML);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related contents on contentId " + this.contentId + " with relationName " + attributeName + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedContentVOList;
    }

    private List getRelatedContentsFromXML(String qualifyerXML) {
        ArrayList<ContentVO> relatedContentVOList = new ArrayList<ContentVO>();
        try {
            if (qualifyerXML != null && !qualifyerXML.equals("")) {
                Document document = domBuilder.getDocument(qualifyerXML);
                List children = document.getRootElement().elements();
                for (Element child : children) {
                    ContentVO contentVO;
                    String id = child.attributeValue("id");
                    if (id == null || id.equals("")) {
                        id = child.getText();
                    }
                    if ((contentVO = this.getContent(new Integer(id))) == null || !ContentDeliveryController.getContentDeliveryController().isValidContent(this.getDatabase(), contentVO.getId(), this.languageId, true, true, this.getPrincipal(), this.deliveryContext)) continue;
                    relatedContentVOList.add(contentVO);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related contents from qualifyerXML " + qualifyerXML + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedContentVOList;
    }

    private List getRelatedPagesFromXML(String qualifyerXML, boolean escapeHTML) {
        ArrayList<WebPage> relatedPages = new ArrayList<WebPage>();
        try {
            if (qualifyerXML != null && !qualifyerXML.equals("")) {
                Document document = domBuilder.getDocument(qualifyerXML);
                List children = document.getRootElement().elements();
                for (Element child : children) {
                    String id = child.attributeValue("id");
                    if (id == null || id.equals("")) {
                        id = child.getText();
                    }
                    try {
                        SiteNodeVO siteNodeVO = this.nodeDeliveryController.getSiteNode(this.getDatabase(), new Integer(id)).getValueObject();
                        if (!this.nodeDeliveryController.isValidSiteNode(this.getDatabase(), siteNodeVO.getId())) continue;
                        WebPage webPage = new WebPage();
                        webPage.setSiteNodeId(siteNodeVO.getSiteNodeId());
                        webPage.setLanguageId(this.languageId);
                        webPage.setContentId(null);
                        webPage.setNavigationTitle(this.nodeDeliveryController.getPageNavigationTitle(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, true, this.deliveryContext, escapeHTML));
                        webPage.setMetaInfoContentId(this.nodeDeliveryController.getMetaInfoContentId(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), META_INFO_BINDING_NAME, true, this.deliveryContext));
                        webPage.setUrl(this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, this.deliveryContext));
                        relatedPages.add(webPage);
                    }
                    catch (Exception e) {
                        logger.info((Object)("An error occurred when looking up one of the related Pages FromXML:" + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related contents from qualifyerXML " + qualifyerXML + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedPages;
    }

    @Override
    public List getRelatedPages(String attributeName) {
        return this.getRelatedPages(attributeName, false);
    }

    public List getRelatedPages(String attributeName, boolean escapeHTML) {
        List relatedPages = new ArrayList();
        try {
            String qualifyerXML = this.getContentAttribute(attributeName, true);
            relatedPages = this.getRelatedPagesFromXML(qualifyerXML, escapeHTML);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related contents on contentId " + this.contentId + " with relationName " + attributeName + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedPages;
    }

    @Override
    public List getRelatedPages(String bindingName, String attributeName) {
        return this.getRelatedPages(bindingName, attributeName, false);
    }

    public List getRelatedPages(String bindingName, String attributeName, boolean escapeHTML) {
        List relatedPages = new ArrayList();
        try {
            String qualifyerXML = this.getContentAttribute(bindingName, attributeName, true);
            relatedPages = this.getRelatedPagesFromXML(qualifyerXML, escapeHTML);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related contents on contentId " + this.contentId + " with relationName " + attributeName + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedPages;
    }

    @Override
    public List getRelatedPages(Integer contentId, String attributeName) {
        List relatedPages = new ArrayList();
        try {
            String qualifyerXML = this.getContentAttribute(contentId, attributeName, true);
            relatedPages = this.getRelatedPagesFromXML(qualifyerXML, false);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related contents on contentId " + this.contentId + " with relationName " + attributeName + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedPages;
    }

    public List getRelatedPages(InfoGluePrincipal infogluePrincipal, String attributeName) {
        List relatedPages = new ArrayList();
        try {
            String qualifyerXML = this.getPrincipalPropertyValue(infogluePrincipal, attributeName, false);
            relatedPages = this.getRelatedPagesFromXML(qualifyerXML, false);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get related pages on infogluePrincipal " + infogluePrincipal + " with relationName " + attributeName + ":" + e.getMessage()), (Throwable)e);
        }
        return relatedPages;
    }

    @Override
    public List getReferencingPages(Integer contentId, int maxRows) {
        return this.getReferencingPages(contentId, maxRows, new Boolean(true));
    }

    @Override
    public List getReferencingPages(Integer contentId, int maxRows, Boolean excludeCurrentPage) {
        ArrayList<Object> referencingPages;
        String cacheKey = "content_" + contentId + "_" + maxRows + "_" + excludeCurrentPage;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("cacheKey:" + cacheKey));
        }
        if ((referencingPages = (ArrayList<Object>)CacheController.getCachedObject("referencingPagesCache", cacheKey)) != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached referencingPages:" + referencingPages.size()));
            }
        } else {
            referencingPages = new ArrayList<Object>();
            try {
                List referencingObjects = RegistryController.getController().getReferencingObjectsForContent(contentId, maxRows, this.getDatabase());
                for (ReferenceBean referenceBean : referencingObjects) {
                    Object pageCandidate = referenceBean.getReferencingCompletingObject();
                    if (!(pageCandidate instanceof SiteNodeVO) || excludeCurrentPage.booleanValue() && ((SiteNodeVO)pageCandidate).getId().equals(this.getSiteNodeId())) continue;
                    referencingPages.add(pageCandidate);
                }
                if (referencingPages != null) {
                    CacheController.cacheObject("referencingPagesCache", cacheKey, referencingPages);
                }
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred trying to get referencing pages for the contentId " + this.contentId + ":" + e.getMessage()), (Throwable)e);
            }
        }
        return referencingPages;
    }

    @Override
    public String getArchiveBaseUrl(String contentBindningName, String assetKey) {
        String assetUrl = "";
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            assetUrl = ContentDeliveryController.getContentDeliveryController().getArchiveBaseUrl(this.getDatabase(), contentVO.getContentId(), this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on contentBindningName " + contentBindningName + " with assetKey " + assetKey + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    public String getArchiveBaseUrlForAssetWithId(Integer digitalAssetId) {
        String assetUrl = "";
        try {
            assetUrl = ContentDeliveryController.getContentDeliveryController().getArchiveBaseUrl(this.getDatabase(), digitalAssetId, this.siteNodeId, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl with digitalAssetId " + digitalAssetId + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getArchiveBaseUrl(Integer contentId, String assetKey) {
        String assetUrl = "";
        try {
            assetUrl = ContentDeliveryController.getContentDeliveryController().getArchiveBaseUrl(this.getDatabase(), contentId, this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on content with id " + contentId + " with assetKey " + assetKey + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public Vector getArchiveEntries(Integer contentId, String assetKey) {
        Vector entries = null;
        try {
            entries = ContentDeliveryController.getContentDeliveryController().getArchiveEntries(this.getDatabase(), contentId, this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on content with id " + contentId + " with assetKey " + assetKey + ":" + e.getMessage()), (Throwable)e);
        }
        return entries;
    }

    @Override
    public String getArchiveBaseUrl(String contentBindningName, int index, String assetKey) {
        String assetUrl = "";
        try {
            List contentVOList = this.nodeDeliveryController.getBoundContents(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, true, true, this.deliveryContext);
            if (contentVOList != null && contentVOList.size() > index) {
                ContentVO contentVO = (ContentVO)contentVOList.get(index);
                assetUrl = ContentDeliveryController.getContentDeliveryController().getArchiveBaseUrl(this.getDatabase(), contentVO.getContentId(), this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get assetUrl on contentBindningName " + contentBindningName + " with assetKey " + assetKey + ":" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getContentAttributeAsPDFUrl(String contentBindningName, String attributeName) {
        String pdfUrl = "";
        try {
            String template = this.getParsedContentAttribute(contentBindningName, attributeName, true);
            String uniqueId = this.siteNodeId + "_" + attributeName + "_" + contentBindningName + template.hashCode();
            String fileName = String.valueOf(uniqueId) + ".pdf";
            int i = 0;
            String filePath = CmsPropertyHandler.getDigitalAssetPath0();
            while (filePath != null) {
                File pdfFile = new File(String.valueOf(filePath) + File.separator + fileName);
                if (!pdfFile.exists()) {
                    logger.info((Object)"Creating a foprenderer");
                    FOPHelper fop = new FOPHelper();
                    fop.generatePDF(template, pdfFile);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
            }
            SiteNode siteNode = this.nodeDeliveryController.getSiteNode(this.getDatabase(), this.siteNodeId);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            pdfUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, null, fileName, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get ContentAttribute As PDFUrl:" + e.getMessage()), (Throwable)e);
        }
        return pdfUrl;
    }

    @Override
    public String getStringAsDigitalAssetUrl(String data, String fileName, String suffix) {
        String assetUrl = "";
        try {
            String uniqueFileName = fileName + data.hashCode() + "." + suffix;
            VisualFormatter vf = new VisualFormatter();
            uniqueFileName = vf.replaceNonAscii(uniqueFileName, '_');
            int i = 0;
            String filePath = CmsPropertyHandler.getDigitalAssetPath0();
            while (filePath != null) {
                File file = new File(String.valueOf(filePath) + File.separator + uniqueFileName);
                if (!file.exists()) {
                    FileHelper.writeToFile(file, data, false);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
            }
            SiteNode siteNode = this.nodeDeliveryController.getSiteNode(this.getDatabase(), this.siteNodeId);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            assetUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, null, uniqueFileName, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get text as Url:" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    public String getContentAttributeAsPDFUrl(Integer contentId, String attributeName) {
        String pdfUrl = "";
        try {
            String template = this.getParsedContentAttribute(contentId, attributeName, true);
            String uniqueId = contentId + "_" + attributeName + template.hashCode();
            String fileName = String.valueOf(uniqueId) + ".pdf";
            int i = 0;
            String filePath = CmsPropertyHandler.getDigitalAssetPath0();
            while (filePath != null) {
                File pdfFile = new File(String.valueOf(filePath) + File.separator + fileName);
                if (!pdfFile.exists()) {
                    logger.info((Object)"Creating a foprenderer");
                    FOPHelper fop = new FOPHelper();
                    fop.generatePDF(template, pdfFile);
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
            }
            SiteNode siteNode = this.nodeDeliveryController.getSiteNode(this.getDatabase(), this.siteNodeId);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            pdfUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, null, fileName, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get ContentAttribute As PDFUrl:" + e.getMessage()), (Throwable)e);
        }
        return pdfUrl;
    }

    @Override
    public String getContentAttributeAsImageUrl(String contentBindningName, String attributeName, int canvasWidth, int canvasHeight) {
        return this.getContentAttributeAsImageUrl(contentBindningName, attributeName, canvasWidth, canvasHeight, 5, 20, canvasWidth - 10, canvasHeight - 10, "Verdana", 1, 28, Color.black, Color.white);
    }

    @Override
    public String getContentAttributeAsImageUrl(String contentBindningName, String attributeName, int canvasWidth, int canvasHeight, int textStartPosX, int textStartPosY, int textWidth, int textHeight, String fontName, int fontStyle, int fontSize, String foregroundColor, String backgroundColor) {
        return this.getContentAttributeAsImageUrl(contentBindningName, attributeName, canvasWidth, canvasHeight, textStartPosX, textStartPosY, textWidth, textHeight, fontName, fontStyle, fontSize, new Color(this.getMathHelper().hexToDecimal(foregroundColor)), new Color(this.getMathHelper().hexToDecimal(backgroundColor)));
    }

    @Override
    public String getContentAttributeAsImageUrl(String contentBindningName, String attributeName, int canvasWidth, int canvasHeight, int textStartPosX, int textStartPosY, int textWidth, int textHeight, String fontName, int fontStyle, int fontSize, String foregroundColor, String backgroundColor, String backgroundImageUrl) {
        return this.getContentAttributeAsImageUrl(contentBindningName, attributeName, canvasWidth, canvasHeight, textStartPosX, textStartPosY, textWidth, textHeight, fontName, fontStyle, fontSize, new Color(this.getMathHelper().hexToDecimal(foregroundColor)), new Color(this.getMathHelper().hexToDecimal(backgroundColor)));
    }

    @Override
    public String getContentAttributeAsImageUrl(Integer contentId, String attributeName, int canvasWidth, int canvasHeight, int textStartPosX, int textStartPosY, int textWidth, int textHeight, String fontName, int fontStyle, int fontSize, String foregroundColor, String backgroundColor) {
        return this.getContentAttributeAsImageUrl(contentId, attributeName, canvasWidth, canvasHeight, textStartPosX, textStartPosY, textWidth, textHeight, fontName, fontStyle, fontSize, new Color(this.getMathHelper().hexToDecimal(foregroundColor)), new Color(this.getMathHelper().hexToDecimal(backgroundColor)));
    }

    @Override
    public String getContentAttributeAsImageUrl(String contentBindningName, String attributeName, int canvasWidth, int canvasHeight, int textStartPosX, int textStartPosY, int textWidth, int textHeight, String fontName, int fontStyle, int fontSize, Color foregroundColor, Color backgroundColor) {
        String assetUrl = "";
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            if (contentVO != null) {
                assetUrl = this.getContentAttributeAsImageUrl(contentVO.getContentId(), attributeName, canvasWidth, canvasHeight, textStartPosX, textStartPosY, textWidth, textHeight, fontName, fontStyle, fontSize, foregroundColor, backgroundColor);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get ContentAttribute As ImageUrl:" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getContentAttributeAsImageUrl(String contentBindningName, String attributeName, int canvasWidth, int canvasHeight, int textStartPosX, int textStartPosY, int textWidth, int textHeight, String fontName, int fontStyle, int fontSize, Color foregroundColor, Color backgroundColor, String backgroundImageUrl) {
        String assetUrl = "";
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            if (contentVO != null) {
                assetUrl = this.getContentAttributeAsImageUrl(contentVO.getContentId(), attributeName, canvasWidth, canvasHeight, textStartPosX, textStartPosY, textWidth, textHeight, fontName, fontStyle, fontSize, foregroundColor, backgroundColor, backgroundImageUrl);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get ContentAttribute As ImageUrl:" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getContentAttributeAsImageUrl(Integer contentId, String attributeName, int canvasWidth, int canvasHeight, int textStartPosX, int textStartPosY, int textWidth, int textHeight, String fontName, int fontStyle, int fontSize, Color foregroundColor, Color backgroundColor) {
        return this.getContentAttributeAsImageUrl(contentId, attributeName, canvasWidth, canvasHeight, textStartPosX, textStartPosY, textWidth, textHeight, fontName, fontStyle, fontSize, foregroundColor, backgroundColor, null);
    }

    @Override
    public String getRenderedTextUrl(Integer contentId, String text, Map renderAttributes) {
        String assetUrl = "";
        if (text == null || text.length() == 0) {
            logger.warn((Object)("Could not render text with a null or 0 lenght value on sitenode: " + this.getSiteNodeId() + ", contentId = " + contentId));
            return assetUrl;
        }
        try {
            ContentDeliveryController cdc = ContentDeliveryController.getContentDeliveryController();
            ContentTypeDefinitionController ctdc = ContentTypeDefinitionController.getController();
            ContentVersionVO contentVersionVO = cdc.getContentVersionVO(this.getDatabase(), this.siteNodeId, contentId, this.languageId, true, this.deliveryContext, this.infoGluePrincipal);
            Integer contentTypeDefinitionId = cdc.getContentVO(contentId, this.getDatabase()).getContentTypeDefinitionId();
            ContentTypeDefinitionVO contentTypeDefinitionVO = ctdc.getContentTypeDefinitionVOWithId(contentTypeDefinitionId);
            Iterator attrIterator = ctdc.getContentTypeAttributes(contentTypeDefinitionVO.getSchemaValue()).iterator();
            String aText = text.replaceAll("[^\\w]", "");
            aText = aText.substring(0, aText.length() < 8 ? aText.length() : 8).toLowerCase();
            StringBuffer uniqueId = new StringBuffer(aText);
            uniqueId.append("_" + contentVersionVO.getId());
            uniqueId.append("_" + Math.abs(text.hashCode()));
            uniqueId.append("_" + Math.abs(contentVersionVO.getVersionValue().hashCode()));
            uniqueId.append("_" + Math.abs(contentTypeDefinitionVO.getSchemaValue().hashCode()));
            uniqueId.append("_" + (renderAttributes != null ? Math.abs(renderAttributes.hashCode()) : 4711));
            AdvancedImageRenderer imageRenderer = new AdvancedImageRenderer();
            while (attrIterator.hasNext()) {
                ContentTypeAttribute contentTypeAttribute = (ContentTypeAttribute)attrIterator.next();
                String attributeName = contentTypeAttribute.getName();
                if (!imageRenderer.hasAttribute(attributeName)) continue;
                String attribute = cdc.getContentAttribute(this.getDatabase(), contentVersionVO, attributeName, false);
                imageRenderer.setAttribute(attributeName.toLowerCase(), attribute);
            }
            imageRenderer.renderImage(text, renderAttributes);
            String fileName = uniqueId + "." + imageRenderer.getImageFormatName();
            assetUrl = this.writeRenderedImage(imageRenderer, fileName);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to getRenderedTextUrl(), text = " + text + ", on siteNodeId = " + this.siteNodeId + " :" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getRenderedTextUrl(String text, Map renderAttributes) {
        String assetUrl = "";
        if (text == null || text.length() == 0) {
            logger.warn((Object)("Could not render text with a null or 0 lenght value on sitenode: " + this.getSiteNodeId()));
            return assetUrl;
        }
        try {
            String aText = text.replaceAll("[^\\w]", "");
            aText = aText.substring(0, aText.length() < 12 ? aText.length() : 11).toLowerCase();
            StringBuffer uniqueId = new StringBuffer(aText);
            uniqueId.append("_" + Math.abs(text.hashCode()));
            uniqueId.append("_" + (renderAttributes != null ? Math.abs(renderAttributes.hashCode()) : 4711));
            AdvancedImageRenderer imageRenderer = new AdvancedImageRenderer();
            imageRenderer.renderImage(text, renderAttributes);
            String fileName = uniqueId + "." + imageRenderer.getImageFormatName();
            assetUrl = this.writeRenderedImage(imageRenderer, fileName);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to getRenderedTextUrl(), text = " + text + ", on siteNodeId = " + this.siteNodeId + " :" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    private String writeRenderedImage(AdvancedImageRenderer imageRenderer, String fileName) throws SystemException {
        int i = 0;
        String filePath = CmsPropertyHandler.getDigitalAssetPath0();
        while (filePath != null) {
            File imageFile = new File(filePath, fileName);
            if (!imageFile.exists()) {
                imageRenderer.writeImage(imageFile);
            }
            filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
        }
        SiteNode siteNode = this.nodeDeliveryController.getSiteNode(this.getDatabase(), this.siteNodeId);
        String dnsName = CmsPropertyHandler.getWebServerAddress();
        if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
            dnsName = siteNode.getRepository().getDnsName();
        }
        return this.urlComposer.composeDigitalAssetUrl(dnsName, null, fileName, this.deliveryContext);
    }

    @Override
    public String getContentAttributeAsImageUrl(Integer contentId, String attributeName, int canvasWidth, int canvasHeight, int textStartPosX, int textStartPosY, int textWidth, int textHeight, String fontName, int fontStyle, int fontSize, Color foregroundColor, Color backgroundColor, String backgroundImageUrl) {
        String assetUrl = "";
        try {
            ContentVersionVO contentVersionVO = ContentDeliveryController.getContentDeliveryController().getContentVersionVO(this.getDatabase(), this.siteNodeId, contentId, this.languageId, true, this.deliveryContext, this.infoGluePrincipal);
            String attribute = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentVersionVO, attributeName, false);
            String uniqueId = contentVersionVO.getId() + "_" + attributeName + canvasWidth + canvasHeight + textStartPosX + textStartPosY + textWidth + textHeight + fontName.replaceAll(" ", "") + fontStyle + fontSize + foregroundColor.getRed() + foregroundColor.getGreen() + foregroundColor.getBlue() + backgroundColor.getRed() + backgroundColor.getGreen() + backgroundColor.getBlue();
            String fileName = String.valueOf(uniqueId) + ".png";
            int i = 0;
            String filePath = CmsPropertyHandler.getDigitalAssetPath0();
            while (filePath != null) {
                File imageFile = new File(String.valueOf(filePath) + File.separator + fileName);
                if (!imageFile.exists()) {
                    logger.info((Object)"Creating a imagerenderer");
                    ImageRenderer imageRenderer = new ImageRenderer();
                    imageRenderer.setCanvasWidth(canvasWidth);
                    imageRenderer.setCanvasHeight(canvasHeight);
                    imageRenderer.setTextStartPosX(textStartPosX);
                    imageRenderer.setTextStartPosY(textStartPosY);
                    imageRenderer.setTextWidth(textWidth);
                    imageRenderer.setTextHeight(textHeight);
                    imageRenderer.setFontName(fontName);
                    imageRenderer.setFontStyle(fontStyle);
                    imageRenderer.setFontSize(fontSize);
                    imageRenderer.setForeGroundColor(foregroundColor);
                    imageRenderer.setBackgroundColor(backgroundColor);
                    imageRenderer.setBackgroundImageUrl(backgroundImageUrl);
                    logger.info((Object)("Created imageRenderer and printing to " + filePath + File.separator + fileName));
                    imageRenderer.generateGifImageFromText(String.valueOf(filePath) + File.separator + fileName, attribute, LanguageDeliveryController.getLanguageDeliveryController().getLanguageVO(this.getDatabase(), this.languageId).getCharset());
                    logger.info((Object)"Rendered in getContentAttributeAsImageUrl");
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
            }
            SiteNode siteNode = this.nodeDeliveryController.getSiteNode(this.getDatabase(), this.siteNodeId);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            assetUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, null, fileName, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get ContentAttribute As ImageUrl:" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public List getContentAttributes(String schemaValue) {
        return ContentTypeDefinitionController.getController().getContentTypeAttributes(schemaValue);
    }

    @Override
    public String getStringAsImageUrl(String text, int canvasWidth, int canvasHeight, int textStartPosX, int textStartPosY, int textWidth, int textHeight, String fontName, int fontStyle, int fontSize, String foregroundColor, String backgroundColor) {
        return this.getStringAsImageUrl(text, canvasWidth, canvasHeight, textStartPosX, textStartPosY, textWidth, textHeight, fontName, fontStyle, fontSize, new Color(this.getMathHelper().hexToDecimal(foregroundColor)), new Color(this.getMathHelper().hexToDecimal(backgroundColor)));
    }

    public String getStringAsImageUrl(String text, int canvasWidth, int canvasHeight, int textStartPosX, int textStartPosY, int textWidth, int textHeight, String fontName, int fontStyle, int fontSize, String foregroundColor, String backgroundColor, String backGroundImageUrl) {
        return this.getStringAsImageUrl(text, canvasWidth, canvasHeight, textStartPosX, textStartPosY, textWidth, textHeight, fontName, fontStyle, fontSize, new Color(this.getMathHelper().hexToDecimal(foregroundColor)), new Color(this.getMathHelper().hexToDecimal(backgroundColor)), backGroundImageUrl);
    }

    @Override
    public String getStringAsImageUrl(String text, int canvasWidth, int canvasHeight, int textStartPosX, int textStartPosY, int textWidth, int textHeight, String fontName, int fontStyle, int fontSize, Color foregroundColor, Color backgroundColor) {
        return this.getStringAsImageUrl(text, canvasWidth, canvasHeight, textStartPosX, textStartPosY, textWidth, textHeight, fontName, fontStyle, fontSize, foregroundColor, backgroundColor, null);
    }

    public String getStringAsImageUrl(String text, int canvasWidth, int canvasHeight, int textStartPosX, int textStartPosY, int textWidth, int textHeight, String fontName, int fontStyle, int fontSize, Color foregroundColor, Color backgroundColor, String backgroundImageUrl) {
        String assetUrl = "";
        try {
            String uniqueId = String.valueOf(text.hashCode()) + "_" + canvasWidth + canvasHeight + textStartPosX + textStartPosY + textWidth + textHeight + fontName.replaceAll(" ", "") + fontStyle + fontSize + foregroundColor.getRed() + foregroundColor.getGreen() + foregroundColor.getBlue() + backgroundColor.getRed() + backgroundColor.getGreen() + backgroundColor.getBlue();
            String fileName = String.valueOf(uniqueId) + ".png";
            int i = 0;
            String filePath = CmsPropertyHandler.getDigitalAssetPath0();
            while (filePath != null) {
                File imageFile = new File(String.valueOf(filePath) + File.separator + fileName);
                if (!imageFile.exists()) {
                    logger.info((Object)"Creating a imagerenderer");
                    ImageRenderer imageRenderer = new ImageRenderer();
                    imageRenderer.setCanvasWidth(canvasWidth);
                    imageRenderer.setCanvasHeight(canvasHeight);
                    imageRenderer.setTextStartPosX(textStartPosX);
                    imageRenderer.setTextStartPosY(textStartPosY);
                    imageRenderer.setTextWidth(textWidth);
                    imageRenderer.setTextHeight(textHeight);
                    imageRenderer.setFontName(fontName);
                    imageRenderer.setFontStyle(fontStyle);
                    imageRenderer.setFontSize(fontSize);
                    imageRenderer.setForeGroundColor(foregroundColor);
                    imageRenderer.setBackgroundColor(backgroundColor);
                    imageRenderer.setBackgroundImageUrl(backgroundImageUrl);
                    logger.info((Object)("Created imageRenderer and printing to " + filePath + File.separator + fileName));
                    imageRenderer.generateGifImageFromText(String.valueOf(filePath) + File.separator + fileName, text, LanguageDeliveryController.getLanguageDeliveryController().getLanguageVO(this.getDatabase(), this.languageId).getCharset());
                    logger.info((Object)"Rendered in getContentAttributeAsImageUrl");
                }
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
            }
            SiteNode siteNode = this.nodeDeliveryController.getSiteNode(this.getDatabase(), this.siteNodeId);
            String dnsName = CmsPropertyHandler.getWebServerAddress();
            if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                dnsName = siteNode.getRepository().getDnsName();
            }
            assetUrl = this.urlComposer.composeDigitalAssetUrl(dnsName, null, fileName, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to render string as an image:" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }

    @Override
    public String getDigitalAssetBaseUrl() throws Exception {
        String url = String.valueOf(this.getRepositoryBaseUrl()) + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl();
        return url;
    }

    @Override
    public Integer getDigitalAssetId(Integer contentId, String assetKey) throws Exception {
        return ContentDeliveryController.getContentDeliveryController().getDigitalAssetId(this.getDatabase(), contentId, this.languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
    }

    @Override
    public Integer getDigitalAssetId(Integer contentId, Integer languageId, String assetKey) throws Exception {
        return ContentDeliveryController.getContentDeliveryController().getDigitalAssetId(this.getDatabase(), contentId, languageId, assetKey, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal);
    }

    public String getRepositoryExtraProperty(String propertyName) {
        String propertyValue = RepositoryDeliveryController.getRepositoryDeliveryController().getExtraPropertyValue(this.getSiteNode().getRepositoryId(), propertyName);
        return propertyValue;
    }

    @Override
    public String getRepositoryBaseUrl() throws Exception {
        String url = "";
        String context = CmsPropertyHandler.getServletContext();
        SiteNode siteNode = this.nodeDeliveryController.getSiteNode(this.getDatabase(), this.siteNodeId);
        String dnsName = CmsPropertyHandler.getWebServerAddress();
        if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
            dnsName = siteNode.getRepository().getDnsName();
            String useDNSNameInUrls = CmsPropertyHandler.getUseDNSNameInURI();
            if (!useDNSNameInUrls.equalsIgnoreCase("false")) {
                String operatingMode = CmsPropertyHandler.getOperatingMode();
                String keyword = "";
                if (operatingMode.equalsIgnoreCase("0")) {
                    keyword = "working=";
                } else if (operatingMode.equalsIgnoreCase("2")) {
                    keyword = "preview=";
                }
                if (operatingMode.equalsIgnoreCase("3")) {
                    keyword = "live=";
                }
                if (dnsName != null) {
                    int startIndex = dnsName.indexOf(keyword);
                    if (startIndex != -1) {
                        int endIndex = dnsName.indexOf(",", startIndex);
                        dnsName = endIndex > -1 ? dnsName.substring(startIndex, endIndex) : dnsName.substring(startIndex);
                        dnsName = dnsName.split("=")[1];
                    } else {
                        int endIndex = dnsName.indexOf(",");
                        dnsName = endIndex > -1 ? dnsName.substring(0, endIndex) : dnsName.substring(0);
                    }
                }
                dnsName = String.valueOf(dnsName) + context;
            } else {
                dnsName = context;
            }
        }
        url = dnsName;
        return url;
    }

    @Override
    public SiteNodeVO getRepositoryRootSiteNode() throws Exception {
        Integer repositoryId = this.getSiteNode(this.siteNodeId).getRepositoryId();
        SiteNodeVO siteNodeVO = this.getRepositoryRootSiteNode(repositoryId);
        return siteNodeVO;
    }

    @Override
    public SiteNodeVO getRepositoryRootSiteNode(Integer repositoryId) throws Exception {
        SiteNodeVO siteNodeVO = this.nodeDeliveryController.getRootSiteNode(this.getDatabase(), repositoryId);
        return siteNodeVO;
    }

    @Override
    public Integer getParentRepositoryId(Integer repositoryId) {
        String parentRepository = RepositoryDeliveryController.getRepositoryDeliveryController().getPropertyValue(repositoryId, "parentRepository");
        if (parentRepository != null && !parentRepository.equalsIgnoreCase("")) {
            return new Integer(parentRepository);
        }
        return null;
    }

    @Override
    public Integer getParentRepositoryId() {
        Integer repositoryId = this.getSiteNode(this.siteNodeId).getRepositoryId();
        return this.getParentRepositoryId(repositoryId);
    }

    @Override
    public String getPageUrl(String structureBindningName) {
        String pageUrl = "";
        try {
            SiteNodeVO siteNodeVO = this.nodeDeliveryController.getBoundSiteNode(this.getDatabase(), this.siteNodeId, structureBindningName);
            if (siteNodeVO != null) {
                pageUrl = this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, this.deliveryContext);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get page url for structureBindningName " + structureBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return pageUrl;
    }

    @Override
    public String getPageUrl(WebPage webpage, Integer contentId) {
        String pageUrl = "";
        try {
            pageUrl = this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), webpage.getSiteNodeId(), webpage.getLanguageId(), contentId, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the transformed page url " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return pageUrl;
    }

    @Override
    public String getPageBaseUrl(String structureBindningName) {
        String pageUrl = "";
        try {
            pageUrl = this.nodeDeliveryController.getPageBaseUrl(this.getDatabase());
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get page url for structureBindningName " + structureBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return pageUrl;
    }

    public String getPageBaseUrl() {
        String pageUrl = "";
        try {
            pageUrl = this.nodeDeliveryController.getPageBaseUrl(this.getDatabase());
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get page url the current url:" + e.getMessage()), (Throwable)e);
        }
        return pageUrl;
    }

    @Override
    public SiteNodeVO getSiteNode() {
        SiteNodeVO siteNodeVO = null;
        try {
            siteNodeVO = this.nodeDeliveryController.getSiteNode(this.getDatabase(), this.siteNodeId).getValueObject();
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get the current content:" + e.getMessage()), (Throwable)e);
        }
        return siteNodeVO;
    }

    @Override
    public SiteNodeVO getSiteNode(Integer siteNodeId) {
        SiteNodeVO siteNodeVO = null;
        try {
            siteNodeVO = this.nodeDeliveryController.getSiteNode(this.getDatabase(), siteNodeId).getValueObject();
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get the siteNode with id " + siteNodeId + ":" + e.getMessage()), (Throwable)e);
        }
        return siteNodeVO;
    }

    @Override
    public Integer getSiteNodeId(String structureBindningName) {
        Integer siteNodeId = null;
        try {
            SiteNodeVO siteNodeVO = this.nodeDeliveryController.getBoundSiteNode(this.getDatabase(), this.siteNodeId, structureBindningName);
            siteNodeId = siteNodeVO.getSiteNodeId();
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get siteNodeId for structureBindningName " + structureBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return siteNodeId;
    }

    @Override
    public Collection<SiteNodeVO> getSiteNodesFromWebPages(Collection webPages) {
        ArrayList<SiteNodeVO> siteNodeVOList = new ArrayList<SiteNodeVO>();
        try {
            for (WebPage webPage : webPages) {
                SiteNodeVO siteNodeVO = this.getSiteNode(webPage.getSiteNodeId());
                siteNodeVOList.add(siteNodeVO);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to convert the list of webpages:" + e.getMessage()), (Throwable)e);
        }
        return siteNodeVOList;
    }

    @Override
    public Integer getContentId(String contentBindningName) {
        Integer contentId = null;
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            if (contentVO != null) {
                contentId = contentVO.getId();
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get contentId for contentBindningName " + contentBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return contentId;
    }

    @Override
    public Integer getMetaInformationContentId() {
        return this.getContentId(META_INFO_BINDING_NAME);
    }

    @Override
    public Integer getMetaInformationContentId(Integer siteNodeId) {
        return this.getContentId(siteNodeId, META_INFO_BINDING_NAME);
    }

    @Override
    public Collection getChildContents(Integer contentId, boolean includeFolders) {
        List childContents = null;
        try {
            childContents = ContentDeliveryController.getContentDeliveryController().getChildContents(this.getDatabase(), this.getPrincipal(), contentId, this.languageId, true, includeFolders, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get childContents for contentId " + contentId + ":" + e.getMessage()), (Throwable)e);
        }
        return childContents;
    }

    @Override
    public Integer getContentId(Integer siteNodeId, String contentBindningName) {
        Integer contentId = null;
        try {
            ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
            if (contentVO != null) {
                contentId = contentVO.getId();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get contentId for contentBindningName " + contentBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return contentId;
    }

    @Override
    public List getContentVersionsByCategory(Integer categoryId, String attributeName) {
        try {
            return ContentDeliveryController.getContentDeliveryController().findContentVersionVOsForCategory(this.getDatabase(), categoryId, attributeName, this.getPrincipal(), this.siteNodeId, this.languageId, true, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get Content for categoryId " + categoryId + ":" + e.getMessage()), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public List getPrincipalContentVersions(String contentTypeDefinitionName, String principalName, Date publishStartDate, Date publishEndDate, Date unpublishStartDate, Date unpublishEndDate) {
        try {
            Integer contentTypeDefinitionId = null;
            ContentTypeDefinitionVO contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName(contentTypeDefinitionName, this.getDatabase());
            if (contentTypeDefinitionVO != null) {
                contentTypeDefinitionId = contentTypeDefinitionVO.getId();
            }
            Set contentVersions = SearchController.getContentVersions(contentTypeDefinitionId, principalName, publishStartDate, publishEndDate, unpublishStartDate, unpublishEndDate);
            ArrayList<ContentVersionVO> result = new ArrayList<ContentVersionVO>();
            for (ContentVersionVO contentVersionVO : contentVersions) {
                if (!ContentDeliveryController.getContentDeliveryController().isValidContent(this.getDatabase(), contentVersionVO.getContentId(), this.languageId, true, true, this.getPrincipal(), this.deliveryContext)) continue;
                result.add(contentVersionVO);
            }
            return result;
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get content version which was last changed by:" + principalName + ":" + e.getMessage()), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public List getMatchingContents(String contentTypeDefinitionNamesString, String categoryConditionString, boolean useLanguageFallback) {
        return this.getMatchingContents(contentTypeDefinitionNamesString, categoryConditionString, null, null, null, null, useLanguageFallback);
    }

    @Override
    public List getMatchingContents(String contentTypeDefinitionNamesString, String categoryConditionString, String freeText, List freeTextAttributeNames, Date fromDate, Date toDate, boolean useLanguageFallback) {
        return this.getMatchingContents(contentTypeDefinitionNamesString, categoryConditionString, null, null, null, null, useLanguageFallback, false, -1, null, null);
    }

    @Override
    public List getMatchingContents(String contentTypeDefinitionNamesString, String categoryConditionString, String freeText, List freeTextAttributeNames, Date fromDate, Date toDate, boolean useLanguageFallback, boolean cacheResult, int cacheInterval, String cacheName, String cacheKey) {
        return this.getMatchingContents(contentTypeDefinitionNamesString, categoryConditionString, null, null, null, null, useLanguageFallback, false, -1, null, null, null);
    }

    @Override
    public List getMatchingContents(String contentTypeDefinitionNamesString, String categoryConditionString, String freeText, List freeTextAttributeNames, Date fromDate, Date toDate, boolean useLanguageFallback, boolean cacheResult, int cacheInterval, String cacheName, String cacheKey, List<Integer> repositoryIdList) {
        String key;
        List cachedMatchingContents;
        if (freeText != null && !freeText.equals("") || freeTextAttributeNames != null && freeTextAttributeNames.size() > 0 || fromDate != null || toDate != null) {
            cacheResult = false;
        }
        if (cacheName == null || cacheName.equals("")) {
            cacheName = "matchingContentsCache";
        }
        if (cacheKey == null || cacheKey.equals("")) {
            cacheKey = "matchingContentsCache";
        }
        StringBuffer repositoryIdString = new StringBuffer();
        if (repositoryIdList != null) {
            Iterator<Integer> repositoryIdListIterator = repositoryIdList.iterator();
            while (repositoryIdListIterator.hasNext()) {
                repositoryIdString.append("," + repositoryIdListIterator.next());
            }
        }
        if ((cachedMatchingContents = (List)CacheController.getCachedObjectFromAdvancedCache(cacheName, key = "sortedMatchingContents" + contentTypeDefinitionNamesString + "_" + categoryConditionString + "_publishDateTime_languageId_" + this.languageId + "_" + useLanguageFallback + repositoryIdString, cacheInterval)) == null || !cacheResult) {
            logger.info((Object)("Getting matching contents from db for key:" + key));
            try {
                ArrayList<ContentTypeDefinitionVO> contentTypeDefinitionVOList = new ArrayList<ContentTypeDefinitionVO>();
                String[] contentTypeDefinitionNames = contentTypeDefinitionNamesString.split(",");
                int i = 0;
                while (i < contentTypeDefinitionNames.length) {
                    ContentTypeDefinitionVO contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName(contentTypeDefinitionNames[i], this.getDatabase());
                    if (contentTypeDefinitionVO != null) {
                        contentTypeDefinitionVOList.add(contentTypeDefinitionVO);
                    }
                    ++i;
                }
                CategoryConditions categoryConditions = CategoryConditions.parse(categoryConditionString);
                ExtendedSearchCriterias criterias = new ExtendedSearchCriterias(this.getOperatingMode());
                criterias.setCategoryConditions(categoryConditions);
                criterias.setLanguage(this.getLanguage(this.getLanguageId()));
                if (freeText != null && freeTextAttributeNames != null) {
                    criterias.setFreetext(freeText, freeTextAttributeNames);
                }
                criterias.setContentTypeDefinitions(contentTypeDefinitionVOList);
                criterias.setDates(fromDate, toDate);
                if (repositoryIdList != null && repositoryIdList.size() > 0) {
                    criterias.setRepositoryIdList(repositoryIdList);
                }
                Set set = ExtendedSearchController.getController().search(criterias, this.getDatabase());
                ArrayList<ContentVO> result = new ArrayList<ContentVO>();
                for (Content content : set) {
                    if (!ContentDeliveryController.getContentDeliveryController().isValidContent(this.getDatabase(), content.getId(), this.languageId, true, true, this.getPrincipal(), this.deliveryContext)) continue;
                    result.add(content.getValueObject());
                }
                if (cacheResult) {
                    CacheController.cacheObjectInAdvancedCache(cacheName, key, result, null, false);
                }
                return result;
            }
            catch (Exception e) {
                logger.warn((Object)("An error occurred trying to get Matching Contents for contentTypeDefinitionNamesString: " + contentTypeDefinitionNamesString + ":" + e.getMessage()), (Throwable)e);
            }
        } else if (cachedMatchingContents != null) {
            logger.info((Object)("Getting cached contents for key:" + key));
            return cachedMatchingContents;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Integer getOperatingMode() {
        Integer operatingMode = new Integer(0);
        try {
            operatingMode = new Integer(CmsPropertyHandler.getOperatingMode());
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the operating mode from the propertyFile:" + e.getMessage()), (Throwable)e);
        }
        return operatingMode;
    }

    public String getSmtpServer() {
        return CmsPropertyHandler.getMailSmtpHost();
    }

    public String getSmtpPort() {
        return CmsPropertyHandler.getMailSmtpPort();
    }

    @Override
    public String getPageUrl(String structureBindningName, Integer contentId) {
        String pageUrl = "";
        try {
            SiteNodeVO siteNodeVO = this.nodeDeliveryController.getBoundSiteNode(this.getDatabase(), this.siteNodeId, structureBindningName);
            pageUrl = this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, contentId, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get page url for structureBindningName " + structureBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return pageUrl;
    }

    @Override
    public String getPageUrlOnPosition(String structureBindningName, int position) {
        String pageUrl = "";
        try {
            SiteNodeVO siteNodeVO = this.nodeDeliveryController.getBoundSiteNode(this.getDatabase(), this.siteNodeId, structureBindningName, position);
            pageUrl = this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get page url for structureBindningName " + structureBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return pageUrl;
    }

    @Override
    public String getPageUrl(String structureBindningName, int position, Integer contentId) {
        String pageUrl = "";
        try {
            SiteNodeVO siteNodeVO = this.nodeDeliveryController.getBoundSiteNode(this.getDatabase(), this.siteNodeId, structureBindningName, position);
            pageUrl = this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, contentId, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get page url for structureBindningName " + structureBindningName + ":" + e.getMessage()), (Throwable)e);
        }
        return pageUrl;
    }

    @Override
    public String getCurrentPageUrl() {
        String pageUrl = "";
        try {
            pageUrl = this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, this.contentId, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get current page url:" + e.getMessage()), (Throwable)e);
        }
        return pageUrl;
    }

    @Override
    public String getOriginalURL() {
        String originalRequestURL = this.getHttpServletRequest().getParameter("originalRequestURL");
        if (originalRequestURL == null || originalRequestURL.length() == 0) {
            originalRequestURL = this.getHttpServletRequest().getRequestURL().toString();
        }
        return originalRequestURL;
    }

    @Override
    public String getOriginalQueryString() {
        String originalQueryString = this.getHttpServletRequest().getParameter("originalQueryString");
        if (originalQueryString == null || originalQueryString.length() == 0) {
            originalQueryString = this.getHttpServletRequest().getQueryString();
        }
        return originalQueryString;
    }

    @Override
    public String getOriginalFullURL() {
        String originalRequestURL = this.getOriginalURL();
        String originalQueryString = this.getOriginalQueryString();
        return String.valueOf(originalRequestURL) + (originalQueryString == null ? "" : "?" + originalQueryString);
    }

    @Override
    public String getPageUrl(Integer siteNodeId, Integer languageId, Integer contentId) {
        String pageUrl = "";
        try {
            pageUrl = this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), siteNodeId, languageId, contentId, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get page url for siteNodeId[" + siteNodeId + "]:" + e.getMessage() + "\n" + "The page generating the error was:" + this.getOriginalFullURL()));
        }
        return pageUrl;
    }

    @Override
    public String getPageAsDigitalAssetUrl(Integer siteNodeId, Integer languageId, Integer contentId, String fileSuffix, boolean cacheUrl) {
        String pageDigitalAssetUrl = "";
        try {
            pageDigitalAssetUrl = this.nodeDeliveryController.getPageAsDigitalAssetUrl(this.getDatabase(), this.getPrincipal(), siteNodeId, languageId, contentId, this.deliveryContext, fileSuffix, cacheUrl);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get current page digitalAsset url:" + e.getMessage()), (Throwable)e);
        }
        return pageDigitalAssetUrl;
    }

    @Override
    public String getCurrentPagePath() {
        String pagePath = "";
        try {
            pagePath = this.nodeDeliveryController.getPagePath(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, this.contentId, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, true, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get current page url:" + e.getMessage()), (Throwable)e);
        }
        return pagePath;
    }

    @Override
    public String getPagePath(Integer siteNodeId, Integer languageId) {
        String pagePath = "";
        try {
            pagePath = this.nodeDeliveryController.getPagePath(this.getDatabase(), this.getPrincipal(), siteNodeId, languageId, this.contentId, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, true, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get current page url:" + e.getMessage()), (Throwable)e);
        }
        return pagePath;
    }

    @Override
    public String getContentPath(Integer contentId) {
        return this.getContentPath(contentId, false, false);
    }

    @Override
    public String getContentPath(Integer contentId, boolean includeRootContent, boolean includeRepositoryName) {
        StringBuffer sb = new StringBuffer();
        ContentVO contentVO = this.getContent(contentId);
        if (contentVO != null) {
            sb.insert(0, contentVO.getName());
            while (contentVO.getParentContentId() != null) {
                contentVO = this.getContent(contentVO.getParentContentId());
                if (!includeRootContent && contentVO.getParentContentId() == null) continue;
                sb.insert(0, String.valueOf(contentVO.getName()) + "/");
            }
            if (includeRepositoryName) {
                try {
                    RepositoryVO repositoryVO = RepositoryController.getController().getRepositoryVOWithId(contentVO.getRepositoryId(), this.getDatabase());
                    if (repositoryVO != null) {
                        sb.insert(0, String.valueOf(repositoryVO.getName()) + " - /");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("The repository for content " + contentVO.getName() + ":" + contentVO.getId() + " did not exist. Must be an inconsistency."));
                }
            }
        }
        return sb.toString();
    }

    @Override
    public SiteNodeVO getParentSiteNode(Integer siteNodeId) {
        SiteNodeVO siteNodeVO = null;
        try {
            siteNodeVO = this.nodeDeliveryController.getParentSiteNode(this.getDatabase(), siteNodeId);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get parent siteNode:" + e.getMessage()), (Throwable)e);
        }
        return siteNodeVO;
    }

    @Override
    public String getPageUrlAfterLanguageChange(String languageCode) {
        String pageUrl = "";
        try {
            LanguageVO languageVO = LanguageDeliveryController.getLanguageDeliveryController().getLanguageWithCode(this.getDatabase(), languageCode);
            pageUrl = this.nodeDeliveryController.getPageUrlAfterLanguageChange(this.getDatabase(), this.getPrincipal(), this.siteNodeId, languageVO.getLanguageId(), this.contentId, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the new page-url after language-change:" + e.getMessage()), (Throwable)e);
        }
        return pageUrl;
    }

    @Override
    public String getPageTitle() {
        String navTitle = "";
        try {
            navTitle = this.nodeDeliveryController.getPageNavigationTitle(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, null, META_INFO_BINDING_NAME, TITLE_ATTRIBUTE_NAME, true, this.deliveryContext, false);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the page navigationtitle:" + e.getMessage()), (Throwable)e);
        }
        return navTitle;
    }

    @Override
    public String getPageNavTitle(String structureBindningName) {
        return this.getPageNavTitle(structureBindningName, false);
    }

    public String getPageNavTitle(String structureBindningName, boolean escapeHTML) {
        String navTitle = "";
        try {
            SiteNodeVO siteNodeVO = this.nodeDeliveryController.getBoundSiteNode(this.getDatabase(), this.siteNodeId, structureBindningName);
            logger.info((Object)siteNodeVO.getName());
            navTitle = this.nodeDeliveryController.getPageNavigationTitle(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, true, this.deliveryContext, escapeHTML);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the page navigationtitle on " + this.getCurrentPagePath() + ": " + e.getMessage()), (Throwable)e);
        }
        return navTitle;
    }

    @Override
    public String getPageNavTitle(Integer siteNodeId) {
        return this.getPageNavTitle(siteNodeId, false);
    }

    public String getPageNavTitle(Integer siteNodeId, boolean escapeHTML) {
        String navTitle = "";
        try {
            navTitle = this.nodeDeliveryController.getPageNavigationTitle(this.getDatabase(), this.getPrincipal(), siteNodeId, this.languageId, null, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, true, this.deliveryContext, escapeHTML);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get the page navigationtitle on " + this.getCurrentPagePath() + ": " + e.getMessage()), (Throwable)e);
        }
        return navTitle;
    }

    @Override
    public String getPageNavTitle(String structureBindningName, int index) {
        return this.getPageNavTitle(structureBindningName, index, false);
    }

    public String getPageNavTitle(String structureBindningName, int index, boolean escapeHTML) {
        String navTitle = "";
        try {
            SiteNodeVO siteNodeVO = this.nodeDeliveryController.getBoundSiteNode(this.getDatabase(), this.siteNodeId, structureBindningName, index);
            logger.info((Object)siteNodeVO.getName());
            navTitle = this.nodeDeliveryController.getPageNavigationTitle(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, true, this.deliveryContext, escapeHTML);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the page navigationtitle on " + this.getCurrentPagePath() + ": " + e.getMessage()), (Throwable)e);
        }
        return navTitle;
    }

    @Override
    public boolean getIsPageCacheDisabled() {
        boolean isPageCacheDisabled = false;
        try {
            isPageCacheDisabled = this.nodeDeliveryController.getIsPageCacheDisabled(this.getDatabase(), this.siteNodeId);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled pageCache:" + e.getMessage()), (Throwable)e);
        }
        return isPageCacheDisabled;
    }

    @Override
    public String getPageContentType() {
        String pageContentType = "text/html";
        try {
            SiteNodeVersionVO latestSiteNodeVersionVO = this.nodeDeliveryController.getLatestActiveSiteNodeVersionVO(this.getDatabase(), this.siteNodeId);
            if (latestSiteNodeVersionVO != null && latestSiteNodeVersionVO.getContentType() != null && latestSiteNodeVersionVO.getContentType().length() > 0) {
                pageContentType = latestSiteNodeVersionVO.getContentType();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get the content type of the page:" + e.getMessage()), (Throwable)e);
        }
        return pageContentType;
    }

    @Override
    public Integer getPageCacheTimeout() {
        Integer pageCacheTimeout = null;
        try {
            String pageCacheTimeoutString;
            SiteNodeVersionVO latestSiteNodeVersionVO = this.nodeDeliveryController.getLatestActiveSiteNodeVersionVO(this.getDatabase(), this.siteNodeId);
            if (latestSiteNodeVersionVO != null && latestSiteNodeVersionVO.getContentType() != null && latestSiteNodeVersionVO.getContentType().length() > 0 && (pageCacheTimeoutString = latestSiteNodeVersionVO.getPageCacheTimeout()) != null && !pageCacheTimeoutString.equals("")) {
                pageCacheTimeout = new Integer(pageCacheTimeoutString);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get the pageCacheTimeout of the page " + this.siteNodeId + ":" + e.getMessage()), (Throwable)e);
        }
        return pageCacheTimeout;
    }

    @Override
    public boolean getIsPageProtected() {
        boolean isPageProtected = false;
        try {
            isPageProtected = this.nodeDeliveryController.getIsPageProtected(this.getDatabase(), this.siteNodeId);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has protect page:" + e.getMessage()), (Throwable)e);
        }
        return isPageProtected;
    }

    @Override
    public boolean getIsInPageComponentMode() {
        boolean isInPageComponentMode = false;
        try {
            if (this instanceof EditOnSiteBasicTemplateController) {
                isInPageComponentMode = true;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the user was is editing mode:" + e.getMessage()), (Throwable)e);
        }
        return isInPageComponentMode;
    }

    @Override
    public boolean getIsEditOnSightDisabled() {
        boolean isEditOnSightDisabled = false;
        try {
            isEditOnSightDisabled = this.nodeDeliveryController.getIsEditOnSightDisabled(this.getDatabase(), this.siteNodeId);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled editOnSight:" + e.getMessage()), (Throwable)e);
        }
        return isEditOnSightDisabled;
    }

    @Override
    public List getAvailableLanguages() {
        List availableLanguages = new ArrayList();
        try {
            availableLanguages = LanguageDeliveryController.getLanguageDeliveryController().getAvailableLanguages(this.getDatabase(), this.siteNodeId);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get all available languages:" + e.getMessage()), (Throwable)e);
        }
        return availableLanguages;
    }

    @Override
    public List getNodeAvailableLanguages() {
        return this.getNodeAvailableLanguages(this.siteNodeId);
    }

    @Override
    public List getNodeAvailableLanguages(Integer siteNodeId) {
        List availableLanguages = new ArrayList();
        try {
            availableLanguages = LanguageDeliveryController.getLanguageDeliveryController().getAvailableLanguages(this.getDatabase(), siteNodeId);
            Iterator languageIterator = availableLanguages.iterator();
            while (languageIterator.hasNext()) {
                LanguageVO languageVO = (LanguageVO)languageIterator.next();
                ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), siteNodeId, this.languageId, true, META_INFO_BINDING_NAME, this.deliveryContext);
                ContentVersionVO contentVersionVO = null;
                if (contentVO != null) {
                    contentVersionVO = ContentDeliveryController.getContentDeliveryController().getContentVersionVO(this.getDatabase(), siteNodeId, contentVO.getId(), languageVO.getId(), false, this.deliveryContext, this.infoGluePrincipal);
                }
                if (contentVO != null && contentVersionVO != null) continue;
                logger.warn((Object)("The meta-info did not have a version of " + languageVO.getName()));
                languageIterator.remove();
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get all available languages:" + e.getMessage()), (Throwable)e);
        }
        return availableLanguages;
    }

    @Override
    public List getPageLanguages() {
        return this.getPageLanguages(this.siteNodeId);
    }

    @Override
    public List getPageLanguages(Integer siteNodeId) {
        List availableLanguages = new ArrayList();
        try {
            availableLanguages = LanguageDeliveryController.getLanguageDeliveryController().getLanguagesForSiteNode(this.getDatabase(), siteNodeId, this.getPrincipal());
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get all available languages:" + e.getMessage()), (Throwable)e);
        }
        return availableLanguages;
    }

    @Override
    public WebPage getPage(Integer siteNodeId, Integer languageId, Integer contentId, boolean escapeHTML, boolean hideUnauthorizedPages) {
        if (siteNodeId == null || siteNodeId < 1) {
            return null;
        }
        WebPage page = null;
        try {
            SiteNodeVO siteNodeVO = this.getSiteNode(siteNodeId);
            page = this.getPage(siteNodeVO, escapeHTML, hideUnauthorizedPages);
        }
        catch (Exception e) {
            logger.warn((Object)("There was a problem getting the page for siteNodeId[" + siteNodeId + "]. Message: " + e.getMessage()));
        }
        return page;
    }

    @Override
    public List getChildPages() {
        return this.getChildPages(false);
    }

    public List getChildPages(boolean escapeHTML) {
        return this.getChildPages(false, false);
    }

    public List getChildPages(boolean escapeHTML, boolean hideUnauthorizedPages) {
        List childPages = new ArrayList();
        try {
            List childNodeVOList = this.nodeDeliveryController.getChildSiteNodes(this.getDatabase(), this.siteNodeId);
            childPages = this.getPages(childNodeVOList, escapeHTML, hideUnauthorizedPages);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the page childPages:" + e.getMessage()), (Throwable)e);
        }
        return childPages;
    }

    @Override
    public List getChildPages(String structureBindingName) {
        return this.getChildPages(structureBindingName, false);
    }

    public List getChildPages(String structureBindingName, boolean escapeHTML) {
        return this.getChildPages(structureBindingName, escapeHTML, false);
    }

    public List getChildPages(String structureBindingName, boolean escapeHTML, boolean hideUnauthorizedPages) {
        List childPages = new ArrayList();
        try {
            List childNodeVOList = this.nodeDeliveryController.getChildSiteNodes(this.getDatabase(), this.getSiteNodeId(structureBindingName));
            childPages = this.getPages(childNodeVOList, escapeHTML, hideUnauthorizedPages);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the page childPages:" + e.getMessage()), (Throwable)e);
        }
        return childPages;
    }

    private WebPage getPage(SiteNodeVO siteNodeVO, boolean escapeHTML, boolean hideUnauthorizedPages) throws Exception {
        WebPage page = null;
        if (!hideUnauthorizedPages || this.getHasUserPageAccess(siteNodeVO.getId())) {
            try {
                page = new WebPage();
                page.setSiteNodeId(siteNodeVO.getSiteNodeId());
                page.setLanguageId(this.languageId);
                page.setContentId(null);
                page.setNavigationTitle(this.nodeDeliveryController.getPageNavigationTitle(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, true, this.deliveryContext, escapeHTML));
                page.setMetaInfoContentId(this.nodeDeliveryController.getMetaInfoContentId(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), META_INFO_BINDING_NAME, true, this.deliveryContext));
                page.setUrl(this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, this.deliveryContext));
            }
            catch (Exception e) {
                logger.info((Object)("An error occurred when looking up the page:" + e.getMessage()), (Throwable)e);
            }
        }
        return page;
    }

    private List getPages(List childNodeVOList, boolean escapeHTML, boolean hideUnauthorizedPages) throws Exception {
        ArrayList<WebPage> childPages = new ArrayList<WebPage>();
        for (SiteNodeVO siteNodeVO : childNodeVOList) {
            if (hideUnauthorizedPages && !this.getHasUserPageAccess(siteNodeVO.getId())) continue;
            try {
                WebPage webPage = new WebPage();
                webPage.setSiteNodeId(siteNodeVO.getSiteNodeId());
                webPage.setLanguageId(this.languageId);
                webPage.setContentId(null);
                webPage.setNavigationTitle(this.nodeDeliveryController.getPageNavigationTitle(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, true, this.deliveryContext, escapeHTML));
                webPage.setMetaInfoContentId(this.nodeDeliveryController.getMetaInfoContentId(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), META_INFO_BINDING_NAME, true, this.deliveryContext));
                webPage.setUrl(this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, this.deliveryContext));
                childPages.add(webPage);
            }
            catch (Exception e) {
                logger.info((Object)("An error occurred when looking up one of the childPages:" + e.getMessage()), (Throwable)e);
            }
        }
        return childPages;
    }

    @Override
    public List getChildPages(Integer siteNodeId) {
        return this.getChildPages(siteNodeId, false, false);
    }

    public List getChildPages(Integer siteNodeId, boolean escapeHTML) {
        return this.getChildPages(siteNodeId, escapeHTML, false);
    }

    @Override
    public List getChildPages(Integer siteNodeId, boolean escapeHTML, boolean hideUnauthorizedPages) {
        List childPages = new ArrayList();
        try {
            List childNodeVOList = this.nodeDeliveryController.getChildSiteNodes(this.getDatabase(), siteNodeId);
            childPages = this.getPages(childNodeVOList, escapeHTML, hideUnauthorizedPages);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the page childPages:" + e.getMessage()), (Throwable)e);
        }
        return childPages;
    }

    public List getChildPages(Integer siteNodeId, String sortAttribute, String sortOrder) {
        return this.getChildPages(siteNodeId, sortAttribute, sortOrder, false, false);
    }

    public List getChildPages(Integer siteNodeId, String sortAttribute, String sortOrder, boolean hideUnauthorizedPages) {
        return this.getChildPages(siteNodeId, sortAttribute, sortOrder, false, hideUnauthorizedPages);
    }

    public List getChildPages(Integer siteNodeId, String sortAttribute, String sortOrder, boolean escapeHTML, boolean hideUnauthorizedPages) {
        List childPages = new ArrayList();
        try {
            List childNodeVOList = this.nodeDeliveryController.getChildSiteNodes(this.getDatabase(), siteNodeId);
            Collections.sort(childNodeVOList, new SiteNodeComparator(sortAttribute, sortOrder, this));
            childPages = this.getPages(childNodeVOList, escapeHTML, hideUnauthorizedPages);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the page childPages:" + e.getMessage()), (Throwable)e);
        }
        return childPages;
    }

    @Override
    public List getBoundPages(String structureBindningName) {
        return this.getBoundPages(structureBindningName, false, false);
    }

    public List getBoundPages(String structureBindningName, boolean escapeHTML) {
        return this.getBoundPages(structureBindningName, escapeHTML, false);
    }

    public List getBoundPages(String structureBindningName, boolean escapeHTML, boolean hideUnauthorizedPages) {
        return this.getBoundPages(this.siteNodeId, structureBindningName, escapeHTML, false);
    }

    @Override
    public List getBoundPages(Integer siteNodeId, String structureBindningName) {
        return this.getBoundPages(siteNodeId, structureBindningName, false, false);
    }

    public List getBoundPages(Integer siteNodeId, String structureBindningName, boolean escapeHTML) {
        return this.getBoundPages(siteNodeId, structureBindningName, escapeHTML, false);
    }

    public List getBoundPages(Integer siteNodeId, String structureBindningName, boolean escapeHTML, boolean hideUnauthorizedPages) {
        if (this.cachedBindings.containsKey(siteNodeId + "_" + structureBindningName + "_" + hideUnauthorizedPages)) {
            return (List)this.cachedBindings.get(siteNodeId + "_" + structureBindningName + "_" + hideUnauthorizedPages);
        }
        List boundPages = new ArrayList();
        try {
            List siteNodeVOList = this.nodeDeliveryController.getBoundSiteNodes(this.getDatabase(), siteNodeId, structureBindningName);
            boundPages = this.getPages(siteNodeVOList, escapeHTML, hideUnauthorizedPages);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the bound pages:" + e.getMessage()), (Throwable)e);
        }
        this.cachedBindings.put(siteNodeId + "_" + structureBindningName + "_" + hideUnauthorizedPages, boundPages);
        return boundPages;
    }

    @Override
    public List getLocalizedBoundPages(String structureBindningName) {
        if (this.cachedBindings.containsKey(structureBindningName)) {
            return (List)this.cachedBindings.get(structureBindningName);
        }
        ArrayList<WebPage> boundPages = new ArrayList<WebPage>();
        try {
            List siteNodeVOList = this.nodeDeliveryController.getBoundSiteNodes(this.getDatabase(), this.siteNodeId, structureBindningName);
            for (SiteNodeVO siteNodeVO : siteNodeVOList) {
                try {
                    Integer metaInfoContentId = this.nodeDeliveryController.getMetaInfoContentId(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), META_INFO_BINDING_NAME, false, this.deliveryContext);
                    String navigationTitle = this.nodeDeliveryController.getPageNavigationTitle(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, META_INFO_BINDING_NAME, NAV_TITLE_ATTRIBUTE_NAME, false, this.deliveryContext, false);
                    if (metaInfoContentId == null || navigationTitle == null || navigationTitle.equals("")) continue;
                    WebPage webPage = new WebPage();
                    webPage.setSiteNodeId(siteNodeVO.getSiteNodeId());
                    webPage.setLanguageId(this.languageId);
                    webPage.setContentId(null);
                    webPage.setNavigationTitle(navigationTitle);
                    webPage.setMetaInfoContentId(metaInfoContentId);
                    webPage.setUrl(this.nodeDeliveryController.getPageUrl(this.getDatabase(), this.getPrincipal(), siteNodeVO.getSiteNodeId(), this.languageId, null, this.deliveryContext));
                    boundPages.add(webPage);
                }
                catch (Exception e) {
                    logger.info((Object)("An error occurred when looking up one of the getLocalizedBoundPages:" + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the bound pages:" + e.getMessage()), (Throwable)e);
        }
        this.cachedBindings.put(structureBindningName, boundPages);
        return boundPages;
    }

    @Override
    public ContentVO getBoundContent(String structureBindningName) {
        ContentVO content = null;
        List contents = this.getBoundContents(structureBindningName);
        if (contents != null && contents.size() > 0) {
            content = (ContentVO)contents.get(0);
        }
        return content;
    }

    @Override
    public List getBoundContents(String structureBindningName) {
        if (this.cachedBindings.containsKey(structureBindningName)) {
            return (List)this.cachedBindings.get(structureBindningName);
        }
        List boundContents = new ArrayList();
        try {
            boundContents = this.nodeDeliveryController.getBoundContents(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, structureBindningName, true, true, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the bound contents:" + e.getMessage()), (Throwable)e);
        }
        this.cachedBindings.put(structureBindningName, boundContents);
        return boundContents;
    }

    @Override
    public List getBoundFolderContents(String structureBindningName, boolean searchRecursive, String sortAttribute, String sortOrder) {
        List boundContents = new ArrayList();
        try {
            boundContents = this.nodeDeliveryController.getBoundFolderContents(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, structureBindningName, searchRecursive, new Integer(3), sortAttribute, sortOrder, true, false, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the bound contents:" + e.getMessage()), (Throwable)e);
        }
        return boundContents;
    }

    @Override
    public List getBoundFolderContents(Integer siteNodeId, String structureBindningName, boolean searchRecursive, String sortAttribute, String sortOrder) {
        List boundContents = new ArrayList();
        try {
            boundContents = this.nodeDeliveryController.getBoundFolderContents(this.getDatabase(), this.getPrincipal(), siteNodeId, this.languageId, structureBindningName, searchRecursive, new Integer(3), sortAttribute, sortOrder, true, false, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the bound contents:" + e.getMessage()), (Throwable)e);
        }
        return boundContents;
    }

    @Override
    public List getChildContents(Integer contentId, boolean searchRecursive, String sortAttribute, String sortOrder) {
        return this.getChildContents(contentId, searchRecursive, sortAttribute, sortOrder, false);
    }

    @Override
    public List getChildContents(Integer contentId, boolean searchRecursive, String sortAttribute, String sortOrder, boolean includeFolders) {
        List childContents = new ArrayList();
        try {
            childContents = this.nodeDeliveryController.getBoundFolderContents(this.getDatabase(), this.getPrincipal(), contentId, this.languageId, searchRecursive, new Integer(3), sortAttribute, sortOrder, true, includeFolders, this.deliveryContext);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the bound contents:" + e.getMessage()), (Throwable)e);
        }
        return childContents;
    }

    @Override
    public ContentTypeDefinitionVO getContentTypeDefinitionVO(Integer contentId) {
        ContentTypeDefinitionVO contentTypeDefinition = null;
        try {
            contentTypeDefinition = ContentDeliveryController.getContentDeliveryController().getContentTypeDefinitionVO(this.getDatabase(), contentId);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the bound contents:" + e.getMessage()), (Throwable)e);
        }
        return contentTypeDefinition;
    }

    @Override
    public ContentTypeDefinitionVO getContentTypeDefinitionVO(String name) {
        ContentTypeDefinitionVO contentTypeDefinition = null;
        try {
            contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName(name, this.getDatabase());
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get the bound contents:" + e.getMessage()), (Throwable)e);
        }
        return contentTypeDefinition;
    }

    @Override
    public WebPage getBoundPage(String structureBindningName, int position) {
        List boundPages = this.getBoundPages(structureBindningName);
        if (boundPages.size() > position) {
            return (WebPage)boundPages.get(position);
        }
        return null;
    }

    @Override
    public String renderString(String template) {
        String result = "";
        try {
            HashMap<String, TemplateController> context = new HashMap<String, TemplateController>();
            context.put("inheritedTemplateLogic", this);
            context.put("templateLogic", this.getTemplateController(this.siteNodeId, this.languageId, this.contentId, this.request, this.infoGluePrincipal, this.deliveryContext));
            context.putAll(this.templateLogicContext);
            StringWriter cacheString = new StringWriter();
            PrintWriter cachedStream = new PrintWriter(cacheString);
            new VelocityTemplateProcessor().renderTemplate(context, cachedStream, template);
            result = cacheString.toString();
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to do an include:" + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    @Override
    public String renderString(String template, boolean useSubContext) {
        String result = "";
        try {
            HashMap<String, TemplateController> context = new HashMap<String, TemplateController>();
            if (!useSubContext) {
                context.put("templateLogic", this);
            } else {
                context.put("inheritedTemplateLogic", this);
                context.put("templateLogic", this.getTemplateController(this.siteNodeId, this.languageId, this.contentId, this.request, this.infoGluePrincipal, this.deliveryContext));
            }
            context.putAll(this.templateLogicContext);
            StringWriter cacheString = new StringWriter();
            PrintWriter cachedStream = new PrintWriter(cacheString);
            new VelocityTemplateProcessor().renderTemplate(context, cachedStream, template);
            result = cacheString.toString();
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to do an include:" + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    @Override
    public String include(String contentBindningName, String attributeName) {
        return this.include(contentBindningName, attributeName, true);
    }

    @Override
    public String include(String contentBindningName, String attributeName, boolean cacheInclude) {
        return this.include(contentBindningName, attributeName, cacheInclude, null, null);
    }

    @Override
    public String include(String contentBindningName, String attributeName, boolean cacheInclude, String cName, Object cObject) {
        String includeKey = this.siteNodeId + "_" + this.languageId + "_" + this.contentId + "_" + this.browserBean.getUseragent() + "_" + contentBindningName + "_" + attributeName;
        logger.info((Object)("includeKey:" + includeKey));
        String result = (String)CacheController.getCachedObject("includeCache", includeKey);
        if (result != null) {
            logger.info((Object)("There was an cached include:" + result));
        } else {
            try {
                ContentVO contentVO = this.nodeDeliveryController.getBoundContent(this.getDatabase(), this.getPrincipal(), this.siteNodeId, this.languageId, true, contentBindningName, this.deliveryContext);
                if (contentVO != null) {
                    String includedTemplate = ContentDeliveryController.getContentDeliveryController().getContentAttribute(this.getDatabase(), contentVO.getContentId(), this.languageId, TEMPLATE_ATTRIBUTE_NAME, this.siteNodeId, true, this.deliveryContext, this.infoGluePrincipal, false);
                    logger.info((Object)("Found included template:" + includedTemplate));
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put("inheritedTemplateLogic", this);
                    context.put("templateLogic", this.getTemplateController(this.siteNodeId, this.languageId, this.contentId, this.request, this.infoGluePrincipal, this.deliveryContext));
                    context.put("deliveryContext", this.deliveryContext);
                    context.putAll(this.templateLogicContext);
                    if (cName != null) {
                        context.put(cName, cObject);
                    }
                    StringWriter cacheString = new StringWriter();
                    PrintWriter cachedStream = new PrintWriter(cacheString);
                    new VelocityTemplateProcessor().renderTemplate(context, cachedStream, includedTemplate);
                    result = cacheString.toString();
                    logger.info((Object)("result:" + result));
                    if (cacheInclude) {
                        CacheController.cacheObject("includeCache", includeKey, result);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred trying to do an include:" + e.getMessage()), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public String getUrlContent(String url) {
        String contents = "";
        try {
            logger.info((Object)("We are going to do an include on an external webpage: " + url));
            contents = this.integrationDeliveryController.getUrlContent(url, this.request, true);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to do an include the url:" + url), (Throwable)e);
        }
        return contents;
    }

    @Override
    public String getUrlContent(String url, boolean includeRequest) {
        String contents = "";
        try {
            logger.info((Object)("We are going to do an include on an external webpage: " + url));
            contents = this.integrationDeliveryController.getUrlContent(url, this.request, includeRequest);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to do an include the url:" + url), (Throwable)e);
        }
        return contents;
    }

    @Override
    public String getUrlContent(String url, String encoding) {
        String contents = "";
        try {
            logger.info((Object)("We are going to do an include on an external webpage: " + url));
            contents = this.integrationDeliveryController.getUrlContent(url, this.request, true, encoding);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to do an include the url:" + url), (Throwable)e);
        }
        return contents;
    }

    @Override
    public String getUrlContent(String url, boolean includeRequest, String encoding) {
        String contents = "";
        try {
            logger.info((Object)("We are going to do an include on an external webpage: " + url));
            contents = this.integrationDeliveryController.getUrlContent(url, this.request, includeRequest, encoding);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to do an include the url:" + url), (Throwable)e);
        }
        return contents;
    }

    @Override
    public Object getObjectWithName(String classname) {
        try {
            return this.integrationDeliveryController.getObjectWithName(classname, this.request);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String replace(String originalString, String expressionToReplace, String newString) {
        return originalString.replaceAll(expressionToReplace, newString);
    }

    @Override
    public String replace(String originalString, String substring, String stringToReplace, String newString) {
        StringBuffer result = new StringBuffer();
        int startIndex = 0;
        int stopIndex = 0;
        int offset = 0;
        try {
            List substrings = this.search(originalString, substring);
            for (String currentSubstring : substrings) {
                String newSubstring = currentSubstring.replaceAll(stringToReplace, newString);
                startIndex = originalString.indexOf(currentSubstring, offset);
                stopIndex = startIndex + currentSubstring.length();
                result.append(originalString.substring(offset, startIndex));
                result.append(originalString.substring(startIndex, stopIndex));
                result.append(newSubstring);
                offset = stopIndex;
            }
            if (offset < originalString.length()) {
                result.append(originalString.substring(offset));
            }
        }
        catch (Exception e) {
            logger.error((Object)("The replace function experienced an error:" + e.getMessage()), (Throwable)e);
        }
        return result.toString();
    }

    private List search(String containsMatches, String regexp) throws Exception {
        ArrayList<String> foundMatches = new ArrayList<String>();
        int matches = 0;
        Perl5Compiler compiler = new Perl5Compiler();
        Perl5Matcher matcher = new Perl5Matcher();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(regexp);
        }
        catch (MalformedPatternException e) {
            throw new Exception("A bad pattern was entered:" + e.getMessage());
        }
        PatternMatcherInput input = new PatternMatcherInput(containsMatches);
        while (matcher.contains(input, pattern)) {
            MatchResult result = matcher.getMatch();
            ++matches;
            foundMatches.add(result.toString());
        }
        return foundMatches;
    }

    @Override
    public boolean getIsCurrentSiteNode(Integer siteNodeId) {
        return this.siteNodeId.equals(siteNodeId);
    }

    @Override
    public boolean getIsParentToCurrent(Integer siteNodeId) {
        return this.getIsParentToCurrentRecursive(siteNodeId, this.siteNodeId);
    }

    private boolean getIsParentToCurrentRecursive(Integer siteNodeId, Integer currentSiteNodeId) {
        boolean isParentToCurrent = false;
        try {
            if (currentSiteNodeId != null && siteNodeId != null && currentSiteNodeId.intValue() == siteNodeId.intValue()) {
                isParentToCurrent = true;
            } else {
                SiteNodeVO parentSiteNodeVO = this.nodeDeliveryController.getParentSiteNode(this.getDatabase(), currentSiteNodeId);
                if (parentSiteNodeVO != null) {
                    isParentToCurrent = this.getIsParentToCurrentRecursive(siteNodeId, parentSiteNodeVO.getSiteNodeId());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred:" + e.getMessage()), (Throwable)e);
        }
        return isParentToCurrent;
    }

    @Override
    public boolean getHasLocalizedVersion(Integer contentId) {
        boolean ret = false;
        try {
            ret = ContentDeliveryController.getContentDeliveryController().getContentVersionVO(this.getDatabase(), this.siteNodeId, contentId, this.languageId, false, this.deliveryContext, this.infoGluePrincipal) != null;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get determine if content:" + contentId + " has a localized version:" + e.getMessage()), (Throwable)e);
        }
        return ret;
    }

    @Override
    public List getAccessRights(String interceptionPointName, String parameters) {
        List accessRights = new ArrayList();
        try {
            accessRights = AccessRightController.getController().getAccessRightVOList(interceptionPointName, parameters, this.getDatabase());
        }
        catch (Exception e) {
            logger.warn((Object)("Problems getting access rights for " + interceptionPointName + "(" + parameters + ")"), (Throwable)e);
        }
        return accessRights;
    }

    @Override
    public List getPageAccessRights(String interceptionPointName, Integer siteNodeId) {
        List accessRights = new ArrayList();
        try {
            Integer protectedSiteNodeVersionId = this.nodeDeliveryController.getProtectedSiteNodeVersionId(this.getDatabase(), siteNodeId);
            if (protectedSiteNodeVersionId == null) {
                logger.info((Object)"The page was not protected...");
            } else {
                accessRights = AccessRightController.getController().getAccessRightVOList(interceptionPointName, protectedSiteNodeVersionId.toString(), this.getDatabase());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Problems getting access rights for " + interceptionPointName + "(siteNodeId=" + siteNodeId + ")"), (Throwable)e);
        }
        return accessRights;
    }

    @Override
    public boolean getHasUserPageAccess(Integer siteNodeId) {
        boolean hasUserPageAccess = false;
        try {
            Integer protectedSiteNodeVersionId = this.nodeDeliveryController.getProtectedSiteNodeVersionId(this.getDatabase(), siteNodeId);
            if (protectedSiteNodeVersionId == null) {
                logger.info((Object)"The page was not protected...");
                hasUserPageAccess = true;
            } else {
                logger.info((Object)"The page was protected...");
                InfoGluePrincipal principal = this.getPrincipal();
                logger.info((Object)("Principal:" + principal));
                if (principal != null) {
                    hasUserPageAccess = AccessRightController.getController().getIsPrincipalAuthorized(principal, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get determine if content:" + this.contentId + " has a localized version:" + e.getMessage()), (Throwable)e);
        }
        return hasUserPageAccess;
    }

    @Override
    public boolean getHasUserPageAccess(Integer siteNodeId, String interceptionPointName) {
        boolean hasUserPageAccess = false;
        try {
            Integer protectedSiteNodeVersionId = this.nodeDeliveryController.getProtectedSiteNodeVersionId(this.getDatabase(), siteNodeId);
            if (protectedSiteNodeVersionId == null) {
                logger.info((Object)"The page was not protected...");
                hasUserPageAccess = true;
            } else {
                logger.info((Object)"The page was protected...");
                InfoGluePrincipal principal = this.getPrincipal();
                logger.info((Object)("Principal:" + principal));
                if (principal != null) {
                    hasUserPageAccess = AccessRightController.getController().getIsPrincipalAuthorized(principal, interceptionPointName, protectedSiteNodeVersionId.toString());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get determine if content:" + this.contentId + " has a localized version:" + e.getMessage()), (Throwable)e);
        }
        return hasUserPageAccess;
    }

    @Override
    public boolean getHasUserContentAccess(Integer contentId) {
        boolean hasUserContentAccess = true;
        try {
            if (contentId != null) {
                Integer protectedContentId = ContentDeliveryController.getContentDeliveryController().getProtectedContentId(this.getDatabase(), contentId);
                logger.info((Object)("IsProtected:" + protectedContentId));
                if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.infoGluePrincipal, "Content.Read", protectedContentId.toString())) {
                    hasUserContentAccess = false;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get determine if content:" + contentId + " has a localized version:" + e.getMessage()), (Throwable)e);
        }
        return hasUserContentAccess;
    }

    public boolean getHasUserContentAccess(Integer contentId, String action) {
        boolean hasUserContentAccess = true;
        try {
            Integer protectedContentId = ContentDeliveryController.getContentDeliveryController().getProtectedContentId(this.getDatabase(), contentId);
            logger.info((Object)("IsProtected:" + protectedContentId));
            if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.infoGluePrincipal, action, protectedContentId.toString())) {
                hasUserContentAccess = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to get determine if content:" + contentId + " has a localized version:" + e.getMessage()), (Throwable)e);
        }
        return hasUserContentAccess;
    }

    @Override
    public boolean getHasUserPageWriteAccess(Integer siteNodeId) {
        boolean hasUserPageWriteAccess = false;
        try {
            Integer protectedSiteNodeVersionId = this.nodeDeliveryController.getProtectedSiteNodeVersionId(this.getDatabase(), siteNodeId);
            if (protectedSiteNodeVersionId == null) {
                logger.info((Object)"The page was not protected...");
                hasUserPageWriteAccess = true;
            } else {
                logger.info((Object)"The page was protected...");
                InfoGluePrincipal principal = this.getPrincipal();
                logger.info((Object)("Principal:" + principal));
                if (principal != null) {
                    hasUserPageWriteAccess = AccessRightController.getController().getIsPrincipalAuthorized(principal, "SiteNodeVersion.Write", protectedSiteNodeVersionId.toString());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred trying to find out if the user had write access to page:" + siteNodeId + ": " + e.getMessage()), (Throwable)e);
        }
        return hasUserPageWriteAccess;
    }

    @Override
    public List getFormAttributes(String contentBindningName, String attributeName) {
        String formDefinition = this.getContentAttribute(contentBindningName, attributeName, true);
        return FormDeliveryController.getFormDeliveryController().getContentTypeAttributes(formDefinition);
    }

    @Override
    public List getFormAttributes(Integer contentId, String attributeName) {
        String formDefinition = this.getContentAttribute(contentId, attributeName, true);
        return FormDeliveryController.getFormDeliveryController().getContentTypeAttributes(formDefinition);
    }

    public List getWorkflowSteps(String workflowId) {
        List workflowSteps = null;
        try {
            InfoGluePrincipal infoGluePrincipal = this.getPrincipal();
            if (infoGluePrincipal == null) {
                HashMap<String, String> arguments = new HashMap<String, String>();
                arguments.put("j_username", CmsPropertyHandler.getAnonymousUser());
                arguments.put("j_password", CmsPropertyHandler.getAnonymousPassword());
                infoGluePrincipal = (InfoGluePrincipal)ExtranetController.getController().getAuthenticatedPrincipal(arguments);
            }
            WorkflowController workflowController = WorkflowController.getController();
            logger.info((Object)("infoGluePrincipal:" + infoGluePrincipal));
            logger.info((Object)("workflowId:" + workflowId));
            workflowSteps = workflowController.getAllSteps(infoGluePrincipal, new Long(workflowId));
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when trying to get the steps available: " + e.getMessage()), (Throwable)e);
        }
        return workflowSteps;
    }

    public List getWorkflowHistoricalSteps(String workflowId) {
        List workflowSteps = null;
        try {
            InfoGluePrincipal infoGluePrincipal = this.getPrincipal();
            if (infoGluePrincipal == null) {
                HashMap<String, String> arguments = new HashMap<String, String>();
                arguments.put("j_username", CmsPropertyHandler.getAnonymousUser());
                arguments.put("j_password", CmsPropertyHandler.getAnonymousPassword());
                infoGluePrincipal = (InfoGluePrincipal)ExtranetController.getController().getAuthenticatedPrincipal(arguments);
            }
            WorkflowController workflowController = WorkflowController.getController();
            workflowSteps = workflowController.getHistorySteps(infoGluePrincipal, new Long(workflowId));
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when trying to get the steps available: " + e.getMessage()), (Throwable)e);
        }
        return workflowSteps;
    }

    public List getWorkflowCurrentSteps(String workflowId) {
        List workflowSteps = null;
        try {
            InfoGluePrincipal infoGluePrincipal = this.getPrincipal();
            if (infoGluePrincipal == null) {
                HashMap<String, String> arguments = new HashMap<String, String>();
                arguments.put("j_username", CmsPropertyHandler.getAnonymousUser());
                arguments.put("j_password", CmsPropertyHandler.getAnonymousPassword());
                infoGluePrincipal = (InfoGluePrincipal)ExtranetController.getController().getAuthenticatedPrincipal(arguments);
            }
            WorkflowController workflowController = WorkflowController.getController();
            workflowSteps = workflowController.getCurrentSteps(infoGluePrincipal, new Long(workflowId));
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when trying to get the steps available: " + e.getMessage()), (Throwable)e);
        }
        return workflowSteps;
    }

    @Override
    public void setCookie(String cookieName, String value, String domain, String path, Integer maxAge) {
        Cookie cookie = new Cookie(cookieName, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        if (maxAge != null) {
            cookie.setMaxAge(maxAge.intValue());
        }
        this.deliveryContext.getHttpServletResponse().addCookie(cookie);
    }

    @Override
    public String getCookie(String cookieName) {
        Cookie[] cookies;
        if (this.request != null && (cookies = this.request.getCookies()) != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie cookie = cookies[i];
                if (cookie.getName().equals(cookieName)) {
                    return cookie.getValue();
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public LanguageVO getLanguage(Integer languageId) {
        LanguageVO language = null;
        try {
            language = LanguageDeliveryController.getLanguageDeliveryController().getLanguageVO(this.getDatabase(), languageId);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when getting language:" + e.getMessage()), (Throwable)e);
        }
        return language;
    }

    @Override
    public LanguageVO getLanguage(String languageCode) {
        LanguageVO language = null;
        try {
            language = LanguageDeliveryController.getLanguageDeliveryController().getLanguageWithCode(this.getDatabase(), languageCode);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when getting language:" + e.getMessage()), (Throwable)e);
        }
        return language;
    }

    @Override
    public Locale getLanguageCode(Integer languageId) throws SystemException {
        return LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.getDatabase(), languageId);
    }

    @Override
    public Locale getLocale() throws SystemException {
        return LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.getDatabase(), this.languageId);
    }

    @Override
    public Locale getLocaleAvailableInTool() throws SystemException {
        Locale locale = LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithId(this.getDatabase(), this.languageId);
        List toolLocales = CmsPropertyHandler.getToolLocales();
        if (toolLocales != null && toolLocales.size() > 0 && !toolLocales.contains(locale)) {
            locale = (Locale)toolLocales.get(0);
        }
        return locale;
    }

    public String getLogoutURL() throws Exception {
        AuthenticationModule authenticationModule = AuthenticationModule.getAuthenticationModule(this.getDatabase(), null);
        return authenticationModule.getLogoutUrl();
    }

    @Override
    public TemplateController getTemplateController(Integer siteNodeId, Integer languageId, Integer contentId, InfoGluePrincipal infoGluePrincipal, DeliveryContext deliveryContext) throws SystemException, Exception {
        return this.getTemplateController(siteNodeId, languageId, contentId, this.request, infoGluePrincipal, deliveryContext);
    }

    @Override
    public TemplateController getTemplateController(Integer siteNodeId, Integer languageId, Integer contentId, HttpServletRequest request, InfoGluePrincipal infoGluePrincipal, DeliveryContext deliveryContextt) throws SystemException, Exception {
        BasicTemplateController templateController = null;
        templateController = new BasicTemplateController(this.databaseWrapper, infoGluePrincipal);
        templateController.setStandardRequestParameters(siteNodeId, languageId, contentId);
        templateController.setHttpRequest(request);
        templateController.setBrowserBean(this.browserBean);
        templateController.setDeliveryControllers(this.nodeDeliveryController, null, this.integrationDeliveryController);
        templateController.setDeliveryContext(this.deliveryContext);
        if (this.isPersistedContext()) {
            templateController.addToContext(this.templateLogicContext);
            templateController.setPersistedContext(true);
        }
        String operatingMode = CmsPropertyHandler.getOperatingMode();
        String editOnSite = CmsPropertyHandler.getEditOnSite();
        boolean isEditOnSightDisabled = templateController.getIsEditOnSightDisabled();
        boolean allowEditOnSightAtAll = false;
        if (request.getRequestURL().indexOf("!renderDecoratedPage") > -1) {
            allowEditOnSightAtAll = true;
        }
        if (!isEditOnSightDisabled && operatingMode != null && (operatingMode.equals("0") || operatingMode.equals("1") || operatingMode.equals("2")) && editOnSite != null && editOnSite.equalsIgnoreCase("true")) {
            templateController = new EditOnSiteBasicTemplateController(this.databaseWrapper, infoGluePrincipal);
            templateController.setStandardRequestParameters(siteNodeId, languageId, contentId);
            templateController.setHttpRequest(request);
            templateController.setBrowserBean(this.browserBean);
            templateController.setDeliveryControllers(this.nodeDeliveryController, null, this.integrationDeliveryController);
            templateController.setDeliveryContext(this.deliveryContext);
        }
        return templateController;
    }

    @Override
    public String decoratePage(String page) {
        return page;
    }

    public String getEditOnSightTag(Integer contentId, String attributeName, String html, boolean showInPublishedMode) {
        return this.getEditOnSightTag(contentId, this.getLanguageId(), attributeName, html, showInPublishedMode);
    }

    @Override
    public String getEditOnSightTag(Integer contentId, Integer languageId, String attributeName, String html, boolean showInPublishedMode) {
        if (!showInPublishedMode && this.getOperatingMode() == 3) {
            return "";
        }
        String editOnSiteUrl = CmsPropertyHandler.getEditOnSiteUrl();
        String decoratedAttributeValue = "<a href=\"#\" onClick=\"window.open('" + editOnSiteUrl + "?contentId=" + contentId + "&languageId=" + languageId + "&attributeName=" + attributeName + "&forceWorkingChange=true#" + attributeName + "Anchor', 'Edit', 'width=750,height=700,left=' + (document.body.clientWidth / 4) + ',top=50,toolbar=no,status=no,scrollbars=yes,location=no,menubar=no,directories=no,resizable=no');\">" + html + "</a>";
        return decoratedAttributeValue;
    }

    @Override
    public String getExportedContentsUrl(List contentIdList, String fileNamePrefix, boolean includeContentTypes, boolean includeCategories) throws Exception {
        String url = "";
        try {
            int i = 0;
            String fileName = null;
            String filePath = CmsPropertyHandler.getDigitalAssetPath0();
            while (filePath != null) {
                fileName = ExportImportController.getController().exportContent(contentIdList, filePath, fileNamePrefix, includeContentTypes, includeCategories);
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
            }
            if (fileName != null) {
                SiteNode siteNode = this.nodeDeliveryController.getSiteNode(this.getDatabase(), this.siteNodeId);
                String dnsName = CmsPropertyHandler.getWebServerAddress();
                if (siteNode != null && siteNode.getRepository().getDnsName() != null && !siteNode.getRepository().getDnsName().equals("")) {
                    dnsName = siteNode.getRepository().getDnsName();
                }
                url = this.urlComposer.composeDigitalAssetUrl(dnsName, null, fileName, this.deliveryContext);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Problem with getExportedContentsUrl:" + e.getMessage()), (Throwable)e);
        }
        return url;
    }

    @Override
    public String getAssignPropertyBindingTag(String propertyName, boolean createNew, String html, boolean showInPublishedMode, boolean showDecorated) {
        return this.getAssignPropertyBindingTag(propertyName, createNew, html, showInPublishedMode, showDecorated, null);
    }

    @Override
    public String getAssignPropertyBindingTag(String propertyName, boolean createNew, String html, boolean showInPublishedMode, boolean showDecorated, String extraParameters) {
        String result = "";
        try {
            String allowedContentTypeIdParameters;
            String componentEditorUrl = CmsPropertyHandler.getComponentEditorUrl();
            DecoratedComponentBasedHTMLPageInvoker dec = new DecoratedComponentBasedHTMLPageInvoker();
            Collection properties = dec.getComponentProperties(this.getComponentLogic().getInfoGlueComponent().getId(), this, this.siteNodeId, this.languageId, this.getComponentLogic().getInfoGlueComponent().getContentId());
            ComponentProperty property = null;
            for (ComponentProperty propertyCandidate : properties) {
                if (!propertyCandidate.getName().equals(propertyName)) continue;
                property = propertyCandidate;
            }
            String contentId = "-1";
            String createUrl = "";
            String assignUrl = "";
            Integer componentId = this.getComponentLogic().getInfoGlueComponent().getId();
            Integer repositoryId = this.getSiteNode().getRepositoryId();
            if (property.getVisualizingAction() != null && !property.getVisualizingAction().equals("")) {
                assignUrl = String.valueOf(componentEditorUrl) + property.getVisualizingAction() + "?repositoryId=" + repositoryId + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated;
            } else if (property.getEntityClass().equalsIgnoreCase("Content")) {
                allowedContentTypeIdParameters = "";
                if (property.getAllowedContentTypeNamesArray() != null && property.getAllowedContentTypeNamesArray().length > 0) {
                    allowedContentTypeIdParameters = "&" + property.getAllowedContentTypeIdAsUrlEncodedString(this.getDatabase());
                    logger.info((Object)("allowedContentTypeIdParameters:" + allowedContentTypeIdParameters));
                }
                assignUrl = property.getIsMultipleBinding() ? (property.getIsAssetBinding() ? String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showContentTreeForMultipleAssetBinding.action?repositoryId=" + repositoryId + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + allowedContentTypeIdParameters + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated : String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showContentTreeForMultipleBinding.action?repositoryId=" + repositoryId + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + allowedContentTypeIdParameters + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated) : String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showContentTree.action?repositoryId=" + repositoryId + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + allowedContentTypeIdParameters + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated + "&isAssetBinding=" + property.getIsAssetBinding();
            } else if (property.getEntityClass().equalsIgnoreCase("SiteNode")) {
                assignUrl = property.getIsMultipleBinding() ? String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showStructureTreeForMultipleBinding.action?repositoryId=" + repositoryId + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated : String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showStructureTree.action?repositoryId=" + repositoryId + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated;
            } else if (property.getEntityClass().equalsIgnoreCase("Category")) {
                assignUrl = property.getIsMultipleBinding() ? String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showCategoryTreeForMultipleBinding.action?repositoryId=" + repositoryId + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated : String.valueOf(componentEditorUrl) + "ViewSiteNodePageComponents!showCategoryTree.action?repositoryId=" + repositoryId + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated;
            }
            if (property.getCreateAction() != null && !property.getCreateAction().equals("")) {
                createUrl = String.valueOf(componentEditorUrl) + property.getCreateAction() + "?repositoryId=" + this.getSiteNode().getRepositoryId() + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated;
            } else if (property.getVisualizingAction() != null && !property.getVisualizingAction().equals("")) {
                createUrl = assignUrl;
            } else if (property.getEntityClass().equalsIgnoreCase("Content")) {
                String cancelKey;
                String cancelAddress;
                String key;
                String returnAddress;
                allowedContentTypeIdParameters = "";
                if (property.getAllowedContentTypeNamesArray() != null && property.getAllowedContentTypeNamesArray().length > 0) {
                    allowedContentTypeIdParameters = "&" + property.getAllowedContentTypeIdAsUrlEncodedString(this.getDatabase());
                    logger.info((Object)("allowedContentTypeIdParameters:" + allowedContentTypeIdParameters));
                }
                if ((returnAddress = (String)CacheController.getCachedObjectFromAdvancedCache("encodedStringsCache", key = "ViewSiteNodePageComponents!addComponentPropertyBinding.action?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=-1&entity=Content&entityId=#entityId&componentId=" + componentId + "&propertyName=" + property.getName() + "&path=#path&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated)) == null) {
                    returnAddress = URLEncoder.encode(key, "UTF-8");
                    CacheController.cacheObjectInAdvancedCache("encodedStringsCache", key, returnAddress);
                }
                if ((cancelAddress = (String)CacheController.getCachedObjectFromAdvancedCache("encodedStringsCache", cancelKey = this.getOriginalFullURL())) == null) {
                    cancelAddress = URLEncoder.encode(cancelKey, "UTF-8");
                    CacheController.cacheObjectInAdvancedCache("encodedStringsCache", cancelKey, cancelAddress);
                }
                createUrl = property.getIsMultipleBinding() ? String.valueOf(componentEditorUrl) + "CreateContentWizardFinish.action?repositoryId=" + this.getSiteNode().getRepositoryId() + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + allowedContentTypeIdParameters + "&refreshAddress=" + returnAddress + "&cancelAddress=" + cancelAddress + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated + (extraParameters != null ? "&" + extraParameters : "") : String.valueOf(componentEditorUrl) + "CreateContentWizardFinish.action?repositoryId=" + this.getSiteNode().getRepositoryId() + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + allowedContentTypeIdParameters + "&refreshAddress=" + returnAddress + "&cancelAddress=" + cancelAddress + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated + (extraParameters != null ? "&" + extraParameters : "");
            } else if (property.getEntityClass().equalsIgnoreCase("SiteNode")) {
                String cancelKey;
                String cancelAddress;
                String key = "ViewSiteNodePageComponents!addComponentPropertyBinding.action?siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=-1&entity=SiteNode&entityId=#entityId&componentId=" + componentId + "&propertyName=" + property.getName() + "&path=#path&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated;
                String returnAddress = (String)CacheController.getCachedObjectFromAdvancedCache("encodedStringsCache", key);
                if (returnAddress == null) {
                    returnAddress = URLEncoder.encode(key, "UTF-8");
                    CacheController.cacheObjectInAdvancedCache("encodedStringsCache", key, returnAddress);
                }
                if ((cancelAddress = (String)CacheController.getCachedObjectFromAdvancedCache("encodedStringsCache", cancelKey = this.getOriginalFullURL())) == null) {
                    cancelAddress = URLEncoder.encode(cancelKey, "UTF-8");
                    CacheController.cacheObjectInAdvancedCache("encodedStringsCache", cancelKey, cancelAddress);
                }
                createUrl = property.getIsMultipleBinding() ? String.valueOf(componentEditorUrl) + "CreateSiteNodeWizardFinish.action?repositoryId=" + this.getSiteNode().getRepositoryId() + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + "&refreshAddress=" + returnAddress + "&cancelAddress=" + cancelAddress + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated + (extraParameters != null ? "&" + extraParameters : "") : String.valueOf(componentEditorUrl) + "CreateSiteNodeWizardFinish.action?repositoryId=" + this.getSiteNode().getRepositoryId() + "&siteNodeId=" + this.siteNodeId + "&languageId=" + this.languageId + "&contentId=" + contentId + "&componentId=" + componentId + "&propertyName=" + property.getName() + "&refreshAddress=" + returnAddress + "&cancelAddress=" + cancelAddress + "&showSimple=" + this.getDeliveryContext().getShowSimple() + "&showDecorated=" + showDecorated + (extraParameters != null ? "&" + extraParameters : "");
            }
            if (!showInPublishedMode && this.getOperatingMode() == 3) {
                result = "";
            } else {
                String editOnSiteUrl = CmsPropertyHandler.getEditOnSiteUrl();
                String url = assignUrl;
                result = !createNew ? "<a href=\"#\" onClick=\"window.open('" + assignUrl + "', 'Edit', 'width=500,height=600,left=' + (document.body.clientWidth / 4) + ',top=50,toolbar=no,status=no,scrollbars=yes,location=no,menubar=no,directories=no,resizable=no');\">" + html + "</a>" : "<a href=\"" + createUrl + "\">" + html + "</a>";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "";
        }
        return result;
    }

    @Override
    public DeliveryContext getDeliveryContext() {
        return this.deliveryContext;
    }

    @Override
    public void setDeliveryContext(DeliveryContext deliveryContext) {
        this.deliveryContext = deliveryContext;
    }

    public boolean isPersistedContext() {
        return this.persistedContext;
    }

    public void setPersistedContext(boolean persistedContext) {
        this.persistedContext = persistedContext;
    }

    @Override
    public boolean getThreatFoldersAsContents() {
        return this.threatFoldersAsContents;
    }

    @Override
    public void setThreatFoldersAsContents(boolean threatFoldersAsContents) {
        this.threatFoldersAsContents = threatFoldersAsContents;
    }

    @Override
    public boolean getIsDecorated() {
        return this instanceof EditOnSiteBasicTemplateController;
    }
}

