/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.kernel.IBaseEntity;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;

public abstract class BaseDeliveryController {
    private static final Logger logger = Logger.getLogger((String)BaseDeliveryController.class.getName());

    protected Object getObjectWithId(Class arg, Integer id, Database db) throws SystemException, Bug {
        Object object = null;
        try {
            object = db.load(arg, (Object)id, (short)0);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch the object " + arg.getName() + ". Reason:" + e.getMessage(), e);
        }
        if (object == null) {
            throw new Bug("The object with id [" + id + "] was not found. This should never happen.");
        }
        return object;
    }

    protected BaseEntityVO getVOWithId(Class arg, Integer id, Database db) throws SystemException, Bug {
        IBaseEntity vo = null;
        try {
            vo = (IBaseEntity)db.load(arg, (Object)id, (short)0);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch the object " + arg.getName() + ". Reason:" + e.getMessage(), e);
        }
        if (vo == null) {
            throw new Bug("The object with id [" + id + "] was not found. This should never happen.");
        }
        return vo.getVO();
    }

    public List getAllVOObjects(Class arg, Database db) throws SystemException, Bug {
        ArrayList<Object> resultList = new ArrayList<Object>();
        try {
            logger.info((Object)("BaseHelper::GetAllObjects for " + arg.getName()));
            OQLQuery oql = db.getOQLQuery("SELECT u FROM " + arg.getName() + " u");
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                Object o = results.next();
                resultList.add(o.getClass().getDeclaredMethod("getValueObject", new Class[0]).invoke(o, new Object[0]));
            }
            results.close();
            oql.close();
        }
        catch (NoSuchMethodException e) {
            throw new Bug("The object [" + arg.getName() + "] is of the wrong type. This should never happen.", e);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch " + arg.getName() + " Reason:" + e.getMessage(), e);
        }
        return Collections.unmodifiableList(resultList);
    }

    public List getAllVOObjects(Class arg, String orderByField, String direction, Database db) throws SystemException, Bug {
        ArrayList<Object> resultList = new ArrayList<Object>();
        try {
            logger.info((Object)("BaseHelper::GetAllObjects for " + arg.getName()));
            OQLQuery oql = db.getOQLQuery("SELECT u FROM " + arg.getName() + " u ORDER BY u." + orderByField + " " + direction);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                Object o = results.next();
                resultList.add(o.getClass().getDeclaredMethod("getValueObject", new Class[0]).invoke(o, new Object[0]));
            }
            results.close();
            oql.close();
        }
        catch (NoSuchMethodException e) {
            throw new Bug("The object [" + arg.getName() + "] is of the wrong type. This should never happen.", e);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch " + arg.getName() + " Reason:" + e.getMessage(), e);
        }
        return Collections.unmodifiableList(resultList);
    }

    protected static List executeQuery(Database db, String query) throws SystemException, Exception {
        return BaseDeliveryController.executeQuery(db, query, Collections.EMPTY_LIST);
    }

    protected static List executeQuery(Database db, String query, List params) throws Exception {
        List resultList = new ArrayList();
        OQLQuery oql = BaseDeliveryController.createQuery(db, query, params);
        QueryResults results = oql.execute((short)0);
        resultList = Collections.list(results);
        results.close();
        oql.close();
        return resultList;
    }

    protected static OQLQuery createQuery(Database db, String query, List params) throws PersistenceException {
        OQLQuery oql = db.getOQLQuery(query);
        if (params != null) {
            Iterator i = params.iterator();
            while (i.hasNext()) {
                oql.bind(i.next());
            }
        }
        return oql;
    }

    protected static List toVOList(Collection entities) throws SystemException, Bug {
        ArrayList<Object> resultVOList = new ArrayList<Object>();
        if (entities == null) {
            return Collections.EMPTY_LIST;
        }
        for (Object o : entities) {
            try {
                resultVOList.add(o.getClass().getDeclaredMethod("getValueObject", new Class[0]).invoke(o, new Object[0]));
            }
            catch (NoSuchMethodException e) {
                throw new Bug("The object in list was of the wrong type: " + o.getClass().getName() + ". This should never happen.", e);
            }
            catch (Exception e) {
                throw new SystemException("An error occurred when we tried to convert the collection to a valueList. Reason:" + e.getMessage(), e);
            }
        }
        return resultVOList;
    }

    public static void beginTransaction(Database db) throws SystemException {
        try {
            db.begin();
            logger.info((Object)"Opening a new Transaction...");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to begin an transaction. Reason:" + e.getMessage(), e);
        }
    }

    public static void closeTransaction(Database db) throws SystemException {
        logger.info((Object)"closeTransaction a transaction and closing it...");
        BaseDeliveryController.commitTransaction(db);
    }

    public static void commitTransaction(Database db) throws SystemException {
        try {
            logger.info((Object)"Committing a transaction and closing it...");
            db.commit();
            db.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to commit an transaction. Reason:" + e.getMessage(), e);
        }
    }

    public static void rollbackTransaction(Database db) throws SystemException {
        logger.info((Object)"Rollback a transaction...");
        try {
            if (db.isActive()) {
                db.rollback();
                db.close();
            }
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred when we tried to rollback an transaction. Reason:" + e.getMessage()));
        }
    }

    public static void closeDatabase(Database db) throws SystemException {
        try {
            logger.info((Object)"Closing database...");
            db.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to close a database. Reason:" + e.getMessage(), e);
        }
    }
}

