/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.controllers.kernel.impl.simple;

import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.entities.management.AvailableServiceBinding;
import org.infoglue.cms.entities.management.AvailableServiceBindingVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.deliver.controllers.kernel.impl.simple.BaseDeliveryController;
import org.infoglue.deliver.util.CacheController;

public class AvailableServiceBindingDeliveryController
extends BaseDeliveryController {
    private static final Logger logger = Logger.getLogger((String)AvailableServiceBindingDeliveryController.class.getName());

    private AvailableServiceBindingDeliveryController() {
    }

    public static AvailableServiceBindingDeliveryController getAvailableServiceBindingDeliveryController() {
        return new AvailableServiceBindingDeliveryController();
    }

    public AvailableServiceBindingVO getAvailableServiceBindingVO(String availableServiceBindingName, Database db) throws SystemException, Exception {
        String key = availableServiceBindingName;
        logger.info((Object)("key:" + key));
        AvailableServiceBindingVO availableServiceBindingVO = (AvailableServiceBindingVO)CacheController.getCachedObject("availableServiceBindingCache", key);
        if (availableServiceBindingVO != null) {
            logger.info((Object)("There was an cached availableServiceBindingVO:" + availableServiceBindingVO));
        } else {
            logger.info((Object)("Going to look for availableServiceBindingName " + availableServiceBindingName));
            OQLQuery oql = db.getOQLQuery("SELECT asb FROM org.infoglue.cms.entities.management.impl.simple.SmallAvailableServiceBindingImpl asb WHERE asb.name = $1");
            oql.bind((Object)availableServiceBindingName);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                AvailableServiceBinding availableServiceBinding = (AvailableServiceBinding)results.next();
                availableServiceBindingVO = availableServiceBinding.getValueObject();
                logger.info((Object)("Found availableServiceBinding:" + availableServiceBindingVO.getName()));
            } else {
                logger.info((Object)("Found no AvailableServiceBindingVO with name " + availableServiceBindingName));
            }
            results.close();
            oql.close();
            CacheController.cacheObject("availableServiceBindingCache", key, availableServiceBindingVO);
        }
        return availableServiceBindingVO;
    }

    public AvailableServiceBinding getAvailableServiceBinding(String availableServiceBindingName, Database db) throws SystemException, Exception {
        AvailableServiceBinding availableServiceBinding = null;
        OQLQuery oql = db.getOQLQuery("SELECT asb FROM org.infoglue.cms.entities.management.impl.simple.AvailableServiceBindingImpl asb WHERE asb.name = $1");
        oql.bind((Object)availableServiceBindingName);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            availableServiceBinding = (AvailableServiceBinding)results.next();
            logger.info((Object)("Found availableServiceBinding:" + availableServiceBinding.getName()));
        }
        results.close();
        oql.close();
        return availableServiceBinding;
    }
}

