/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.inputhandlers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.mail.MailServiceFactory;
import org.infoglue.deliver.applications.databeans.DatabaseWrapper;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.applications.inputhandlers.InfoGlueInputHandler;
import org.infoglue.deliver.controllers.kernel.impl.simple.BasicTemplateController;
import org.infoglue.deliver.controllers.kernel.impl.simple.ContentDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.IntegrationDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;
import org.infoglue.deliver.util.VelocityTemplateProcessor;

public class MailSender
implements InfoGlueInputHandler {
    public void processInput(DatabaseWrapper databaseWrapper, Integer siteNodeId, Integer languageId, Integer contentId, Integer formContentId, HashMap parameters, HttpServletRequest request, InfoGluePrincipal infogluePrincipal) throws Exception {
        String template = ContentDeliveryController.getContentDeliveryController().getContentAttribute(databaseWrapper.getDatabase(), formContentId, languageId, "MailSender_template", siteNodeId, true, DeliveryContext.getDeliveryContext(), infogluePrincipal, false);
        String fromAddress = ContentDeliveryController.getContentDeliveryController().getContentAttribute(databaseWrapper.getDatabase(), formContentId, languageId, "MailSender_fromAddress", siteNodeId, true, DeliveryContext.getDeliveryContext(), infogluePrincipal, false);
        String toAddress = ContentDeliveryController.getContentDeliveryController().getContentAttribute(databaseWrapper.getDatabase(), formContentId, languageId, "MailSender_toAddress", siteNodeId, true, DeliveryContext.getDeliveryContext(), infogluePrincipal, false);
        String subject = ContentDeliveryController.getContentDeliveryController().getContentAttribute(databaseWrapper.getDatabase(), formContentId, languageId, "MailSender_subject", siteNodeId, true, DeliveryContext.getDeliveryContext(), infogluePrincipal, false);
        String body = this.renderMailBody(databaseWrapper, siteNodeId, languageId, contentId, template, parameters, request, infogluePrincipal);
        MailServiceFactory.getService().send(fromAddress, toAddress, subject, body, "text/html", "UTF-8");
    }

    private String renderMailBody(DatabaseWrapper databaseWrapper, Integer siteNodeId, Integer languageId, Integer contentId, String template, HashMap parameters, HttpServletRequest request, InfoGluePrincipal infogluePrincipal) throws Exception {
        parameters.put("templateLogic", this.getTemplateController(databaseWrapper, siteNodeId, languageId, contentId, request, infogluePrincipal));
        StringWriter tempString = new StringWriter();
        PrintWriter pw = new PrintWriter(tempString);
        new VelocityTemplateProcessor().renderTemplate(parameters, pw, template);
        return tempString.toString();
    }

    public TemplateController getTemplateController(DatabaseWrapper databaseWrapper, Integer siteNodeId, Integer languageId, Integer contentId, HttpServletRequest request, InfoGluePrincipal infogluePrincipal) throws Exception {
        NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId);
        IntegrationDeliveryController integrationDeliveryController = IntegrationDeliveryController.getIntegrationDeliveryController(siteNodeId, languageId, contentId);
        BasicTemplateController templateController = new BasicTemplateController(databaseWrapper, infogluePrincipal);
        templateController.setStandardRequestParameters(siteNodeId, languageId, contentId);
        templateController.setHttpRequest(request);
        templateController.setDeliveryControllers(nodeDeliveryController, null, integrationDeliveryController);
        return templateController;
    }
}

