/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.filters;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.RedirectController;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.applications.filters.URIMapperCache;
import org.infoglue.deliver.applications.filters.URIMatcher;
import org.infoglue.deliver.controllers.kernel.impl.simple.BaseDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.ExtranetController;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.RepositoryDeliveryController;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.RequestAnalyser;

public class ViewPageFilter
implements Filter {
    public static final Logger logger = Logger.getLogger((String)ViewPageFilter.class.getName());
    private FilterConfig filterConfig = null;
    private URIMatcher uriMatcher = null;
    private URIMapperCache uriCache = null;
    public static String attributeName = null;
    public static boolean caseSensitive = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String filterURIs = filterConfig.getInitParameter("FilterURIs");
        String caseSensitiveString = CmsPropertyHandler.getCaseSensitiveRedirects();
        logger.info((Object)("caseSensitiveString:" + caseSensitiveString));
        caseSensitive = Boolean.parseBoolean(caseSensitiveString);
        this.uriMatcher = URIMatcher.compilePatterns(this.splitString(filterURIs, ","), caseSensitive);
        attributeName = CmsPropertyHandler.getNiceURIAttributeName();
        logger.info((Object)("attributeName from properties:" + attributeName));
        if (attributeName == null || attributeName.indexOf("@") > -1) {
            attributeName = filterConfig.getInitParameter("AttributeName");
        }
        logger.info((Object)("attributeName from web.xml, filter parameters:" + attributeName));
        if (attributeName == null || attributeName.equals("")) {
            attributeName = "NavigationTitle";
        }
        logger.info((Object)("attributeName used:" + attributeName));
        this.uriCache = new URIMapperCache();
    }

    /*
     * Unable to fully structure code
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        block26: {
            start = System.currentTimeMillis();
            httpRequest = (HttpServletRequest)servletRequest;
            httpResponse = (HttpServletResponse)servletResponse;
            enableNiceURI = CmsPropertyHandler.getEnableNiceURI();
            if (enableNiceURI == null) {
                enableNiceURI = "false";
            }
            this.validateCmsProperties(httpRequest);
            requestURI = URLDecoder.decode(this.getContextRelativeURI(httpRequest), "UTF-8");
            ViewPageFilter.logger.info((Object)("requestURI:" + requestURI));
            try {
                block27: {
                    if (requestURI.indexOf(String.valueOf(CmsPropertyHandler.getDigitalAssetBaseUrl()) + "/protected") > -1) {
                        throw new Exception("Not allowed to view protected assets...");
                    }
                    if (!enableNiceURI.equalsIgnoreCase("true") || this.uriMatcher.matches(requestURI)) break block27;
                    RequestAnalyser.getRequestAnalyser().incNumberOfCurrentRequests(null);
                    httpSession = httpRequest.getSession(true);
                    repositoryVOList = null;
                    languageId = null;
                    db = CastorDatabaseService.getDatabase();
                    BaseDeliveryController.beginTransaction(db);
                    try {
                        repositoryVOList = this.getRepositoryId(httpRequest, db);
                        ViewPageFilter.logger.info((Object)("repositoryVOList:" + repositoryVOList.size()));
                        languageId = this.getLanguageId(httpRequest, httpSession, repositoryVOList, db);
                        siteNodeId = null;
                        if (languageId != null) {
                            nodeNames = this.splitString(requestURI, "/");
                            ViewPageFilter.logger.info((Object)("nodeNames:" + nodeNames.length));
                            infoGluePrincipal = (InfoGluePrincipal)httpSession.getAttribute("infogluePrincipal");
                            if (infoGluePrincipal == null) {
                                try {
                                    infoGluePrincipal = (InfoGluePrincipal)CacheController.getCachedObject("userCache", "anonymous");
                                    if (infoGluePrincipal == null) {
                                        arguments = new HashMap<String, String>();
                                        arguments.put("j_username", CmsPropertyHandler.getAnonymousUser());
                                        arguments.put("j_password", CmsPropertyHandler.getAnonymousPassword());
                                        infoGluePrincipal = (InfoGluePrincipal)ExtranetController.getController().getAuthenticatedPrincipal(db, arguments);
                                        if (infoGluePrincipal != null) {
                                            CacheController.cacheObject("userCache", "anonymous", infoGluePrincipal);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    BaseDeliveryController.rollbackTransaction(db);
                                    throw new SystemException("There was no anonymous user found in the system. There must be - add the user anonymous/anonymous and try again.", e);
                                }
                            }
                            for (RepositoryVO repositoryVO : repositoryVOList) {
                                ViewPageFilter.logger.info((Object)("Getting node from:" + repositoryVO.getName()));
                                siteNodeId = NodeDeliveryController.getSiteNodeIdFromPath(infoGluePrincipal, repositoryVO, nodeNames, ViewPageFilter.attributeName, languageId, DeliveryContext.getDeliveryContext());
                                if (siteNodeId != null) break;
                            }
                        }
                        BaseDeliveryController.rollbackTransaction(db);
                        end = System.currentTimeMillis();
                        if (siteNodeId != null) ** GOTO lbl63
                        redirectUrl = RedirectController.getController().getRedirectUrl(httpRequest);
                        if (redirectUrl != null && redirectUrl.length() > 0) {
                            httpResponse.sendRedirect(redirectUrl);
                            return;
                        }
                        try {
                            extraInformation = "Referer: " + httpRequest.getHeader("Referer") + "\n";
                            extraInformation = String.valueOf(extraInformation) + "UserAgent: " + httpRequest.getHeader("User-Agent") + "\n";
                            extraInformation = String.valueOf(extraInformation) + "User IP: " + httpRequest.getRemoteAddr();
                            ViewPageFilter.logger.warn((Object)("Could not map URI " + requestURI + " against any page on this website." + "\n" + extraInformation));
                            throw new ServletException("Could not map URI " + requestURI + " against any page on this website.");
lbl63:
                            // 1 sources

                            ViewPageFilter.logger.info((Object)("Mapped URI " + requestURI + " --> " + siteNodeId + " in " + (end - start) + "ms"));
                            wrappedHttpRequest = this.prepareRequest(httpRequest, siteNodeId, languageId);
                            wrappedHttpRequest.getRequestDispatcher("/ViewPage.action").forward((ServletRequest)wrappedHttpRequest, (ServletResponse)httpResponse);
                            break block26;
                        }
                        catch (SystemException e) {
                            BaseDeliveryController.rollbackTransaction(db);
                            ViewPageFilter.logger.error((Object)"Failed to resolve siteNodeId", (Throwable)e);
                            throw new ServletException((Throwable)e);
                        }
                        catch (Exception e) {
                            BaseDeliveryController.rollbackTransaction(db);
                            throw new ServletException((Throwable)e);
                        }
                    }
                    finally {
                        try {
                            BaseDeliveryController.closeDatabase(db);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        RequestAnalyser.getRequestAnalyser().decNumberOfCurrentRequests(-1L);
                    }
                }
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            catch (SystemException se) {
                httpRequest.setAttribute("responseCode", (Object)"500");
                httpRequest.setAttribute("error", (Object)se);
                httpRequest.getRequestDispatcher("/ErrorPage.action").forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            catch (Exception e) {
                httpRequest.setAttribute("responseCode", (Object)"404");
                httpRequest.setAttribute("error", (Object)e);
                httpRequest.getRequestDispatcher("/ErrorPage.action").forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
        }
    }

    public void destroy() {
        this.filterConfig = null;
    }

    private void validateCmsProperties(HttpServletRequest request) {
        if (CmsPropertyHandler.getServletContext() == null) {
            CmsPropertyHandler.setServletContext(request.getContextPath());
        }
    }

    private List getRepositoryId(HttpServletRequest request, Database db) throws ServletException, SystemException, Exception {
        logger.info((Object)"Trying to lookup repositoryId");
        String serverName = request.getServerName();
        String portNumber = new Integer(request.getServerPort()).toString();
        String repositoryName = request.getParameter("repositoryName");
        logger.info((Object)("serverName:" + serverName));
        logger.info((Object)("repositoryName:" + repositoryName));
        String repCacheKey = serverName + "_" + portNumber + "_" + repositoryName;
        List repositoryVOList = (List)CacheController.getCachedObject(this.uriCache.CACHE_NAME, repCacheKey);
        if (repositoryVOList != null) {
            logger.info((Object)"Using cached repositoryVOList");
            return repositoryVOList;
        }
        List repositories = RepositoryDeliveryController.getRepositoryDeliveryController().getRepositoryVOListFromServerName(db, serverName, portNumber, repositoryName);
        logger.info((Object)("repositories:" + repositories));
        if (repositories.size() == 0) {
            String redirectUrl = RedirectController.getController().getRedirectUrl(request);
            logger.info((Object)("redirectUrl:" + redirectUrl));
            if (redirectUrl == null || redirectUrl.length() == 0) {
                if (repositories.size() == 0) {
                    try {
                        logger.info((Object)"Adding master repository instead - is this correct?");
                        repositories.add(RepositoryDeliveryController.getRepositoryDeliveryController().getMasterRepository(db));
                    }
                    catch (Exception e1) {
                        logger.error((Object)"Failed to lookup master repository");
                    }
                }
                if (repositories.size() == 0) {
                    throw new ServletException("Unable to find a repository for server-name " + serverName);
                }
            }
        }
        CacheController.cacheObject(this.uriCache.CACHE_NAME, repCacheKey, repositories);
        return repositories;
    }

    private Integer getLanguageId(HttpServletRequest request, HttpSession session, List repositoryVOList, Database db) throws ServletException, Exception {
        Integer languageId = null;
        if (request.getParameter("languageId") != null) {
            logger.info((Object)"Language is explicitely given in request");
            try {
                languageId = Integer.valueOf(request.getParameter("languageId"));
                session.setAttribute("LanguageId", (Object)languageId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (languageId != null) {
            return languageId;
        }
        if (session.getAttribute("LanguageId") != null) {
            logger.info((Object)"Fetching languageId from session");
            return (Integer)session.getAttribute("LanguageId");
        }
        Integer repositoryId = null;
        if (repositoryVOList != null && repositoryVOList.size() > 0) {
            repositoryId = ((RepositoryVO)repositoryVOList.get(0)).getId();
        }
        logger.info((Object)("Looking for languageId for repository " + repositoryId));
        Locale requestLocale = request.getLocale();
        if (repositoryId == null) {
            return null;
        }
        try {
            List availableLanguagesForRepository = LanguageDeliveryController.getLanguageDeliveryController().getAvailableLanguagesForRepository(db, repositoryId);
            if (requestLocale != null) {
                int i = 0;
                while (i < availableLanguagesForRepository.size()) {
                    LanguageVO language = (LanguageVO)availableLanguagesForRepository.get(i);
                    logger.info((Object)("language:" + language.getLanguageCode()));
                    logger.info((Object)("browserLanguage:" + requestLocale.getLanguage()));
                    if (language.getLanguageCode().equalsIgnoreCase(requestLocale.getLanguage())) {
                        languageId = language.getLanguageId();
                    }
                    ++i;
                }
            }
            if (languageId == null && availableLanguagesForRepository.size() > 0) {
                languageId = ((LanguageVO)availableLanguagesForRepository.get(0)).getLanguageId();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to fetch available languages for repository " + repositoryId));
        }
        if (languageId == null) {
            throw new ServletException("Unable to determine language for repository " + repositoryId);
        }
        session.setAttribute("LanguageId", (Object)languageId);
        return languageId;
    }

    private String getContextRelativeURI(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (contextPath != null && requestURI.length() > 0) {
            requestURI = requestURI.substring(contextPath.length(), requestURI.length());
        }
        if (requestURI.length() == 0) {
            return "/";
        }
        return requestURI;
    }

    private String[] splitString(String str, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.startsWith("_")) break;
            list.add(t.trim());
        }
        return list.toArray(new String[list.size()]);
    }

    private HttpServletRequest prepareRequest(HttpServletRequest request, Integer siteNodeId, Integer languageId) {
        IGHttpServletRequest wrappedRequest = new IGHttpServletRequest(request, siteNodeId, languageId);
        return wrappedRequest;
    }

    private class IGHttpServletRequest
    extends HttpServletRequestWrapper {
        Map requestParameters;

        public IGHttpServletRequest(HttpServletRequest httpServletRequest, Integer siteNodeId, Integer languageId) {
            super(httpServletRequest);
            this.requestParameters = new HashMap();
            this.requestParameters.putAll(httpServletRequest.getParameterMap());
            this.requestParameters.put("siteNodeId", new String[]{String.valueOf(siteNodeId)});
            this.requestParameters.put("languageId", new String[]{String.valueOf(languageId)});
            if (this.requestParameters.get("contentId") == null) {
                this.requestParameters.put("contentId", new String[]{String.valueOf(-1)});
            }
            String originalServletPath = httpServletRequest.getServletPath();
            String originalRequestURL = httpServletRequest.getRequestURL().toString();
            String originalQueryString = httpServletRequest.getQueryString();
            this.requestParameters.put("originalServletPath", new String[]{originalServletPath});
            this.requestParameters.put("originalRequestURL", new String[]{originalRequestURL});
            if (originalQueryString != null && originalQueryString.length() > 0) {
                this.requestParameters.put("originalQueryString", new String[]{originalQueryString});
            }
        }

        public String getParameter(String s) {
            String[] array = (String[])this.requestParameters.get(s);
            if (array != null && array.length > 0) {
                return array[0];
            }
            return null;
        }

        public Map getParameterMap() {
            return Collections.unmodifiableMap(this.requestParameters);
        }

        public Enumeration getParameterNames() {
            return new ParameterNamesEnumeration(this.requestParameters.keySet().iterator());
        }

        public String[] getParameterValues(String s) {
            String[] array = (String[])this.requestParameters.get(s);
            if (array != null && array.length > 0) {
                return array;
            }
            return null;
        }
    }

    private class ParameterNamesEnumeration
    implements Enumeration {
        Iterator it = null;

        public ParameterNamesEnumeration(Iterator it) {
            this.it = it;
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }
}

