/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.filters;

import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class URIMatcher {
    private Pattern[] patterns = new Pattern[0];

    private URIMatcher() {
    }

    public URIMatcher(Pattern[] patterns) {
        this.patterns = patterns;
    }

    public static URIMatcher compilePatterns(String[] strings, boolean caseSensitive) throws PatternSyntaxException {
        URIMatcher uriMatcher = new URIMatcher();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (strings != null && strings.length > 0) {
            int i = 0;
            while (i < strings.length) {
                String str = strings[i];
                if (str != null && (str = str.trim()).length() > 0) {
                    String patternStr = URIMatcher.patternize(str);
                    Pattern pattern = null;
                    pattern = caseSensitive ? Pattern.compile(patternStr) : Pattern.compile(patternStr, 2);
                    patterns.add(pattern);
                }
                ++i;
            }
        }
        uriMatcher.setPatterns(patterns.toArray(new Pattern[0]));
        return uriMatcher;
    }

    public boolean matches(String URI2) {
        if (URI2 != null && this.patterns != null && this.patterns.length > 0) {
            int i = 0;
            while (i < this.patterns.length) {
                if (this.patterns[i].matcher(URI2).matches()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static String patternize(String str) {
        str = str.replaceAll("\\.", "\\\\.");
        str = str.replaceAll("\\:", "\\\\:");
        str = str.replaceAll("\\*", ".*");
        return str;
    }

    private void setPatterns(Pattern[] patterns) {
        this.patterns = patterns;
    }
}

