/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.filters;

import org.infoglue.deliver.util.CacheController;

public class URIMapperCache {
    private static URIMapperCache instance = null;
    final String CACHE_NAME = "NavigationCache";

    public static synchronized URIMapperCache getInstance() {
        if (instance == null) {
            instance = new URIMapperCache();
        }
        return instance;
    }

    public void clear() {
    }

    public Integer getCachedSiteNodeId(Integer repositoryId, String[] path, int upToIndex) {
        if (repositoryId == null || path == null) {
            return null;
        }
        String cacheKey = this.createCacheKey(repositoryId, path, upToIndex);
        return (Integer)CacheController.getCachedObject("NavigationCache", cacheKey);
    }

    public boolean addCachedSiteNodeId(Integer repositoryId, String[] path, int upToIndex, Integer siteNodeId) {
        if (repositoryId == null || path == null || siteNodeId == null) {
            return false;
        }
        String cacheKey = this.createCacheKey(repositoryId, path, upToIndex);
        CacheController.cacheObject("NavigationCache", cacheKey, siteNodeId);
        return true;
    }

    private String createCacheKey(Integer repositoryId, String[] path, int upToIndex) {
        StringBuffer sb = new StringBuffer(128);
        sb.append(String.valueOf(repositoryId)).append(":/");
        int i = 0;
        while (i < path.length && i < upToIndex) {
            sb.append(path[i].toLowerCase()).append("/");
            ++i;
        }
        return sb.toString();
    }
}

