/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.filters;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.RedirectController;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.deliver.applications.filters.URIMatcher;

public class RedirectFilter
implements Filter {
    public static final Logger logger = Logger.getLogger((String)RedirectFilter.class.getName());
    private static String FILTER_URIS_PARAMETER = "FilterURIs";
    private FilterConfig filterConfig = null;
    private URIMatcher uriMatcher = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String filterURIs = filterConfig.getInitParameter(FILTER_URIS_PARAMETER);
        this.uriMatcher = URIMatcher.compilePatterns(this.splitString(filterURIs, ","), false);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpResponse;
        HttpServletRequest httpRequest;
        block6: {
            long start = System.currentTimeMillis();
            httpRequest = (HttpServletRequest)servletRequest;
            httpResponse = (HttpServletResponse)servletResponse;
            String requestURL = httpRequest.getRequestURL().toString();
            logger.info((Object)("Redirect filter requestURL:" + requestURL));
            try {
                String requestURI = URLDecoder.decode(this.getContextRelativeURI(httpRequest), "UTF-8");
                if (this.uriMatcher.matches(requestURI)) break block6;
                try {
                    String redirectUrl = RedirectController.getController().getRedirectUrl(httpRequest);
                    if (redirectUrl != null && redirectUrl.length() > 0) {
                        httpResponse.sendRedirect(redirectUrl);
                        return;
                    }
                }
                catch (SystemException se) {
                    logger.warn((Object)("Error in redirect filter: " + se.getMessage()), (Throwable)se);
                    httpRequest.setAttribute("responseCode", (Object)"500");
                    httpRequest.setAttribute("error", (Object)se);
                    httpRequest.getRequestDispatcher("/ErrorPage.action").forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
                catch (Exception e) {
                    logger.warn((Object)("Error in redirect filter: " + e.getMessage()), (Throwable)e);
                    httpRequest.setAttribute("responseCode", (Object)"404");
                    httpRequest.setAttribute("error", (Object)e);
                    httpRequest.getRequestDispatcher("/ErrorPage.action").forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
            }
            catch (Exception e) {
                logger.error((Object)("RedirectFilter threw error:" + e.getMessage()), (Throwable)e);
            }
        }
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public void destroy() {
        this.filterConfig = null;
    }

    private String getContextRelativeURI(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (contextPath != null && requestURI.length() > 0) {
            requestURI = requestURI.substring(contextPath.length(), requestURI.length());
        }
        if (requestURI.length() == 0) {
            return "/";
        }
        return requestURI;
    }

    private String[] splitString(String str, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.startsWith("_")) break;
            list.add(t.trim());
        }
        return list.toArray(new String[list.size()]);
    }
}

