/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.filters;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.deliver.portal.PathParser;

public class PortalServletRequest
extends HttpServletRequestWrapper {
    private static final Log log = LogFactory.getLog(PortalServletRequest.class);
    public static final String MULTI_VALUE = "__";
    private Map paramMap;
    private Principal principal = null;

    public PortalServletRequest(HttpServletRequest req) {
        super(req);
        this.paramMap = PathParser.copyParameters(req.getParameterMap());
        this.paramMap.putAll(PathParser.parsePathParameters("_ig_", req.getServletPath(), false));
        if (log.isDebugEnabled()) {
            StringBuffer str = new StringBuffer();
            Iterator it = this.paramMap.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                str.append(name);
                str.append(": ");
                str.append(Arrays.asList((String[])this.paramMap.get(name)));
                if (!it.hasNext()) continue;
                str.append(", ");
            }
            log.debug((Object)("Available params: " + str));
        }
        this.principal = (InfoGluePrincipal)req.getSession().getAttribute("infogluePrincipal");
        if (req.getUserPrincipal() != null) {
            this.principal = req.getUserPrincipal();
        }
    }

    public Map getParameterMap() {
        return this.paramMap;
    }

    public String getParameter(String name) {
        String[] values = (String[])this.paramMap.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.paramMap.keySet());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.paramMap.get(name);
    }

    public String getRemoteUser() {
        return this.principal == null ? null : this.principal.getName();
    }

    public boolean isUserInRole(String role) {
        boolean isUserInRole = false;
        if (this.principal != null) {
            if (this.principal instanceof InfoGluePrincipal) {
                List roles = ((InfoGluePrincipal)this.principal).getRoles();
                for (InfoGlueRole currentRole : roles) {
                    if (!currentRole.getName().equals(role)) continue;
                    isUserInRole = true;
                    break;
                }
            } else {
                isUserInRole = super.isUserInRole(role);
            }
        }
        return isUserInRole;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }
}

