/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.filters;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.filters.PortalServletRequest;
import org.infoglue.deliver.applications.filters.URIMatcher;

public class PortalParameterFilter
implements Filter {
    private static final Log log = LogFactory.getLog(PortalParameterFilter.class);
    private static String FILTER_URIS_PARAMETER = "FilterURIs";
    private FilterConfig filterConfig = null;
    private URIMatcher uriMatcher = null;
    private boolean active = true;

    public void init(FilterConfig filterConfig) throws ServletException {
        String portalEnabled = CmsPropertyHandler.getEnablePortal();
        this.active = this.active && portalEnabled != null && portalEnabled.equalsIgnoreCase("true");
        this.filterConfig = filterConfig;
        String filterURIs = filterConfig.getInitParameter(FILTER_URIS_PARAMETER);
        this.uriMatcher = URIMatcher.compilePatterns(this.splitString(filterURIs, ","), false);
        log.info((Object)("PortalParameterFilter is active: " + this.active));
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        HttpServletResponse httpResponse = (HttpServletResponse)resp;
        if (this.active) {
            String requestURI = URLDecoder.decode(this.getContextRelativeURI(httpRequest), "UTF-8");
            if (!this.uriMatcher.matches(requestURI)) {
                log.debug((Object)("wrapping " + ((HttpServletRequest)req).getRequestURI()));
                chain.doFilter((ServletRequest)new PortalServletRequest((HttpServletRequest)req), resp);
            } else {
                chain.doFilter(req, resp);
            }
        } else {
            chain.doFilter(req, resp);
        }
    }

    public void destroy() {
    }

    private String getContextRelativeURI(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (contextPath != null && requestURI.length() > 0) {
            requestURI = requestURI.substring(contextPath.length(), requestURI.length());
        }
        if (requestURI.length() == 0) {
            return "/";
        }
        return requestURI;
    }

    private String[] splitString(String str, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.startsWith("_")) break;
            list.add(t.trim());
        }
        return list.toArray(new String[list.size()]);
    }
}

