/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.filters;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.infoglue.deliver.applications.filters.URIMatcher;
import org.infoglue.deliver.util.CacheController;

public class CacheEvictionFilter
implements Filter {
    public static final Logger logger = Logger.getLogger((String)CacheEvictionFilter.class.getName());
    private static String FILTER_URIS_PARAMETER = "FilterURIs";
    private FilterConfig filterConfig = null;
    private URIMatcher uriMatcher = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String filterURIs = filterConfig.getInitParameter(FILTER_URIS_PARAMETER);
        this.uriMatcher = URIMatcher.compilePatterns(this.splitString(filterURIs, ","), false);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        try {
            String requestURI = URLDecoder.decode(this.getContextRelativeURI(httpRequest), "UTF-8");
            String userAgent = httpRequest.getHeader("user-agent");
            if (userAgent != null) {
                userAgent = userAgent.toLowerCase();
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("userAgent:" + userAgent));
            }
            if (!this.uriMatcher.matches(requestURI) && userAgent != null && userAgent.indexOf("java") == -1 && userAgent.indexOf("axis") == -1) {
                CacheController.evictWaitingCache();
            }
        }
        catch (Exception e) {
            logger.error((Object)("CacheEvictionFilter threw error:" + e.getMessage()), (Throwable)e);
        }
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public void destroy() {
    }

    private String getContextRelativeURI(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (contextPath != null && requestURI.length() > 0) {
            requestURI = requestURI.substring(contextPath.length(), requestURI.length());
        }
        if (requestURI.length() == 0) {
            return "/";
        }
        return requestURI;
    }

    private String[] splitString(String str, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.startsWith("_")) break;
            list.add(t.trim());
        }
        return list.toArray(new String[list.size()]);
    }
}

