/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.databeans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.infoglue.cms.applications.common.Session;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.deliver.applications.databeans.UsageListener;
import org.infoglue.deliver.controllers.kernel.impl.simple.InfoGlueHashSet;

public class DeliveryContext
implements UsageListener {
    public static final String META_INFO_BINDING_NAME = "Meta information";
    public static final String TEMPLATE_ATTRIBUTE_NAME = "Template";
    public static final String TITLE_ATTRIBUTE_NAME = "Title";
    public static final String NAV_TITLE_ATTRIBUTE_NAME = "NavigationTitle";
    public static final boolean USE_LANGUAGE_FALLBACK = true;
    public static final boolean DO_NOT_USE_LANGUAGE_FALLBACK = false;
    public static final boolean USE_INHERITANCE = true;
    public static final boolean DO_NOT_USE_INHERITANCE = false;
    private Integer siteNodeId = null;
    private Integer contentId = null;
    private Integer languageId = null;
    private String contentType = null;
    private boolean disablePageCache = false;
    private boolean showSimple = false;
    private String repositoryName = null;
    private String pageKey = null;
    private String pagePath = null;
    private HttpServletResponse httpServletResponse = null;
    private HttpServletRequest httpServletRequest = null;
    private Session session = null;
    private InfoGlueAbstractAction infoglueAbstractAction = null;
    private List usageListeners = new ArrayList();
    private Set usedContents = new InfoGlueHashSet();
    private Set usedContentVersions = new InfoGlueHashSet();
    private Set usedSiteNodes = new InfoGlueHashSet();
    private Set usedSiteNodeVersions = new InfoGlueHashSet();
    private Set usedPageMetaInfoContentVersionIdSet = new InfoGlueHashSet();
    private Date lastModifiedDateTime = null;
    private boolean registerLastModifiedDate = false;
    private boolean useFullUrl = false;
    private boolean disableNiceUri = false;
    private boolean trimResponse = false;
    private boolean evaluateFullPage = true;
    private boolean validateOnDates = false;
    private boolean useDownloadAction = false;
    private Map pageAttributes = new HashMap();
    private List htmlHeadItems = new ArrayList();
    private Map httpHeaders = new HashMap();

    public static DeliveryContext getDeliveryContext() {
        return new DeliveryContext();
    }

    public static DeliveryContext getDeliveryContext(boolean registerLastModifiedDate) {
        return new DeliveryContext(registerLastModifiedDate);
    }

    private DeliveryContext() {
        this(false);
    }

    private DeliveryContext(boolean registerLastModifiedDate) {
        this.registerLastModifiedDate = registerLastModifiedDate;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getPageKey() {
        return this.pageKey;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public void setPageKey(String pageKey) {
        this.pageKey = pageKey;
    }

    public void setPagePath(String pagePath) {
        this.pagePath = pagePath;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("siteNodeId:" + this.siteNodeId);
        sb.append("languageId:" + this.languageId);
        sb.append("contentId:" + this.contentId);
        return sb.toString();
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public InfoGlueAbstractAction getInfoGlueAbstractAction() {
        return this.infoglueAbstractAction;
    }

    public void setInfoGlueAbstractAction(InfoGlueAbstractAction action) {
        this.infoglueAbstractAction = action;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    public void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    public void addUsedContent(String usedContent) {
        this.usedContents.add(usedContent);
        for (UsageListener usageListener : this.getUsageListeners()) {
            usageListener.addUsedContent(usedContent);
        }
    }

    public void addUsedSiteNode(String usedSiteNode) {
        this.usedSiteNodes.add(usedSiteNode);
        for (UsageListener usageListener : this.getUsageListeners()) {
            usageListener.addUsedSiteNode(usedSiteNode);
        }
    }

    public void addUsedContentVersion(String usedContentVersion) {
        this.usedContentVersions.add(usedContentVersion);
        for (UsageListener usageListener : this.getUsageListeners()) {
            usageListener.addUsedContentVersion(usedContentVersion);
        }
    }

    public void addUsedSiteNodeVersion(String usedSiteNodeVersion) {
        this.usedSiteNodeVersions.add(usedSiteNodeVersion);
        for (UsageListener usageListener : this.getUsageListeners()) {
            usageListener.addUsedSiteNodeVersion(usedSiteNodeVersion);
        }
    }

    public String[] getAllUsedEntities() {
        ArrayList list = new ArrayList();
        list.addAll(this.usedContents);
        list.addAll(this.usedContentVersions);
        list.addAll(this.usedSiteNodes);
        list.addAll(this.usedSiteNodeVersions);
        Object[] array = list.toArray();
        String[] groups = new String[array.length];
        int i = 0;
        while (i < array.length) {
            groups[i] = array[i].toString();
            ++i;
        }
        return groups;
    }

    public List getUsageListeners() {
        return this.usageListeners;
    }

    public boolean getShowSimple() {
        return this.showSimple;
    }

    public void setShowSimple(boolean showSimple) {
        this.showSimple = showSimple;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean getDisablePageCache() {
        return this.disablePageCache;
    }

    public void setDisablePageCache(boolean disablePageCache) {
        this.disablePageCache = disablePageCache;
    }

    public boolean getUseFullUrl() {
        return this.useFullUrl;
    }

    public void setUseFullUrl(boolean useFullUrl) {
        this.useFullUrl = useFullUrl;
    }

    public boolean getDisableNiceUri() {
        return this.disableNiceUri;
    }

    public void setDisableNiceUri(boolean disableNiceUri) {
        this.disableNiceUri = disableNiceUri;
    }

    public boolean getTrimResponse() {
        return this.trimResponse;
    }

    public void setTrimResponse(boolean trimResponse) {
        this.trimResponse = trimResponse;
    }

    public boolean getEvaluateFullPage() {
        return this.evaluateFullPage;
    }

    public void setEvaluateFullPage(boolean evaluateFullPage) {
        this.evaluateFullPage = evaluateFullPage;
    }

    public boolean getValidateOnDates() {
        return this.validateOnDates;
    }

    public void setValidateOnDates(boolean validateOnDates) {
        this.validateOnDates = validateOnDates;
    }

    public Set getUsedPageMetaInfoContentVersionIdSet() {
        return this.usedPageMetaInfoContentVersionIdSet;
    }

    public Map getPageAttributes() {
        return this.pageAttributes;
    }

    public boolean getUseDownloadAction() {
        return this.useDownloadAction;
    }

    public void setUseDownloadAction(boolean useDownloadAction) {
        this.useDownloadAction = useDownloadAction;
    }

    public List getHtmlHeadItems() {
        return this.htmlHeadItems;
    }

    public Map getHttpHeaders() {
        return this.httpHeaders;
    }

    public Object getExtraData() {
        HashMap<String, Object> extraData = new HashMap<String, Object>();
        extraData.put("contentType", this.getContentType());
        extraData.put("headers", this.getHttpHeaders());
        extraData.put("lastModifiedDateTime", this.lastModifiedDateTime);
        return extraData;
    }

    public void populateExtraData(Map extraData) {
        Date lastModifiedDateTime;
        Map headers;
        String contentType = (String)extraData.get("contentType");
        if (contentType != null) {
            this.setContentType(contentType);
        }
        if ((headers = (Map)extraData.get("headers")) != null) {
            this.getHttpHeaders().putAll(headers);
        }
        if ((lastModifiedDateTime = (Date)extraData.get("lastModifiedDateTime")) != null) {
            this.lastModifiedDateTime = lastModifiedDateTime;
        }
    }

    public Date getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public void setLastModifiedDateTime(Date lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    public Set getUsedContentVersions() {
        return Collections.unmodifiableSet(this.usedContentVersions);
    }
}

