/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.actions;

import java.net.URLEncoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.SiteNodeTypeDefinitionVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.NoBaseTemplateFoundException;
import org.infoglue.cms.exception.PageNotFoundException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthenticationModule;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.DesEncryptionHelper;
import org.infoglue.cms.util.mail.MailServiceFactory;
import org.infoglue.deliver.applications.databeans.DatabaseWrapper;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.impl.simple.BasicTemplateController;
import org.infoglue.deliver.controllers.kernel.impl.simple.EditOnSiteBasicTemplateController;
import org.infoglue.deliver.controllers.kernel.impl.simple.ExtranetController;
import org.infoglue.deliver.controllers.kernel.impl.simple.IntegrationDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.RepositoryDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;
import org.infoglue.deliver.invokers.PageInvoker;
import org.infoglue.deliver.portal.PortalService;
import org.infoglue.deliver.util.BrowserBean;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.RequestAnalyser;
import org.infoglue.deliver.util.ThreadMonitor;

public class ViewPageAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    public static final Logger logger = Logger.getLogger((String)ViewPageAction.class.getName());
    private Integer siteNodeId = null;
    private Integer contentId = null;
    private Integer languageId = null;
    private Integer repositoryId = null;
    private boolean showSimple = false;
    private String repositoryName = null;
    protected NodeDeliveryController nodeDeliveryController = null;
    protected IntegrationDeliveryController integrationDeliveryController = null;
    protected TemplateController templateController = null;
    private static final boolean USE_LANGUAGE_FALLBACK = true;
    private static final boolean DO_NOT_USE_LANGUAGE_FALLBACK = false;
    private BrowserBean browserBean = null;
    private Principal principal = null;
    private String referer = null;
    private boolean isRecacheCall = false;
    public static long contentVersionTime = 0L;
    public static long serviceBindingTime = 0L;
    public static long contentAttributeTime = 0L;
    public static long boundContentTime = 0L;
    public static long inheritedServiceBindingTime = 0L;
    public static long selectMatchingEntitiesTime = 0L;
    public static long isValidTime = 0L;
    public static long qualifyersTime = 0L;
    public static long sortQualifyersTime = 0L;
    public static long commitTime = 0L;
    public static long rollbackTime = 0L;
    public static long closeTime = 0L;
    public static long lastRequestProcessingTime = 0L;
    private static Thread lastThread = null;
    private static boolean memoryWarningSent = false;
    private ThreadMonitor tk = null;
    private static Random random = new Random();

    public String doExecute() throws Exception {
        block71: {
            if (this.isRecacheCall) {
                Thread.currentThread().setPriority(1);
            }
            while (!CmsPropertyHandler.getOperatingMode().equals("3") && RequestAnalyser.getRequestAnalyser().getBlockRequests()) {
                Thread.sleep(10L);
            }
            try {
                Integer maxActiveRequests = new Integer(CmsPropertyHandler.getMaxActiveRequests());
                Integer maxRequestTime = new Integer(CmsPropertyHandler.getMaxRequestTime());
                while (CmsPropertyHandler.getUseHighLoadLimiter().equalsIgnoreCase("true") && RequestAnalyser.getRequestAnalyser().getNumberOfActiveRequests() > maxActiveRequests && (lastRequestProcessingTime > (long)maxRequestTime.intValue() || maxRequestTime < 1)) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Queing up...:" + RequestAnalyser.getRequestAnalyser().getNumberOfActiveRequests() + "(" + RequestAnalyser.getRequestAnalyser().getNumberOfCurrentRequests() + ") - " + lastRequestProcessingTime));
                    }
                    int sleepTime = random.nextInt(300);
                    Thread.sleep(sleepTime);
                }
            }
            catch (Exception e) {
                logger.error((Object)("You have faulty settings in either maxActiveRequests or maxRequestTime - fix this as it affects performance:" + e.getMessage()), (Throwable)e);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)"************************************************");
                logger.info((Object)"* ViewPageAction was called....                *");
                logger.info((Object)"************************************************");
            }
            HttpServletRequest request = this.getRequest();
            this.tk = !CmsPropertyHandler.getOperatingMode().equals("3") ? new ThreadMonitor(new Long(CmsPropertyHandler.getDeliverRequestTimeout()), request, "Page view took to long!", true) : (!CmsPropertyHandler.getKillLiveRequestWhichTimedout() ? new ThreadMonitor(new Long(CmsPropertyHandler.getLiveDeliverRequestTimeout()), request, "Page view seems to take to long!", false) : new ThreadMonitor(new Long(CmsPropertyHandler.getLiveDeliverRequestTimeout()), request, "Page view took to long!", true));
            RequestAnalyser.getRequestAnalyser().incNumberOfCurrentRequests(this.tk);
            long start = System.currentTimeMillis();
            long elapsedTime = 0L;
            DatabaseWrapper dbWrapper = new DatabaseWrapper(CastorDatabaseService.getDatabase());
            this.beginTransaction(dbWrapper.getDatabase());
            try {
                String extraInformation;
                String portalEnabled;
                boolean portalActive;
                this.validateAndModifyInputParameters(dbWrapper.getDatabase());
                this.nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.languageId, this.contentId);
                this.integrationDeliveryController = IntegrationDeliveryController.getIntegrationDeliveryController(this.siteNodeId, this.languageId, this.contentId);
                boolean isUserRedirected = false;
                Integer protectedSiteNodeVersionId = this.nodeDeliveryController.getProtectedSiteNodeVersionIdForPageCache(dbWrapper.getDatabase(), this.siteNodeId);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("protectedSiteNodeVersionId:" + protectedSiteNodeVersionId));
                }
                String protectWorking = CmsPropertyHandler.getProtectDeliverWorking();
                String protectPreview = CmsPropertyHandler.getProtectDeliverPreview();
                boolean protectDeliver = false;
                if (protectWorking.equals("true") && CmsPropertyHandler.getOperatingMode().equals("0")) {
                    protectDeliver = true;
                } else if (protectPreview.equals("true") && CmsPropertyHandler.getOperatingMode().equals("2")) {
                    protectDeliver = true;
                }
                if (protectedSiteNodeVersionId != null || protectDeliver) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("protectedSiteNodeVersionId:" + protectedSiteNodeVersionId));
                        logger.info((Object)("protectDeliver:" + protectDeliver));
                    }
                    isUserRedirected = this.handleExtranetLogic(dbWrapper.getDatabase(), this.repositoryId, protectedSiteNodeVersionId, protectDeliver);
                } else {
                    String forceIdentityCheck = RepositoryDeliveryController.getRepositoryDeliveryController().getExtraPropertyValue(this.repositoryId, "forceIdentityCheck");
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("forceIdentityCheck:" + forceIdentityCheck));
                    }
                    if (CmsPropertyHandler.getForceIdentityCheck().equalsIgnoreCase("true") || forceIdentityCheck != null && forceIdentityCheck.equalsIgnoreCase("true")) {
                        boolean isForcedIdentityCheckDisabled = this.nodeDeliveryController.getIsForcedIdentityCheckDisabled(dbWrapper.getDatabase(), this.siteNodeId);
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("isForcedIdentityCheckDisabled:" + isForcedIdentityCheckDisabled));
                        }
                        if (!isForcedIdentityCheckDisabled) {
                            isUserRedirected = this.handleExtranetLogic(dbWrapper.getDatabase(), true);
                        }
                    }
                }
                String pageKey = this.nodeDeliveryController.getPageCacheKey(dbWrapper.getDatabase(), this.getHttpSession(), this.getRequest(), this.siteNodeId, this.languageId, this.contentId, this.browserBean.getUseragent(), this.getRequest().getQueryString(), "");
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("pageKey:" + pageKey));
                }
                this.templateController = this.getTemplateController(dbWrapper, this.getSiteNodeId(), this.getLanguageId(), this.getContentId(), this.getRequest(), (InfoGluePrincipal)this.principal, false);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("handled extranet users: " + isUserRedirected));
                }
                boolean bl = portalActive = (portalEnabled = CmsPropertyHandler.getEnablePortal()) != null && portalEnabled.equals("true");
                if (portalActive && !this.isRecacheCall) {
                    PortalService service;
                    boolean actionExecuted;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"---> Checking for portlet action");
                    }
                    if (actionExecuted = (service = new PortalService()).service(this.getRequest(), this.getResponse())) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)"---> PortletAction was executed, returning NONE as a redirect has been issued");
                        }
                        isUserRedirected = true;
                        return "none";
                    }
                }
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("handled portal action: " + isUserRedirected));
                    }
                    if (isUserRedirected) break block71;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("this.templateController.getPrincipal():" + this.templateController.getPrincipal()));
                    }
                    DeliveryContext deliveryContext = DeliveryContext.getDeliveryContext(true);
                    deliveryContext.setRepositoryName(this.repositoryName);
                    deliveryContext.setSiteNodeId(this.siteNodeId);
                    deliveryContext.setContentId(this.contentId);
                    deliveryContext.setLanguageId(this.languageId);
                    deliveryContext.setPageKey(pageKey);
                    deliveryContext.setSession(this.getSession());
                    deliveryContext.setInfoGlueAbstractAction(this);
                    deliveryContext.setHttpServletRequest(this.getRequest());
                    deliveryContext.setHttpServletResponse(this.getResponse());
                    deliveryContext.setUseFullUrl(Boolean.parseBoolean(CmsPropertyHandler.getUseDNSNameInURI()));
                    SiteNodeTypeDefinitionVO siteNodeTypeDefinitionVO = this.getSiteNodeTypeDefinition(this.siteNodeId, dbWrapper.getDatabase());
                    try {
                        String invokerClassName = siteNodeTypeDefinitionVO.getInvokerClassName();
                        PageInvoker pageInvoker = (PageInvoker)Class.forName(invokerClassName).newInstance();
                        pageInvoker.setParameters(dbWrapper, this.getRequest(), this.getResponse(), this.templateController, deliveryContext);
                        pageInvoker.deliverPage();
                        request.setAttribute("progress", (Object)"after pageInvoker was called");
                    }
                    catch (ClassNotFoundException e) {
                        throw new SystemException("An error was thrown when trying to use the page invoker class assigned to this page type:" + e.getMessage(), e);
                    }
                }
                catch (PageNotFoundException e) {
                    extraInformation = "Original URL: " + this.getOriginalFullURL() + "\n";
                    extraInformation = String.valueOf(extraInformation) + "Referer: " + this.getRequest().getHeader("Referer") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "UserAgent: " + this.getRequest().getHeader("User-Agent") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "User IP: " + this.getRequest().getRemoteAddr();
                    logger.warn((Object)("A user requested a non existing page:" + e.getMessage() + "\n" + extraInformation));
                    this.rollbackTransaction(dbWrapper.getDatabase());
                    this.getResponse().setContentType("text/html; charset=UTF-8");
                    this.getRequest().setAttribute("responseCode", (Object)"404");
                    this.getRequest().setAttribute("error", (Object)e);
                    this.getRequest().setAttribute("errorUrl", (Object)this.getErrorUrl());
                    this.getRequest().getRequestDispatcher("/ErrorPage.action").forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
                }
                catch (NoBaseTemplateFoundException e) {
                    extraInformation = "Original URL: " + this.getOriginalFullURL() + "\n";
                    extraInformation = String.valueOf(extraInformation) + "Referer: " + this.getRequest().getHeader("Referer") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "UserAgent: " + this.getRequest().getHeader("User-Agent") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "User IP: " + this.getRequest().getRemoteAddr();
                    logger.error((Object)("A user requested a page which had no base template (probably of the old HTMLPageInvoker type - should be changed):" + e.getMessage() + "\n" + extraInformation));
                    this.rollbackTransaction(dbWrapper.getDatabase());
                    this.getResponse().setContentType("text/html; charset=UTF-8");
                    this.getRequest().setAttribute("responseCode", (Object)"500");
                    this.getRequest().setAttribute("error", (Object)e);
                    this.getRequest().setAttribute("errorUrl", (Object)this.getErrorUrl());
                    this.getRequest().getRequestDispatcher("/ErrorPage.action").forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
                }
                catch (Exception e) {
                    extraInformation = "Original URL: " + this.getOriginalFullURL() + "\n";
                    extraInformation = String.valueOf(extraInformation) + "Referer: " + this.getRequest().getHeader("Referer") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "UserAgent: " + this.getRequest().getHeader("User-Agent") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "User IP: " + this.getRequest().getRemoteAddr();
                    logger.error((Object)("An error occurred so we should not complete the transaction:" + e.getMessage() + "\n" + extraInformation), (Throwable)e);
                    this.rollbackTransaction(dbWrapper.getDatabase());
                    this.getResponse().setContentType("text/html; charset=UTF-8");
                    this.getRequest().setAttribute("responseCode", (Object)"500");
                    this.getRequest().setAttribute("error", (Object)e);
                    this.getRequest().setAttribute("errorUrl", (Object)this.getErrorUrl());
                    this.getRequest().getRequestDispatcher("/ErrorPage.action").forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
                }
            }
            finally {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Before closing transaction");
                }
                try {
                    this.closeTransaction(dbWrapper.getDatabase());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"After closing transaction");
                }
                elapsedTime = Math.abs(System.currentTimeMillis() - start);
                RequestAnalyser.getRequestAnalyser().decNumberOfCurrentRequests(elapsedTime);
                lastRequestProcessingTime = elapsedTime;
                if (!memoryWarningSent) {
                    float memoryLeft = ((float)Runtime.getRuntime().maxMemory() - (float)Runtime.getRuntime().totalMemory()) / 1024.0f / 1024.0f;
                    float percentLeft = memoryLeft / ((float)Runtime.getRuntime().maxMemory() / 1024.0f / 1024.0f) * 100.0f;
                    float percentLeft2 = (float)Runtime.getRuntime().freeMemory() / (float)Runtime.getRuntime().totalMemory() * 100.0f;
                    if (percentLeft < 15.0f && percentLeft2 < 15.0f) {
                        memoryWarningSent = true;
                        String subject = "Memory is getting low on " + CmsPropertyHandler.getServerName();
                        String mailBody = "The java maximum heap size is almost used up - only " + (int)memoryLeft + "MB (" + (int)percentLeft + "%) left. Increase the max heap size if possible or trim the cache sizes if they are very large.";
                        String warningEmailReceiver = CmsPropertyHandler.getWarningEmailReceiver();
                        if (warningEmailReceiver != null && !warningEmailReceiver.equals("") && warningEmailReceiver.indexOf("@warningEmailReceiver@") == -1) {
                            try {
                                logger.warn((Object)("Sending warning mail:" + (int)percentLeft + ":" + (int)memoryLeft + ":" + Runtime.getRuntime().maxMemory() / 1024L / 1024L));
                                MailServiceFactory.getService().sendEmail(warningEmailReceiver, warningEmailReceiver, null, subject, mailBody, "utf-8");
                            }
                            catch (Exception e) {
                                logger.error((Object)("Could not send mail:" + e.getMessage()), (Throwable)e);
                            }
                        }
                    }
                }
                if (elapsedTime > 10000L) {
                    logger.warn((Object)("The page delivery took " + elapsedTime + "ms for request " + this.getRequest().getRequestURL() + "?" + this.getRequest().getQueryString()));
                    logger.warn((Object)("The memory consumption was " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + "(" + Runtime.getRuntime().totalMemory() + "/" + Runtime.getRuntime().maxMemory() + ") bytes"));
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)("The page delivery took " + elapsedTime + "ms"));
                    logger.info((Object)("The memory consumption was " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + "(" + Runtime.getRuntime().totalMemory() + "/" + Runtime.getRuntime().maxMemory() + ") bytes"));
                }
                if (this.tk != null) {
                    this.tk.done();
                }
            }
        }
        return "none";
    }

    /*
     * Unable to fully structure code
     */
    public String doRenderDecoratedPage() throws Exception {
        block46: {
            if (!CmsPropertyHandler.getOperatingMode().equals("3")) ** GOTO lbl4
            return this.doExecute();
lbl-1000:
            // 1 sources

            {
                Thread.sleep(10L);
lbl4:
                // 2 sources

                ** while (!CmsPropertyHandler.getOperatingMode().equals((Object)"3") && RequestAnalyser.getRequestAnalyser().getBlockRequests())
            }
lbl5:
            // 1 sources

            ViewPageAction.logger.info((Object)"************************************************");
            ViewPageAction.logger.info((Object)"* ViewPageAction was called....                *");
            ViewPageAction.logger.info((Object)"************************************************");
            request = this.getRequest();
            this.tk = CmsPropertyHandler.getOperatingMode().equals("3") == false ? new ThreadMonitor(new Long(CmsPropertyHandler.getDeliverRequestTimeout()), request, "Page view took to long!", true) : (CmsPropertyHandler.getKillLiveRequestWhichTimedout() == false ? new ThreadMonitor(new Long(CmsPropertyHandler.getLiveDeliverRequestTimeout()), request, "Page view seems to take to long!", false) : new ThreadMonitor(new Long(CmsPropertyHandler.getLiveDeliverRequestTimeout()), request, "Page view took to long!", true));
            RequestAnalyser.getRequestAnalyser().incNumberOfCurrentRequests(this.tk);
            start = System.currentTimeMillis();
            elapsedTime = 0L;
            dbWrapper = new DatabaseWrapper(CastorDatabaseService.getDatabase());
            this.beginTransaction(dbWrapper.getDatabase());
            try {
                this.validateAndModifyInputParameters(dbWrapper.getDatabase());
                this.nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.languageId, this.contentId);
                this.integrationDeliveryController = IntegrationDeliveryController.getIntegrationDeliveryController(this.siteNodeId, this.languageId, this.contentId);
                isUserRedirected = false;
                protectedSiteNodeVersionId = this.nodeDeliveryController.getProtectedSiteNodeVersionId(dbWrapper.getDatabase(), this.siteNodeId);
                ViewPageAction.logger.info((Object)("protectedSiteNodeVersionId:" + protectedSiteNodeVersionId));
                protectWorking = CmsPropertyHandler.getProtectDeliverWorking();
                protectPreview = CmsPropertyHandler.getProtectDeliverPreview();
                protectDeliver = true;
                if (protectedSiteNodeVersionId != null || protectDeliver) {
                    isUserRedirected = this.handleExtranetLogic(dbWrapper.getDatabase(), this.repositoryId, protectedSiteNodeVersionId, protectDeliver);
                }
                pageKey = this.nodeDeliveryController.getPageCacheKey(dbWrapper.getDatabase(), this.getHttpSession(), this.getRequest(), this.siteNodeId, this.languageId, this.contentId, this.browserBean.getUseragent(), this.getRequest().getQueryString(), "_" + this.showSimple + "_pagecomponentDecorated");
                if (ViewPageAction.logger.isInfoEnabled()) {
                    ViewPageAction.logger.info((Object)("A pageKey:" + pageKey));
                }
                this.templateController = this.getTemplateController(dbWrapper, this.getSiteNodeId(), this.getLanguageId(), this.getContentId(), this.getRequest(), (InfoGluePrincipal)this.principal, true);
                ViewPageAction.logger.info((Object)"handled extranet users");
                portalEnabled = CmsPropertyHandler.getEnablePortal();
                v0 = portalActive = portalEnabled != null && portalEnabled.equals("true") != false;
                if (portalActive && !this.isRecacheCall) {
                    ViewPageAction.logger.info((Object)"---> Checking for portlet action");
                    service = new PortalService();
                    actionExecuted = service.service(this.getRequest(), this.getResponse());
                    if (actionExecuted) {
                        ViewPageAction.logger.info((Object)"---> PortletAction was executed, returning NONE as a redirect has been issued");
                        isUserRedirected = true;
                        return "none";
                    }
                }
                try {
                    ViewPageAction.logger.info((Object)"handled portal action");
                    if (isUserRedirected) break block46;
                    ViewPageAction.logger.info((Object)("this.templateController.getPrincipal():" + this.templateController.getPrincipal()));
                    deliveryContext = DeliveryContext.getDeliveryContext(true);
                    deliveryContext.setRepositoryName(this.repositoryName);
                    deliveryContext.setSiteNodeId(this.siteNodeId);
                    deliveryContext.setLanguageId(this.languageId);
                    deliveryContext.setContentId(this.contentId);
                    deliveryContext.setShowSimple(this.showSimple);
                    deliveryContext.setPageKey(pageKey);
                    deliveryContext.setSession(this.getSession());
                    deliveryContext.setInfoGlueAbstractAction(this);
                    deliveryContext.setHttpServletRequest(this.getRequest());
                    deliveryContext.setHttpServletResponse(this.getResponse());
                    deliveryContext.setUseFullUrl(Boolean.parseBoolean(CmsPropertyHandler.getUseDNSNameInURI()));
                    deliveryContext.setDisablePageCache(true);
                    siteNode = this.nodeDeliveryController.getSiteNode(dbWrapper.getDatabase(), this.siteNodeId);
                    if (siteNode == null) {
                        throw new SystemException("There was no page with this id.");
                    }
                    if (siteNode.getSiteNodeTypeDefinition() == null) {
                        throw new SystemException("There was no SiteNodeTypeDefinition defined for the site node " + siteNode.getName() + "[" + siteNode.getId() + "].");
                    }
                    invokerClassName = siteNode.getSiteNodeTypeDefinition().getInvokerClassName();
                    if (invokerClassName == null && invokerClassName.equals("")) {
                        throw new SystemException("There was no page invoker class assigned to this page type.");
                    }
                    try {
                        pageInvoker = (PageInvoker)Class.forName(invokerClassName).newInstance();
                        pageInvoker = pageInvoker.getDecoratedPageInvoker(this.templateController);
                        pageInvoker.setParameters(dbWrapper, this.getRequest(), this.getResponse(), this.templateController, deliveryContext);
                        pageInvoker.deliverPage();
                    }
                    catch (ClassNotFoundException e) {
                        throw new SystemException("An error was thrown when trying to use the page invoker class assigned to this page type:" + e.getMessage(), e);
                    }
                }
                catch (PageNotFoundException e) {
                    extraInformation = "Original URL: " + this.getOriginalFullURL() + "\n";
                    extraInformation = String.valueOf(extraInformation) + "Referer: " + this.getRequest().getHeader("Referer") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "UserAgent: " + this.getRequest().getHeader("User-Agent") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "User IP: " + this.getRequest().getRemoteAddr();
                    ViewPageAction.logger.warn((Object)("A user requested a non existing page:" + e.getMessage() + "\n" + extraInformation));
                    this.rollbackTransaction(dbWrapper.getDatabase());
                    this.getResponse().setContentType("text/html; charset=UTF-8");
                    this.getRequest().setAttribute("responseCode", (Object)"404");
                    this.getRequest().setAttribute("error", (Object)e);
                    this.getRequest().setAttribute("errorUrl", (Object)this.getErrorUrl());
                    this.getRequest().getRequestDispatcher("/ErrorPage.action").forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
                }
                catch (NoBaseTemplateFoundException e) {
                    extraInformation = "Original URL: " + this.getOriginalFullURL() + "\n";
                    extraInformation = String.valueOf(extraInformation) + "Referer: " + this.getRequest().getHeader("Referer") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "UserAgent: " + this.getRequest().getHeader("User-Agent") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "User IP: " + this.getRequest().getRemoteAddr();
                    ViewPageAction.logger.error((Object)("A user requested a page which had no base template (probably of the old HTMLPageInvoker type - should be changed):" + e.getMessage() + "\n" + extraInformation));
                    this.rollbackTransaction(dbWrapper.getDatabase());
                    this.getResponse().setContentType("text/html; charset=UTF-8");
                    this.getRequest().setAttribute("responseCode", (Object)"500");
                    this.getRequest().setAttribute("error", (Object)e);
                    this.getRequest().setAttribute("errorUrl", (Object)this.getErrorUrl());
                    this.getRequest().getRequestDispatcher("/ErrorPage.action").forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
                }
                catch (Exception e) {
                    extraInformation = "Original URL: " + this.getOriginalFullURL() + "\n";
                    extraInformation = String.valueOf(extraInformation) + "Referer: " + this.getRequest().getHeader("Referer") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "UserAgent: " + this.getRequest().getHeader("User-Agent") + "\n";
                    extraInformation = String.valueOf(extraInformation) + "User IP: " + this.getRequest().getRemoteAddr();
                    ViewPageAction.logger.error((Object)("An error occurred so we should not complete the transaction:" + e.getMessage() + "\n" + extraInformation), (Throwable)e);
                    this.rollbackTransaction(dbWrapper.getDatabase());
                    throw new SystemException(e.getMessage());
                }
            }
            finally {
                try {
                    this.closeTransaction(dbWrapper.getDatabase());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                elapsedTime = Math.abs(System.currentTimeMillis() - start);
                RequestAnalyser.getRequestAnalyser().decNumberOfCurrentRequests(elapsedTime);
                if (!ViewPageAction.memoryWarningSent) {
                    memoryLeft = ((float)Runtime.getRuntime().maxMemory() - (float)Runtime.getRuntime().totalMemory()) / 1024.0f / 1024.0f;
                    percentLeft = memoryLeft / ((float)Runtime.getRuntime().maxMemory() / 1024.0f / 1024.0f) * 100.0f;
                    percentLeft2 = (float)Runtime.getRuntime().freeMemory() / (float)Runtime.getRuntime().totalMemory() * 100.0f;
                    if (percentLeft < 15.0f && percentLeft2 < 15.0f) {
                        ViewPageAction.memoryWarningSent = true;
                        subject = "Memory is getting low on " + CmsPropertyHandler.getServerName();
                        mailBody = "The java maximum heap size is almost used up - only " + (int)memoryLeft + "MB (" + (int)percentLeft + "%) left. Increase the max heap size if possible or trim the cache sizes if they are very large.";
                        warningEmailReceiver = CmsPropertyHandler.getWarningEmailReceiver();
                        if (warningEmailReceiver != null && !warningEmailReceiver.equals("") && warningEmailReceiver.indexOf("@warningEmailReceiver@") == -1) {
                            try {
                                ViewPageAction.logger.warn((Object)("Sending warning mail:" + (int)percentLeft + ":" + (int)memoryLeft + ":" + (float)Runtime.getRuntime().maxMemory() / 1024.0f / 1024.0f));
                                MailServiceFactory.getService().sendEmail(warningEmailReceiver, warningEmailReceiver, null, subject, mailBody, "utf-8");
                            }
                            catch (Exception e) {
                                ViewPageAction.logger.error((Object)("Could not send mail:" + e.getMessage()), (Throwable)e);
                            }
                        }
                    }
                }
                if (elapsedTime > 20000L) {
                    ViewPageAction.logger.warn((Object)("The page delivery took " + elapsedTime + "ms for request " + this.getRequest().getRequestURL() + "?" + this.getRequest().getQueryString()));
                    ViewPageAction.logger.warn((Object)("The memory consumption was " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + "(" + Runtime.getRuntime().totalMemory() + "/" + Runtime.getRuntime().maxMemory() + ") bytes"));
                } else {
                    ViewPageAction.logger.info((Object)("The page delivery took " + elapsedTime + "ms"));
                    ViewPageAction.logger.info((Object)("The memory consumption was " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + "(" + Runtime.getRuntime().totalMemory() + "/" + Runtime.getRuntime().maxMemory() + ") bytes"));
                }
                if (this.tk != null) {
                    this.tk.done();
                }
            }
        }
        return "none";
    }

    public TemplateController getTemplateController(DatabaseWrapper dbWrapper, Integer siteNodeId, Integer languageId, Integer contentId, HttpServletRequest request, InfoGluePrincipal infoGluePrincipal, boolean allowEditOnSightAtAll) throws SystemException, Exception {
        BasicTemplateController templateController = new BasicTemplateController(dbWrapper, infoGluePrincipal);
        templateController.setStandardRequestParameters(siteNodeId, languageId, contentId);
        templateController.setHttpRequest(request);
        templateController.setBrowserBean(this.browserBean);
        templateController.setDeliveryControllers(this.nodeDeliveryController, null, this.integrationDeliveryController);
        String operatingMode = CmsPropertyHandler.getOperatingMode();
        if (operatingMode != null && (operatingMode.equals("0") || operatingMode.equals("1") || operatingMode.equals("2"))) {
            String editOnSite = CmsPropertyHandler.getEditOnSite();
            boolean isEditOnSightDisabled = templateController.getIsEditOnSightDisabled();
            if (allowEditOnSightAtAll && !isEditOnSightDisabled && editOnSite != null && editOnSite.equalsIgnoreCase("true")) {
                templateController = new EditOnSiteBasicTemplateController(dbWrapper, infoGluePrincipal);
                templateController.setStandardRequestParameters(siteNodeId, languageId, contentId);
                templateController.setHttpRequest(request);
                templateController.setBrowserBean(this.browserBean);
                templateController.setDeliveryControllers(this.nodeDeliveryController, null, this.integrationDeliveryController);
            }
        }
        return templateController;
    }

    private void validateAndModifyInputParameters(Database db) throws PageNotFoundException, SystemException, Exception {
        this.browserBean = new BrowserBean();
        this.browserBean.setRequest(this.getRequest());
        this.principal = (Principal)this.getHttpSession().getAttribute("infogluePrincipal");
        if (this.principal == null) {
            try {
                this.principal = (Principal)CacheController.getCachedObject("userCache", "anonymous");
                if (this.principal == null) {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    arguments.put("j_username", CmsPropertyHandler.getAnonymousUser());
                    arguments.put("j_password", CmsPropertyHandler.getAnonymousPassword());
                    this.principal = ExtranetController.getController().getAuthenticatedPrincipal(db, arguments);
                    if (this.principal != null) {
                        CacheController.cacheObject("userCache", "anonymous", this.principal);
                    }
                }
            }
            catch (Exception e) {
                throw new SystemException("There was no anonymous user found in the system. There must be - add the user anonymous/anonymous and try again.", e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("principal in validateAndModifyInputParameters:" + this.principal));
        }
        if (this.getSiteNodeId() == null) {
            SiteNodeVO rootSiteNodeVO;
            if (this.getRepositoryName() == null) {
                this.setRepositoryName(RepositoryDeliveryController.getRepositoryDeliveryController().getMasterRepository(db).getName());
            }
            if ((rootSiteNodeVO = NodeDeliveryController.getRootSiteNode(db, this.getRepositoryName())) == null) {
                throw new SystemException("There was no repository called " + this.getRepositoryName() + " or no pages were available in that repository");
            }
            this.setSiteNodeId(rootSiteNodeVO.getSiteNodeId());
            this.repositoryId = rootSiteNodeVO.getRepositoryId();
        }
        try {
            if (this.getSiteNodeId() != null) {
                SiteNodeVO siteNodeVO = SiteNodeController.getSiteNodeVOWithId(this.getSiteNodeId(), db);
                this.repositoryId = siteNodeVO.getRepositoryId();
            }
        }
        catch (Exception e) {
            throw new PageNotFoundException("There is no page with the requested specification. SiteNodeId:" + this.getSiteNodeId());
        }
        if (this.getLanguageId() == null) {
            LanguageVO browserLanguageVO = null;
            String useAlternativeBrowserLanguageCheck = CmsPropertyHandler.getUseAlternativeBrowserLanguageCheck();
            browserLanguageVO = useAlternativeBrowserLanguageCheck == null || !useAlternativeBrowserLanguageCheck.equalsIgnoreCase("true") ? LanguageDeliveryController.getLanguageDeliveryController().getLanguageIfSiteNodeSupportsIt(db, this.browserBean.getLanguageCode(), this.getSiteNodeId(), (InfoGluePrincipal)this.principal) : LanguageDeliveryController.getLanguageDeliveryController().getLanguageIfRepositorySupportsIt(db, this.browserBean.getLanguageCode(), this.getSiteNodeId());
            logger.debug((Object)"Checking browser language...");
            if (browserLanguageVO != null) {
                logger.info((Object)("The system had browserLanguageVO available:" + browserLanguageVO.getName()));
                this.setLanguageId(browserLanguageVO.getLanguageId());
            } else {
                LanguageVO masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, this.getSiteNodeId());
                if (masterLanguageVO == null) {
                    throw new SystemException("There was no master language for the siteNode " + this.getSiteNodeId());
                }
                NodeDeliveryController ndc = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.languageId, this.contentId);
                boolean isMasterLanguageValid = LanguageDeliveryController.getLanguageDeliveryController().getIsValidLanguage(db, ndc, ndc.getSiteNode(db, this.siteNodeId), masterLanguageVO.getId());
                if (!isMasterLanguageValid) {
                    logger.info((Object)"Master language was not allowed on this sitenode... let's take the next on in order");
                    List languages = LanguageDeliveryController.getLanguageDeliveryController().getAvailableLanguages(db, this.getSiteNodeId());
                    for (LanguageVO currentLanguage : languages) {
                        boolean isCurrentLanguageValid = LanguageDeliveryController.getLanguageDeliveryController().getIsValidLanguage(db, ndc, ndc.getSiteNode(db, this.siteNodeId), currentLanguage.getId());
                        logger.info((Object)("currentLanguage validity:" + isCurrentLanguageValid));
                        if (!isCurrentLanguageValid) continue;
                        this.setLanguageId(currentLanguage.getLanguageId());
                        break;
                    }
                } else {
                    logger.info((Object)("The system had no browserLanguageVO available - using master language instead:" + masterLanguageVO.getName()));
                    this.setLanguageId(masterLanguageVO.getLanguageId());
                }
            }
        } else {
            LanguageVO languageVO = LanguageDeliveryController.getLanguageDeliveryController().getLanguageIfSiteNodeSupportsIt(db, this.getLanguageId(), this.getSiteNodeId());
            if (languageVO != null) {
                logger.info((Object)("The system had browserLanguageVO available:" + languageVO.getName()));
                this.setLanguageId(languageVO.getLanguageId());
            } else {
                LanguageVO masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, this.getSiteNodeId());
                if (masterLanguageVO == null) {
                    throw new SystemException("There was no master language for the siteNode " + this.getSiteNodeId());
                }
                NodeDeliveryController ndc = NodeDeliveryController.getNodeDeliveryController(this.siteNodeId, this.languageId, this.contentId);
                boolean isMasterLanguageValid = LanguageDeliveryController.getLanguageDeliveryController().getIsValidLanguage(db, ndc, ndc.getSiteNode(db, this.siteNodeId), masterLanguageVO.getId());
                if (!isMasterLanguageValid) {
                    logger.info((Object)"Master language was not allowed on this sitenode... let's take the next on in order");
                    List languages = LanguageDeliveryController.getLanguageDeliveryController().getAvailableLanguages(db, this.getSiteNodeId());
                    for (LanguageVO currentLanguage : languages) {
                        boolean isCurrentLanguageValid = LanguageDeliveryController.getLanguageDeliveryController().getIsValidLanguage(db, ndc, ndc.getSiteNode(db, this.siteNodeId), currentLanguage.getId());
                        logger.info((Object)("currentLanguage validity:" + isCurrentLanguageValid));
                        if (!isCurrentLanguageValid) continue;
                        this.setLanguageId(currentLanguage.getLanguageId());
                        break;
                    }
                } else {
                    logger.info((Object)("The system had no browserLanguageVO available - using master language instead:" + masterLanguageVO.getName()));
                    this.setLanguageId(masterLanguageVO.getLanguageId());
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleExtranetLogic(Database db, Integer repositoryId, Integer protectedSiteNodeVersionId, boolean protectDeliver) throws SystemException, Exception {
        boolean isRedirected = false;
        try {
            Principal anonymousPrincipal;
            Boolean redirected;
            HashMap<String, Boolean> status;
            String referer = this.getRequest().getHeader("Referer");
            logger.info((Object)("referer:" + referer));
            if (referer == null || referer.indexOf("ViewStructureToolToolBar.action") != -1) {
                referer = "/";
            }
            Principal principal = (Principal)this.getHttpSession().getAttribute("infogluePrincipal");
            logger.info((Object)("principal:" + principal));
            if (principal == null && this.getRequest().getUserPrincipal() != null && !(this.getRequest().getUserPrincipal() instanceof InfoGluePrincipal)) {
                status = new HashMap();
                status.put("redirected", new Boolean(false));
                principal = AuthenticationModule.getAuthenticationModule(db, this.getOriginalFullURL()).loginUser(this.getRequest(), this.getResponse(), status);
                redirected = (Boolean)status.get("redirected");
                if (redirected != null && redirected.booleanValue()) {
                    this.getHttpSession().removeAttribute("infogluePrincipal");
                    this.principal = null;
                    return true;
                }
                if (principal != null) {
                    this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                    this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                    this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
                    this.principal = principal;
                }
            }
            if (principal == null && !protectDeliver) {
                Principal anonymousPrincipal2 = this.getAnonymousPrincipal();
                boolean isAuthorized = AccessRightController.getController().getIsPrincipalAuthorized(db, (InfoGluePrincipal)anonymousPrincipal2, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString());
                if (isAuthorized && (principal = anonymousPrincipal2) != null) {
                    this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                    this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                    this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
                }
            }
            if (principal == null) {
                status = new HashMap<String, Boolean>();
                status.put("redirected", new Boolean(false));
                principal = AuthenticationModule.getAuthenticationModule(db, this.getOriginalFullURL()).loginUser(this.getRequest(), this.getResponse(), status);
                redirected = (Boolean)status.get("redirected");
                if (redirected != null && redirected.booleanValue()) {
                    this.getHttpSession().removeAttribute("infogluePrincipal");
                    this.principal = null;
                    return true;
                }
                if (principal != null) {
                    this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                    this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                    this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
                    this.principal = principal;
                }
                if (principal == null) {
                    principal = this.loginWithCookies();
                }
                if (principal == null) {
                    principal = this.loginWithRequestArguments();
                }
                if (principal == null) {
                    try {
                        principal = this.getAnonymousPrincipal();
                        if (principal == null) return isRedirected;
                        this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                        this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                        this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
                        boolean isAuthorized = false;
                        if (!protectDeliver) {
                            isAuthorized = AccessRightController.getController().getIsPrincipalAuthorized(db, (InfoGluePrincipal)principal, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString());
                        }
                        if (isAuthorized) return isRedirected;
                        this.getHttpSession().removeAttribute("infogluePrincipal");
                        logger.info((Object)"SiteNode is protected and anonymous user was not allowed - sending him to login page.");
                        String redirectUrl = this.getRedirectUrl(this.getRequest(), this.getResponse());
                        this.getResponse().sendRedirect(redirectUrl);
                        return true;
                    }
                    catch (Exception e) {
                        throw new SystemException("There was no anonymous user found in the system. There must be - add the user anonymous/anonymous and try again.", e);
                    }
                }
                boolean isAuthorized = false;
                if (protectDeliver && protectedSiteNodeVersionId == null && !principal.getName().equals(CmsPropertyHandler.getAnonymousUser())) {
                    isAuthorized = true;
                } else if (protectedSiteNodeVersionId != null) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("protectedSiteNodeVersionId:" + protectedSiteNodeVersionId));
                    }
                    isAuthorized = AccessRightController.getController().getIsPrincipalAuthorized((InfoGluePrincipal)this.getAnonymousPrincipal(), "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString());
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Anonymous auth:" + isAuthorized));
                    }
                    if (!isAuthorized) {
                        isAuthorized = AccessRightController.getController().getIsPrincipalAuthorized(db, (InfoGluePrincipal)principal, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString());
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)(principal + " auth:" + isAuthorized));
                        }
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("protectedSiteNodeVersionId:" + protectedSiteNodeVersionId));
                    }
                } else if (!protectDeliver) {
                    isAuthorized = AccessRightController.getController().getIsPrincipalAuthorized(db, (InfoGluePrincipal)principal, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString());
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("protectDeliver:" + protectDeliver));
                    logger.info((Object)("protectedSiteNodeVersionId:" + protectedSiteNodeVersionId));
                    logger.info((Object)("isAuthorized:" + isAuthorized));
                    logger.info((Object)("principal:" + principal));
                }
                if (isAuthorized) {
                    this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                    this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                    this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
                    this.principal = principal;
                    return isRedirected;
                }
                if (this.referer == null) {
                    this.referer = this.getRequest().getHeader("Referer");
                }
                if (this.referer == null || referer.indexOf("ViewStructureToolToolBar.action") != -1) {
                    this.referer = "/";
                }
                if (principal.getName().equals(CmsPropertyHandler.getAnonymousUser())) {
                    logger.info((Object)"SiteNode is protected and user was anonymous - sending him to login page.");
                    String url = this.getRedirectUrl(this.getRequest(), this.getResponse());
                    this.getResponse().sendRedirect(url);
                    return true;
                }
                logger.info((Object)"SiteNode is protected and user has no access - sending him to no access page.");
                String url = "ExtranetLogin!noAccess.action?referer=" + URLEncoder.encode(this.referer, "UTF-8") + "&date=" + System.currentTimeMillis();
                this.getResponse().sendRedirect(url);
                return true;
            }
            logger.info((Object)("principal:" + principal));
            logger.info((Object)("protectedSiteNodeVersionId:" + protectedSiteNodeVersionId));
            Principal alternativePrincipal = this.loginWithCookies();
            if (alternativePrincipal == null) {
                alternativePrincipal = this.loginWithRequestArguments();
            }
            if (protectedSiteNodeVersionId != null && alternativePrincipal != null && AccessRightController.getController().getIsPrincipalAuthorized((InfoGluePrincipal)alternativePrincipal, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString())) {
                logger.info((Object)("The user " + alternativePrincipal.getName() + " was approved."));
                return isRedirected;
            }
            if (protectedSiteNodeVersionId != null && !AccessRightController.getController().getIsPrincipalAuthorized((InfoGluePrincipal)principal, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString()) && !AccessRightController.getController().getIsPrincipalAuthorized((InfoGluePrincipal)this.getAnonymousPrincipal(), "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString())) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("principal:" + principal));
                    logger.info((Object)("protectedSiteNodeVersionId:" + protectedSiteNodeVersionId));
                    logger.info((Object)("this.getAnonymousPrincipal():" + this.getAnonymousPrincipal()));
                    logger.info((Object)("Principal access: " + !AccessRightController.getController().getIsPrincipalAuthorized((InfoGluePrincipal)principal, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString())));
                    logger.info((Object)("Principal access: " + !AccessRightController.getController().getIsPrincipalAuthorized((InfoGluePrincipal)principal, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString())));
                    logger.info((Object)("Anonymous access: " + !AccessRightController.getController().getIsPrincipalAuthorized((InfoGluePrincipal)this.getAnonymousPrincipal(), "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString())));
                }
                if (this.referer == null) {
                    this.referer = this.getRequest().getHeader("Referer");
                }
                if (this.referer == null || referer.indexOf("ViewStructureToolToolBar.action") != -1) {
                    this.referer = "/";
                }
                if (!principal.getName().equals(CmsPropertyHandler.getAnonymousUser())) {
                    logger.info((Object)("SiteNode is protected and neither " + principal + " or " + this.getAnonymousPrincipal() + " has access - sending him to no access page."));
                    String url = "ExtranetLogin!noAccess.action?referer=" + URLEncoder.encode(this.referer, "UTF-8") + "&date=" + System.currentTimeMillis();
                    this.getResponse().sendRedirect(url);
                    return true;
                }
                String ssoUserName = AuthenticationModule.getAuthenticationModule(null, this.getOriginalFullURL()).getSSOUserName(this.getRequest());
                if (ssoUserName != null) {
                    principal = UserControllerProxy.getController().getUser(ssoUserName);
                    if (principal == null) return isRedirected;
                    this.principal = principal;
                    this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                    this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                    this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
                    return isRedirected;
                }
                logger.info((Object)"SiteNode is protected and user was anonymous - sending him to login page.");
                String url = this.getRedirectUrl(this.getRequest(), this.getResponse());
                logger.info((Object)("url:" + url));
                if (url == null) return isRedirected;
                this.getResponse().sendRedirect(url);
                return true;
            }
            if (protectedSiteNodeVersionId != null) return isRedirected;
            if (!protectDeliver) return isRedirected;
            logger.info((Object)"Setting user to anonymous... as this is a protected deliver but not a extranet...");
            this.principal = anonymousPrincipal = this.getAnonymousPrincipal();
            return isRedirected;
        }
        catch (SystemException se) {
            logger.warn((Object)("An error occurred:" + se.getMessage()), (Throwable)se);
            throw se;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred:" + e.getMessage()), (Throwable)e);
        }
        return isRedirected;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleExtranetLogic(Database db, boolean gateway) throws SystemException, Exception {
        boolean isRedirected = false;
        try {
            Boolean redirected;
            HashMap<String, Boolean> status;
            String skipSSOCheck = this.getRequest().getParameter("skipSSOCheck");
            String ticket = this.getRequest().getParameter("ticket");
            if (skipSSOCheck != null && !skipSSOCheck.equals("") && (ticket == null || ticket.equals(""))) {
                this.principal = this.getAnonymousPrincipal();
                if (this.principal == null) return isRedirected;
                this.getHttpSession().setAttribute("infogluePrincipal", (Object)this.principal);
                this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)this.principal.getName());
                this.getHttpSession().setAttribute("cmsUserName", (Object)this.principal.getName());
                return isRedirected;
            }
            String referer = this.getRequest().getHeader("Referer");
            logger.info((Object)("referer:" + referer));
            if (referer == null || referer.indexOf("ViewStructureToolToolBar.action") != -1) {
                referer = "/";
            }
            Principal principal = (Principal)this.getHttpSession().getAttribute("infogluePrincipal");
            logger.info((Object)("principal:" + principal));
            if (principal == null && this.getRequest().getUserPrincipal() != null && !(this.getRequest().getUserPrincipal() instanceof InfoGluePrincipal)) {
                status = new HashMap();
                status.put("redirected", new Boolean(false));
                this.getRequest().setAttribute("gateway", (Object)("" + gateway));
                principal = AuthenticationModule.getAuthenticationModule(db, this.getOriginalFullURL()).loginUser(this.getRequest(), this.getResponse(), status);
                redirected = (Boolean)status.get("redirected");
                if (redirected != null && redirected.booleanValue()) {
                    this.getHttpSession().removeAttribute("infogluePrincipal");
                    this.principal = null;
                    return true;
                }
                if (principal != null) {
                    this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                    this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                    this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
                    this.principal = principal;
                }
            }
            if (principal != null) {
                logger.info((Object)("principal:" + principal));
                Principal alternativePrincipal = this.loginWithCookies();
                if (alternativePrincipal != null) return isRedirected;
                alternativePrincipal = this.loginWithRequestArguments();
                return isRedirected;
            }
            status = new HashMap<String, Boolean>();
            status.put("redirected", new Boolean(false));
            this.getRequest().setAttribute("gateway", (Object)("" + gateway));
            principal = AuthenticationModule.getAuthenticationModule(db, this.getOriginalFullURL()).loginUser(this.getRequest(), this.getResponse(), status);
            redirected = (Boolean)status.get("redirected");
            if (redirected != null && redirected.booleanValue()) {
                this.getHttpSession().removeAttribute("infogluePrincipal");
                this.principal = null;
                return true;
            }
            if (principal != null) {
                this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
                this.principal = principal;
            }
            if (principal == null) {
                principal = this.loginWithCookies();
            }
            if (principal == null) {
                principal = this.loginWithRequestArguments();
            }
            if (principal != null) {
                this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
                this.principal = principal;
                return isRedirected;
            }
            try {
                principal = this.getAnonymousPrincipal();
                if (principal == null) return isRedirected;
                this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
                return isRedirected;
            }
            catch (Exception e) {
                throw new SystemException("There was no anonymous user found in the system. There must be - add the user anonymous/anonymous and try again.", e);
            }
        }
        catch (SystemException se) {
            logger.warn((Object)("An error occurred:" + se.getMessage()), (Throwable)se);
            throw se;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred:" + e.getMessage()), (Throwable)e);
        }
        return isRedirected;
    }

    private Principal loginWithCookies() throws Exception {
        Principal principal = null;
        boolean enableExtranetCookies = false;
        int extranetCookieTimeout = 43200;
        String enableExtranetCookiesString = CmsPropertyHandler.getEnableExtranetCookies();
        String extranetCookieTimeoutString = CmsPropertyHandler.getExtranetCookieTimeout();
        if (enableExtranetCookiesString != null && enableExtranetCookiesString.equalsIgnoreCase("true")) {
            enableExtranetCookies = true;
        }
        if (extranetCookieTimeoutString != null) {
            try {
                extranetCookieTimeout = Integer.parseInt(extranetCookieTimeoutString.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (enableExtranetCookies) {
            String userName = null;
            String password = null;
            Cookie[] cookies = this.getRequest().getCookies();
            if (cookies != null) {
                int i = 0;
                while (i < cookies.length) {
                    Cookie cookie = cookies[i];
                    if (cookie.getName().equals("igextranetuserid")) {
                        userName = cookie.getValue();
                    } else if (cookie.getName().equals("igextranetpassword")) {
                        password = cookie.getValue();
                    }
                    ++i;
                }
            }
            if (userName != null && password != null) {
                DesEncryptionHelper encHelper = new DesEncryptionHelper();
                userName = encHelper.decrypt(userName);
                password = encHelper.decrypt(password);
                HashMap<String, String> arguments = new HashMap<String, String>();
                arguments.put("j_username", userName);
                arguments.put("j_password", password);
                principal = ExtranetController.getController().getAuthenticatedPrincipal(arguments);
                if (principal != null) {
                    this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                    this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                    this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
                }
            }
        }
        return principal;
    }

    private Principal loginWithRequestArguments() throws Exception {
        Principal principal = null;
        String userName = this.getRequest().getParameter("j_username");
        String password = this.getRequest().getParameter("j_password");
        Object ticket = null;
        if (ticket != null) {
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            arguments.put("ticket", ticket);
            principal = ExtranetController.getController().getAuthenticatedPrincipal(arguments);
            if (principal != null) {
                this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
            }
        } else if (userName != null && password != null) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("j_username", userName);
            arguments.put("j_password", password);
            principal = ExtranetController.getController().getAuthenticatedPrincipal(arguments);
            if (principal != null) {
                this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
                this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
                this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
            }
        }
        return principal;
    }

    private SiteNodeTypeDefinitionVO getSiteNodeTypeDefinition(Integer siteNodeId, Database db) throws SystemException {
        String key = "" + siteNodeId;
        logger.info((Object)("key:" + key));
        SiteNodeTypeDefinitionVO siteNodeTypeDefinitionVO = (SiteNodeTypeDefinitionVO)CacheController.getCachedObject("pageCacheSiteNodeTypeDefinition", key);
        if (siteNodeTypeDefinitionVO != null) {
            logger.info((Object)("There was an cached siteNodeTypeDefinitionVO:" + siteNodeTypeDefinitionVO));
        } else {
            SiteNode siteNode = this.nodeDeliveryController.getSiteNode(db, this.siteNodeId);
            if (siteNode == null) {
                throw new SystemException("There was no page with this id.");
            }
            if (siteNode.getSiteNodeTypeDefinition() == null || siteNode.getSiteNodeTypeDefinition().getInvokerClassName() == null || siteNode.getSiteNodeTypeDefinition().getInvokerClassName().equals("")) {
                throw new SystemException("There was no page invoker class assigned to the site node " + siteNode.getName());
            }
            siteNodeTypeDefinitionVO = siteNode.getSiteNodeTypeDefinition().getValueObject();
            CacheController.cacheObject("pageCacheSiteNodeTypeDefinition", key, siteNodeTypeDefinitionVO);
        }
        return siteNodeTypeDefinitionVO;
    }

    private String getRedirectUrl(HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        String url = AuthenticationModule.getAuthenticationModule(null, this.getOriginalFullURL()).getLoginDialogUrl(request, response);
        String repositoryLoginUrl = RepositoryDeliveryController.getRepositoryDeliveryController().getExtraPropertyValue(this.repositoryId, "loginUrl");
        if (repositoryLoginUrl != null && !repositoryLoginUrl.equals("")) {
            String returnAddress = this.getOriginalFullURL();
            url = String.valueOf(repositoryLoginUrl) + (repositoryLoginUrl.indexOf("?") > -1 ? "&" : "?") + "returnAddress=" + URLEncoder.encode(returnAddress, "UTF-8");
        }
        return url;
    }

    private String getErrorUrl() throws Exception {
        String errorUrl = CmsPropertyHandler.getErrorUrl();
        String repositoryErrorUrl = RepositoryDeliveryController.getRepositoryDeliveryController().getExtraPropertyValue(this.repositoryId, "errorUrl");
        if (repositoryErrorUrl != null && !repositoryErrorUrl.equals("")) {
            errorUrl = repositoryErrorUrl;
        }
        return errorUrl;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public void setShowSimple(boolean showSimple) {
        this.showSimple = showSimple;
    }

    public void setRecacheCall(boolean isRecacheCall) {
        this.isRecacheCall = isRecacheCall;
    }

    public void setCmsUserName(String userName) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("userName:" + userName));
        }
        this.getHttpSession().setAttribute("cmsUserName", (Object)userName);
    }
}

