/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.actions;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.OSCacheUtility;
import com.opensymphony.oscache.web.ServletCache;
import com.opensymphony.oscache.web.ServletCacheAdministrator;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.pluto.PortletContainerServices;
import org.apache.pluto.portalImpl.services.ServiceManager;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistry;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ServerNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.WorkflowController;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.CmsSessionContextListener;
import org.infoglue.cms.util.sorters.AverageInvokingTimeComparator;
import org.infoglue.deliver.portal.ServletConfigContainer;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.RequestAnalyser;
import webwork.action.ActionContext;

public class ViewApplicationStateAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ViewApplicationStateAction.class.getName());
    private List states = new ArrayList();
    private Map applicationMap = new HashMap();
    private boolean databaseConnectionOk = false;
    private boolean applicationSettingsOk = false;
    private boolean testQueriesOk = false;
    private boolean diskPermissionOk = false;
    private String cacheName = "";
    private String className = "";
    private String logLevel = "";
    private String attributeName = "";
    private static VisualFormatter formatter = new VisualFormatter();

    private Category getDeliverCategory() {
        Enumeration enumeration = Logger.getCurrentCategories();
        while (enumeration.hasMoreElements()) {
            Category category = (Category)enumeration.nextElement();
            if (!category.getName().equalsIgnoreCase("org.infoglue.deliver")) continue;
            return category;
        }
        return null;
    }

    private Category getCastorJDOCategory() {
        Enumeration enumeration = Logger.getCurrentCategories();
        while (enumeration.hasMoreElements()) {
            Category category = (Category)enumeration.nextElement();
            if (!category.getName().equalsIgnoreCase("org.exolab.castor.jdo")) continue;
            return category;
        }
        return null;
    }

    private Category getCategory(String className) {
        Category category;
        Enumeration enumeration = Logger.getCurrentCategories();
        while (enumeration.hasMoreElements()) {
            category = (Category)enumeration.nextElement();
            if (!category.getName().equalsIgnoreCase(className)) continue;
            return category;
        }
        category = Category.getInstance((String)className);
        return category;
    }

    public String doClearCache() throws Exception {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doReCache."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        CacheController.clearCache(this.cacheName);
        return "cleared";
    }

    public String doClearCastorCache() throws Exception {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doReCache."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        CacheController.clearCache(Class.forName(this.className));
        return "cleared";
    }

    public String doClearApplicationCache() throws Exception {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doClearApplicationCache."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        if (this.attributeName != null && this.attributeName.equals("all")) {
            this.getApplicationAttributes();
            for (String attributeName : this.applicationMap.keySet()) {
                ActionContext.getServletContext().removeAttribute(attributeName);
            }
        } else if (this.attributeName != null) {
            ActionContext.getServletContext().removeAttribute(this.attributeName);
        }
        return "cleared";
    }

    public String doRestoreWorkflows() throws Exception {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doRestoreWorkflows."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        WorkflowController.restoreSessionFactory(null);
        return "cleared";
    }

    public String doDecreaseActiveCount() throws Exception {
        if (CmsPropertyHandler.getOperatingMode().equalsIgnoreCase("3")) {
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doRestoreWorkflows."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        RequestAnalyser.getRequestAnalyser().decNumberOfCurrentRequests(1000L);
        return "cleared";
    }

    public String doSetLogLevel() throws Exception {
        Level newLevel = Level.ERROR;
        if (this.logLevel.equalsIgnoreCase("debug")) {
            newLevel = Level.DEBUG;
        }
        if (this.logLevel.equalsIgnoreCase("info")) {
            newLevel = Level.INFO;
        } else if (this.logLevel.equalsIgnoreCase("warn")) {
            newLevel = Level.WARN;
        } else if (this.logLevel.equalsIgnoreCase("error")) {
            newLevel = Level.ERROR;
        }
        Category category = this.getCategory(this.className);
        if (category != null) {
            category.setLevel(newLevel);
            Enumeration enumeration = Logger.getLogger((String)"org.infoglue.console-debug-dummy").getAllAppenders();
            if (enumeration.hasMoreElements()) {
                Appender appender = (Appender)enumeration.nextElement();
                category.addAppender(appender);
            }
        }
        return "cleared";
    }

    public String doSetLogInfo() throws Exception {
        CastorDatabaseService.logger.setLevel(Level.INFO);
        CacheController.logger.setLevel(Level.INFO);
        this.getDeliverCategory().setLevel(Level.INFO);
        this.getCastorJDOCategory().setLevel(Level.INFO);
        return "cleared";
    }

    public String doSetLogWarning() throws Exception {
        CastorDatabaseService.logger.setLevel(Level.WARN);
        CacheController.logger.setLevel(Level.WARN);
        this.getDeliverCategory().setLevel(Level.WARN);
        this.getCastorJDOCategory().setLevel(Level.WARN);
        return "cleared";
    }

    public String doSetLogError() throws Exception {
        CastorDatabaseService.logger.setLevel(Level.ERROR);
        CacheController.logger.setLevel(Level.ERROR);
        this.getDeliverCategory().setLevel(Level.ERROR);
        this.getCastorJDOCategory().setLevel(Level.ERROR);
        return "cleared";
    }

    public String doClearCaches() throws Exception {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doReCache."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        CacheController.clearServerNodeProperty(true);
        CacheController.clearCastorCaches();
        CacheController.clearCaches(null, null, null);
        return "cleared";
    }

    public String doClearOSCaches() throws Exception {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doReCache."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        ServletCacheAdministrator servletCacheAdministrator = ServletCacheAdministrator.getInstance((ServletContext)ActionContext.getServletContext());
        servletCacheAdministrator.flushAll();
        Cache cache = servletCacheAdministrator.getAppScopeCache(ActionContext.getServletContext());
        OSCacheUtility.clear(cache);
        return "cleared";
    }

    public String doClearPortlets() throws Exception {
        try {
            String[] svcs = new String[]{"org.apache.pluto.portalImpl.services.portletdefinitionregistry.PortletDefinitionRegistryService", "org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistryService"};
            int len = svcs.length;
            int i = 0;
            while (i < len) {
                try {
                    ServiceManager.hotInit((ServletConfig)ServletConfigContainer.getContainer().getServletConfig(), (String)svcs[i]);
                }
                catch (Throwable e) {
                    String svc = svcs[i].substring(svcs[i].lastIndexOf(46) + 1);
                    String msg = "Initialization of " + svc + " service for hot deployment failed!";
                    logger.error((Object)msg);
                    break;
                }
                try {
                    logger.error((Object)("ServletConfigContainer.getContainer().getServletConfig():" + ServletConfigContainer.getContainer().getServletConfig()));
                    logger.error((Object)("ServletConfigContainer.getContainer().getServletConfig().getServletContext():" + ServletConfigContainer.getContainer().getServletConfig().getServletContext()));
                    logger.error((Object)("svcs[i]:" + svcs[i]));
                    ServiceManager.postHotInit((ServletConfig)ServletConfigContainer.getContainer().getServletConfig(), (String)svcs[i]);
                }
                catch (Throwable e) {
                    String svc = svcs[i].substring(svcs[i].lastIndexOf(46) + 1);
                    String msg = "Post initialization of " + svc + " service for hot deployment failed!";
                    logger.error((Object)msg);
                    break;
                }
                ++i;
            }
            PortletContainerServices.prepare((String)"infoglueAVote");
            ServiceManager.init((ServletConfig)ServletConfigContainer.getContainer().getServletConfig());
            PortletEntityRegistry.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "cleared";
    }

    public String doReCache() throws Exception {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doReCache."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        CacheController.cacheCentralCastorCaches();
        return "cleared";
    }

    private List getList(String key, Object value) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(key);
        list.add(value);
        return list;
    }

    public String doGC() throws Exception {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doReCache."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        Runtime.getRuntime().gc();
        return this.doExecute();
    }

    public String doResetComponentStatistics() throws Exception {
        logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doReCache."));
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        RequestAnalyser.resetComponentStatistics();
        return "cleared";
    }

    public String doExecute() throws Exception {
        long start = System.currentTimeMillis();
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doReCache."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        String sessionTimeout = CmsPropertyHandler.getSessionTimeout();
        if (sessionTimeout == null) {
            sessionTimeout = "1800";
        }
        this.states.add(this.getList("Application started", formatter.formatDate(CmsPropertyHandler.getStartupTime(), "yyyy-MM-dd HH:mm")));
        this.states.add(this.getList("Maximum memory (MB)", "" + Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        this.states.add(this.getList("Used memory (MB)", "" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L));
        this.states.add(this.getList("Free memory (MB)", "" + Runtime.getRuntime().freeMemory() / 1024L / 1024L));
        this.states.add(this.getList("Total memory (MB)", "" + Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        this.states.add(this.getList("Number of sessions <br/>(remains for " + Integer.parseInt(sessionTimeout) / 60 + " minutes after last request)", "" + CmsSessionContextListener.getActiveSessions()));
        this.states.add(this.getList("Number of request being handled now", "" + RequestAnalyser.getRequestAnalyser().getNumberOfCurrentRequests()));
        this.states.add(this.getList("Number of active request being handled now", "" + RequestAnalyser.getRequestAnalyser().getNumberOfActiveRequests()));
        this.states.add(this.getList("Total number of requests handled", "" + RequestAnalyser.getRequestAnalyser().getTotalNumberOfRequests()));
        this.states.add(this.getList("Average processing time per request (ms)", "" + RequestAnalyser.getRequestAnalyser().getAverageElapsedTime()));
        this.states.add(this.getList("Slowest request (ms)", "" + RequestAnalyser.getRequestAnalyser().getMaxElapsedTime()));
        this.states.add(this.getList("<br/><strong>Latest publications</strong>", "&nbsp;"));
        List publications = RequestAnalyser.getRequestAnalyser().getLatestPublications();
        for (Date publicationDate : publications) {
            this.states.add(this.getList("Date:", formatter.formatDate(publicationDate, "yyyy-MM-dd HH:mm:ss")));
        }
        this.states.add(this.getList("<br/><strong>Individual components (in milliseconds)</strong>", "&nbsp;"));
        ArrayList<List> unsortedComponents = new ArrayList<List>();
        Set componentNames = RequestAnalyser.getAllComponentNames();
        for (String componentName : componentNames) {
            long componentAverageElapsedTime = RequestAnalyser.getComponentAverageElapsedTime(componentName);
            int componentNumberOfHits = RequestAnalyser.getComponentNumberOfHits(componentName);
            unsortedComponents.add(this.getList(componentName + " - " + componentNumberOfHits + " hits", new Long(componentAverageElapsedTime)));
        }
        Collections.sort(unsortedComponents, new AverageInvokingTimeComparator());
        this.states.addAll(unsortedComponents);
        this.getApplicationAttributes();
        return "success";
    }

    private void getApplicationAttributes() {
        Enumeration attributesEnumeration = ActionContext.getServletContext().getAttributeNames();
        while (attributesEnumeration.hasMoreElements()) {
            String attributeName = (String)attributesEnumeration.nextElement();
            if (attributeName.indexOf("org.apache.catalina") != -1 || attributeName.indexOf("__oscache") != -1 || attributeName.indexOf("javax.servlet") != -1) continue;
            this.applicationMap.put(attributeName, ActionContext.getServletContext().getAttribute(attributeName).getClass().getName());
        }
    }

    public String doAsXML() throws Exception {
        this.doExecute();
        this.getResponse().setContentType("text/xml; charset=utf-8");
        return "successAsXML";
    }

    public boolean getIsApplicationSettingsOk() {
        return this.applicationSettingsOk;
    }

    public boolean getIsDatabaseConnectionOk() {
        return this.databaseConnectionOk;
    }

    public boolean getIsDiskPermissionOk() {
        return this.diskPermissionOk;
    }

    public boolean getIsTestQueriesOk() {
        return this.testQueriesOk;
    }

    public Map getCaches() {
        return CacheController.getCaches();
    }

    public ServletCache getOSCache() {
        ServletCacheAdministrator servletCacheAdministrator = ServletCacheAdministrator.getInstance((ServletContext)ActionContext.getServletContext());
        ServletCache applicationCache = (ServletCache)servletCacheAdministrator.getAppScopeCache(ActionContext.getServletContext());
        return applicationCache;
    }

    public Map getEventListeners() {
        return CacheController.getEventListeners();
    }

    public List getStates() {
        return this.states;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public List getSessionInfoBeanList() {
        return CmsSessionContextListener.getSessionInfoBeanList();
    }

    public String getServerName() {
        String serverName = "Unknown";
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            serverName = localhost.getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serverName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public Map getApplicationMap() {
        return this.applicationMap;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }
}

