/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ServerNodeController;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.databeans.CacheEvictionBean;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.ThreadMonitor;

public class UpdateCacheAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)UpdateCacheAction.class.getName());
    private String repositoryName = null;
    private Integer languageId = null;
    private Integer siteNodeId = null;
    private static boolean cachingInProgress = false;
    private ThreadMonitor tk = null;

    public String doTest() throws Exception {
        String operatingMode = CmsPropertyHandler.getOperatingMode();
        if (operatingMode != null && operatingMode.equalsIgnoreCase("3") && !ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doReCache."));
            this.getResponse().setContentType("text/plain");
            this.getResponse().setStatus(403);
            this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
            return "none";
        }
        this.getResponse().getWriter().println("test ok - cache action available");
        return "none";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doExecute() throws Exception {
        if (!CmsPropertyHandler.getOperatingMode().equals("3")) {
            this.tk = new ThreadMonitor(2000L, this.getRequest(), "Update cache took to long", false);
        }
        logger.info((Object)"Update Cache starts..");
        String operatingMode = CmsPropertyHandler.getOperatingMode();
        if (operatingMode != null && operatingMode.equalsIgnoreCase("3")) {
            long start = System.currentTimeMillis();
            if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
                logger.error((Object)("A user from an IP(" + this.getRequest().getRemoteAddr() + ") which is not allowed tried to call doReCache."));
                this.getResponse().setContentType("text/plain");
                this.getResponse().setStatus(403);
                this.getResponse().getWriter().println("You have no access to this view - talk to your administrator if you should.");
                return "none";
            }
        }
        try {
            CacheEvictionBean cacheEvictionBean;
            ArrayList<CacheEvictionBean> newNotificationList = new ArrayList<CacheEvictionBean>();
            int i = 0;
            String className = this.getRequest().getParameter(String.valueOf(i) + ".className");
            String typeId = this.getRequest().getParameter(String.valueOf(i) + ".typeId");
            String objectId = this.getRequest().getParameter(String.valueOf(i) + ".objectId");
            String objectName = this.getRequest().getParameter(String.valueOf(i) + ".objectName");
            while (className != null && !className.equals("")) {
                logger.info((Object)("className:" + className));
                logger.info((Object)("objectId:" + objectId));
                cacheEvictionBean = new CacheEvictionBean(className, typeId, objectId, objectName);
                newNotificationList.add(cacheEvictionBean);
                logger.info((Object)("Added a cacheEvictionBean " + cacheEvictionBean.getClassName() + ":" + cacheEvictionBean.getTypeId() + ":" + cacheEvictionBean.getObjectName() + ":" + cacheEvictionBean.getObjectId()));
                className = this.getRequest().getParameter(String.valueOf(++i) + ".className");
                typeId = this.getRequest().getParameter(String.valueOf(i) + ".typeId");
                objectId = this.getRequest().getParameter(String.valueOf(i) + ".objectId");
                objectName = this.getRequest().getParameter(String.valueOf(i) + ".objectName");
            }
            if (i == 0) {
                className = this.getRequest().getParameter("className");
                typeId = this.getRequest().getParameter("typeId");
                objectId = this.getRequest().getParameter("objectId");
                objectName = this.getRequest().getParameter("objectName");
                cacheEvictionBean = new CacheEvictionBean(className, typeId, objectId, objectName);
                newNotificationList.add(cacheEvictionBean);
            }
            List list = CacheController.notifications;
            synchronized (list) {
                CacheController.notifications.addAll(newNotificationList);
            }
            logger.info((Object)"UpdateCache finished...");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage());
        }
        logger.info((Object)"Update Cache stops..");
        if (this.tk != null) {
            this.tk.done();
        }
        return "none";
    }
}

