/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.actions;

import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.databeans.DatabaseWrapper;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.applications.inputhandlers.InfoGlueInputHandler;
import org.infoglue.deliver.controllers.kernel.impl.simple.ContentDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.ExtranetController;

public class InfoGlueDefaultInputHandlerAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)InfoGlueDefaultInputHandlerAction.class.getName());
    private Integer siteNodeId = null;
    private Integer languageId = null;
    private Integer contentId = null;
    private String redirectAddress = null;
    private Integer formContentId = null;

    public String doExecute() throws Exception {
        this.invokeHandler();
        this.getResponse().sendRedirect(this.redirectAddress);
        return "none";
    }

    protected void invokeHandler() throws Exception {
        DatabaseWrapper dbWrapper = new DatabaseWrapper(CastorDatabaseService.getDatabase());
        this.beginTransaction(dbWrapper.getDatabase());
        try {
            Principal principal = (Principal)this.getHttpSession().getAttribute("infogluePrincipal");
            if (principal == null) {
                try {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    arguments.put("j_username", CmsPropertyHandler.getAnonymousUser());
                    arguments.put("j_password", CmsPropertyHandler.getAnonymousPassword());
                    principal = ExtranetController.getController().getAuthenticatedPrincipal(dbWrapper.getDatabase(), arguments);
                }
                catch (Exception e) {
                    throw new SystemException("There was no anonymous user found in the system. There must be - add the user anonymous/anonymous and try again.", e);
                }
            }
            String inputHandlerClassName = ContentDeliveryController.getContentDeliveryController().getContentAttribute(dbWrapper.getDatabase(), this.formContentId, this.languageId, "InputHandlerClassName", this.siteNodeId, true, DeliveryContext.getDeliveryContext(), (InfoGluePrincipal)principal, false);
            logger.info((Object)("Trying to invoke " + inputHandlerClassName));
            Object object = Class.forName(inputHandlerClassName).newInstance();
            InfoGlueInputHandler infoGlueInputHandler = (InfoGlueInputHandler)object;
            HashMap parameters = this.requestToHashtable(this.getRequest());
            infoGlueInputHandler.processInput(dbWrapper, this.siteNodeId, this.languageId, this.contentId, this.formContentId, parameters, this.getRequest(), (InfoGluePrincipal)principal);
            this.closeTransaction(dbWrapper.getDatabase());
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(dbWrapper.getDatabase());
            throw new SystemException(e.getMessage());
        }
    }

    private HashMap requestToHashtable(HttpServletRequest req) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = req.getParameter(name);
            parameters.put(name, value);
        }
        return parameters;
    }

    public String getRedirectAddress() {
        return this.redirectAddress;
    }

    public void setRedirectAddress(String redirectAddress) {
        this.redirectAddress = redirectAddress;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public Integer getFormContentId() {
        return this.formContentId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public void setFormContentId(Integer formContentId) {
        this.formContentId = formContentId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }
}

