/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.actions;

import java.net.URLEncoder;
import java.security.Principal;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.security.AuthenticationModule;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.DesEncryptionHelper;
import org.infoglue.deliver.controllers.kernel.impl.simple.ExtranetController;
import org.infoglue.deliver.util.HttpUtilities;
import webwork.action.ActionContext;

public final class ExtranetLoginAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ExtranetLoginAction.class.getName());
    private String userName = null;
    private String password = null;
    private String errorMessage = "";
    private String returnAddress = null;
    private String referer = null;
    private String storeUserInfoCookie = null;

    public String doExecute() throws Exception {
        return "success";
    }

    public String doLoginForm() throws Exception {
        return "loginForm";
    }

    public String doNoAccess() throws Exception {
        return "noAccess";
    }

    public String doInvalidLogin() throws Exception {
        return "invalidLogin";
    }

    public String doCheckUser() throws Exception {
        Hashtable arguments = HttpUtilities.requestToHashtable(this.getRequest());
        if (ExtranetController.getController().getAuthenticatedPrincipal(arguments) != null) {
            return "granted";
        }
        return "denied";
    }

    public String doAuthenticateUser() throws Exception {
        boolean isAuthenticated = false;
        HttpServletRequest hreq = this.getRequest();
        HttpServletResponse hres = this.getResponse();
        Principal principal = null;
        try {
            Hashtable arguments = HttpUtilities.requestToHashtable(hreq);
            principal = ExtranetController.getController().getAuthenticatedPrincipal(arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (principal != null) {
            isAuthenticated = true;
        }
        if (!isAuthenticated) {
            this.errorMessage = "The logon information given was incorrect, please verify and try again.";
            return "invalidLogin";
        }
        this.getHttpSession().setAttribute("infogluePrincipal", (Object)principal);
        this.getHttpSession().setAttribute("infoglueRemoteUser", (Object)principal.getName());
        this.getHttpSession().setAttribute("cmsUserName", (Object)principal.getName());
        this.handleCookies();
        this.getResponse().sendRedirect(this.returnAddress);
        return "none";
    }

    public String doLogout() throws Exception {
        this.getHttpSession().invalidate();
        AuthenticationModule authenticationModule = AuthenticationModule.getAuthenticationModule(null, null);
        boolean redirected = authenticationModule.logoutUser(this.getRequest(), this.getResponse());
        if (redirected) {
            return "none";
        }
        this.getResponse().sendRedirect(this.returnAddress);
        return "none";
    }

    public String urlEncode(String string, String encoding) {
        String endodedString = string;
        try {
            endodedString = URLEncoder.encode(string, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return endodedString;
    }

    public boolean getEnableExtranetCookies() {
        boolean enableExtranetCookies = false;
        String enableExtranetCookiesString = CmsPropertyHandler.getEnableExtranetCookies();
        if (enableExtranetCookiesString != null && enableExtranetCookiesString.equalsIgnoreCase("true")) {
            enableExtranetCookies = true;
        }
        return enableExtranetCookies;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setJ_username(String userName) {
        this.userName = userName;
    }

    public String getJ_username() {
        return this.userName;
    }

    public void setJ_password(String password) {
        this.password = password;
    }

    public String getJ_password() {
        return this.password;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    private void handleCookies() {
        DesEncryptionHelper encHelper = new DesEncryptionHelper();
        String userName = this.getRequest().getParameter("j_username");
        String encryptedName = encHelper.encrypt(userName);
        String password = this.getRequest().getParameter("j_password");
        String encryptedPassword = encHelper.encrypt(password);
        try {
            String cmsBaseUrl = CmsPropertyHandler.getCmsFullBaseUrl();
            String[] parts = cmsBaseUrl.split("/");
            cmsBaseUrl = "/" + parts[parts.length - 1];
            ServletContext servletContext = ActionContext.getServletContext().getContext(cmsBaseUrl);
            if (servletContext == null) {
                logger.error((Object)"Could not autologin to CMS. Set cross context = true in Tomcat config.");
            } else {
                servletContext.setAttribute(encryptedName, (Object)userName);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error: " + e.getMessage()), (Throwable)e);
        }
        int cmsCookieTimeout = 1800;
        String cmsCookieTimeoutString = null;
        if (cmsCookieTimeoutString != null) {
            try {
                cmsCookieTimeout = Integer.parseInt(cmsCookieTimeoutString.trim());
            }
            catch (Exception servletContext) {
                // empty catch block
            }
        }
        Cookie cookie_iguserid = new Cookie("iguserid", encryptedName);
        cookie_iguserid.setPath("/");
        cookie_iguserid.setMaxAge(cmsCookieTimeout);
        this.getResponse().addCookie(cookie_iguserid);
        Cookie cookie_igpassword = new Cookie("igpassword", encryptedPassword);
        cookie_igpassword.setPath("/");
        cookie_igpassword.setMaxAge(cmsCookieTimeout);
        this.getResponse().addCookie(cookie_igpassword);
        if (this.storeUserInfoCookie == null || !this.storeUserInfoCookie.equalsIgnoreCase("true")) {
            return;
        }
        boolean enableExtranetCookies = this.getEnableExtranetCookies();
        int extranetCookieTimeout = 43200;
        String extranetCookieTimeoutString = CmsPropertyHandler.getExtranetCookieTimeout();
        if (extranetCookieTimeoutString != null) {
            try {
                extranetCookieTimeout = Integer.parseInt(extranetCookieTimeoutString.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (enableExtranetCookies) {
            Cookie cookie_userid = new Cookie("igextranetuserid", encryptedName);
            cookie_userid.setMaxAge(2592000);
            this.getResponse().addCookie(cookie_userid);
            Cookie cookie_password = new Cookie("igextranetpassword", encryptedPassword);
            cookie_password.setMaxAge(2592000);
            this.getResponse().addCookie(cookie_password);
        }
    }

    public void setStoreUserInfoCookie(String storeUserInfoCookie) {
        this.storeUserInfoCookie = storeUserInfoCookie;
    }
}

