/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.actions;

import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.controllers.kernel.impl.simple.RepositoryDeliveryController;
import org.infoglue.deliver.util.CacheController;

public class ErrorPageAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ErrorPageAction.class.getName());
    private int responseCode = 500;

    private String getErrorUrl(Integer repositoryId) throws Exception {
        String errorUrl = CmsPropertyHandler.getErrorUrl();
        String isErrorPage = this.getRequest().getParameter("isErrorPage");
        if (isErrorPage == null || isErrorPage.equals("")) {
            String repositoryErrorUrl = RepositoryDeliveryController.getRepositoryDeliveryController().getExtraPropertyValue(repositoryId, "errorUrl");
            if (repositoryErrorUrl != null && !repositoryErrorUrl.equals("")) {
                errorUrl = repositoryErrorUrl;
            }
            if (errorUrl != null) {
                errorUrl = String.valueOf(errorUrl) + (errorUrl.indexOf("?") > -1 ? "&" : "?") + "isErrorPage=true";
            }
        }
        return errorUrl;
    }

    private List getRepositoryId(HttpServletRequest request) throws ServletException, SystemException, Exception {
        String serverName = request.getServerName();
        String portNumber = new Integer(request.getServerPort()).toString();
        String repositoryName = request.getParameter("repositoryName");
        String repCacheKey = serverName + "_" + portNumber + "_" + repositoryName;
        List repositoryVOList = (List)CacheController.getCachedObject("NavigationCache", repCacheKey);
        if (repositoryVOList != null) {
            return repositoryVOList;
        }
        List repositories = RepositoryDeliveryController.getRepositoryDeliveryController().getRepositoryVOListFromServerName(serverName, portNumber, repositoryName);
        CacheController.cacheObject("NavigationCache", repCacheKey, repositories);
        return repositories;
    }

    public String doExecute() throws Exception {
        String errorUrl;
        block15: {
            try {
                RepositoryVO repositoryVO;
                String localErrorUrl;
                String responseCodeParameter;
                String responseCodeAttribute = (String)this.getRequest().getAttribute("responseCode");
                if (responseCodeAttribute != null) {
                    this.responseCode = Integer.parseInt(responseCodeAttribute);
                }
                if ((responseCodeParameter = this.getRequest().getParameter("responseCode")) != null) {
                    this.responseCode = Integer.parseInt(responseCodeParameter);
                }
                String requestURI = String.valueOf(this.getRequest().getServerName()) + this.getRequest().getRequestURI();
                String errorUrlAttribute = (String)this.getRequest().getAttribute("errorUrl");
                String errorUrlParameter = this.getRequest().getParameter("errorUrl");
                Exception e = (Exception)this.getRequest().getAttribute("error");
                if (e != null) {
                    this.setError(e, e.getCause());
                }
                this.getResponse().setContentType("text/html; charset=UTF-8");
                this.getResponse().setStatus(this.responseCode);
                errorUrl = CmsPropertyHandler.getErrorUrl();
                if (errorUrlAttribute != null && !errorUrlAttribute.equals("")) {
                    errorUrl = errorUrlAttribute;
                } else if (errorUrlParameter != null && !errorUrlParameter.equals("")) {
                    errorUrl = errorUrlParameter;
                }
                List repositoryVOList = this.getRepositoryId(this.getRequest());
                if (repositoryVOList != null && repositoryVOList.size() > 0 && (localErrorUrl = this.getErrorUrl((repositoryVO = (RepositoryVO)repositoryVOList.get(0)).getId())) != null) {
                    errorUrl = localErrorUrl;
                }
                if (errorUrl == null || errorUrl.indexOf("@errorUrl@") > -1) {
                    logger.error((Object)("No valid error url was defined:" + errorUrl + ". You should fix this. Defaulting to /error.jsp"));
                    errorUrl = "/error.jsp";
                }
                if (errorUrl == null || errorUrl.indexOf("@errorUrl@") != -1) break block15;
                if (errorUrl.indexOf("http") > -1) {
                    this.getResponse().sendRedirect(errorUrl);
                } else {
                    try {
                        RequestDispatcher dispatch = this.getRequest().getRequestDispatcher(errorUrl);
                        this.getRequest().setAttribute("error", (Object)e);
                        dispatch.include((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        return "success";
                    }
                }
                return "none";
            }
            catch (Throwable t) {
                t.printStackTrace();
                return "success";
            }
        }
        logger.error((Object)("No valid error url was defined:" + errorUrl + ". You should fix this."));
        return "success";
    }

    public String doBusy() throws Exception {
        Exception e;
        String responseCodeParameter;
        String responseCodeAttribute = (String)this.getRequest().getAttribute("responseCode");
        if (responseCodeAttribute != null) {
            this.responseCode = Integer.parseInt(responseCodeAttribute);
        }
        if ((responseCodeParameter = this.getRequest().getParameter("responseCode")) != null) {
            this.responseCode = Integer.parseInt(responseCodeParameter);
        }
        if ((e = (Exception)this.getRequest().getAttribute("error")) != null) {
            this.setError(e, e.getCause());
        }
        this.getResponse().setContentType("text/html; charset=UTF-8");
        this.getResponse().setStatus(this.responseCode);
        String errorUrl = CmsPropertyHandler.getErrorBusyUrl();
        if (errorUrl != null && errorUrl.indexOf("@errorBusyUrl@") == -1) {
            if (errorUrl.indexOf("http") > -1) {
                this.getResponse().sendRedirect(errorUrl);
            } else {
                RequestDispatcher dispatch = this.getRequest().getRequestDispatcher(errorUrl);
                this.getRequest().setAttribute("error", (Object)e);
                dispatch.include((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
            }
            return "none";
        }
        return "success";
    }

    public int getResponseCode() {
        return this.responseCode;
    }
}

