/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.actions;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Principal;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServerNodeController;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.impl.simple.ContentDeliveryController;

public class DownloadAssetAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)DownloadAssetAction.class.getName());
    private Integer digitalAssetId;
    private Integer siteNodeId;
    private Integer contentId;
    private Integer languageId;
    private String assetKey;
    private DigitalAssetVO digitalAssetVO;
    private String assetFilePath = "";

    public String doExecute() throws Exception {
        HttpServletResponse response = this.getResponse();
        if (this.digitalAssetId != null && !ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the download action. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        this.getAssetInformation();
        if (this.assetFilePath != null && this.digitalAssetVO != null) {
            response.setContentType(this.digitalAssetVO.getAssetContentType());
            ServletOutputStream out = response.getOutputStream();
            InputStream in = null;
            try {
                int ch;
                in = new BufferedInputStream(new FileInputStream(this.assetFilePath));
                while ((ch = in.read()) != -1) {
                    out.print((char)ch);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            return "none";
        }
        response.sendError(302);
        return "none";
    }

    private void getAssetInformation() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Getting asset information....");
        }
        if (this.digitalAssetId != null) {
            this.digitalAssetVO = DigitalAssetController.getDigitalAssetVOWithId(this.digitalAssetId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("this.digitalAssetVO:" + this.digitalAssetVO));
            }
            if (this.digitalAssetVO != null) {
                this.assetFilePath = DigitalAssetController.getDigitalAssetFilePath(this.digitalAssetVO.getId());
            }
        } else if (CmsPropertyHandler.getApplicationName().equalsIgnoreCase("cms")) {
            if (logger.isDebugEnabled()) {
                logger.info((Object)("contentId:" + this.contentId));
                logger.info((Object)("languageId:" + this.languageId));
                logger.info((Object)("assetKey:" + this.assetKey));
            }
            this.digitalAssetVO = DigitalAssetController.getDigitalAssetVO(this.contentId, this.languageId, this.assetKey, true);
            if (this.digitalAssetVO != null) {
                this.assetFilePath = DigitalAssetController.getDigitalAssetProtectedFilePath(this.digitalAssetVO.getId());
            }
        } else {
            ContentDeliveryController cdc = ContentDeliveryController.getContentDeliveryController();
            Database db = CastorDatabaseService.getDatabase();
            try {
                Integer digitalAssetId;
                db.begin();
                DeliveryContext deliveryContext = DeliveryContext.getDeliveryContext();
                logger.info((Object)("principal:" + this.getInfoGluePrincipal()));
                Principal principal = this.getInfoGluePrincipal();
                if (principal == null) {
                    principal = this.getAnonymousPrincipal();
                }
                if ((digitalAssetId = cdc.getDigitalAssetId(db, this.contentId, this.languageId, this.assetKey, this.siteNodeId, true, deliveryContext, (InfoGluePrincipal)principal)) != null) {
                    this.digitalAssetVO = DigitalAssetController.getSmallDigitalAssetVOWithId(digitalAssetId, db);
                    if (this.digitalAssetVO != null) {
                        this.assetFilePath = DigitalAssetController.getDigitalAssetProtectedFilePath(digitalAssetId);
                    }
                }
                this.commitTransaction(db);
            }
            catch (Exception e) {
                logger.error((Object)("Problem getting asset url:" + e.getMessage()), (Throwable)e);
                this.rollbackTransaction(db);
            }
        }
    }

    public String getAssetKey() {
        return this.assetKey;
    }

    public void setAssetKey(String assetKey) {
        this.assetKey = assetKey;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public Integer getDigitalAssetId() {
        return this.digitalAssetId;
    }

    public void setDigitalAssetId(Integer digitalAssetId) {
        this.digitalAssetId = digitalAssetId;
    }
}

