/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.applications.actions;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.PortletAssetController;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.portal.deploy.Deploy;
import org.infoglue.deliver.util.CacheController;

public class DeployPortletAction
extends InfoGlueAbstractAction {
    private static final Log log = LogFactory.getLog(DeployPortletAction.class);
    private static final String PORTLET_BASE = CmsPropertyHandler.getPortletBase();
    private Integer digitalAssetId;

    protected String doExecute() throws Exception {
        log.debug((Object)("Deploying portlet, digitalAssetId=" + this.digitalAssetId));
        Database db = CastorDatabaseService.getDatabase();
        try {
            db.begin();
            DigitalAsset da = PortletAssetController.getDigitalAssetWithId(this.digitalAssetId, db);
            if (da == null) {
                return "error";
            }
            try {
                String webappsDir = PORTLET_BASE;
                if (webappsDir == null || webappsDir.length() == 0) {
                    String tomcat_home = System.getProperty("CATALINA_HOME");
                    if (tomcat_home == null) {
                        tomcat_home = System.getProperty("TOMCAT_HOME");
                    }
                    if (tomcat_home != null) {
                        webappsDir = new File(tomcat_home, "webapps").getAbsolutePath();
                    }
                }
                String containerName = (String)this.getRequest().getAttribute("portal_container_name");
                String warName = da.getAssetFileName();
                log.info((Object)("Deploying portlet " + warName + " at " + webappsDir));
                InputStream is = da.getAssetBlob();
                boolean deployed = Deploy.deployArchive(webappsDir, warName, is, containerName);
                is.close();
                if (deployed) {
                    log.debug((Object)"Successful portlet deployment!");
                } else {
                    log.debug((Object)"Portlet already deployed!");
                }
                CacheController.clearPortlets();
            }
            catch (Exception e) {
                log.error((Object)("An error occurred when deployin portlet:" + e.getMessage()), (Throwable)e);
            }
        }
        finally {
            try {
                db.commit();
                db.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "success";
    }

    public Integer getDigitalAssetId() {
        return this.digitalAssetId;
    }

    public void setDigitalAssetId(Integer integer) {
        this.digitalAssetId = integer;
    }
}

