/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.common.settings.controllers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.entities.management.InfoGlueProperty;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.common.settings.controllers.CastorSettingsPersister;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;

public class CastorSettingsController {
    private DOMBuilder domBuilder = new DOMBuilder();
    private CastorSettingsPersister settingsPersister = null;

    public static CastorSettingsController getController(CastorSettingsPersister labelsPersister) {
        return new CastorSettingsController(labelsPersister);
    }

    private CastorSettingsController(CastorSettingsPersister settingsPersister) {
        this.settingsPersister = settingsPersister;
    }

    public List getSystemSettings(String bundleName) {
        ArrayList<String> labels = new ArrayList<String>();
        Properties properties = CmsPropertyHandler.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            labels.add(key);
        }
        Collections.sort(labels);
        return labels;
    }

    public List getSettingsVariations(String nameSpace, String name, Database database) throws Exception {
        ArrayList<String> locales = new ArrayList<String>();
        Document document = this.getPropertyDocument(nameSpace, name, database);
        if (document != null) {
            List languageNodes = document.selectNodes("/variations/variation");
            for (Node node : languageNodes) {
                Element element = (Element)node;
                String id = element.attributeValue("id");
                locales.add(id);
            }
        }
        return locales;
    }

    public Document getPropertyDocument(String nameSpace, String name, Database database) throws Exception {
        String key = "propertyDocument_" + nameSpace + "_" + name;
        Object object = CacheController.getCachedObject("serverNodePropertiesDocumentCache", key);
        if (object instanceof NullObject) {
            return null;
        }
        Document document = (Document)object;
        if (document == null) {
            InfoGlueProperty property = this.settingsPersister.getProperty(nameSpace, name, database);
            if (property != null) {
                String xml = property.getValue();
                if (xml != null && xml.length() > 0) {
                    try {
                        document = this.domBuilder.getDocument(xml);
                    }
                    catch (Exception e) {
                        document = this.domBuilder.createDocument();
                        Element variationsElement = this.domBuilder.addElement(document, "variations");
                        Element languageElement = this.domBuilder.addElement(variationsElement, "variation");
                        this.domBuilder.addAttribute(languageElement, "id", "default");
                        Element element = this.domBuilder.addElement(languageElement, "setting");
                    }
                }
            } else {
                document = this.domBuilder.createDocument();
                Element variationsElement = this.domBuilder.addElement(document, "variations");
                Element languageElement = this.domBuilder.addElement(variationsElement, "variation");
                this.domBuilder.addAttribute(languageElement, "id", "default");
                Element labelsElement = this.domBuilder.addElement(languageElement, "setting");
                String xml = this.domBuilder.getFormattedDocument(document, "UTF-8");
                this.settingsPersister.createProperty(nameSpace, name, xml, database);
                document = this.domBuilder.getDocument(xml);
            }
            if (document != null) {
                CacheController.cacheObject("serverNodePropertiesDocumentCache", key, document);
            } else {
                CacheController.cacheObject("serverNodePropertiesDocumentCache", key, new NullObject());
            }
        }
        return document;
    }

    public void addVariation(String nameSpace, String name, String id, Database database) throws Exception {
        Document document;
        Element variationElement;
        if (id == null || id.equals("-1")) {
            id = "default";
        }
        if ((variationElement = (Element)(document = this.getPropertyDocument(nameSpace, name, database)).selectSingleNode("/variations/variation[@id='" + id + "']")) == null) {
            Element variationsElement = (Element)document.selectSingleNode("/variations");
            Element languageElement = this.domBuilder.addElement(variationsElement, "variation");
            this.domBuilder.addAttribute(languageElement, "id", id);
            Element labelsElement = this.domBuilder.addElement(languageElement, "setting");
            String xml = this.domBuilder.getFormattedDocument(document, "UTF-8");
            this.settingsPersister.updateProperty(nameSpace, name, xml, database);
            CacheController.clearCache("serverNodePropertiesCache");
            CacheController.clearCache("serverNodePropertiesDocumentCache");
        }
    }

    public void removeVariation(String nameSpace, String name, String id, Database database) throws Exception {
        Document document;
        Element variationsElement;
        if (id == null || id.equals("-1")) {
            id = "default";
        }
        if ((variationsElement = (Element)(document = this.getPropertyDocument(nameSpace, name, database)).selectSingleNode("/variations/variation[@id='" + id + "']")) != null) {
            variationsElement.getParent().remove(variationsElement);
            String xml = this.domBuilder.getFormattedDocument(document, "UTF-8");
            this.settingsPersister.updateProperty(nameSpace, name, xml, database);
            CacheController.clearCache("serverNodePropertiesCache");
            CacheController.clearCache("serverNodePropertiesDocumentCache");
        }
    }

    public void removeProperty(String nameSpace, String name, String id, String key, Database database) throws Exception {
        Document document;
        Element settingElement;
        if (id == null || id.equals("-1")) {
            id = "default";
        }
        if ((settingElement = (Element)(document = this.getPropertyDocument(nameSpace, name, database)).selectSingleNode("/variations/variation[@id='" + id + "']/setting/" + key)) != null) {
            settingElement.getParent().remove(settingElement);
            String xml = this.domBuilder.getFormattedDocument(document, "UTF-8");
            this.settingsPersister.updateProperty(nameSpace, name, xml, database);
            CacheController.clearCache("serverNodePropertiesCache");
            CacheController.clearCache("serverNodePropertiesDocumentCache");
        }
    }

    public void updateSettings(String nameSpace, String name, String id, Map properties, Database database) throws Exception {
        if (id == null || id.equals("-1")) {
            id = "default";
        }
        Document document = this.getPropertyDocument(nameSpace, name, database);
        String xpath = "/variations/variation[@id='" + id + "']/setting";
        Element labelsElement = (Element)document.selectSingleNode(xpath);
        for (String key : properties.keySet()) {
            String value = (String)properties.get(key);
            if (!Character.isLetter(key.charAt(0))) {
                key = "NP" + key;
            }
            if (key == null || value == null || labelsElement == null) continue;
            Element labelElement = labelsElement.element(key);
            if (labelElement == null) {
                labelElement = this.domBuilder.addElement(labelsElement, key);
            } else {
                labelElement.clearContent();
                List elements = labelElement.elements();
                for (Element element : elements) {
                    labelElement.remove(element);
                }
            }
            this.domBuilder.addCDATAElement(labelElement, value);
        }
        String xml = this.domBuilder.getFormattedDocument(document, "UTF-8");
        this.settingsPersister.updateProperty(nameSpace, name, xml, database);
        CacheController.clearCache("serverNodePropertiesCache");
        CacheController.clearCache("serverNodePropertiesDocumentCache");
    }

    public String getSetting(String nameSpace, String name, String key, String id, Database database) throws Exception {
        String setting = null;
        if (id == null || id.equals("-1")) {
            id = "default";
        }
        if (key != null && !key.equals("")) {
            Document document;
            if (!Character.isLetter(key.charAt(0))) {
                key = "NP" + key;
            }
            if ((document = this.getPropertyDocument(nameSpace, name, database)) != null) {
                String xpath;
                Element labelElement;
                if (id == null) {
                    id = "default";
                }
                if ((labelElement = (Element)document.selectSingleNode(xpath = "/variations/variation[@id='" + id + "']/setting/" + key)) != null) {
                    setting = labelElement.getText();
                }
            }
        }
        return setting;
    }
}

