/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.workflow.taglib;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.workflow.taglib.Element;
import org.infoglue.cms.workflow.taglib.ElementTag;

public class LanguageSelector
extends ElementTag {
    private static final long serialVersionUID = 7831749037593672903L;
    private List<LanguageVO> languageVOList = new ArrayList<LanguageVO>();
    private String selected;

    public int doEndTag() throws JspException {
        this.createOptions();
        this.languageVOList.clear();
        this.selected = null;
        return super.doEndTag();
    }

    private void createOptions() {
        try {
            List languages = LanguageController.getController().getLanguageVOList();
            for (LanguageVO languageVO : languages) {
                String name = languageVO.getName();
                String value = languageVO.getId().toString();
                this.getElement().addChild("option").addText(name).addAttribute("value", value).addAttribute("selected", "selected", value != null && this.selected != null && value.equals(this.selected));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Element createElement() {
        return new Element("select");
    }

    public void setDefaultLabel(String label) {
        this.getElement().addChildFirst("option").addText(label);
    }

    public void setName(String name) {
        this.getElement().addAttribute("name", name);
        this.selected = this.getPropertySet().getDataString(name);
    }
}

