/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.workflow.taglib;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class Element {
    private static final String ATTRIBUTE = "{0}=\"{1}\"";
    private static final String CHILDREN_AND_ATTRIBUTES = "<{0} {1}>{2}</{0}>";
    private static final String CHILDREN_AND_NO_ATTRIBUTES = "<{0}>{1}</{0}>";
    private static final String NO_CHILDREN_NO_ATTRIBUTES = "<{0}></{0}>";
    private static final String NO_CHILDREN_AND_ATTRIBUTES = "<{0} {1}></{0}>";
    private final String name;
    private Element parent;
    private final Map attributes = new HashMap();
    private final List children = new ArrayList();

    public Element(String name) {
        this(null, name);
    }

    public Element(Element parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public Element addAttribute(String name, String value) {
        return this.addAttribute(name, value, true);
    }

    public Element addAttribute(String name, String value, boolean condition) {
        if (condition && value != null) {
            Object o = this.attributes.get(name);
            if (o != null && o instanceof String) {
                value = o + " " + value;
            }
            this.attributes.put(name, value);
        }
        return this;
    }

    public Element addChild(String name) {
        Element child = new Element(this, name);
        this.children.add(child);
        return child;
    }

    public Element addChildFirst(String name) {
        Element child = new Element(this, name);
        this.children.add(0, child);
        return child;
    }

    public Element addChild(Element child) {
        if (child != null) {
            child.parent = this;
            this.children.add(child);
        }
        return this;
    }

    public Element addText(String text) {
        if (text != null && text.length() > 0) {
            this.children.add(text);
        }
        return this;
    }

    public boolean hasAttribute(String name) {
        return name != null && this.attributes.containsKey(name);
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Element pop() {
        return this.parent;
    }

    public String toString() {
        if (this.hasAttributes() && this.hasChildren()) {
            return MessageFormat.format(CHILDREN_AND_ATTRIBUTES, this.name, this.attributesString(), this.childrenString());
        }
        if (this.hasAttributes() && !this.hasChildren()) {
            return MessageFormat.format(NO_CHILDREN_AND_ATTRIBUTES, this.name, this.attributesString());
        }
        if (!this.hasAttributes() && this.hasChildren()) {
            return MessageFormat.format(CHILDREN_AND_NO_ATTRIBUTES, this.name, this.childrenString());
        }
        return MessageFormat.format(NO_CHILDREN_NO_ATTRIBUTES, this.name);
    }

    private String attributesString() {
        StringBuffer sb = new StringBuffer();
        for (Object key : this.attributes.keySet()) {
            Object value = this.attributes.get(key);
            sb.append(String.valueOf(sb.length() > 0 ? " " : "") + MessageFormat.format(ATTRIBUTE, key, value));
        }
        return sb.toString();
    }

    private String childrenString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
        }
        return sb.toString();
    }
}

