/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.workflow.taglib;

import javax.servlet.jsp.JspException;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.workflow.taglib.ElementTag;

public abstract class ContentBooleanFieldTag
extends ElementTag {
    private String value;
    private String checked;
    private boolean languageDependent = true;
    private String languageCode = null;

    public int doEndTag() throws JspException {
        this.getElement().addAttribute("checked", "checked", this.isChecked());
        this.value = null;
        this.checked = null;
        return super.doEndTag();
    }

    public void setLanguageDependent(boolean languageDependent) {
        this.languageDependent = languageDependent;
    }

    private boolean isChecked() {
        return this.value != null && this.checked != null && this.value.equals(this.checked);
    }

    public void setName(String name) {
        if (this.languageDependent) {
            try {
                LanguageVO languageVO;
                String languageIdString = this.getPropertySet().getString("languageId");
                if (languageIdString != null && (languageVO = LanguageController.getController().getLanguageVOWithId(new Integer(languageIdString))) != null) {
                    this.languageCode = languageVO.getLanguageCode();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getElement().addAttribute("name", name);
        if (this.languageCode == null || this.languageCode.equals("")) {
            this.checked = this.getPropertySet().getDataString(name);
        } else {
            this.checked = this.getPropertySet().getDataString(String.valueOf(this.languageCode) + "_" + name);
            if (this.checked == null || this.checked.equals("")) {
                this.checked = this.getPropertySet().getDataString(name);
            }
        }
    }

    public void setValue(String value) {
        this.getElement().addAttribute("value", value);
        this.value = value;
    }
}

