/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.workflow.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.workflow.taglib.Element;
import org.infoglue.cms.workflow.taglib.ElementTag;

public class CategorySelector
extends ElementTag {
    private static final long serialVersionUID = 7831749037593672903L;
    private CategoryVO rootCategoryVO;
    private String selected;

    public int doEndTag() throws JspException {
        this.createOptions();
        this.rootCategoryVO = null;
        this.selected = null;
        return super.doEndTag();
    }

    private void createOptions() {
        for (CategoryVO categoryVO : this.rootCategoryVO.getChildren()) {
            String name = categoryVO.getName();
            String value = categoryVO.getId().toString();
            this.getElement().addChild("option").addText(name).addAttribute("value", value).addAttribute("selected", "selected", value != null && this.selected != null && value.equals(this.selected));
        }
    }

    protected Element createElement() {
        return new Element("select");
    }

    public void setDefaultLabel(String label) {
        this.getElement().addChildFirst("option").addText(label);
    }

    public void setCategoryPath(String path) throws JspException {
        this.rootCategoryVO = this.getRootCategory(path);
    }

    public void setName(String name) {
        this.getElement().addAttribute("name", name);
        this.selected = this.getPropertySet().getDataString(name);
    }

    private CategoryVO getRootCategory(String path) throws JspException {
        try {
            CategoryVO categoryVO = CategoryController.getController().findByPath(path);
            if (categoryVO != null) {
                return CategoryController.getController().findWithChildren(categoryVO.getId());
            }
            throw new Exception("No category with path " + path + " was found.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JspTagException(e.getMessage());
        }
    }
}

