/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.webservices;

import com.opensymphony.workflow.WorkflowException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.WorkflowController;
import org.infoglue.cms.entities.mydesktop.WorkflowVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.webservices.RemoteInfoGlueService;
import org.infoglue.deliver.util.webservices.DynamicWebserviceSerializer;

public class RemoteWorkflowServiceImpl
extends RemoteInfoGlueService {
    private static final Logger logger = Logger.getLogger((String)RemoteWorkflowServiceImpl.class.getName());
    private InfoGluePrincipal principal;
    private Map inputs;

    public Boolean start(String principalName, Integer languageId, String workflowName, Object[] inputsArray, Object[] ppp) {
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            this.initializePrincipal(principalName, workflowName);
            this.initializeInputs((Map)serializer.deserialize(inputsArray), languageId);
            logger.debug((Object)("start(" + principalName + "," + workflowName + "," + languageId + "," + this.inputs + ")"));
            WorkflowVO workflowVO = WorkflowController.getController().initializeWorkflow(this.principal, workflowName, 0, this.inputs);
            if (this.hasTerminated(workflowVO)) {
                logger.debug((Object)"The workflow has terminated.");
                return Boolean.FALSE;
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Error:" + t.getMessage()), t);
            return Boolean.FALSE;
        }
        this.updateCaches();
        return Boolean.TRUE;
    }

    public Boolean invokeAction(String principalName, Integer languageId, Long workflowId, Integer actionId, Object[] inputsArray, Object[] ppp) {
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            this.initializeInputs((Map)serializer.deserialize(inputsArray), languageId);
            logger.debug((Object)("start(" + principalName + "," + workflowId + "," + actionId + "," + languageId + "," + this.inputs + ")"));
            WorkflowVO workflowVO = WorkflowController.getController().invokeAction(this.principal, workflowId, actionId, this.inputs);
            if (this.hasTerminated(workflowVO)) {
                logger.debug((Object)"The workflow has terminated.");
                return Boolean.FALSE;
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Error:" + t.getMessage()), t);
            return Boolean.FALSE;
        }
        this.updateCaches();
        return Boolean.TRUE;
    }

    private boolean hasTerminated(WorkflowVO workflowVO) throws WorkflowException {
        return WorkflowController.getController().hasTerminated(this.principal, workflowVO.getIdAsPrimitive());
    }

    private void initializeInputs(Map callerInputs, Integer languageId) throws SystemException {
        this.inputs = callerInputs;
        this.inputs.put("principal", this.principal);
        this.inputs.put("locale", LanguageController.getController().getLocaleWithId(languageId));
    }

    private void initializePrincipal(String userName, String workflowName) throws SystemException {
        try {
            this.principal = UserControllerProxy.getController().getUser(userName);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        if (this.principal == null) {
            throw new SystemException("No such principal [" + userName + "].");
        }
        if (!WorkflowController.getController().getIsAccessApproved(workflowName, this.principal)) {
            throw new SystemException("The principal [" + userName + "] is not allowed to create the [" + workflowName + "] workflow.");
        }
    }
}

