/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.webservices;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ServerNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.webservices.RemoteInfoGlueService;
import org.infoglue.common.security.beans.InfoGlueGroupBean;
import org.infoglue.common.security.beans.InfoGluePrincipalBean;
import org.infoglue.common.security.beans.InfoGlueRoleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteUserServiceImpl
extends RemoteInfoGlueService {
    private static final Logger logger = Logger.getLogger((String)RemoteUserServiceImpl.class.getName());
    private InfoGluePrincipal principal;
    private static UserControllerProxy userControllerProxy = UserControllerProxy.getController();

    public Boolean createUser(String principalName, String firstName, String lastName, String email, String userName, String password, List roleNames, List groupNames) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        logger.info((Object)"***************************************");
        logger.info((Object)"Creating user through webservice.......");
        logger.info((Object)"***************************************");
        try {
            this.initializePrincipal(principalName);
            SystemUserVO systemUserVO = new SystemUserVO();
            systemUserVO.setFirstName(firstName);
            systemUserVO.setLastName(lastName);
            systemUserVO.setEmail(email);
            systemUserVO.setUserName(userName);
            systemUserVO.setPassword(password);
            Object[] roleNamesArray = roleNames.toArray();
            Object[] groupNamesArray = groupNames.toArray();
            String[] roles = new String[roleNamesArray.length];
            String[] groups = new String[groupNamesArray.length];
            int i = 0;
            while (i < roleNamesArray.length) {
                roles[i] = "" + roleNamesArray[i];
                ++i;
            }
            i = 0;
            while (i < groupNamesArray.length) {
                groups[i] = "" + groupNamesArray[i];
                ++i;
            }
            userControllerProxy.createUser(systemUserVO);
            userControllerProxy.updateUser(systemUserVO, roles, groups);
        }
        catch (Exception e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to create a new contentVersion:" + e.getMessage()), (Throwable)e);
        }
        this.updateCaches();
        return status;
    }

    public Boolean updateUser(String principalName, SystemUserVO systemUserVO, String[] roleNames, String[] groupNames) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        logger.info((Object)"***************************************");
        logger.info((Object)"Updating user through webservice.......");
        logger.info((Object)"***************************************");
        try {
            this.initializePrincipal(principalName);
            userControllerProxy.updateUser(systemUserVO, roleNames, groupNames);
        }
        catch (Exception e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to create a new contentVersion:" + e.getMessage()), (Throwable)e);
        }
        this.updateCaches();
        return status;
    }

    public Boolean deleteUser(String principalName, SystemUserVO systemUserVO) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        logger.info((Object)"***************************************");
        logger.info((Object)"Delete user through webservice.........");
        logger.info((Object)"***************************************");
        try {
            this.initializePrincipal(principalName);
            userControllerProxy.deleteUser(systemUserVO.getUserName());
        }
        catch (Exception e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to create a new contentVersion:" + e.getMessage()), (Throwable)e);
        }
        this.updateCaches();
        return status;
    }

    public List<InfoGlueRoleBean> getRoles() {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        ArrayList<InfoGlueRoleBean> roles = new ArrayList<InfoGlueRoleBean>();
        logger.info((Object)"***************************************");
        logger.info((Object)"Getting all roles through webservice...");
        logger.info((Object)"***************************************");
        try {
            List rolesList = RoleControllerProxy.getController().getAllRoles();
            for (InfoGlueRole role : rolesList) {
                InfoGlueRoleBean bean = new InfoGlueRoleBean();
                bean.setName(role.getName());
                bean.setDisplayName(role.getDisplayName());
                bean.setDescription(role.getDescription());
                roles.add(bean);
            }
        }
        catch (Exception e) {
            logger.error((Object)("En error occurred when we tried to create a new contentVersion:" + e.getMessage()), (Throwable)e);
        }
        return roles;
    }

    public List<InfoGlueGroupBean> getGroups() {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        ArrayList<InfoGlueGroupBean> groups = new ArrayList<InfoGlueGroupBean>();
        logger.info((Object)"***************************************");
        logger.info((Object)"Getting all groups through webservice..");
        logger.info((Object)"***************************************");
        try {
            List groupsList = GroupControllerProxy.getController().getAllGroups();
            for (InfoGlueGroup group : groupsList) {
                InfoGlueGroupBean bean = new InfoGlueGroupBean();
                bean.setName(group.getName());
                bean.setDisplayName(group.getDisplayName());
                bean.setDescription(group.getDescription());
                groups.add(bean);
            }
        }
        catch (Exception e) {
            logger.error((Object)("En error occurred when we tried to create a new contentVersion:" + e.getMessage()), (Throwable)e);
        }
        return groups;
    }

    public InfoGluePrincipalBean getPrincipal(String userName) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        InfoGluePrincipalBean bean = null;
        logger.info((Object)"***************************************");
        logger.info((Object)"Getting all principals through webservice..");
        logger.info((Object)"***************************************");
        try {
            InfoGluePrincipal principal = UserControllerProxy.getController().getUser(userName);
            bean = new InfoGluePrincipalBean();
            bean.setName(principal.getName());
            bean.setDisplayName(principal.getDisplayName());
            bean.setEmail(principal.getEmail());
            bean.setFirstName(principal.getFirstName());
            bean.setLastName(principal.getLastName());
            bean.setAdministrator(false);
            bean.setMetaInformation(principal.getMetaInformation());
            ArrayList<InfoGlueGroupBean> groups = new ArrayList<InfoGlueGroupBean>();
            for (InfoGlueGroup group : principal.getGroups()) {
                InfoGlueGroupBean groupBean = new InfoGlueGroupBean();
                groupBean.setName(group.getName());
                groupBean.setDisplayName(group.getDisplayName());
                groupBean.setDescription(group.getDescription());
                groups.add(groupBean);
            }
            bean.setGroups(groups);
            ArrayList<InfoGlueRoleBean> roles = new ArrayList<InfoGlueRoleBean>();
            for (InfoGlueRole role : principal.getRoles()) {
                InfoGlueRoleBean roleBean = new InfoGlueRoleBean();
                roleBean.setName(role.getName());
                roleBean.setDisplayName(role.getDisplayName());
                roleBean.setDescription(role.getDescription());
                roles.add(roleBean);
            }
            bean.setRoles(roles);
        }
        catch (Exception e) {
            logger.error((Object)("En error occurred when we tried to create a new contentVersion:" + e.getMessage()), (Throwable)e);
        }
        return bean;
    }

    public List<InfoGluePrincipalBean> getPrincipals() {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        ArrayList<InfoGluePrincipalBean> users = new ArrayList<InfoGluePrincipalBean>();
        logger.info((Object)"***************************************");
        logger.info((Object)"Getting all principals through webservice..");
        logger.info((Object)"***************************************");
        try {
            List principalList = UserControllerProxy.getController().getAllUsers();
            for (InfoGluePrincipal principal : principalList) {
                InfoGluePrincipalBean bean = new InfoGluePrincipalBean();
                bean.setName(principal.getName());
                bean.setDisplayName(principal.getDisplayName());
                bean.setEmail(principal.getEmail());
                bean.setFirstName(principal.getFirstName());
                bean.setLastName(principal.getLastName());
                bean.setAdministrator(false);
                bean.setMetaInformation(principal.getMetaInformation());
                ArrayList<InfoGlueGroupBean> groups = new ArrayList<InfoGlueGroupBean>();
                for (InfoGlueGroup group : principal.getGroups()) {
                    InfoGlueGroupBean groupBean = new InfoGlueGroupBean();
                    groupBean.setName(group.getName());
                    groupBean.setDisplayName(group.getDisplayName());
                    groupBean.setDescription(group.getDescription());
                    groups.add(groupBean);
                }
                bean.setGroups(groups);
                ArrayList<InfoGlueRoleBean> roles = new ArrayList<InfoGlueRoleBean>();
                for (InfoGlueRole role : principal.getRoles()) {
                    InfoGlueRoleBean roleBean = new InfoGlueRoleBean();
                    roleBean.setName(role.getName());
                    roleBean.setDisplayName(role.getDisplayName());
                    roleBean.setDescription(role.getDescription());
                    roles.add(roleBean);
                }
                bean.setRoles(roles);
                users.add(bean);
            }
        }
        catch (Exception e) {
            logger.error((Object)("En error occurred when we tried to create a new contentVersion:" + e.getMessage()), (Throwable)e);
        }
        return users;
    }

    public List<InfoGluePrincipalBean> getPrincipalsWithRole(String roleName) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        ArrayList<InfoGluePrincipalBean> users = new ArrayList<InfoGluePrincipalBean>();
        logger.info((Object)"***************************************");
        logger.info((Object)"Getting all principals through webservice..");
        logger.info((Object)"***************************************");
        try {
            List principalList = RoleControllerProxy.getController().getInfoGluePrincipals(roleName);
            for (InfoGluePrincipal principal : principalList) {
                InfoGluePrincipalBean bean = new InfoGluePrincipalBean();
                bean.setName(principal.getName());
                bean.setDisplayName(principal.getDisplayName());
                bean.setEmail(principal.getEmail());
                bean.setFirstName(principal.getFirstName());
                bean.setLastName(principal.getLastName());
                bean.setAdministrator(false);
                bean.setMetaInformation(principal.getMetaInformation());
                ArrayList<InfoGlueGroupBean> groups = new ArrayList<InfoGlueGroupBean>();
                for (InfoGlueGroup group : principal.getGroups()) {
                    InfoGlueGroupBean groupBean = new InfoGlueGroupBean();
                    groupBean.setName(group.getName());
                    groupBean.setDisplayName(group.getDisplayName());
                    groupBean.setDescription(group.getDescription());
                    groups.add(groupBean);
                }
                bean.setGroups(groups);
                ArrayList<InfoGlueRoleBean> roles = new ArrayList<InfoGlueRoleBean>();
                for (InfoGlueRole role : principal.getRoles()) {
                    InfoGlueRoleBean roleBean = new InfoGlueRoleBean();
                    roleBean.setName(role.getName());
                    roleBean.setDisplayName(role.getDisplayName());
                    roleBean.setDescription(role.getDescription());
                    roles.add(roleBean);
                }
                bean.setRoles(roles);
                users.add(bean);
            }
        }
        catch (Exception e) {
            logger.error((Object)("En error occurred when we tried to create a new contentVersion:" + e.getMessage()), (Throwable)e);
        }
        return users;
    }

    public List<InfoGluePrincipalBean> getPrincipalsWithGroup(String groupName) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        ArrayList<InfoGluePrincipalBean> users = new ArrayList<InfoGluePrincipalBean>();
        logger.info((Object)"***************************************");
        logger.info((Object)"Getting all principals through webservice..");
        logger.info((Object)"***************************************");
        try {
            List principalList = GroupControllerProxy.getController().getInfoGluePrincipals(groupName);
            for (InfoGluePrincipal principal : principalList) {
                InfoGluePrincipalBean bean = new InfoGluePrincipalBean();
                bean.setName(principal.getName());
                bean.setDisplayName(principal.getDisplayName());
                bean.setEmail(principal.getEmail());
                bean.setFirstName(principal.getFirstName());
                bean.setLastName(principal.getLastName());
                bean.setAdministrator(false);
                bean.setMetaInformation(principal.getMetaInformation());
                ArrayList<InfoGlueGroupBean> groups = new ArrayList<InfoGlueGroupBean>();
                for (InfoGlueGroup group : principal.getGroups()) {
                    InfoGlueGroupBean groupBean = new InfoGlueGroupBean();
                    groupBean.setName(group.getName());
                    groupBean.setDisplayName(group.getDisplayName());
                    groupBean.setDescription(group.getDescription());
                    groups.add(groupBean);
                }
                bean.setGroups(groups);
                ArrayList<InfoGlueRoleBean> roles = new ArrayList<InfoGlueRoleBean>();
                for (InfoGlueRole role : principal.getRoles()) {
                    InfoGlueRoleBean roleBean = new InfoGlueRoleBean();
                    roleBean.setName(role.getName());
                    roleBean.setDisplayName(role.getDisplayName());
                    roleBean.setDescription(role.getDescription());
                    roles.add(roleBean);
                }
                bean.setRoles(roles);
                users.add(bean);
            }
        }
        catch (Exception e) {
            logger.error((Object)("En error occurred when we tried to create a new contentVersion:" + e.getMessage()), (Throwable)e);
        }
        return users;
    }

    private void initializePrincipal(String userName) throws SystemException {
        try {
            this.principal = UserControllerProxy.getController().getUser(userName);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        if (this.principal == null) {
            throw new SystemException("No such principal [" + userName + "].");
        }
    }
}

