/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.webservices;

import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServerNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.management.UserPropertiesVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.cms.webservices.RemoteInfoGlueService;
import org.infoglue.deliver.util.webservices.DynamicWebserviceSerializer;

public class RemoteUserPropertiesServiceImpl
extends RemoteInfoGlueService {
    private static final Logger logger = Logger.getLogger((String)RemoteUserPropertiesServiceImpl.class.getName());
    private InfoGluePrincipal principal;
    private static UserPropertiesController userPropertiesController = UserPropertiesController.getController();

    public int updateUserProperties(String principalName, UserPropertiesVO userPropertiesVO) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return -1;
        }
        int newUserPropertiesId = 0;
        logger.info((Object)"***********************************************");
        logger.info((Object)"Creating user properties through webservice....");
        logger.info((Object)"***********************************************");
        try {
            this.initializePrincipal(principalName);
            UserPropertiesVO newUserPropertiesVO = userPropertiesController.update(userPropertiesVO.getLanguageId(), userPropertiesVO.getContentTypeDefinitionId(), userPropertiesVO);
            newUserPropertiesId = newUserPropertiesVO.getId();
        }
        catch (Exception e) {
            logger.error((Object)("En error occurred when we tried to create a new userProperty:" + e.getMessage()), (Throwable)e);
        }
        this.updateCaches();
        return newUserPropertiesId;
    }

    public Boolean updateUserProperties(String principalName, int languageId, int contentTypeDefinitionId, Object[] inputsArray) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        int newUserPropertiesId = 0;
        logger.info((Object)"***********************************************");
        logger.info((Object)"Creating user properties through webservice....");
        logger.info((Object)"***********************************************");
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map userPropertiesAttributesMap = (Map)serializer.deserialize(inputsArray);
            this.initializePrincipal(principalName);
            logger.info((Object)("principalName:" + principalName));
            logger.info((Object)("principal:" + this.principal));
            logger.info((Object)("languageId:" + languageId));
            logger.info((Object)("contentTypeDefinitionId:" + contentTypeDefinitionId));
            UserPropertiesVO userPropertiesVO = new UserPropertiesVO();
            userPropertiesVO.setUserName(this.principal.getName());
            logger.info((Object)("userPropertiesAttributesMap:" + userPropertiesAttributesMap.size()));
            DOMBuilder domBuilder = new DOMBuilder();
            Document document = domBuilder.createDocument();
            Element rootElement = domBuilder.addElement(document, "article");
            Element attributesRoot = domBuilder.addElement(rootElement, "attributes");
            for (String attributeName : userPropertiesAttributesMap.keySet()) {
                String attributeValue = (String)userPropertiesAttributesMap.get(attributeName);
                logger.info((Object)(String.valueOf(attributeName) + "=" + attributeValue));
                Element attribute = domBuilder.addElement(attributesRoot, attributeName);
                domBuilder.addCDATAElement(attribute, attributeValue);
            }
            userPropertiesVO.setValue(document.asXML());
            UserPropertiesVO newUserPropertiesVO = userPropertiesController.update(new Integer(languageId), new Integer(contentTypeDefinitionId), userPropertiesVO);
            newUserPropertiesId = newUserPropertiesVO.getId();
        }
        catch (Throwable e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to create a new userProperty:" + e.getMessage()), e);
        }
        this.updateCaches();
        return status;
    }

    public Boolean deleteDigitalAsset(String principalName, Object[] inputsArray) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        logger.info((Object)"****************************************");
        logger.info((Object)"Updating content through webservice....");
        logger.info((Object)"****************************************");
        logger.info((Object)("principalName:" + principalName));
        logger.info((Object)("inputsArray:" + inputsArray));
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map digitalAsset = (Map)serializer.deserialize(inputsArray);
            logger.info((Object)("digitalAsset:" + digitalAsset));
            this.initializePrincipal(principalName);
            Integer contentVersionId = (Integer)digitalAsset.get("contentVersionId");
            Integer contentId = (Integer)digitalAsset.get("contentId");
            Integer languageId = (Integer)digitalAsset.get("languageId");
            String assetKey = (String)digitalAsset.get("assetKey");
            logger.info((Object)("contentVersionId:" + contentVersionId));
            logger.info((Object)("contentId:" + contentId));
            logger.info((Object)("languageId:" + languageId));
            logger.info((Object)("assetKey:" + assetKey));
            ContentVersionController.getContentVersionController().deleteDigitalAsset(contentId, languageId, assetKey);
            logger.info((Object)"Done with contents..");
        }
        catch (Throwable e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to delete a digitalAsset:" + e.getMessage()), e);
        }
        this.updateCaches();
        return status;
    }

    private void initializePrincipal(String userName) throws SystemException {
        try {
            this.principal = UserControllerProxy.getController().getUser(userName);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        if (this.principal == null) {
            throw new SystemException("No such principal [" + userName + "].");
        }
    }
}

