/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.webservices;

import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ChangeNotificationController;

public class RemoteInfoGlueService {
    private static final Logger logger = Logger.getLogger((String)RemoteInfoGlueService.class.getName());

    public void updateCaches() {
        try {
            ChangeNotificationController.notifyListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected HttpServletRequest getRequest() {
        HttpServletRequest request = (HttpServletRequest)MessageContext.getCurrentContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        return request;
    }

    public String cleanAttributeValue(String attributeValue, boolean allowHTML, boolean allowExternalLinks) {
        if (!allowExternalLinks) {
            attributeValue = attributeValue.replaceAll("http://", "");
            attributeValue = attributeValue.replaceAll("https://", "");
            attributeValue = attributeValue.replaceAll("ftp://", "");
        }
        attributeValue = attributeValue.replaceAll("\\$", "");
        attributeValue = attributeValue.replaceAll("#", "");
        attributeValue = !allowHTML ? attributeValue.replaceAll("</*[^>]+>", "") : attributeValue.replaceAll("<%/*[^%>]+%>", "");
        attributeValue = attributeValue.replaceAll("templateLogic.getPageUrl", "\\$templateLogic.getPageUrl");
        attributeValue = attributeValue.replaceAll("templateLogic.getInlineAssetUrl", "\\$templateLogic.getInlineAssetUrl");
        return attributeValue;
    }

    protected static Database beginTransaction() throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        RemoteInfoGlueService.beginTransaction(db);
        return db;
    }

    protected static void beginTransaction(Database db) throws SystemException {
        try {
            db.begin();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to begin an transaction. Reason:" + e.getMessage(), e);
        }
    }

    protected static void commitTransaction(Database db) throws SystemException {
        try {
            db.commit();
            db.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to commit an transaction. Reason:" + e.getMessage(), e);
        }
    }

    protected static void rollbackTransaction(Database db) throws SystemException {
        try {
            if (db != null && db.isActive()) {
                db.rollback();
                db.close();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when we tried to rollback an transaction. Reason:" + e.getMessage()));
        }
    }

    protected static void closeDatabase(Database db) throws SystemException {
        try {
            if (db != null) {
                db.close();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when we tried to rollback an transaction. Reason:" + e.getMessage()));
        }
    }
}

