/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.webservices;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.FormEntryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServerNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.FormEntry;
import org.infoglue.cms.entities.management.FormEntryVO;
import org.infoglue.cms.entities.management.FormEntryValueVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.webservices.RemoteInfoGlueService;
import org.infoglue.deliver.util.webservices.DynamicWebserviceSerializer;

public class RemoteFormServiceImpl
extends RemoteInfoGlueService {
    private static final Logger logger = Logger.getLogger((String)RemoteFormServiceImpl.class.getName());
    private InfoGluePrincipal principal;
    private static FormEntryController formEntryController = FormEntryController.getController();

    public Boolean createFormEntry(String principalName, Object[] inputsArray) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        ArrayList newSiteNodeIdList = new ArrayList();
        logger.error((Object)"****************************************");
        logger.error((Object)"Creating gorm entry through webservice....");
        logger.error((Object)"****************************************");
        logger.error((Object)("principalName:" + principalName));
        logger.error((Object)("inputsArray:" + inputsArray));
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            List formEntries = (List)serializer.deserialize(inputsArray);
            logger.info((Object)("formEntries:" + formEntries));
            this.initializePrincipal(principalName);
            for (Map formEntry : formEntries) {
                String formName = (String)formEntry.get("formName");
                Integer formContentId = (Integer)formEntry.get("formContentId");
                String originAddress = (String)formEntry.get("originAddress");
                String userIP = (String)formEntry.get("userIP");
                String userAgent = (String)formEntry.get("userAgent");
                Map formEntryValues = (Map)formEntry.get("formEntryValues");
                logger.info((Object)("formName:" + formName));
                logger.info((Object)("formContentId:" + formContentId));
                logger.info((Object)("originAddress:" + originAddress));
                logger.info((Object)("userIP:" + userIP));
                logger.info((Object)("userAgent:" + userAgent));
                logger.info((Object)("formEntryValues:" + formEntryValues));
                ArrayList<FormEntryValueVO> formEntryValueVOList = new ArrayList<FormEntryValueVO>();
                for (String name : formEntryValues.keySet()) {
                    String value = (String)formEntryValues.get(name);
                    FormEntryValueVO formEntryValueVO = new FormEntryValueVO();
                    formEntryValueVO.setName(name);
                    formEntryValueVO.setValue(value);
                    formEntryValueVOList.add(formEntryValueVO);
                }
                FormEntryVO formEntryVO = new FormEntryVO();
                formEntryVO.setFormContentId(formContentId);
                formEntryVO.setFormName(formName);
                formEntryVO.setOriginAddress(originAddress);
                formEntryVO.setUserAgent(userAgent);
                formEntryVO.setUserIP(userIP);
                Database db = CastorDatabaseService.getDatabase();
                ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
                RemoteFormServiceImpl.beginTransaction(db);
                try {
                    FormEntry newFormEntry = formEntryController.create(formEntryVO, formEntryValueVOList, db);
                    RemoteFormServiceImpl.commitTransaction(db);
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
                    RemoteFormServiceImpl.rollbackTransaction(db);
                    throw new SystemException(e.getMessage());
                }
            }
            logger.info((Object)"Done with site nodes..");
        }
        catch (Throwable e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to create a new siteNode:" + e.getMessage()), e);
        }
        this.updateCaches();
        return status;
    }

    private void initializePrincipal(String userName) throws SystemException {
        try {
            this.principal = UserControllerProxy.getController().getUser(userName);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        if (this.principal == null) {
            throw new SystemException("No such principal [" + userName + "].");
        }
    }
}

