/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.webservices;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServerNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.WorkflowDefinitionController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.workflow.WorkflowDefinitionVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.webservices.RemoteInfoGlueService;
import org.infoglue.deliver.util.webservices.DynamicWebserviceSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDeploymentServiceImpl
extends RemoteInfoGlueService {
    private static final Logger logger = Logger.getLogger((String)RemoteDeploymentServiceImpl.class.getName());
    private InfoGluePrincipal principal;
    private static ContentTypeDefinitionController contentTypeDefinitionController = ContentTypeDefinitionController.getController();
    private static WorkflowDefinitionController workflowDefinitionController = WorkflowDefinitionController.getController();
    private static CategoryController categoryController = CategoryController.getController();
    private static ContentControllerProxy contentControllerProxy = ContentControllerProxy.getController();

    public List<ContentTypeDefinitionVO> getContentTypeDefinitions(String principalName) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"******************************************************");
            logger.info((Object)"* Getting content type definition through webservice *");
            logger.info((Object)"******************************************************");
        }
        ArrayList<ContentTypeDefinitionVO> contentTypeDefinitionVOList = new ArrayList();
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("principalName:" + principalName));
            }
            contentTypeDefinitionVOList = contentTypeDefinitionController.getContentTypeDefinitionVOList();
        }
        catch (Throwable t) {
            logger.error((Object)("En error occurred when we tried to get the contentVersionVO:" + t.getMessage()), t);
        }
        return contentTypeDefinitionVOList;
    }

    public Boolean updateContentTypeDefinitions(String principalName, Object[] input) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"*******************************************************");
            logger.info((Object)"* Updating content type definition through webservice *");
            logger.info((Object)"*******************************************************");
        }
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map arguments = (Map)serializer.deserialize(input);
            logger.info((Object)("arguments:" + arguments));
            if (logger.isInfoEnabled()) {
                logger.info((Object)("principalName:" + principalName));
            }
            List remoteContentTypeDefinitionVOList = (List)arguments.get("contentTypeDefinitionVOList");
            List missingContentTypeNameArray = (List)arguments.get("missingContentTypeNameArray");
            List deviatingContentTypeNameArray = (List)arguments.get("deviatingContentTypeNameArray");
            logger.info((Object)("remoteContentTypeDefinitionVOList:" + remoteContentTypeDefinitionVOList));
            logger.info((Object)("missingContentTypeNameArray:" + missingContentTypeNameArray));
            logger.info((Object)("deviatingContentTypeNameArray:" + deviatingContentTypeNameArray));
            if (missingContentTypeNameArray != null) {
                for (String missingContentTypeName : missingContentTypeNameArray) {
                    logger.info((Object)("Updating missingContentTypeName:" + missingContentTypeName));
                    for (ContentTypeDefinitionVO remoteContentTypeDefinitionVO : remoteContentTypeDefinitionVOList) {
                        if (!remoteContentTypeDefinitionVO.getName().equals(missingContentTypeName)) continue;
                        logger.info((Object)("Creating remoteContentTypeDefinitionVO:" + remoteContentTypeDefinitionVO.getName()));
                        ContentTypeDefinitionController.getController().create(remoteContentTypeDefinitionVO);
                    }
                }
            }
            if (deviatingContentTypeNameArray != null) {
                for (String deviatingContentTypeName : deviatingContentTypeNameArray) {
                    Map deviationArguments = (Map)arguments.get("deviationArguments_" + deviatingContentTypeName);
                    logger.info((Object)("deviationArguments:" + deviationArguments));
                    for (ContentTypeDefinitionVO remoteContentTypeDefinitionVO : remoteContentTypeDefinitionVOList) {
                        if (!remoteContentTypeDefinitionVO.getName().equals(deviatingContentTypeName)) continue;
                        ContentTypeDefinitionVO localContentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName(remoteContentTypeDefinitionVO.getName());
                        String newSchemaValue = localContentTypeDefinitionVO.getSchemaValue();
                        newSchemaValue = remoteContentTypeDefinitionVO.getSchemaValue();
                        localContentTypeDefinitionVO.setSchemaValue(newSchemaValue);
                        logger.info((Object)("Updating localContentTypeDefinitionVO:" + localContentTypeDefinitionVO.getName()));
                        ContentTypeDefinitionController.getController().update(localContentTypeDefinitionVO);
                    }
                }
            }
        }
        catch (Throwable t) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to get the contentVersionVO:" + t.getMessage()), t);
        }
        this.updateCaches();
        return status;
    }

    public Boolean updateCategories(String principalName, Object[] input) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"*******************************************************");
            logger.info((Object)"*       Updating categories through webservice        *");
            logger.info((Object)"*******************************************************");
        }
        try {
            logger.info((Object)("input:" + input));
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map arguments = (Map)serializer.deserialize(input);
            logger.info((Object)("arguments:" + arguments));
            List remoteCategoryVOList = (List)arguments.get("categoryVOList");
            Map requestMap = (Map)arguments.get("requestMap");
            logger.info((Object)("remoteCategoryVOList:" + remoteCategoryVOList));
            if (logger.isInfoEnabled()) {
                logger.info((Object)("principalName:" + principalName));
            }
            List allLocalCategories = CategoryController.getController().findAllActiveCategories();
            HashMap handledRemoteCategoryPaths = new HashMap();
            categoryController.compareAndCompleteCategoryLists(remoteCategoryVOList, allLocalCategories, null, handledRemoteCategoryPaths, requestMap);
        }
        catch (Throwable t) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to update categories:" + t.getMessage()), t);
        }
        this.updateCaches();
        return status;
    }

    public Boolean updateWorkflows(String principalName, Object[] input) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"*******************************************************");
            logger.info((Object)"*       Updating categories through webservice        *");
            logger.info((Object)"*******************************************************");
        }
        try {
            logger.info((Object)("input:" + input));
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map arguments = (Map)serializer.deserialize(input);
            logger.info((Object)("arguments:" + arguments));
            List remoteWorkflowDefinitionVOList = (List)arguments.get("workflowDefinitionVOList");
            Map requestMap = (Map)arguments.get("requestMap");
            logger.info((Object)("remoteWorkflowDefinitionVOList:" + remoteWorkflowDefinitionVOList));
            if (logger.isInfoEnabled()) {
                logger.info((Object)("principalName:" + principalName));
            }
            for (WorkflowDefinitionVO remoteWorkflowDefinitionVO : remoteWorkflowDefinitionVOList) {
                WorkflowDefinitionVO localWorkflowDefinitionVO = WorkflowDefinitionController.getController().getWorkflowDefinitionVOWithName(remoteWorkflowDefinitionVO.getName());
                if (localWorkflowDefinitionVO == null) {
                    WorkflowDefinitionController.getController().create(remoteWorkflowDefinitionVO);
                    continue;
                }
                WorkflowDefinitionController.getController().update(remoteWorkflowDefinitionVO);
            }
        }
        catch (Throwable t) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to update categories:" + t.getMessage()), t);
        }
        this.updateCaches();
        return status;
    }

    public Boolean updateComponents(String principalName, Object[] input) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"*******************************************************");
            logger.info((Object)"*       Updating components through webservice        *");
            logger.info((Object)"*******************************************************");
        }
        try {
            LanguageVO languageVO;
            logger.info((Object)("input:" + input));
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map arguments = (Map)serializer.deserialize(input);
            logger.info((Object)("arguments:" + arguments));
            List components = ContentController.getContentController().getContentVOWithContentTypeDefinition("HTMLTemplate");
            ContentTypeDefinitionVO contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName("HTMLTemplate");
            if (logger.isInfoEnabled()) {
                logger.info((Object)("principalName:" + principalName));
            }
            InfoGluePrincipal principal = UserControllerProxy.getController().getUser(principalName);
            List missingRemoteComponents = (List)arguments.get("missingComponents");
            logger.info((Object)("missingRemoteComponents:" + missingRemoteComponents));
            for (ContentVO missingRemoteContentVO : missingRemoteComponents) {
                if (missingRemoteContentVO != null) {
                    missingRemoteContentVO.setIsBranch(Boolean.FALSE);
                }
                logger.info((Object)("missingRemoteContentVO:" + missingRemoteContentVO + ":" + missingRemoteContentVO.getFullPath()));
                String fullPath = missingRemoteContentVO.getFullPath();
                logger.info((Object)("fullPath:" + fullPath));
                int siteNodeEnd = fullPath.indexOf(" - /");
                String repositoryString = fullPath.substring(0, siteNodeEnd);
                String restString = fullPath.substring(siteNodeEnd + 4);
                restString = restString.substring(0, restString.lastIndexOf("/"));
                restString = restString.indexOf("/") > -1 ? restString.substring(restString.indexOf("/") + 1) : "";
                logger.info((Object)("repositoryString:" + repositoryString));
                logger.info((Object)("restString:" + restString));
                try {
                    RepositoryVO repositoryVO = RepositoryController.getController().getRepositoryVOWithName(repositoryString);
                    logger.info((Object)("repositoryVO:" + repositoryVO));
                    if (repositoryVO == null) continue;
                    languageVO = LanguageController.getController().getMasterLanguage(repositoryVO.getRepositoryId());
                    ContentVO parentContent = ContentController.getContentController().getContentVOWithPath(repositoryVO.getId(), restString, true, principal);
                    logger.info((Object)("parentContent:" + parentContent));
                    ContentVO newContentVO = ContentController.getContentController().create(parentContent.getId(), contentTypeDefinitionVO.getContentTypeDefinitionId(), parentContent.getRepositoryId(), missingRemoteContentVO);
                    logger.info((Object)("Now we want to create the version also on:" + newContentVO.getName()));
                    ContentVersionVO contentVersionVO = new ContentVersionVO();
                    contentVersionVO.setVersionComment("deployment");
                    contentVersionVO.setVersionModifier(principal.getName());
                    if (missingRemoteContentVO.getVersions() == null || missingRemoteContentVO.getVersions().length <= 0) continue;
                    contentVersionVO.setVersionValue(missingRemoteContentVO.getVersions()[0]);
                    ContentVersionController.getContentVersionController().create(newContentVO.getId(), languageVO.getId(), contentVersionVO, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            List remoteComponents = (List)arguments.get("deviatingComponents");
            logger.info((Object)("remoteComponents:" + remoteComponents));
            for (ContentVO remoteContentVO : remoteComponents) {
                logger.info((Object)("remoteContentVO:" + remoteContentVO + ":" + remoteContentVO.getFullPath()));
                for (ContentVO contentVO : components) {
                    String fullPath = ContentController.getContentController().getContentPath(contentVO.getId(), true, true);
                    logger.info((Object)("fullPath:" + fullPath));
                    if (!fullPath.equalsIgnoreCase(remoteContentVO.getFullPath())) continue;
                    languageVO = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId());
                    ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), languageVO.getId());
                    if (contentVersionVO == null || remoteContentVO.getVersions() == null || remoteContentVO.getVersions().length <= 0) continue;
                    contentVersionVO.setVersionValue(remoteContentVO.getVersions()[0]);
                    logger.info((Object)("Updating :" + contentVersionVO.getContentName() + " with new latest versionValue:" + remoteContentVO.getVersions()[0].length()));
                    ContentVersionController.getContentVersionController().update(contentVersionVO.getId(), contentVersionVO);
                }
            }
        }
        catch (Throwable t) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to update categories:" + t.getMessage()), t);
        }
        this.updateCaches();
        return status;
    }

    public List<WorkflowDefinitionVO> getWorkflowDefinitions(String principalName) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"******************************************************");
            logger.info((Object)"*   Getting workflow definitions through webservice  *");
            logger.info((Object)"******************************************************");
        }
        ArrayList<WorkflowDefinitionVO> workflowDefinitionVOList = new ArrayList();
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("principalName:" + principalName));
            }
            workflowDefinitionVOList = workflowDefinitionController.getWorkflowDefinitionVOList();
        }
        catch (Throwable t) {
            logger.error((Object)("En error occurred when we tried to get the contentVersionVO:" + t.getMessage()), t);
        }
        return workflowDefinitionVOList;
    }

    public List<CategoryVO> getAllActiveCategories(String principalName) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"******************************************");
            logger.info((Object)"*   Getting categies through webservice  *");
            logger.info((Object)"******************************************");
        }
        ArrayList<CategoryVO> categoryVOList = new ArrayList();
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("principalName:" + principalName));
            }
            categoryVOList = categoryController.findAllActiveCategories(true);
        }
        catch (Throwable t) {
            logger.error((Object)("En error occurred when we tried to get the contentVersionVO:" + t.getMessage()), t);
        }
        return categoryVOList;
    }

    public List<ContentVO> getComponents(String principalName) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"******************************************************");
            logger.info((Object)"*        Getting components through webservice       *");
            logger.info((Object)"******************************************************");
        }
        List<ContentVO> contentVOList = new ArrayList();
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("principalName:" + principalName));
            }
            contentVOList = contentControllerProxy.getContentVOWithContentTypeDefinition("HTMLTemplate");
            Iterator contentVOListIterator = contentVOList.iterator();
            while (contentVOListIterator.hasNext()) {
                ContentVO contentVO = (ContentVO)contentVOListIterator.next();
                LanguageVO languageVO = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId());
                String fullPath = ContentController.getContentController().getContentPath(contentVO.getId(), true, true);
                ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), languageVO.getId());
                if (contentVersionVO != null) {
                    contentVO.setContentVersion(contentVersionVO);
                    contentVO.setVersions(new String[]{contentVersionVO.getVersionValue()});
                } else {
                    contentVOListIterator.remove();
                }
                contentVO.setFullPath(fullPath);
            }
        }
        catch (Throwable t) {
            logger.error((Object)("En error occurred when we tried to get the contents:" + t.getMessage()), t);
        }
        return contentVOList;
    }

    private void initializePrincipal(String userName) throws SystemException {
        try {
            this.principal = UserControllerProxy.getController().getUser(userName);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        if (this.principal == null) {
            throw new SystemException("No such principal [" + userName + "].");
        }
    }
}

