/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.webservices;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentCategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentStateController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.EventController;
import org.infoglue.cms.controllers.kernel.impl.simple.PublicationController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServerNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.Category;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.publishing.PublicationVO;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.cms.webservices.RemoteInfoGlueService;
import org.infoglue.cms.webservices.elements.RemoteAttachment;
import org.infoglue.deliver.util.webservices.DynamicWebserviceSerializer;

public class RemoteContentServiceImpl
extends RemoteInfoGlueService {
    private static final Logger logger = Logger.getLogger((String)RemoteContentServiceImpl.class.getName());
    private InfoGluePrincipal principal;
    private static ContentControllerProxy contentControllerProxy = ContentControllerProxy.getController();
    private static ContentVersionControllerProxy contentVersionControllerProxy = ContentVersionControllerProxy.getController();

    public ContentVersionVO getContentVersion(String principalName, Object[] inputsArray) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"**************************************");
            logger.info((Object)"* Getting content through webservice *");
            logger.info((Object)"**************************************");
        }
        ContentVersionVO contentVersionVO = null;
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map args = (Map)serializer.deserialize(inputsArray);
            logger.info((Object)("args:" + args));
            Integer contentId = (Integer)args.get("contentId");
            Integer languageId = (Integer)args.get("languageId");
            if (logger.isInfoEnabled()) {
                logger.info((Object)("principalName:" + principalName));
                logger.info((Object)("contentId:" + contentId));
                logger.info((Object)("languageId:" + languageId));
            }
            this.initializePrincipal(principalName);
            contentVersionVO = contentVersionControllerProxy.getACLatestActiveContentVersionVO(this.principal, contentId, languageId);
        }
        catch (Throwable t) {
            logger.error((Object)("En error occurred when we tried to get the contentVersionVO:" + t.getMessage()), t);
        }
        return contentVersionVO;
    }

    public int createContent(String principalName, ContentVO contentVO, int parentContentId, int contentTypeDefinitionId, int repositoryId) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return -1;
        }
        int newContentId = 0;
        logger.info((Object)"***************************************");
        logger.info((Object)"Creating content through webservice....");
        logger.info((Object)"***************************************");
        logger.info((Object)("parentContentId:" + parentContentId));
        logger.info((Object)("contentTypeDefinitionId:" + contentTypeDefinitionId));
        logger.info((Object)("repositoryId:" + repositoryId));
        try {
            this.initializePrincipal(principalName);
            ContentVO newContentVO = contentControllerProxy.acCreate(this.principal, new Integer(parentContentId), new Integer(contentTypeDefinitionId), new Integer(repositoryId), contentVO);
            newContentId = newContentVO.getId();
        }
        catch (Exception e) {
            logger.error((Object)("En error occurred when we tried to create a new content:" + e.getMessage()), (Throwable)e);
        }
        this.updateCaches();
        return newContentId;
    }

    public int createContentVersion(String principalName, ContentVersionVO contentVersionVO, int contentId, int languageId) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return -1;
        }
        int newContentVersionId = 0;
        logger.info((Object)"***************************************");
        logger.info((Object)"Creating content through webservice....");
        logger.info((Object)"***************************************");
        try {
            this.initializePrincipal(principalName);
            ContentVersionVO newContentVersionVO = contentVersionControllerProxy.acCreate(this.principal, new Integer(contentId), new Integer(languageId), contentVersionVO);
            newContentVersionId = newContentVersionVO.getId();
        }
        catch (Exception e) {
            logger.error((Object)("En error occurred when we tried to create a new contentVersion:" + e.getMessage()), (Throwable)e);
        }
        this.updateCaches();
        return newContentVersionId;
    }

    public Boolean createContents(String principalName, Object[] inputsArray) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        ArrayList<Integer> newContentIdList = new ArrayList<Integer>();
        logger.info((Object)"****************************************");
        logger.info((Object)"Creating contents through webservice....");
        logger.info((Object)"****************************************");
        logger.info((Object)("principalName:" + principalName));
        logger.info((Object)("inputsArray:" + inputsArray));
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            List contents = (List)serializer.deserialize(inputsArray);
            logger.info((Object)("contents:" + contents));
            this.initializePrincipal(principalName);
            for (Map content : contents) {
                String name = (String)content.get("name");
                Integer contentTypeDefinitionId = (Integer)content.get("contentTypeDefinitionId");
                Integer repositoryId = (Integer)content.get("repositoryId");
                Integer parentContentId = (Integer)content.get("parentContentId");
                String contentPath = (String)content.get("contentPath");
                logger.info((Object)("name:" + name));
                logger.info((Object)("contentTypeDefinitionId:" + contentTypeDefinitionId));
                logger.info((Object)("repositoryId:" + repositoryId));
                logger.info((Object)("parentContentId:" + parentContentId));
                logger.info((Object)("contentPath:" + contentPath));
                if (contentPath != null && !contentPath.equals("")) {
                    Database db = CastorDatabaseService.getDatabase();
                    RemoteContentServiceImpl.beginTransaction(db);
                    try {
                        if (parentContentId != null) {
                            StringBuffer path = new StringBuffer();
                            Content parentContent = ContentController.getContentController().getContentWithId(parentContentId, db);
                            path.insert(0, String.valueOf(parentContent.getName()) + "/");
                            while (parentContent.getParentContent() != null) {
                                if ((parentContent = parentContent.getParentContent()) == null || parentContent.getParentContent() == null) continue;
                                path.insert(0, String.valueOf(parentContent.getName()) + "/");
                            }
                            contentPath = String.valueOf(path.toString()) + contentPath;
                        }
                        ContentVO parentContentVO = ContentController.getContentController().getContentVOWithPath(repositoryId, contentPath, true, this.principal, db);
                        parentContentId = parentContentVO.getId();
                        RemoteContentServiceImpl.commitTransaction(db);
                    }
                    catch (Exception e) {
                        logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                        RemoteContentServiceImpl.rollbackTransaction(db);
                        throw new SystemException(e.getMessage());
                    }
                }
                ContentVO contentVO = new ContentVO();
                contentVO.setName(name);
                contentVO.setContentTypeDefinitionId(contentTypeDefinitionId);
                contentVO.setRepositoryId(repositoryId);
                contentVO.setParentContentId(parentContentId);
                if (contentVO.getCreatorName() == null) {
                    contentVO.setCreatorName(this.principal.getName());
                }
                ContentVO newContentVO = contentControllerProxy.acCreate(this.principal, contentVO.getParentContentId(), contentVO.getContentTypeDefinitionId(), contentVO.getRepositoryId(), contentVO);
                List contentVersions = (List)content.get("contentVersions");
                for (Map contentVersion : contentVersions) {
                    Integer languageId = (Integer)contentVersion.get("languageId");
                    Integer stateId = (Integer)contentVersion.get("stateId");
                    Boolean allowHTMLContent = (Boolean)contentVersion.get("allowHTMLContent");
                    Boolean allowExternalLinks = (Boolean)contentVersion.get("allowExternalLinks");
                    if (allowHTMLContent == null) {
                        allowHTMLContent = new Boolean(false);
                    }
                    if (allowExternalLinks == null) {
                        allowExternalLinks = new Boolean(false);
                    }
                    logger.info((Object)("languageId:" + languageId));
                    logger.info((Object)("stateId:" + stateId));
                    logger.info((Object)("allowHTMLContent:" + allowHTMLContent));
                    logger.info((Object)("allowExternalLinks:" + allowExternalLinks));
                    ContentVersionVO contentVersionVO = new ContentVersionVO();
                    contentVersionVO.setLanguageId(languageId);
                    if (contentVersionVO.getVersionModifier() == null) {
                        contentVersionVO.setVersionModifier(this.principal.getName());
                    }
                    Map attributes = (Map)contentVersion.get("contentVersionAttributes");
                    DOMBuilder domBuilder = new DOMBuilder();
                    Document document = domBuilder.createDocument();
                    Element rootElement = domBuilder.addElement(document, "root");
                    domBuilder.addAttribute(rootElement, "xmlns", "x-schema:Schema.xml");
                    Element attributesRoot = domBuilder.addElement(rootElement, "attributes");
                    for (String attributeName : attributes.keySet()) {
                        String attributeValue = (String)attributes.get(attributeName);
                        attributeValue = this.cleanAttributeValue(attributeValue, allowHTMLContent, allowExternalLinks);
                        Element attribute = domBuilder.addElement(attributesRoot, attributeName);
                        domBuilder.addCDATAElement(attribute, attributeValue);
                    }
                    contentVersionVO.setVersionValue(document.asXML());
                    ContentVersionVO newContentVersionVO = contentVersionControllerProxy.acCreate(this.principal, newContentVO.getId(), languageId, contentVersionVO);
                    Integer newContentVersionId = newContentVersionVO.getId();
                    List digitalAssets = (List)contentVersion.get("digitalAssets");
                    logger.info((Object)("digitalAssets:" + digitalAssets));
                    if (digitalAssets != null) {
                        for (RemoteAttachment remoteAttachment : digitalAssets) {
                            logger.info((Object)("digitalAssets in ws:" + remoteAttachment));
                            DigitalAssetVO newAsset = new DigitalAssetVO();
                            newAsset.setAssetContentType(remoteAttachment.getContentType());
                            newAsset.setAssetKey(remoteAttachment.getName());
                            newAsset.setAssetFileName(remoteAttachment.getFileName());
                            newAsset.setAssetFilePath(remoteAttachment.getFilePath());
                            newAsset.setAssetFileSize(new Integer(new Long(remoteAttachment.getBytes().length).intValue()));
                            ByteArrayInputStream is = new ByteArrayInputStream(remoteAttachment.getBytes());
                            DigitalAssetController.create(newAsset, (InputStream)is, newContentVersionId, this.principal);
                        }
                    }
                    List contentCategories = (List)contentVersion.get("contentCategories");
                    logger.info((Object)("contentCategories:" + contentCategories));
                    if (contentCategories != null) {
                        for (String contentCategoryString : contentCategories) {
                            String[] split = contentCategoryString.split("=");
                            String categoryKey = split[0];
                            String fullCategoryName = split[1];
                            logger.info((Object)("categoryKey:" + categoryKey));
                            logger.info((Object)("fullCategoryName:" + fullCategoryName));
                            CategoryVO categoryVO = CategoryController.getController().findByPath(fullCategoryName);
                            logger.info((Object)("categoryVO:" + categoryVO));
                            ArrayList<CategoryVO> categoryVOList = new ArrayList<CategoryVO>();
                            categoryVOList.add(categoryVO);
                            Database db = RemoteContentServiceImpl.beginTransaction();
                            try {
                                ContentVersion latestContentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(newContentVersionVO.getId(), db);
                                logger.info((Object)("Adding categoryKey:" + categoryKey + " to " + newContentVersionVO.getId() + ":" + categoryVO));
                                List categories = this.categoryVOListToCategoryList(categoryVOList, db);
                                ContentCategoryController.getController().create(categories, latestContentVersion, categoryKey, db);
                                RemoteContentServiceImpl.commitTransaction(db);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                RemoteContentServiceImpl.rollbackTransaction(db);
                                throw new SystemException(e.getMessage());
                            }
                        }
                    }
                    if (stateId == null || stateId.equals(ContentVersionVO.WORKING_STATE)) continue;
                    ArrayList events = new ArrayList();
                    ContentStateController.changeState(newContentVersionId, stateId, "Remote update from deliver", false, this.principal, newContentVO.getId(), events);
                    if (!stateId.equals(ContentVersionVO.PUBLISHED_STATE)) continue;
                    PublicationVO publicationVO = new PublicationVO();
                    publicationVO.setName("Direct publication by " + this.principal.getName());
                    publicationVO.setDescription("Direct publication from deliver");
                    publicationVO.setRepositoryId(repositoryId);
                    publicationVO = PublicationController.getController().createAndPublish(publicationVO, events, false, this.principal);
                }
                newContentIdList.add(newContentVO.getId());
            }
            logger.info((Object)"Done with contents..");
        }
        catch (Throwable e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to create a new content:" + e.getMessage()), e);
        }
        this.updateCaches();
        return status;
    }

    private List categoryVOListToCategoryList(List categoryVOList, Database db) throws Exception {
        ArrayList<Category> result = new ArrayList<Category>();
        for (CategoryVO categoryVO : categoryVOList) {
            result.add(CategoryController.getController().findById(categoryVO.getCategoryId(), db));
        }
        return result;
    }

    public Boolean updateContent(String principalName, Object[] inputsArray) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        logger.info((Object)"****************************************");
        logger.info((Object)"Updating content through webservice....");
        logger.info((Object)"****************************************");
        logger.info((Object)("principalName:" + principalName));
        logger.info((Object)("inputsArray:" + inputsArray));
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map content = (Map)serializer.deserialize(inputsArray);
            logger.info((Object)("content:" + content));
            this.initializePrincipal(principalName);
            Integer contentId = (Integer)content.get("contentId");
            String name = (String)content.get("name");
            Date publishDateTime = (Date)content.get("publishDateTime");
            Date expireDateTime = (Date)content.get("expireDateTime");
            logger.info((Object)("contentId:" + contentId));
            logger.info((Object)("name:" + name));
            logger.info((Object)("publishDateTime:" + publishDateTime));
            logger.info((Object)("expireDateTime:" + expireDateTime));
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId);
            if (name != null) {
                contentVO.setName(name);
            }
            if (publishDateTime != null) {
                contentVO.setPublishDateTime(publishDateTime);
            }
            if (expireDateTime != null) {
                contentVO.setExpireDateTime(expireDateTime);
            }
            ContentVO newContentVO = contentControllerProxy.acUpdate(this.principal, contentVO, null);
            logger.info((Object)"Done with contents..");
        }
        catch (Throwable e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to create a new content:" + e.getMessage()), e);
        }
        this.updateCaches();
        return status;
    }

    public Boolean updateContentVersion(String principalName, Object[] inputsArray) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        logger.info((Object)"****************************************");
        logger.info((Object)"Updating content versions through webservice....");
        logger.info((Object)"****************************************");
        logger.info((Object)("principalName:" + principalName));
        logger.info((Object)("inputsArray:" + inputsArray));
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map contentVersion = (Map)serializer.deserialize(inputsArray);
            logger.info((Object)("contentVersion:" + contentVersion));
            this.initializePrincipal(principalName);
            Integer contentVersionId = (Integer)contentVersion.get("contentVersionId");
            Integer contentId = (Integer)contentVersion.get("contentId");
            Integer languageId = (Integer)contentVersion.get("languageId");
            Integer stateId = (Integer)contentVersion.get("stateId");
            String versionComment = (String)contentVersion.get("versionComment");
            Boolean allowHTMLContent = (Boolean)contentVersion.get("allowHTMLContent");
            Boolean allowExternalLinks = (Boolean)contentVersion.get("allowExternalLinks");
            if (allowHTMLContent == null) {
                allowHTMLContent = new Boolean(false);
            }
            if (allowExternalLinks == null) {
                allowExternalLinks = new Boolean(false);
            }
            logger.info((Object)("contentVersionId:" + contentVersionId));
            logger.info((Object)("contentId:" + contentId));
            logger.info((Object)("languageId:" + languageId));
            logger.info((Object)("stateId:" + stateId));
            logger.info((Object)("versionComment:" + versionComment));
            logger.info((Object)("allowHTMLContent:" + allowHTMLContent));
            logger.info((Object)("allowExternalLinks:" + allowExternalLinks));
            ContentVersionVO contentVersionVO = null;
            contentVersionVO = contentVersionId != null ? ContentVersionController.getContentVersionController().getContentVersionVOWithId(contentVersionId) : ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, languageId);
            if (contentVersionVO == null) {
                return new Boolean(false);
            }
            contentVersionVO.setVersionComment(versionComment);
            Map attributes = (Map)contentVersion.get("contentVersionAttributes");
            if (attributes != null && attributes.size() > 0) {
                DOMBuilder domBuilder = new DOMBuilder();
                Document document = domBuilder.createDocument();
                Element rootElement = domBuilder.addElement(document, "root");
                domBuilder.addAttribute(rootElement, "xmlns", "x-schema:Schema.xml");
                Element attributesRoot = domBuilder.addElement(rootElement, "attributes");
                for (String attributeName : attributes.keySet()) {
                    String attributeValue = (String)attributes.get(attributeName);
                    attributeValue = this.cleanAttributeValue(attributeValue, allowHTMLContent, allowExternalLinks);
                    Element attribute = domBuilder.addElement(attributesRoot, attributeName);
                    domBuilder.addCDATAElement(attribute, attributeValue);
                }
                contentVersionVO.setVersionValue(document.asXML());
            }
            ContentVersionControllerProxy.getController().acUpdate(this.principal, contentId, languageId, contentVersionVO);
            List digitalAssets = (List)contentVersion.get("digitalAssets");
            if (digitalAssets != null) {
                logger.info((Object)("digitalAssets:" + digitalAssets.size()));
                for (RemoteAttachment remoteAttachment : digitalAssets) {
                    logger.info((Object)("digitalAssets in ws:" + remoteAttachment));
                    DigitalAssetVO newAsset = new DigitalAssetVO();
                    newAsset.setAssetContentType(remoteAttachment.getContentType());
                    newAsset.setAssetKey(remoteAttachment.getName());
                    newAsset.setAssetFileName(remoteAttachment.getFileName());
                    newAsset.setAssetFilePath(remoteAttachment.getFilePath());
                    newAsset.setAssetFileSize(new Integer(new Long(remoteAttachment.getBytes().length).intValue()));
                    ByteArrayInputStream is = new ByteArrayInputStream(remoteAttachment.getBytes());
                    DigitalAssetController.create(newAsset, (InputStream)is, contentVersionVO.getContentVersionId(), this.principal);
                }
            }
            List contentCategories = (List)contentVersion.get("contentCategories");
            logger.info((Object)("contentCategories:" + contentCategories));
            if (contentCategories != null) {
                for (String contentCategoryString : contentCategories) {
                    String[] split = contentCategoryString.split("=");
                    String categoryKey = split[0];
                    String fullCategoryName = split[1];
                    logger.info((Object)("categoryKey:" + categoryKey));
                    logger.info((Object)("fullCategoryName:" + fullCategoryName));
                    CategoryVO categoryVO = CategoryController.getController().findByPath(fullCategoryName);
                    logger.info((Object)("categoryVO:" + categoryVO));
                    ArrayList<CategoryVO> categoryVOList = new ArrayList<CategoryVO>();
                    categoryVOList.add(categoryVO);
                    Database db = RemoteContentServiceImpl.beginTransaction();
                    try {
                        ContentVersion latestContentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionVO.getId(), db);
                        logger.info((Object)("Adding categoryKey:" + categoryKey + " to " + contentVersionVO.getId() + ":" + categoryVO));
                        List categories = this.categoryVOListToCategoryList(categoryVOList, db);
                        ContentCategoryController.getController().create(categories, latestContentVersion, categoryKey, db);
                        RemoteContentServiceImpl.commitTransaction(db);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        RemoteContentServiceImpl.rollbackTransaction(db);
                        throw new SystemException(e.getMessage());
                    }
                }
            }
            if (stateId != null && !stateId.equals(ContentVersionVO.WORKING_STATE)) {
                ArrayList events = new ArrayList();
                ContentStateController.changeState(contentVersionVO.getId(), stateId, "Remote update from deliver", false, this.principal, contentVersionVO.getContentId(), events);
                if (stateId.equals(ContentVersionVO.PUBLISHED_STATE)) {
                    PublicationVO publicationVO = new PublicationVO();
                    publicationVO.setName("Direct publication by " + this.principal.getName());
                    publicationVO.setDescription("Direct publication from deliver");
                    ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentVersionVO.getContentId());
                    publicationVO.setRepositoryId(contentVO.getRepositoryId());
                    publicationVO = PublicationController.getController().createAndPublish(publicationVO, events, false, this.principal);
                }
            }
            logger.info((Object)"Done with contentVersion..");
        }
        catch (Throwable e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to create a new content:" + e.getMessage()), e);
        }
        this.updateCaches();
        return status;
    }

    public Boolean deleteDigitalAsset(String principalName, Object[] inputsArray) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        logger.info((Object)"****************************************");
        logger.info((Object)"Updating content through webservice....");
        logger.info((Object)"****************************************");
        logger.info((Object)("principalName:" + principalName));
        logger.info((Object)("inputsArray:" + inputsArray));
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map digitalAsset = (Map)serializer.deserialize(inputsArray);
            logger.info((Object)("digitalAsset:" + digitalAsset));
            this.initializePrincipal(principalName);
            Integer contentVersionId = (Integer)digitalAsset.get("contentVersionId");
            Integer contentId = (Integer)digitalAsset.get("contentId");
            Integer languageId = (Integer)digitalAsset.get("languageId");
            String assetKey = (String)digitalAsset.get("assetKey");
            logger.info((Object)("contentVersionId:" + contentVersionId));
            logger.info((Object)("contentId:" + contentId));
            logger.info((Object)("languageId:" + languageId));
            logger.info((Object)("assetKey:" + assetKey));
            ContentVersionController.getContentVersionController().deleteDigitalAsset(contentId, languageId, assetKey);
            logger.info((Object)"Done with contents..");
        }
        catch (Throwable e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to delete a digitalAsset:" + e.getMessage()), e);
        }
        this.updateCaches();
        return status;
    }

    public Boolean deleteContent(String principalName, Object[] inputsArray) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        logger.info((Object)"****************************************");
        logger.info((Object)"Updating content through webservice....");
        logger.info((Object)"****************************************");
        logger.info((Object)("principalName:" + principalName));
        logger.info((Object)("inputsArray:" + inputsArray));
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map content = (Map)serializer.deserialize(inputsArray);
            logger.info((Object)("content:" + content));
            this.initializePrincipal(principalName);
            Integer contentId = (Integer)content.get("contentId");
            Boolean forceDelete = (Boolean)content.get("forceDelete");
            if (forceDelete == null) {
                forceDelete = new Boolean(false);
            }
            logger.info((Object)("contentId:" + contentId));
            ContentVO contentVO = new ContentVO();
            contentVO.setContentId(contentId);
            if (forceDelete.booleanValue()) {
                ContentVO currentContentVO = ContentControllerProxy.getContentController().getContentVOWithId(contentId);
                List contentVersionsVOList = ContentVersionController.getContentVersionController().getPublishedActiveContentVersionVOList(contentId);
                ArrayList<EventVO> events = new ArrayList<EventVO>();
                for (ContentVersionVO contentVersionVO : contentVersionsVOList) {
                    EventVO eventVO = new EventVO();
                    eventVO.setDescription("Unpublished before forced deletion");
                    eventVO.setEntityClass(ContentVersion.class.getName());
                    eventVO.setEntityId(contentVersionVO.getContentVersionId());
                    eventVO.setName(String.valueOf(contentVersionVO.getContentName()) + "(" + contentVersionVO.getLanguageName() + ")");
                    eventVO.setTypeId(EventVO.UNPUBLISH_LATEST);
                    eventVO = EventController.create(eventVO, currentContentVO.getRepositoryId(), this.principal);
                    events.add(eventVO);
                }
                PublicationVO publicationVO = new PublicationVO();
                publicationVO.setName("Direct publication by " + this.principal.getName());
                publicationVO.setDescription("Unpublished all versions before forced deletion");
                publicationVO.setRepositoryId(currentContentVO.getRepositoryId());
                publicationVO = PublicationController.getController().createAndPublish(publicationVO, events, true, this.principal);
            }
            ContentController.getContentController().delete(contentVO, this.principal, forceDelete);
            logger.info((Object)"Done with contents..");
        }
        catch (Throwable e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to delete a digitalAsset:" + e.getMessage()), e);
        }
        this.updateCaches();
        return status;
    }

    public Boolean deleteContentVersion(String principalName, Object[] inputsArray) {
        if (!ServerNodeController.getController().getIsIPAllowed(this.getRequest())) {
            logger.error((Object)("A client with IP " + this.getRequest().getRemoteAddr() + " was denied access to the webservice. Could be a hack attempt or you have just not configured the allowed IP-addresses correct."));
            return new Boolean(false);
        }
        Boolean status = new Boolean(true);
        logger.info((Object)"****************************************");
        logger.info((Object)"Updating content through webservice....");
        logger.info((Object)"****************************************");
        logger.info((Object)("principalName:" + principalName));
        logger.info((Object)("inputsArray:" + inputsArray));
        try {
            DynamicWebserviceSerializer serializer = new DynamicWebserviceSerializer();
            Map digitalAsset = (Map)serializer.deserialize(inputsArray);
            logger.info((Object)("digitalAsset:" + digitalAsset));
            this.initializePrincipal(principalName);
            Integer contentVersionId = (Integer)digitalAsset.get("contentVersionId");
            logger.info((Object)("contentVersionId:" + contentVersionId));
            ContentVersionVO contentVersionVO = new ContentVersionVO();
            contentVersionVO.setContentVersionId(contentVersionId);
            ContentVersionController.getContentVersionController().delete(contentVersionVO);
            logger.info((Object)"Done with contents..");
        }
        catch (Throwable e) {
            status = new Boolean(false);
            logger.error((Object)("En error occurred when we tried to delete a digitalAsset:" + e.getMessage()), e);
        }
        this.updateCaches();
        return status;
    }

    private void initializePrincipal(String userName) throws SystemException {
        try {
            this.principal = UserControllerProxy.getController().getUser(userName);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        if (this.principal == null) {
            throw new SystemException("No such principal [" + userName + "].");
        }
    }
}

