/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow.hibernate;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.module.propertyset.cached.CachingPropertySet;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.spi.hibernate.HibernateWorkflowStore;
import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.workflow.hibernate.InfoglueDefaultHibernateConfigurationProvider;
import org.infoglue.deliver.util.CacheController;

public class InfoglueHibernateWorkflowStore
extends HibernateWorkflowStore {
    private static final Logger logger = Logger.getLogger((String)InfoglueHibernateWorkflowStore.class.getName());
    private SessionFactory sessionFactory;

    public InfoglueHibernateWorkflowStore() {
    }

    public InfoglueHibernateWorkflowStore(SessionFactory sessionFactory) throws StoreException {
        super(sessionFactory);
        this.sessionFactory = sessionFactory;
    }

    public void init(Map props) throws StoreException {
        this.sessionFactory = (SessionFactory)props.get("sessionFactory");
        super.init(props);
    }

    public PropertySet getPropertySet(long entryId) {
        String key = "psCache_" + entryId;
        PropertySet ps = (PropertySet)CacheController.getCachedObject("propertySetCache", key);
        if (ps == null) {
            try {
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("entityName", "OSWorkflowEntry");
                args.put("entityId", new Long(entryId));
                InfoglueDefaultHibernateConfigurationProvider configurationProvider = new InfoglueDefaultHibernateConfigurationProvider();
                configurationProvider.setSessionFactory(this.sessionFactory);
                args.put("configurationProvider", (Object)configurationProvider);
                ps = new CachingPropertySet();
                HashMap<String, Object> args2 = new HashMap<String, Object>();
                args2.put("PropertySet", PropertySetManager.getInstance((String)"hibernate", args));
                args2.put("bulkload", new Boolean(true));
                ps.init(new HashMap(), args2);
                CacheController.cacheObject("propertySetCache", key, ps);
                ps = PropertySetManager.getInstance((String)"hibernate", args);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    logger.error((Object)"\n\nRestoring the session factory....");
                    this.sessionFactory = new Configuration().configure().buildSessionFactory();
                    InfoglueDefaultHibernateConfigurationProvider configurationProvider = new InfoglueDefaultHibernateConfigurationProvider();
                    configurationProvider.setSessionFactory(this.sessionFactory);
                    HashMap<String, InfoglueDefaultHibernateConfigurationProvider> args = new HashMap<String, InfoglueDefaultHibernateConfigurationProvider>();
                    args.put("configurationProvider", configurationProvider);
                    ps = new CachingPropertySet();
                    HashMap<String, Object> args2 = new HashMap<String, Object>();
                    args2.put("PropertySet", PropertySetManager.getInstance((String)"hibernate", args));
                    args2.put("bulkload", new Boolean(true));
                    ps.init(new HashMap(), args2);
                }
                catch (HibernateException he) {
                    he.printStackTrace();
                }
            }
        }
        return ps;
    }
}

