/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow.hibernate;

import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.hibernate.HibernatePropertySetDAO;
import com.opensymphony.module.propertyset.hibernate.PropertySetItem;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.infoglue.cms.util.workflow.hibernate.InfoglueHibernatePropertySetDAOUtils;
import org.infoglue.cms.util.workflow.hibernate.InfogluePropertySetItemImpl;

public class InfoglueHibernatePropertySetDAOImpl
implements HibernatePropertySetDAO {
    private SessionFactory sessionFactory;

    public InfoglueHibernatePropertySetDAOImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setImpl(PropertySetItem item, boolean isUpdate) {
        Session session = null;
        try {
            try {
                session = this.sessionFactory.openSession();
                if (isUpdate) {
                    session.update((Object)item);
                } else {
                    session.save((Object)item);
                }
                session.flush();
            }
            catch (HibernateException he) {
                throw new PropertyException("Could not save key '" + item.getKey() + "':" + he.getMessage());
            }
        }
        finally {
            try {
                if (session != null) {
                    if (!session.connection().getAutoCommit()) {
                        session.connection().commit();
                    }
                    session.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Collection getKeys(String entityName, Long entityId, String prefix, int type) {
        Session session = null;
        List list = null;
        try {
            try {
                session = this.sessionFactory.openSession();
                list = InfoglueHibernatePropertySetDAOUtils.getKeysImpl((Session)session, (String)entityName, (Long)entityId, (String)prefix, (int)type);
            }
            catch (HibernateException e) {
                list = Collections.EMPTY_LIST;
                try {
                    if (session != null) {
                        session.flush();
                        session.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (session != null) {
                    session.flush();
                    session.close();
                }
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public PropertySetItem create(String entityName, long entityId, String key) {
        return new InfogluePropertySetItemImpl(entityName, entityId, key);
    }

    public PropertySetItem findByKey(String entityName, Long entityId, String key) {
        Session session = null;
        PropertySetItem item = null;
        try {
            try {
                session = this.sessionFactory.openSession();
                item = InfoglueHibernatePropertySetDAOUtils.getItem(session, entityName, entityId, key);
                session.flush();
            }
            catch (HibernateException hibernateException) {
                try {
                    if (session != null) {
                        session.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception exception) {}
        }
        return item;
    }

    public void remove(String entityName, Long entityId) {
        Session session = null;
        try {
            try {
                session = this.sessionFactory.openSession();
                Collection keys = this.getKeys(entityName, entityId, null, 0);
                for (String key : keys) {
                    session.delete((Object)InfoglueHibernatePropertySetDAOUtils.getItem(session, entityName, entityId, key));
                }
                session.flush();
            }
            catch (HibernateException e) {
                throw new PropertyException("Could not remove all keys: " + e.getMessage());
            }
        }
        finally {
            try {
                if (session != null) {
                    if (!session.connection().getAutoCommit()) {
                        session.connection().commit();
                    }
                    session.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void remove(String entityName, Long entityId, String key) {
        Session session = null;
        try {
            try {
                session = this.sessionFactory.openSession();
                session.delete((Object)InfoglueHibernatePropertySetDAOUtils.getItem(session, entityName, entityId, key));
                session.flush();
            }
            catch (HibernateException e) {
                throw new PropertyException("Could not remove key '" + key + "': " + e.getMessage());
            }
        }
        finally {
            try {
                if (session != null) {
                    if (!session.connection().getAutoCommit()) {
                        session.connection().commit();
                    }
                    session.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

