/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow.hibernate;

import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.hibernate.HibernateConfigurationProvider;
import com.opensymphony.module.propertyset.hibernate.HibernatePropertySet;
import com.opensymphony.module.propertyset.hibernate.PropertySetItem;
import com.opensymphony.util.Data;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.infoglue.cms.util.workflow.hibernate.InfogluePropertySetItem;

public class InfoGlueHibernatePropertySet
extends HibernatePropertySet {
    private static final String UTF8_ENCODING = "utf-8";
    private static final String CONFIGURATION_PROVIDER_ARGUMENT = "configurationProvider";
    private HibernateConfigurationProvider configProvider;
    private Long entityId;
    private String entityName;

    public boolean supportsType(int type) {
        return type == 10 ? true : super.supportsType(type);
    }

    public Object getAsActualType(String key) throws PropertyException {
        try {
            return this.getType(key) == 10 ? this.getDataString(key) : super.getAsActualType(key);
        }
        catch (Exception e) {
            throw new PropertyException("Unable to get type for [" + key + "].");
        }
    }

    public String getDataString(String key) throws PropertyException {
        try {
            byte[] b = this.getData(key);
            String value = b == null ? null : new String(b, UTF8_ENCODING);
            return value;
        }
        catch (UnsupportedEncodingException e) {
            throw new PropertyException("Unable to get data for [" + key + "].");
        }
    }

    public void init(Map config, Map args) {
        super.init(config, args);
        this.configProvider = (HibernateConfigurationProvider)args.get(CONFIGURATION_PROVIDER_ARGUMENT);
        this.entityId = (Long)args.get("entityId");
        this.entityName = (String)args.get("entityName");
    }

    private PropertySetItem findByKey(String key) throws PropertyException {
        return this.configProvider.getPropertySetDAO().findByKey(this.entityName, this.entityId, key);
    }

    protected void setImpl(int type, String key, Object value) throws PropertyException {
        if (type != 10) {
            super.setImpl(type, key, value);
        } else {
            this.setDataImpl(type, key, value);
        }
    }

    protected void setDataImpl(int type, String key, Object value) throws PropertyException {
        boolean update;
        PropertySetItem item = this.configProvider.getPropertySetDAO().findByKey(this.entityName, this.entityId, key);
        boolean bl = update = item != null;
        if (item == null) {
            item = this.configProvider.getPropertySetDAO().create(this.entityName, this.entityId.longValue(), key);
        } else if (item.getType() != type) {
            throw new PropertyException("Existing key '" + key + "' does not have matching type of " + type);
        }
        ((InfogluePropertySetItem)item).setDataVal(((Data)value).getBytes());
        item.setType(type);
        this.configProvider.getPropertySetDAO().setImpl(item, update);
    }

    protected Object get(int type, String key) throws PropertyException {
        if (type != 10) {
            return super.get(type, key);
        }
        return this.getData(type, key);
    }

    private Object getData(int type, String key) throws PropertyException {
        PropertySetItem item = this.findByKey(key);
        if (item == null) {
            return null;
        }
        if (item.getType() != type) {
            throw new PropertyException("key '" + key + "' does not have matching type of " + type);
        }
        return new Data(((InfogluePropertySetItem)item).getDataVal());
    }
}

