/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow.hibernate;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.module.propertyset.cached.CachingPropertySet;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.spi.hibernate.AbstractHibernateWorkflowStore;
import com.opensymphony.workflow.util.PropertySetDelegate;
import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.infoglue.cms.util.workflow.hibernate.InfoglueDefaultHibernateConfigurationProvider;
import org.infoglue.deliver.util.CacheController;

public class ImprovedInfoglueHibernateWorkflowStore
extends AbstractHibernateWorkflowStore {
    private Session session = null;
    private SessionFactory sessionFactory = null;

    private Session getSession() {
        return this.session;
    }

    private void setSession(Session session) {
        this.session = session;
    }

    private SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public ImprovedInfoglueHibernateWorkflowStore() {
    }

    public void init(Map props) throws StoreException {
        this.setSessionFactory((SessionFactory)props.get("sessionFactory"));
        this.setSession((Session)props.get("session"));
        this.setPropertySetDelegate((PropertySetDelegate)props.get("propertySetDelegate"));
    }

    protected Object execute(AbstractHibernateWorkflowStore.InternalCallback action) throws StoreException {
        try {
            return action.doInHibernate(this.getSession());
        }
        catch (HibernateException e) {
            throw new StoreException((Throwable)e);
        }
    }

    public ImprovedInfoglueHibernateWorkflowStore(SessionFactory sessionFactory) throws StoreException {
        this.setSessionFactory(sessionFactory);
    }

    public PropertySet getPropertySet(long entryId) {
        String key = "psCache_" + entryId;
        PropertySet ps = (PropertySet)CacheController.getCachedObject("propertySetCache", key);
        if (ps == null) {
            try {
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("entityName", "OSWorkflowEntry");
                args.put("entityId", new Long(entryId));
                InfoglueDefaultHibernateConfigurationProvider configurationProvider = new InfoglueDefaultHibernateConfigurationProvider();
                configurationProvider.setSessionFactory(this.getSessionFactory());
                args.put("configurationProvider", (Object)configurationProvider);
                ps = new CachingPropertySet();
                HashMap<String, Object> args2 = new HashMap<String, Object>();
                args2.put("PropertySet", PropertySetManager.getInstance((String)"hibernate", args));
                args2.put("bulkload", new Boolean(true));
                ps.init(new HashMap(), args2);
                CacheController.cacheObject("propertySetCache", key, ps);
                ps = PropertySetManager.getInstance((String)"hibernate", args);
            }
            catch (Exception e) {
                e.printStackTrace();
                CacheController.clearCache("propertySetCache", key);
            }
        }
        return ps;
    }
}

