/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.AbstractWorkflow;
import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.config.DefaultConfiguration;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.query.Expression;
import com.opensymphony.workflow.query.FieldExpression;
import com.opensymphony.workflow.query.NestedExpression;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.spi.Step;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.apache.log4j.Logger;
import org.infoglue.cms.entities.mydesktop.WorkflowActionVO;
import org.infoglue.cms.entities.mydesktop.WorkflowStepVO;
import org.infoglue.cms.entities.mydesktop.WorkflowVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.workflow.DatabaseSession;
import org.infoglue.cms.util.workflow.InfoGlueBasicWorkflow;
import org.infoglue.cms.util.workflow.Owner;
import org.infoglue.cms.util.workflow.OwnerFactory;
import org.infoglue.deliver.util.CacheController;

public class WorkflowFacade {
    private static final String WORKFLOW_TITLE_EXTENSION_META_ATTRIBUTE = "org.infoglue.title";
    private static final String WORKFLOW_DATABASE_EXTENSION_META_ATTRIBUTE = "org.infoglue.database";
    private static final Logger logger = Logger.getLogger((String)WorkflowFacade.class.getName());
    private static SessionFactory hibernateSessionFactory;
    private static final Collection currentWorkflows;
    private final AbstractWorkflow workflow;
    private long workflowId;
    private WorkflowDescriptor workflowDescriptor;

    static {
        try {
            hibernateSessionFactory = new Configuration().configure().buildSessionFactory();
        }
        catch (HibernateException e) {
            logger.error((Object)"An exception occurred when we tried to initialize the hibernateSessionFactory", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        currentWorkflows = new ArrayList();
    }

    public WorkflowFacade(Owner owner) {
        this(owner, true);
    }

    public WorkflowFacade(Owner owner, boolean createSession) {
        this.workflow = new InfoGlueBasicWorkflow(owner.getIdentifier());
        this.workflow.getConfiguration().getPersistenceArgs().put("sessionFactory", hibernateSessionFactory);
        if (createSession) {
            try {
                Session session = hibernateSessionFactory.openSession();
                try {
                    HashMap<String, Object> args = new HashMap<String, Object>();
                    args.put("sessionFactory", hibernateSessionFactory);
                    args.put("session", session);
                    this.workflow.getConfiguration().getWorkflowStore().init(args);
                }
                catch (StoreException e) {
                    e.printStackTrace();
                }
                this.workflow.getConfiguration().getPersistenceArgs().put("session", session);
            }
            catch (HibernateException e) {
                e.printStackTrace();
            }
        }
    }

    public WorkflowFacade(Owner owner, SessionFactory sessionFactory, Session session) {
        if (sessionFactory != null) {
            hibernateSessionFactory = sessionFactory;
        }
        this.workflow = new InfoGlueBasicWorkflow(owner.getIdentifier());
        if (session != null) {
            DefaultConfiguration config = new DefaultConfiguration();
            config.getPersistenceArgs().put("session", session);
            config.getPersistenceArgs().put("sessionFactory", hibernateSessionFactory);
            this.workflow.setConfiguration((com.opensymphony.workflow.config.Configuration)config);
        } else {
            this.workflow.getConfiguration().getPersistenceArgs().put("sessionFactory", hibernateSessionFactory);
        }
    }

    public WorkflowFacade(InfoGluePrincipal userPrincipal) {
        this(OwnerFactory.create(userPrincipal));
    }

    public WorkflowFacade(InfoGluePrincipal userPrincipal, boolean createSession) {
        this(OwnerFactory.create(userPrincipal), createSession);
    }

    public WorkflowFacade(InfoGluePrincipal userPrincipal, SessionFactory sessionFactory, Session session) {
        this(OwnerFactory.create(userPrincipal), sessionFactory, session);
    }

    public WorkflowFacade(InfoGluePrincipal userPrincipal, String name, int initialAction) throws SystemException {
        this(userPrincipal, name, initialAction, new HashMap());
    }

    public WorkflowFacade(InfoGluePrincipal userPrincipal, String name, int initialAction, Map inputs) throws SystemException {
        this(userPrincipal);
        this.initialize(name, initialAction, inputs);
    }

    public WorkflowFacade(InfoGluePrincipal userPrincipal, String name, int initialAction, Map inputs, SessionFactory sessionFactory, Session session) throws SystemException {
        this(userPrincipal, sessionFactory, session);
        this.initialize(name, initialAction, inputs);
    }

    public WorkflowFacade(InfoGluePrincipal userPrincipal, long workflowId) {
        this(userPrincipal);
        this.setWorkflowIdAndDescriptor(workflowId);
    }

    public WorkflowFacade(InfoGluePrincipal userPrincipal, long workflowId, boolean createSession) {
        this(userPrincipal, createSession);
        this.setWorkflowIdAndDescriptor(workflowId);
    }

    public WorkflowFacade(InfoGluePrincipal userPrincipal, long workflowId, SessionFactory sessionFactory, Session session) {
        this(userPrincipal, sessionFactory, session);
        this.setWorkflowIdAndDescriptor(workflowId);
    }

    private void setWorkflowIdAndDescriptor(long workflowId) {
        String keyDescriptor;
        WorkflowDescriptor workflowDescriptorTemp;
        this.workflowId = workflowId;
        String key = "workflowName_" + workflowId;
        String workflowName = (String)CacheController.getCachedObject("workflowNameCache", key);
        if (workflowName == null) {
            workflowName = this.workflow.getWorkflowName(workflowId);
            CacheController.cacheObject("workflowNameCache", key, workflowName);
        }
        if ((workflowDescriptorTemp = (WorkflowDescriptor)CacheController.getCachedObject("workflowNameCache", keyDescriptor = "workflowDescriptor_" + workflowId)) == null) {
            this.workflowDescriptor = workflowDescriptorTemp = this.workflow.getWorkflowDescriptor(workflowName);
            CacheController.cacheObject("workflowNameCache", keyDescriptor, workflowDescriptorTemp);
        } else {
            this.workflowDescriptor = workflowDescriptorTemp;
        }
    }

    public long getWorkflowId() {
        return this.workflowId;
    }

    private void initialize(String name, int initialAction, Map inputs) throws SystemException {
        try {
            if (this.useDatabaseExtension(this.workflow.getWorkflowDescriptor(name))) {
                this.setWorkflowIdAndDescriptor(this.doExtendedInitialize(name, initialAction, inputs));
            } else {
                this.setWorkflowIdAndDescriptor(this.workflow.initialize(name, initialAction, inputs));
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get workflow with name:" + name));
            throw new SystemException(e);
        }
    }

    private long doExtendedInitialize(String name, int initialAction, Map inputs) throws WorkflowException {
        long result = 0L;
        DatabaseSession db = new DatabaseSession();
        try {
            try {
                HashMap copy = new HashMap();
                copy.putAll(inputs);
                copy.put(this.workflow.getWorkflowDescriptor(name).getMetaAttributes().get(WORKFLOW_DATABASE_EXTENSION_META_ATTRIBUTE), db);
                result = this.workflow.initialize(name, initialAction, copy);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.setRollbackOnly();
                }
                throw e instanceof WorkflowException ? (WorkflowException)((Object)e) : new WorkflowException((Throwable)e);
            }
        }
        finally {
            db.releaseDB();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doAction(int actionId, Map inputs) throws WorkflowException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("doAction with " + actionId + " on " + this.workflowId));
        }
        try {
            Long id = new Long(this.workflowId);
            if (this.getEntryState() == 0) {
                this.workflow.changeEntryState(this.workflowId, 1);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("workflowId:" + this.workflowId));
                logger.info((Object)("actionId:" + actionId));
            }
            Collection collection = currentWorkflows;
            synchronized (collection) {
                if (!this.isActive()) {
                    if (this.getEntryState() == -1) {
                        throw new WorkflowException("The workflow with id " + this.workflowId + " is in an unknown state - the database could be down or the workflow corrupt");
                    }
                    throw new InvalidActionException("Workflow " + this.workflowId + " is no longer active");
                }
                if (currentWorkflows.contains(id)) {
                    throw new WorkflowException("The selected workflow is executing...");
                }
                currentWorkflows.add(id);
            }
            try {
                if (this.useDatabaseExtension(this.workflowDescriptor)) {
                    this.doExtendedAction(actionId, inputs);
                } else {
                    this.workflow.doAction(this.workflowId, actionId, inputs);
                }
            }
            catch (Throwable throwable) {
                Collection collection2 = currentWorkflows;
                synchronized (collection2) {
                    currentWorkflows.remove(id);
                }
                throw throwable;
            }
            Collection collection3 = currentWorkflows;
            synchronized (collection3) {
                currentWorkflows.remove(id);
            }
        }
        catch (Exception we) {
            logger.error((Object)("An error occurred when we tried to invoke an workflow action:" + we.getMessage()));
            throw new WorkflowException("An error occurred when we tried to invoke an workflow action:" + we.getMessage());
        }
    }

    private void doExtendedAction(int actionId, Map inputs) throws WorkflowException {
        DatabaseSession db = new DatabaseSession();
        try {
            try {
                HashMap copy = new HashMap();
                copy.putAll(inputs);
                copy.put(this.workflowDescriptor.getMetaAttributes().get(WORKFLOW_DATABASE_EXTENSION_META_ATTRIBUTE), db);
                this.workflow.doAction(this.workflowId, actionId, copy);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred in doExtendedAction:" + e.getMessage()), (Throwable)e);
                if (db != null) {
                    db.setRollbackOnly();
                }
                throw e instanceof WorkflowException ? (WorkflowException)((Object)e) : new WorkflowException((Throwable)e);
            }
        }
        finally {
            db.releaseDB();
        }
    }

    public PropertySet getPropertySet() {
        String key = "psCache_" + this.workflowId;
        PropertySet ps = (PropertySet)CacheController.getCachedObject("propertySetCache", key);
        if (ps == null) {
            ps = this.workflow.getPropertySet(this.workflowId);
            CacheController.cacheObject("propertySetCache", key, ps);
        }
        return ps;
    }

    private int getEntryState() throws WorkflowException {
        try {
            return this.workflow.getEntryState(this.workflowId);
        }
        catch (Throwable we) {
            logger.error((Object)("An error occurred when we tried to check for entry state:" + we.getMessage()));
            throw new WorkflowException("An error occurred when we tried to check for entry state:" + we.getMessage());
        }
    }

    public boolean isActive() throws WorkflowException {
        return this.getEntryState() == 1;
    }

    public boolean isFinished() throws WorkflowException {
        int state = this.getEntryState();
        return state == 3 || state == 4;
    }

    public List getDeclaredWorkflows() {
        String[] workflowNames = this.workflow.getWorkflowNames();
        ArrayList<WorkflowVO> availableWorkflows = new ArrayList<WorkflowVO>();
        int i = 0;
        while (i < workflowNames.length) {
            try {
                availableWorkflows.add(this.createWorkflowVO(workflowNames[i]));
            }
            catch (Exception e) {
                logger.error((Object)("The workflow " + workflowNames[i] + " could not be instantiated:" + e.getMessage()), (Throwable)e);
            }
            ++i;
        }
        return availableWorkflows;
    }

    public List getActiveWorkflows() throws SystemException {
        ArrayList<WorkflowVO> workflowVOs = new ArrayList<WorkflowVO>();
        List activeWorkflows = this.findActiveWorkflows();
        Iterator activeWorkflowsIterator = activeWorkflows.iterator();
        while (activeWorkflowsIterator.hasNext()) {
            this.setWorkflowIdAndDescriptor((Long)activeWorkflowsIterator.next());
            workflowVOs.add(this.createWorkflowVO());
        }
        return workflowVOs;
    }

    public List getMyActiveWorkflows(InfoGluePrincipal principal) throws SystemException {
        String key = "myWorkflows_" + principal.getName();
        ArrayList workflows = (ArrayList)CacheController.getCachedObject("myActiveWorkflows", key);
        if (workflows == null) {
            if (principal.getIsAdministrator()) {
                workflows = this.getActiveWorkflows();
            }
            Collection owners = OwnerFactory.createAll(principal);
            Expression[] expressions = new Expression[owners.size()];
            Iterator ownersIterator = owners.iterator();
            int i = 0;
            while (ownersIterator.hasNext()) {
                Owner owner = (Owner)ownersIterator.next();
                FieldExpression expression = new FieldExpression(1, 2, 1, (Object)owner.getIdentifier());
                expressions[i] = expression;
                ++i;
            }
            HashSet workflowVOs = new HashSet();
            workflowVOs.addAll(this.createWorkflowsForOwner(expressions));
            workflows = new ArrayList(workflowVOs);
            CacheController.cacheObject("myActiveWorkflows", key, workflows);
        }
        return workflows;
    }

    private final Set createWorkflowsForOwner(Owner owner) throws SystemException {
        HashSet<WorkflowVO> workflowVOs = new HashSet<WorkflowVO>();
        List workflows = this.findWorkflows(owner);
        Iterator workflowsIterator = workflows.iterator();
        while (workflowsIterator.hasNext()) {
            this.setWorkflowIdAndDescriptor((Long)workflowsIterator.next());
            workflowVOs.add(this.createWorkflowVO());
        }
        return workflowVOs;
    }

    private final Set createWorkflowsForOwner(Expression[] expressions) throws SystemException {
        try {
            HashSet<WorkflowVO> workflowVOs = new HashSet<WorkflowVO>();
            List workflows = this.findWorkflows(expressions);
            Iterator workflowsIterator = workflows.iterator();
            while (workflowsIterator.hasNext()) {
                this.setWorkflowIdAndDescriptor((Long)workflowsIterator.next());
                workflowVOs.add(this.createWorkflowVO());
            }
            return workflowVOs;
        }
        catch (WorkflowException e) {
            throw new SystemException(e);
        }
    }

    private List findActiveWorkflows() throws SystemException {
        try {
            List workflows = this.workflow.query(new WorkflowExpressionQuery((Expression)new FieldExpression(9, 3, 1, (Object)new Integer(1))));
            return workflows;
        }
        catch (WorkflowException e) {
            throw new SystemException(e);
        }
    }

    private List findWorkflows(Owner owner) throws SystemException {
        try {
            List workflows = this.workflow.query(new WorkflowExpressionQuery((Expression)new FieldExpression(1, 2, 1, (Object)owner.getIdentifier())));
            return workflows;
        }
        catch (WorkflowException e) {
            throw new SystemException(e);
        }
    }

    private List findWorkflows(Expression[] expressions) throws WorkflowException {
        try {
            List workflows = this.workflow.query(new WorkflowExpressionQuery((Expression)new NestedExpression(expressions, 7)));
            return workflows;
        }
        catch (WorkflowException we) {
            logger.error((Object)("An error occurred when we tried to invoke an workflow action:" + we.getMessage()));
            throw new WorkflowException("An error occurred when we tried to invoke an workflow action:" + we.getMessage());
        }
    }

    public List getCurrentSteps() {
        return this.getCurrentSteps(null);
    }

    public List getCurrentSteps(WorkflowVO workflowVO) {
        return this.createStepVOs(workflowVO, this.workflow.getCurrentSteps(this.workflowId));
    }

    public List getHistorySteps() {
        return this.getHistorySteps(null);
    }

    public List getHistorySteps(WorkflowVO workflowVO) {
        return this.createStepVOs(workflowVO, this.workflow.getHistorySteps(this.workflowId));
    }

    public List getDeclaredSteps() {
        return this.getDeclaredSteps(this.workflowDescriptor);
    }

    private List createStepVOs(WorkflowVO workflowVO, List steps) {
        ArrayList<WorkflowStepVO> stepVOs = new ArrayList<WorkflowStepVO>();
        Iterator i = steps.iterator();
        while (i.hasNext()) {
            Step step = null;
            step = (Step)i.next();
            try {
                stepVOs.add(this.createStepVO(workflowVO, step));
            }
            catch (Exception e) {
                logger.warn((Object)("There was an invalid step:" + workflowVO), (Throwable)e);
            }
        }
        return stepVOs;
    }

    private List getDeclaredSteps(WorkflowDescriptor descriptor) {
        ArrayList<WorkflowStepVO> steps = new ArrayList<WorkflowStepVO>();
        Iterator i = descriptor.getSteps().iterator();
        while (i.hasNext()) {
            steps.add(this.createStepVO((StepDescriptor)i.next()));
        }
        return steps;
    }

    private List getInitialActions() {
        return this.createActionVOs(this.workflowDescriptor.getInitialActions());
    }

    private List getGlobalActions() {
        return this.createActionVOs(this.workflowDescriptor.getGlobalActions());
    }

    private List createActionVOs(List actionDescriptors) {
        ArrayList<WorkflowActionVO> actions = new ArrayList<WorkflowActionVO>();
        Iterator i = actionDescriptors.iterator();
        while (i.hasNext()) {
            actions.add(this.createActionVO((ActionDescriptor)i.next()));
        }
        return actions;
    }

    public WorkflowVO createWorkflowVO() {
        WorkflowVO workflowVO = new WorkflowVO(new Long(this.workflowId), this.workflow.getWorkflowName(this.workflowId));
        if (this.workflowDescriptor != null && this.useTitleExtension(this.workflowDescriptor)) {
            workflowVO.setTitle(this.getWorkflowTitle());
        }
        workflowVO.setCurrentSteps(this.getCurrentSteps(workflowVO));
        workflowVO.setHistorySteps(this.getHistorySteps(workflowVO));
        workflowVO.setInitialActions(this.getInitialActions());
        workflowVO.setGlobalActions(this.getGlobalActions());
        return workflowVO;
    }

    private String getWorkflowTitle() {
        if (!this.workflowDescriptor.getMetaAttributes().containsKey(WORKFLOW_TITLE_EXTENSION_META_ATTRIBUTE)) {
            return null;
        }
        String key = (String)this.workflowDescriptor.getMetaAttributes().get(WORKFLOW_TITLE_EXTENSION_META_ATTRIBUTE);
        PropertySet ps = this.getPropertySet();
        return ps.exists(key) ? ps.getString(key) : null;
    }

    private WorkflowVO createWorkflowVO(String name) {
        WorkflowVO workflowVO = new WorkflowVO(null, name);
        try {
            workflowVO.setDeclaredSteps(this.getDeclaredSteps(this.workflow.getWorkflowDescriptor(name)));
        }
        catch (Exception e) {
            workflowVO.setStatus(1);
            workflowVO.setStatusMessage("Error in workflow:" + e.getMessage());
            logger.error((Object)("Could not read workflow:" + e.getMessage()), (Throwable)e);
        }
        return workflowVO;
    }

    private WorkflowStepVO createStepVO(WorkflowVO workflowVO, Step step) throws Exception {
        WorkflowStepVO stepVO;
        block4: {
            logger.info((Object)("step:" + step + ':' + step.getId()));
            logger.info((Object)("Owner:" + step.getOwner()));
            stepVO = new WorkflowStepVO(workflowVO);
            stepVO.setId(new Integer((int)step.getId()));
            stepVO.setStepId(new Integer(step.getStepId()));
            stepVO.setWorkflowId(new Long(this.workflowId));
            stepVO.setStatus(step.getStatus());
            stepVO.setStartDate(step.getStartDate());
            stepVO.setFinishDate(step.getFinishDate());
            stepVO.setOwner(step.getOwner());
            stepVO.setCaller(step.getCaller());
            try {
                StepDescriptor stepDescriptor = this.workflowDescriptor.getStep(step.getStepId());
                if (stepDescriptor != null) {
                    stepVO.setName(stepDescriptor.getName());
                    Iterator i = stepDescriptor.getActions().iterator();
                    while (i.hasNext()) {
                        stepVO.addAction(this.createActionVO((ActionDescriptor)i.next()));
                    }
                    break block4;
                }
                throw new SystemException("No stepDescriptor found for " + step);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stepVO;
    }

    private WorkflowStepVO createStepVO(StepDescriptor stepDescriptor) {
        WorkflowStepVO step = new WorkflowStepVO();
        step.setStepId(new Integer(stepDescriptor.getId()));
        step.setName(stepDescriptor.getName());
        step.setStatus("Not started");
        Iterator i = stepDescriptor.getActions().iterator();
        while (i.hasNext()) {
            step.addAction(this.createActionVO((ActionDescriptor)i.next()));
        }
        return step;
    }

    private WorkflowActionVO createActionVO(ActionDescriptor actionDescriptor) {
        logger.info((Object)("Action:" + actionDescriptor.getId() + ':' + actionDescriptor.getName() + ':' + actionDescriptor.getParent().getClass()));
        WorkflowActionVO actionVO = new WorkflowActionVO(new Integer(actionDescriptor.getId()));
        actionVO.setWorkflowId(new Long(this.workflowId));
        actionVO.setName(actionDescriptor.getName());
        actionVO.setView(actionDescriptor.getView());
        actionVO.setAutoExecute(actionDescriptor.getAutoExecute());
        actionVO.setMetaAttributes(actionDescriptor.getMetaAttributes());
        return actionVO;
    }

    private boolean useTitleExtension(WorkflowDescriptor descriptor) {
        return descriptor.getMetaAttributes().containsKey(WORKFLOW_TITLE_EXTENSION_META_ATTRIBUTE);
    }

    private boolean useDatabaseExtension(WorkflowDescriptor descriptor) {
        return descriptor.getMetaAttributes().containsKey(WORKFLOW_DATABASE_EXTENSION_META_ATTRIBUTE);
    }
}

