/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow;

import org.infoglue.cms.applications.common.Session;
import org.infoglue.cms.entities.mydesktop.WorkflowStepVO;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.workflow.Owner;
import org.infoglue.cms.util.workflow.OwnerFactory;
import org.infoglue.cms.util.workflow.StepFilter;

public class OwnerStepFilter
implements StepFilter {
    private final InfoGluePrincipal userPrincipal;

    public OwnerStepFilter() {
        this(new Session().getInfoGluePrincipal());
    }

    public OwnerStepFilter(InfoGluePrincipal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public boolean isAllowed(WorkflowStepVO step) {
        if (!step.hasOwner() || this.isUserAdministrator()) {
            return true;
        }
        for (Owner owner : OwnerFactory.createAll(this.userPrincipal)) {
            if (!step.isOwner(owner.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    protected boolean isUserAdministrator() {
        return this.userPrincipal.getIsAdministrator();
    }

    protected InfoGluePrincipal getUserPrincipal() {
        return this.userPrincipal;
    }
}

