/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow;

import java.util.ArrayList;
import java.util.Collection;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.workflow.Owner;
import org.infoglue.cms.util.workflow.PrincipalOwner;
import org.infoglue.cms.util.workflow.RoleOwner;

public class OwnerFactory {
    private OwnerFactory() {
    }

    public static final Owner create(InfoGluePrincipal principal) {
        return new PrincipalOwner(principal);
    }

    public static final Owner create(InfoGlueRole role) {
        return new RoleOwner(role);
    }

    public static final Owner create(InfoGlueRole role, InfoGlueGroup group) {
        return new RoleOwner(role, group);
    }

    public static final Collection createAll(InfoGluePrincipal principal) {
        ArrayList<Owner> owners = new ArrayList<Owner>();
        owners.add(OwnerFactory.create(principal));
        for (InfoGlueRole role : principal.getRoles()) {
            owners.add(OwnerFactory.create(role));
            for (InfoGlueGroup group : principal.getGroups()) {
                owners.add(OwnerFactory.create(role, group));
            }
        }
        return owners;
    }
}

