/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow;

import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractWorkflowFactory;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.WorkflowDefinitionController;
import org.infoglue.cms.entities.workflow.WorkflowDefinitionVO;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.util.CacheController;

public class InfoGlueWorkflowFactory
extends AbstractWorkflowFactory {
    private static final Logger logger = Logger.getLogger((String)InfoGlueWorkflowFactory.class.getName());
    protected boolean reload;

    public void setLayout(String workflowName, Object layout) {
    }

    public Object getLayout(String workflowName) {
        return null;
    }

    public boolean removeWorkflow(String name) throws FactoryException {
        throw new FactoryException("remove workflow not supported");
    }

    public void renameWorkflow(String oldName, String newName) {
    }

    public void save() {
    }

    public boolean isModifiable(String name) {
        return true;
    }

    public String getName() {
        return "";
    }

    public WorkflowDescriptor getWorkflow(String name, boolean validate) throws FactoryException {
        WorkflowConfig c;
        Map workflows = (Map)CacheController.getCachedObject("workflowCache", "workflowMap");
        if (workflows == null) {
            this.initDone();
        }
        if ((c = (WorkflowConfig)(workflows = (Map)CacheController.getCachedObject("workflowCache", "workflowMap")).get(name)) == null) {
            throw new FactoryException("Unknown workflow name \"" + name + "\"");
        }
        if (c.descriptor != null) {
            this.loadWorkflow(c, validate);
        } else {
            this.loadWorkflow(c, validate);
        }
        c.descriptor.setName(name);
        return c.descriptor;
    }

    public void reload() throws FactoryException {
        this.initDone();
    }

    public String[] getWorkflowNames() {
        Map workflows = (Map)CacheController.getCachedObject("workflowCache", "workflowMap");
        if (workflows == null) {
            try {
                this.initDone();
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
        }
        workflows = (Map)CacheController.getCachedObject("workflowCache", "workflowMap");
        int i = 0;
        String[] res = new String[workflows.keySet().size()];
        Iterator it = workflows.keySet().iterator();
        while (it.hasNext()) {
            res[i++] = (String)it.next();
        }
        return res;
    }

    public void createWorkflow(String name) {
        try {
            this.initDone();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initDone() throws FactoryException {
        try {
            HashMap<String, WorkflowConfig> workflows = new HashMap<String, WorkflowConfig>();
            List list = WorkflowDefinitionController.getController().getWorkflowDefinitionVOList();
            for (WorkflowDefinitionVO workflowDefinitionVO : list) {
                WorkflowConfig config = new WorkflowConfig(workflowDefinitionVO);
                workflows.put(workflowDefinitionVO.getName(), config);
            }
            CacheController.cacheObject("workflowCache", "workflowMap", workflows);
        }
        catch (Exception e) {
            throw new InvalidWorkflowDescriptorException("Error in workflow config", e);
        }
    }

    public boolean saveWorkflow(String name, WorkflowDescriptor descriptor, boolean replace) throws FactoryException {
        throw new FactoryException("Not supported...");
    }

    private void loadWorkflow(WorkflowConfig c, boolean validate) throws FactoryException {
        try {
            WorkflowDescriptor workflowDescriptor;
            String encoding = CmsPropertyHandler.getWorkflowEncoding();
            if (encoding == null || encoding.length() == 0 || encoding.equalsIgnoreCase("@workflowEncoding@")) {
                encoding = "UTF-8";
            }
            if ((workflowDescriptor = (WorkflowDescriptor)CacheController.getCachedObject("workflowCache", "workflowDescriptor_" + c.workflowDefinitionVO.getName())) == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"No cached workflow descriptor - reading it...");
                }
                workflowDescriptor = WorkflowLoader.load((InputStream)new ByteArrayInputStream(c.workflowDefinitionVO.getValue().getBytes(encoding)), (boolean)validate);
                CacheController.cacheObject("workflowCache", "workflowDescriptor_" + c.workflowDefinitionVO.getName(), workflowDescriptor);
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)"Found cached workflow descriptor - using it...");
            }
            c.descriptor = workflowDescriptor;
        }
        catch (Exception e) {
            throw new FactoryException("Error in workflow descriptor: " + c.workflowDefinitionVO.getName(), e);
        }
    }

    static class WorkflowConfig {
        WorkflowDescriptor descriptor;
        WorkflowDefinitionVO workflowDefinitionVO;

        public WorkflowConfig(WorkflowDefinitionVO workflowDefinitionVO) {
            this.workflowDefinitionVO = workflowDefinitionVO;
        }
    }
}

