/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow;

import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.SimpleStep;
import com.opensymphony.workflow.spi.SimpleWorkflowEntry;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.jdbc.JDBCWorkflowStore;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InfoGlueJDBCWorkflowStore
extends JDBCWorkflowStore {
    private static final Logger logger = Logger.getLogger((String)InfoGlueJDBCWorkflowStore.class.getName());
    private String userName;
    private String password;
    private String driverClassName;
    private String url;

    public void init(Map props) throws StoreException {
        super.init(props);
        this.userName = this.getInitProperty(props, "username", "root");
        this.password = this.getInitProperty(props, "password", "");
        this.driverClassName = this.getInitProperty(props, "driverClassName", "com.mysql.jdbc.Driver");
        this.url = this.getInitProperty(props, "url", "jdbc:mysql://localhost/infoglueWM?autoReconnect=true");
    }

    protected Connection getConnection() throws SQLException {
        this.closeConnWhenDone = true;
        Connection conn = null;
        logger.info((Object)("Establishing connection to database '" + this.url + "'"));
        try {
            Class.forName(this.driverClassName).newInstance();
            conn = DriverManager.getConnection(this.url, this.userName, this.password);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return conn;
    }

    public void setEntryState(long id, int state) throws StoreException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            try {
                conn = this.getConnection();
                String sql = "UPDATE " + this.entryTable + " SET " + this.entryState + " = ? WHERE " + this.entryId + " = ?";
                ps = conn.prepareStatement(sql);
                ps.setInt(1, state);
                ps.setLong(2, id);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new StoreException("Unable to update state for workflow instance #" + id + " to " + state, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.cleanup(conn, ps, null);
            throw throwable;
        }
        this.cleanup(conn, ps, null);
    }

    public Step createCurrentStep(long entryId, int wfStepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            long id = this.createCurrentStep(conn, entryId, wfStepId, owner, startDate, dueDate, status);
            this.addPreviousSteps(conn, id, previousIds);
            SimpleStep simpleStep = new SimpleStep(id, entryId, wfStepId, 0, owner, startDate, dueDate, null, status, previousIds, null);
            return simpleStep;
        }
        catch (SQLException e) {
            throw new StoreException("Unable to create current step for workflow instance #" + entryId, (Throwable)e);
        }
        finally {
            this.cleanup(conn, null, null);
        }
    }

    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        SimpleWorkflowEntry simpleWorkflowEntry;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            String sql = "INSERT INTO " + this.entryTable + " (" + this.entryId + ", " + this.entryName + ", " + this.entryState + ") VALUES (?,?,?)";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing SQL statement: " + sql));
            }
            stmt = conn.prepareStatement(sql);
            long id = this.getNextEntrySequence(conn);
            stmt.setLong(1, id);
            stmt.setString(2, workflowName);
            stmt.setInt(3, 0);
            stmt.executeUpdate();
            simpleWorkflowEntry = new SimpleWorkflowEntry(id, workflowName, 0);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new StoreException("Error creating new workflow instance", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanup(conn, stmt, null);
                throw throwable;
            }
        }
        this.cleanup(conn, stmt, null);
        return simpleWorkflowEntry;
    }

    public List findCurrentSteps(long entryId) throws StoreException {
        ArrayList<SimpleStep> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rset = null;
        PreparedStatement stmt2 = null;
        try {
            conn = this.getConnection();
            String sql = "SELECT " + this.stepId + ", " + this.stepStepId + ", " + this.stepActionId + ", " + this.stepOwner + ", " + this.stepStartDate + ", " + this.stepDueDate + ", " + this.stepFinishDate + ", " + this.stepStatus + ", " + this.stepCaller + " FROM " + this.currentTable + " WHERE " + this.stepEntryId + " = ?";
            String sql2 = "SELECT " + this.stepPreviousId + " FROM " + this.currentPrevTable + " WHERE " + this.stepId + " = ?";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing SQL statement: " + sql));
            }
            stmt = conn.prepareStatement(sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing SQL statement: " + sql2));
            }
            stmt2 = conn.prepareStatement(sql2);
            stmt.setLong(1, entryId);
            rset = stmt.executeQuery();
            ArrayList<SimpleStep> currentSteps = new ArrayList<SimpleStep>();
            while (rset.next()) {
                long id = rset.getLong(1);
                int stepId = rset.getInt(2);
                int actionId = rset.getInt(3);
                String owner = rset.getString(4);
                Timestamp startDate = rset.getTimestamp(5);
                Timestamp dueDate = rset.getTimestamp(6);
                Timestamp finishDate = rset.getTimestamp(7);
                String status = rset.getString(8);
                String caller = rset.getString(9);
                ArrayList<Long> prevIdsList = new ArrayList<Long>();
                stmt2.setLong(1, id);
                ResultSet rs = stmt2.executeQuery();
                while (rs.next()) {
                    long prevId = rs.getLong(1);
                    prevIdsList.add(new Long(prevId));
                }
                long[] prevIds = new long[prevIdsList.size()];
                int i = 0;
                for (Long aLong : prevIdsList) {
                    prevIds[i] = aLong;
                    ++i;
                }
                SimpleStep step = new SimpleStep(id, entryId, stepId, actionId, owner, (Date)startDate, (Date)dueDate, (Date)finishDate, status, prevIds, caller);
                currentSteps.add(step);
            }
            arrayList = currentSteps;
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Unable to locate current steps for workflow instance #" + entryId, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanup(null, stmt2, null);
                this.cleanup(conn, stmt, rset);
                throw throwable;
            }
        }
        this.cleanup(null, stmt2, null);
        this.cleanup(conn, stmt, rset);
        return arrayList;
    }

    public WorkflowEntry findEntry(long theEntryId) throws StoreException {
        SimpleWorkflowEntry simpleWorkflowEntry;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            conn = this.getConnection();
            String sql = "SELECT " + this.entryName + ", " + this.entryState + " FROM " + this.entryTable + " WHERE " + this.entryId + " = ?";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing SQL statement: " + sql));
            }
            stmt = conn.prepareStatement(sql);
            stmt.setLong(1, theEntryId);
            rset = stmt.executeQuery();
            rset.next();
            String workflowName = rset.getString(1);
            int state = rset.getInt(2);
            simpleWorkflowEntry = new SimpleWorkflowEntry(theEntryId, workflowName, state);
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Error finding workflow instance #" + this.entryId);
            }
            catch (Throwable throwable) {
                this.cleanup(conn, stmt, rset);
                throw throwable;
            }
        }
        this.cleanup(conn, stmt, rset);
        return simpleWorkflowEntry;
    }

    public List findHistorySteps(long entryId) throws StoreException {
        ArrayList<SimpleStep> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        PreparedStatement stmt2 = null;
        ResultSet rset = null;
        try {
            conn = this.getConnection();
            String sql = "SELECT " + this.stepId + ", " + this.stepStepId + ", " + this.stepActionId + ", " + this.stepOwner + ", " + this.stepStartDate + ", " + this.stepDueDate + ", " + this.stepFinishDate + ", " + this.stepStatus + ", " + this.stepCaller + " FROM " + this.historyTable + " WHERE " + this.stepEntryId + " = ? ORDER BY " + this.stepId + " DESC";
            String sql2 = "SELECT " + this.stepPreviousId + " FROM " + this.historyPrevTable + " WHERE " + this.stepId + " = ?";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing SQL statement: " + sql));
            }
            stmt = conn.prepareStatement(sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing SQL statement: " + sql2));
            }
            stmt2 = conn.prepareStatement(sql2);
            stmt.setLong(1, entryId);
            rset = stmt.executeQuery();
            ArrayList<SimpleStep> currentSteps = new ArrayList<SimpleStep>();
            while (rset.next()) {
                long id = rset.getLong(1);
                int stepId = rset.getInt(2);
                int actionId = rset.getInt(3);
                String owner = rset.getString(4);
                Timestamp startDate = rset.getTimestamp(5);
                Timestamp dueDate = rset.getTimestamp(6);
                Timestamp finishDate = rset.getTimestamp(7);
                String status = rset.getString(8);
                String caller = rset.getString(9);
                ArrayList<Long> prevIdsList = new ArrayList<Long>();
                stmt2.setLong(1, id);
                ResultSet rs = stmt2.executeQuery();
                while (rs.next()) {
                    long prevId = rs.getLong(1);
                    prevIdsList.add(new Long(prevId));
                }
                long[] prevIds = new long[prevIdsList.size()];
                int i = 0;
                for (Long aLong : prevIdsList) {
                    prevIds[i] = aLong;
                    ++i;
                }
                SimpleStep step = new SimpleStep(id, entryId, stepId, actionId, owner, (Date)startDate, (Date)dueDate, (Date)finishDate, status, prevIds, caller);
                currentSteps.add(step);
            }
            arrayList = currentSteps;
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Unable to locate history steps for workflow instance #" + entryId, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanup(null, stmt2, null);
                this.cleanup(conn, stmt, rset);
                throw throwable;
            }
        }
        this.cleanup(null, stmt2, null);
        this.cleanup(conn, stmt, rset);
        return arrayList;
    }

    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        SimpleStep simpleStep;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            String sql = "UPDATE " + this.currentTable + " SET " + this.stepStatus + " = ?, " + this.stepActionId + " = ?, " + this.stepFinishDate + " = ?, " + this.stepCaller + " = ? WHERE " + this.stepId + " = ?";
            logger.info((Object)("Executing SQL statement: " + sql));
            logger.info((Object)("status: " + status));
            logger.info((Object)("actionId: " + actionId));
            logger.info((Object)("new Timestamp(finishDate.getTime()): " + new Timestamp(finishDate.getTime())));
            logger.info((Object)("caller: " + caller));
            logger.info((Object)("step.getId(): " + step.getId()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing SQL statement: " + sql));
            }
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, status);
            stmt.setInt(2, actionId);
            stmt.setTimestamp(3, new Timestamp(finishDate.getTime()));
            stmt.setString(4, caller);
            stmt.setLong(5, step.getId());
            stmt.executeUpdate();
            SimpleStep theStep = (SimpleStep)step;
            theStep.setActionId(actionId);
            theStep.setFinishDate(finishDate);
            theStep.setStatus(status);
            theStep.setCaller(caller);
            simpleStep = theStep;
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Unable to mark step finished for #" + step.getEntryId(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanup(conn, stmt, null);
                throw throwable;
            }
        }
        this.cleanup(conn, stmt, null);
        return simpleStep;
    }

    public void moveToHistory(Step step) throws StoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.getConnection();
                String sql = "INSERT INTO " + this.historyTable + " (" + this.stepId + "," + this.stepEntryId + ", " + this.stepStepId + ", " + this.stepActionId + ", " + this.stepOwner + ", " + this.stepStartDate + ", " + this.stepFinishDate + ", " + this.stepStatus + ", " + this.stepCaller + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                logger.info((Object)("Executing SQL statement: " + sql));
                logger.info((Object)("step.getId(): " + step.getId()));
                logger.info((Object)("step.getEntryId(): " + step.getEntryId()));
                logger.info((Object)("step.getStepId(): " + step.getStepId()));
                logger.info((Object)("step.getActionId(): " + step.getActionId()));
                logger.info((Object)("step.getOwner(): " + step.getOwner()));
                logger.info((Object)("new Timestamp(step.getStartDate().getTime()): " + new Timestamp(step.getStartDate().getTime())));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing SQL statement: " + sql));
                }
                stmt = conn.prepareStatement(sql);
                stmt.setLong(1, step.getId());
                stmt.setLong(2, step.getEntryId());
                stmt.setInt(3, step.getStepId());
                stmt.setInt(4, step.getActionId());
                stmt.setString(5, step.getOwner());
                stmt.setTimestamp(6, new Timestamp(step.getStartDate().getTime()));
                if (step.getFinishDate() != null) {
                    stmt.setTimestamp(7, new Timestamp(step.getFinishDate().getTime()));
                } else {
                    stmt.setNull(7, 93);
                }
                stmt.setString(8, step.getStatus());
                stmt.setString(9, step.getCaller());
                stmt.executeUpdate();
                long[] previousIds = step.getPreviousStepIds();
                if (previousIds != null && previousIds.length > 0) {
                    sql = "INSERT INTO " + this.historyPrevTable + " (" + this.stepId + ", " + this.stepPreviousId + ") VALUES (?, ?)";
                    logger.debug((Object)("Executing SQL statement: " + sql));
                    this.cleanup(null, stmt, null);
                    stmt = conn.prepareStatement(sql);
                    int i = 0;
                    while (i < previousIds.length) {
                        long previousId = previousIds[i];
                        stmt.setLong(1, step.getId());
                        stmt.setLong(2, previousId);
                        stmt.executeUpdate();
                        ++i;
                    }
                }
                sql = "DELETE FROM " + this.currentPrevTable + " WHERE " + this.stepId + " = ?";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing SQL statement: " + sql));
                }
                this.cleanup(null, stmt, null);
                stmt = conn.prepareStatement(sql);
                stmt.setLong(1, step.getId());
                stmt.executeUpdate();
                sql = "DELETE FROM " + this.currentTable + " WHERE " + this.stepId + " = ?";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing SQL statement: " + sql));
                }
                this.cleanup(null, stmt, null);
                stmt = conn.prepareStatement(sql);
                stmt.setLong(1, step.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new StoreException("Unable to move current step to history step for #" + step.getEntryId(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.cleanup(conn, stmt, null);
            throw throwable;
        }
        this.cleanup(conn, stmt, null);
    }

    public List query(WorkflowQuery query) throws StoreException {
        ArrayList<Long> results = new ArrayList<Long>();
        int qtype = query.getType();
        if (qtype == 0 && query.getLeft() != null) {
            qtype = query.getLeft().getType();
        }
        String table = qtype == 2 ? this.currentTable : this.historyTable;
        String sel = "SELECT DISTINCT(" + this.stepEntryId + ") FROM " + table + " WHERE ";
        sel = String.valueOf(sel) + this.queryWhere(query);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sel);
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                conn = this.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sel);
                while (rs.next()) {
                    Long id = new Long(rs.getLong(this.stepEntryId));
                    results.add(id);
                }
            }
            catch (SQLException ex) {
                throw new StoreException("SQL Exception in query: " + ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            this.cleanup(conn, stmt, rs);
            throw throwable;
        }
        this.cleanup(conn, stmt, rs);
        return results;
    }

    private List doExpressionQuery(String sel, String columnName, List values) throws StoreException {
        ArrayList<Long> arrayList;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sel);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Long> results = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sel);
            if (!values.isEmpty()) {
                int i = 1;
                while (i <= values.size()) {
                    stmt.setObject(i, values.get(i - 1));
                    ++i;
                }
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long id = new Long(rs.getLong(columnName));
                results.add(id);
            }
            arrayList = results;
        }
        catch (SQLException ex) {
            try {
                throw new StoreException("SQL Exception in query: " + ex.getMessage());
            }
            catch (Throwable throwable) {
                this.cleanup(conn, stmt, rs);
                throw throwable;
            }
        }
        this.cleanup(conn, stmt, rs);
        return arrayList;
    }

    private String getInitProperty(Map props, String strName, String strDefault) {
        Object o = props.get(strName);
        if (o == null) {
            return strDefault;
        }
        return (String)o;
    }

    private String queryWhere(WorkflowQuery query) {
        if (query.getLeft() == null) {
            return this.queryComparison(query);
        }
        int operator = query.getOperator();
        WorkflowQuery left = query.getLeft();
        WorkflowQuery right = query.getRight();
        switch (operator) {
            case 6: {
                return "(" + this.queryWhere(left) + " AND " + this.queryWhere(right) + ")";
            }
            case 7: {
                return "(" + this.queryWhere(left) + " OR " + this.queryWhere(right) + ")";
            }
            case 8: {
                return "(" + this.queryWhere(left) + " XOR " + this.queryWhere(right) + ")";
            }
        }
        return "";
    }

    private String queryComparison(WorkflowQuery query) {
        String left;
        String oper;
        Object value = query.getValue();
        int operator = query.getOperator();
        int field = query.getField();
        switch (operator) {
            case 1: {
                oper = " = ";
                break;
            }
            case 5: {
                oper = " <> ";
                break;
            }
            case 3: {
                oper = " > ";
                break;
            }
            case 2: {
                oper = " < ";
                break;
            }
            default: {
                oper = " = ";
            }
        }
        switch (field) {
            case 4: {
                left = this.stepActionId;
                break;
            }
            case 6: {
                left = this.stepCaller;
                break;
            }
            case 3: {
                left = this.stepFinishDate;
                break;
            }
            case 1: {
                left = this.stepOwner;
                break;
            }
            case 2: {
                left = this.stepStartDate;
                break;
            }
            case 5: {
                left = this.stepStepId;
                break;
            }
            case 7: {
                left = this.stepStatus;
                break;
            }
            default: {
                left = "1";
            }
        }
        String right = value != null ? "'" + InfoGlueJDBCWorkflowStore.escape(value.toString()) + "'" : "null";
        return String.valueOf(left) + oper + right;
    }

    private static String escape(String s) {
        StringBuffer sb = new StringBuffer(s);
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            switch (c) {
                case '\'': {
                    sb.insert(i, '\'');
                    ++i;
                    break;
                }
                case '\\': {
                    sb.insert(i, '\\');
                    ++i;
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

