/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow;

import com.opensymphony.module.propertyset.InvalidPropertyTypeException;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.database.JDBCPropertySet;
import com.opensymphony.util.Data;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import org.infoglue.deliver.util.NullObject;

public class InfoGlueJDBCPropertySet
extends JDBCPropertySet {
    private static final Logger logger = Logger.getLogger((String)InfoGlueJDBCPropertySet.class.getName());
    private static GenericObjectPool connectionPool;
    private static ConnectionFactory connectionFactory;
    private static PoolableConnectionFactory poolableConnectionFactory;
    private static PoolingDriver driver;
    String colData;
    String colDate;
    String colFloat;
    String colGlobalKey;
    String colItemKey;
    String colItemType;
    String colNumber;
    String colString;
    private String userName;
    private String password;
    private String driverClassName;
    private String url;
    private String dbcpWhenExhaustedAction = null;
    private String dbcpMaxActive = null;
    private String dbcpMaxWait = null;
    private String dbcpMaxIdle = null;
    private String dbcpValidationQuery = null;
    String globalKey;
    String tableName;
    private static Map typeMap;
    private static Map valueMap;
    private boolean enableCache = true;
    private boolean allKeysCached = false;
    private static InfoGlueJDBCPropertySet instance;

    static {
        typeMap = null;
        valueMap = null;
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getKeys(String prefix, int type) throws PropertyException {
        if (prefix == null) {
            prefix = "";
        }
        Connection conn = null;
        try {
            logger.info((Object)("Getting keys with prefix:" + prefix + " and type: " + type));
            conn = this.getConnection();
            PreparedStatement ps = null;
            String sql = "SELECT " + this.colItemKey + "," + this.colItemType + ", " + this.colString + ", " + this.colDate + ", " + this.colData + ", " + this.colFloat + ", " + this.colNumber + " FROM " + this.tableName + " WHERE " + this.colItemKey + " LIKE ? AND " + this.colGlobalKey + " = ?";
            if (type == 0) {
                ps = conn.prepareStatement(sql);
                ps.setString(1, String.valueOf(prefix) + "%");
                ps.setString(2, this.globalKey);
            } else {
                sql = String.valueOf(sql) + " AND " + this.colItemType + " = ?";
                ps = conn.prepareStatement(sql);
                ps.setString(1, String.valueOf(prefix) + "%");
                ps.setString(2, this.globalKey);
                ps.setInt(3, type);
            }
            ArrayList<String> list = new ArrayList<String>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String key = rs.getString(this.colItemKey);
                int typeId = rs.getInt(this.colItemType);
                list.add(key);
                if (typeMap == null) {
                    typeMap = new HashMap();
                }
                Map map = typeMap;
                synchronized (map) {
                    typeMap.put(key, new Integer(typeId));
                }
                Object o = null;
                switch (typeId) {
                    case 1: {
                        int boolVal = rs.getInt(this.colNumber);
                        o = new Boolean(boolVal == 1);
                        break;
                    }
                    case 10: {
                        o = rs.getBytes(this.colData);
                        break;
                    }
                    case 7: {
                        o = rs.getTimestamp(this.colDate);
                        break;
                    }
                    case 4: {
                        o = new Double(rs.getDouble(this.colFloat));
                        break;
                    }
                    case 2: {
                        o = new Integer(rs.getInt(this.colNumber));
                        break;
                    }
                    case 3: {
                        o = new Long(rs.getLong(this.colNumber));
                        break;
                    }
                    case 5: {
                        o = rs.getString(this.colString);
                        break;
                    }
                    default: {
                        logger.error((Object)("JDBCPropertySet doesn't support this type yet:" + key + ":" + typeId));
                    }
                }
                if (valueMap == null) {
                    valueMap = new HashMap();
                }
                Map map2 = valueMap;
                synchronized (map2) {
                    valueMap.put(key, o);
                }
            }
            this.allKeysCached = true;
            rs.close();
            ps.close();
            ArrayList<String> arrayList = list;
            this.closeConnection(conn);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("Problem getting keys due to an SQL exception:" + e.getCause().getMessage()), (Throwable)e);
                throw new PropertyException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType(String key) throws PropertyException {
        Connection conn = null;
        if (this.enableCache && typeMap != null) {
            Map map = typeMap;
            synchronized (map) {
                Integer typeInteger = (Integer)typeMap.get(key);
                if (typeInteger != null) {
                    return typeInteger;
                }
            }
        }
        try {
            conn = this.getConnection();
            String sql = "SELECT " + this.colItemType + " FROM " + this.tableName + " WHERE " + this.colGlobalKey + " = ? AND " + this.colItemKey + " = ?";
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, this.globalKey);
            ps.setString(2, key);
            ResultSet rs = ps.executeQuery();
            int type = 0;
            if (rs.next()) {
                type = rs.getInt(this.colItemType);
            }
            rs.close();
            ps.close();
            int n = type;
            return n;
        }
        catch (SQLException e) {
            throw new PropertyException(e.getMessage());
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public boolean exists(String key) throws PropertyException {
        return this.getType(key) != 0;
    }

    public void init(Map config, Map args) {
        this.globalKey = (String)args.get("globalKey");
        this.tableName = (String)config.get("table.name");
        this.colGlobalKey = (String)config.get("col.globalKey");
        this.colItemKey = (String)config.get("col.itemKey");
        this.colItemType = (String)config.get("col.itemType");
        this.colString = (String)config.get("col.string");
        this.colDate = (String)config.get("col.date");
        this.colData = (String)config.get("col.data");
        this.colFloat = (String)config.get("col.float");
        this.colNumber = (String)config.get("col.number");
        this.userName = (String)config.get("username");
        this.password = (String)config.get("password");
        this.driverClassName = (String)config.get("driverClassName");
        this.url = (String)config.get("url");
        this.dbcpWhenExhaustedAction = (String)config.get("dbcp.whenExhaustedAction");
        this.dbcpMaxActive = (String)config.get("dbcp.maxActive");
        this.dbcpMaxWait = (String)config.get("dbcp.maxWait");
        this.dbcpMaxIdle = (String)config.get("dbcp.maxIdle");
        this.dbcpValidationQuery = (String)config.get("dbcp.validationQuery");
        if (this.dbcpWhenExhaustedAction != null && (this.dbcpWhenExhaustedAction.length() == 0 || this.dbcpWhenExhaustedAction.indexOf("@") > -1)) {
            this.dbcpWhenExhaustedAction = null;
        }
        if (this.dbcpMaxActive != null && (this.dbcpMaxActive.length() == 0 || this.dbcpMaxActive.indexOf("@") > -1)) {
            this.dbcpMaxActive = null;
        }
        if (this.dbcpMaxWait != null && (this.dbcpMaxWait.length() == 0 || this.dbcpMaxWait.indexOf("@") > -1)) {
            this.dbcpMaxWait = null;
        }
        if (this.dbcpMaxIdle != null && (this.dbcpMaxIdle.length() == 0 || this.dbcpMaxIdle.indexOf("@") > -1)) {
            this.dbcpMaxIdle = null;
        }
        if (this.dbcpValidationQuery != null && (this.dbcpValidationQuery.length() == 0 || this.dbcpValidationQuery.indexOf("@") > -1)) {
            this.dbcpValidationQuery = null;
        }
        instance = this;
    }

    public void remove(String key) throws PropertyException {
        Connection conn = null;
        try {
            try {
                conn = this.getConnection();
                String sql = "DELETE FROM " + this.tableName + " WHERE " + this.colGlobalKey + " = ? AND " + this.colItemKey + " = ?";
                PreparedStatement ps = conn.prepareStatement(sql);
                ps.setString(1, this.globalKey);
                ps.setString(2, key);
                ps.executeUpdate();
                ps.close();
                if (valueMap != null) {
                    valueMap.remove(key);
                }
                if (typeMap != null) {
                    typeMap.remove(key);
                }
            }
            catch (SQLException e) {
                throw new PropertyException(e.getMessage());
            }
        }
        finally {
            this.closeConnection(conn);
        }
    }

    protected void setImpl(int type, String key, Object value) throws PropertyException {
        if (value == null) {
            throw new PropertyException("JDBCPropertySet does not allow for null values to be stored");
        }
        Connection conn = null;
        try {
            try {
                conn = this.getConnection();
                String sql = "UPDATE " + this.tableName + " SET " + this.colString + " = ?, " + this.colDate + " = ?, " + this.colData + " = ?, " + this.colFloat + " = ?, " + this.colNumber + " = ?, " + this.colItemType + " = ? " + " WHERE " + this.colGlobalKey + " = ? AND " + this.colItemKey + " = ?";
                PreparedStatement ps = conn.prepareStatement(sql);
                this.setValues(ps, type, key, value);
                int rows = ps.executeUpdate();
                ps.close();
                if (rows != 1) {
                    sql = "INSERT INTO " + this.tableName + " (" + this.colString + ", " + this.colDate + ", " + this.colData + ", " + this.colFloat + ", " + this.colNumber + ", " + this.colItemType + ", " + this.colGlobalKey + ", " + this.colItemKey + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                    ps = conn.prepareStatement(sql);
                    this.setValues(ps, type, key, value);
                    ps.executeUpdate();
                    ps.close();
                }
            }
            catch (SQLException e) {
                throw new PropertyException(e.getMessage());
            }
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object get(int type, String key) throws PropertyException {
        if (this.enableCache && valueMap == null && !this.allKeysCached) {
            this.getKeys();
        }
        if (this.enableCache && valueMap != null) {
            Map map = valueMap;
            synchronized (map) {
                Object v = valueMap.get(key);
                if (v != null && !(v instanceof NullObject)) {
                    return v;
                }
                if (v instanceof NullObject) {
                    return null;
                }
                if (this.allKeysCached) {
                    return null;
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Getting value for key:" + key + ":" + type));
        }
        String sql = "SELECT " + this.colItemType + ", " + this.colString + ", " + this.colDate + ", " + this.colData + ", " + this.colFloat + ", " + this.colNumber + " FROM " + this.tableName + " WHERE " + this.colItemKey + " = ? AND " + this.colGlobalKey + " = ?";
        Object var4_5 = null;
        Connection conn = null;
        try {
            try {
                conn = this.getConnection();
                PreparedStatement ps = conn.prepareStatement(sql);
                ps.setString(1, key);
                ps.setString(2, this.globalKey);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    int propertyType = rs.getInt(this.colItemType);
                    if (propertyType != type) {
                        throw new InvalidPropertyTypeException();
                    }
                    switch (type) {
                        case 1: {
                            int boolVal = rs.getInt(this.colNumber);
                            Boolean bl = new Boolean(boolVal == 1);
                            break;
                        }
                        case 10: {
                            byte[] byArray = rs.getBytes(this.colData);
                            break;
                        }
                        case 7: {
                            Timestamp timestamp = rs.getTimestamp(this.colDate);
                            break;
                        }
                        case 4: {
                            Double d = new Double(rs.getDouble(this.colFloat));
                            break;
                        }
                        case 2: {
                            Integer n = new Integer(rs.getInt(this.colNumber));
                            break;
                        }
                        case 3: {
                            Long l = new Long(rs.getLong(this.colNumber));
                            break;
                        }
                        case 5: {
                            String string = rs.getString(this.colString);
                            break;
                        }
                        default: {
                            throw new InvalidPropertyTypeException("JDBCPropertySet doesn't support this type yet.");
                        }
                    }
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                throw new PropertyException(e.getMessage());
            }
            catch (NumberFormatException e) {
                throw new PropertyException(e.getMessage());
            }
        }
        finally {
            this.closeConnection(conn);
        }
        if (valueMap == null) {
            valueMap = new HashMap();
        }
        Map map = valueMap;
        synchronized (map) {
            void var4_13;
            if (var4_13 != null) {
                valueMap.put(key, var4_13);
            } else {
                valueMap.put(key, new NullObject());
            }
            return var4_13;
        }
    }

    private void setValues(PreparedStatement ps, int type, String key, Object value) throws SQLException, PropertyException {
        String driverName;
        try {
            driverName = ps.getConnection().getMetaData().getDriverName().toUpperCase();
        }
        catch (Exception e) {
            driverName = "";
        }
        ps.setNull(1, 12);
        ps.setNull(2, 93);
        if (driverName.indexOf("SQLSERVER") >= 0 || driverName.indexOf("ORACLE") >= 0) {
            ps.setNull(3, -2);
        } else {
            ps.setNull(3, 2004);
        }
        ps.setNull(4, 6);
        ps.setNull(5, 2);
        ps.setInt(6, type);
        ps.setString(7, this.globalKey);
        ps.setString(8, key);
        switch (type) {
            case 1: {
                Boolean boolVal = (Boolean)value;
                ps.setInt(5, boolVal != false ? 1 : 0);
                break;
            }
            case 10: {
                Data data = (Data)value;
                ps.setBytes(3, data.getBytes());
                break;
            }
            case 7: {
                Date date = (Date)value;
                ps.setTimestamp(2, new Timestamp(date.getTime()));
                break;
            }
            case 4: {
                Double d = (Double)value;
                ps.setDouble(4, d);
                break;
            }
            case 2: {
                Integer i = (Integer)value;
                ps.setInt(5, i);
                break;
            }
            case 3: {
                Long l = (Long)value;
                ps.setLong(5, l);
                break;
            }
            case 5: {
                ps.setString(1, (String)value);
                break;
            }
            default: {
                throw new PropertyException("This type isn't supported!");
            }
        }
        if (valueMap == null) {
            valueMap = new HashMap();
        }
        if (typeMap == null) {
            typeMap = new HashMap();
        }
        valueMap.put(key, value);
        typeMap.put(key, new Integer(type));
    }

    protected Connection getConnection() throws SQLException {
        Connection conn = null;
        try {
            if (connectionPool == null) {
                logger.info((Object)("Establishing connection to database '" + this.url + "'"));
                try {
                    this.setupDriver(this.url, this.userName, this.password);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                logger.info((Object)"Done.");
            }
            conn = DriverManager.getConnection("jdbc:apache:commons:dbcp:infoGlueJDBCPropertySet");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Fetched connection from pool...");
                this.printDriverStats();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return conn;
    }

    private void closeConnection(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Could not close connection");
        }
    }

    public void setupDriver(String connectURI, String userName, String password) throws Exception {
        String validationQuery = "SELECT count(*) FROM " + this.tableName;
        logger.info((Object)"Setting up driver.");
        Class.forName(this.driverClassName).newInstance();
        logger.info((Object)("dbcpWhenExhaustedAction:" + this.dbcpWhenExhaustedAction));
        logger.info((Object)("dbcpMaxActive:" + this.dbcpMaxActive));
        logger.info((Object)("dbcpMaxWait:" + this.dbcpMaxWait));
        logger.info((Object)("dbcpMaxIdle:" + this.dbcpMaxIdle));
        logger.info((Object)("dbcpValidationQuery:" + this.dbcpValidationQuery));
        int dbcpMaxActiveInt = 200;
        if (this.dbcpMaxActive != null && !this.dbcpMaxActive.equals("")) {
            dbcpMaxActiveInt = Integer.parseInt(this.dbcpMaxActive);
        }
        logger.info((Object)("dbcpMaxActiveInt:" + dbcpMaxActiveInt));
        connectionPool = new GenericObjectPool(null, dbcpMaxActiveInt);
        connectionPool.setTestOnBorrow(true);
        connectionFactory = new DriverManagerConnectionFactory(connectURI, userName, password);
        poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, (ObjectPool)connectionPool, null, validationQuery, false, true);
        Class.forName("org.apache.commons.dbcp.PoolingDriver");
        driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool("infoGlueJDBCPropertySet", (ObjectPool)connectionPool);
    }

    public void printDriverStats() throws Exception {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        ObjectPool connectionPool = driver.getConnectionPool("infoGlueJDBCPropertySet");
        if (logger.isInfoEnabled()) {
            logger.info((Object)("NumActive: " + connectionPool.getNumActive()));
            logger.info((Object)("NumIdle: " + connectionPool.getNumIdle()));
        }
    }

    public void shutdownDriver() throws Exception {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.closePool("infoGlueJDBCPropertySet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Map map;
        if (valueMap != null) {
            map = valueMap;
            synchronized (map) {
                valueMap = null;
            }
        }
        if (typeMap != null) {
            map = typeMap;
            synchronized (map) {
                typeMap = null;
            }
        }
        InfoGlueJDBCPropertySet.instance.allKeysCached = false;
    }

    public static void reCache() {
        InfoGlueJDBCPropertySet.clearCaches();
        instance.getKeys();
    }
}

