/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.WorkflowContext;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;

public class InfoGlueAuthorizationCondition
implements Condition {
    private static final Logger logger = Logger.getLogger((String)InfoGlueAuthorizationCondition.class.getName());

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) {
        boolean passesCondition = true;
        try {
            WorkflowContext context = (WorkflowContext)transientVars.get("context");
            String roleName = (String)args.get("roleName");
            String userName = (String)args.get("userName");
            logger.info((Object)"passesCondition.............");
            logger.info((Object)("caller:" + context.getCaller()));
            logger.info((Object)("roleName:" + roleName));
            logger.info((Object)("userName:" + userName));
            InfoGluePrincipal principal = UserControllerProxy.getController().getUser(context.getCaller());
            if (userName != null && userName.length() > 0 && !principal.getName().equals(userName)) {
                passesCondition = false;
            }
            if (roleName != null && roleName.length() > 0) {
                boolean hasRole = false;
                List roles = principal.getRoles();
                for (InfoGlueRole role : roles) {
                    if (!role.getName().equalsIgnoreCase(roleName)) continue;
                    hasRole = true;
                }
                if (!hasRole) {
                    passesCondition = false;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("A severe error occurred when checking workflow authorization:" + e.getMessage()), (Throwable)e);
        }
        return passesCondition;
    }
}

