/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow;

import com.opensymphony.workflow.WorkflowException;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;

public class DatabaseSession {
    private static final Logger logger = Logger.getLogger((String)DatabaseSession.class.getName());
    private Database db;
    private boolean rollbackOnly;

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    public Database getDB() throws WorkflowException {
        if (this.db == null) {
            try {
                logger.debug((Object)"Creating a new database");
                this.db = CastorDatabaseService.getDatabase();
                this.db.begin();
            }
            catch (Exception e) {
                logger.error((Object)"Unable to create database", (Throwable)e);
                throw new WorkflowException((Throwable)e);
            }
        }
        return this.db;
    }

    public void releaseDB() throws WorkflowException {
        logger.debug((Object)("releaseDB : " + (this.rollbackOnly ? "rollback" : "commit")));
        if (this.rollbackOnly) {
            this.rollback();
        } else {
            this.commit();
        }
    }

    private void rollback() throws WorkflowException {
        logger.debug((Object)"rollback()");
        try {
            this.doRollback();
        }
        finally {
            this.doClose();
        }
    }

    private void commit() throws WorkflowException {
        logger.debug((Object)"commit()");
        try {
            try {
                this.doCommit();
            }
            catch (Exception e) {
                this.doRollback();
                throw new WorkflowException((Throwable)e);
            }
        }
        finally {
            this.doClose();
        }
    }

    private void doCommit() throws WorkflowException {
        if (this.db != null && this.db.isActive()) {
            try {
                logger.debug((Object)"doCommit()");
                this.db.commit();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new WorkflowException((Throwable)e);
            }
        }
    }

    private void doRollback() throws WorkflowException {
        if (this.db != null && this.db.isActive()) {
            try {
                logger.debug((Object)"doRollback()");
                this.db.rollback();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new WorkflowException((Throwable)e);
            }
        }
    }

    private void doClose() throws WorkflowException {
        if (this.db != null && !this.db.isClosed()) {
            try {
                logger.debug((Object)"doClose()");
                this.db.close();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new WorkflowException((Throwable)e);
            }
        }
    }
}

