/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.workflow.CustomWorkflowAction;
import webwork.action.ActionContext;

public class CustomClassExecutor
implements FunctionProvider {
    private static final Logger logger = Logger.getLogger((String)CustomClassExecutor.class.getName());

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        logger.info((Object)"CustomClassExecutor.execute........");
        WorkflowContext wfContext = (WorkflowContext)transientVars.get("context");
        String className = (String)args.get("customClass.name");
        HttpServletRequest request = (HttpServletRequest)transientVars.get("request");
        logger.info((Object)("className:" + className));
        for (String key : transientVars.keySet()) {
            logger.info((Object)("transientVars key:" + key));
            Object value = args.get(key);
            logger.info((Object)("transientVars value:" + value));
        }
        HashMap params = new HashMap(transientVars);
        params.putAll(args);
        ActionContext.setParameters(Collections.unmodifiableMap(params));
        CustomWorkflowAction customWorkflowAction = this.getCustomWorkflowActionWithName(className);
        if (customWorkflowAction == null) {
            logger.warn((Object)("Could not find custom class " + className + ". Is it in the classpath?"));
            throw new WorkflowException("Could not find custom class " + className + ". Is it in the classpath?");
        }
        customWorkflowAction.invokeAction(wfContext.getCaller(), request, Collections.unmodifiableMap(params), ps);
    }

    public CustomWorkflowAction getCustomWorkflowActionWithName(String className) {
        try {
            Class<?> theClass = null;
            try {
                theClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                theClass = this.getClass().getClassLoader().loadClass(className);
            }
            return (CustomWorkflowAction)theClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

