/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.validators;

import org.infoglue.cms.util.validators.EmailValidator;
import org.infoglue.cms.util.validators.FloatValidator;
import org.infoglue.cms.util.validators.IntegerValidator;
import org.infoglue.cms.util.validators.StringValidator;

public class ValidatorFactory {
    private ValidatorFactory() {
    }

    public static final StringValidator createStringValidator(String fieldName, boolean isRequired, int upperLengthLimit) {
        return new StringValidator(fieldName, isRequired, upperLengthLimit);
    }

    public static final StringValidator createStringValidator(String fieldName, boolean isRequired, int lowerLengthLimit, int upperLengthLimit) {
        return new StringValidator(fieldName, isRequired, lowerLengthLimit, upperLengthLimit);
    }

    public static final StringValidator createStringValidator(String fieldName, boolean isRequired, int lowerLengthLimit, int upperLengthLimit, boolean mustBeUnique, Class objectClass, Integer excludeId, Object excludedObject) {
        return new StringValidator(fieldName, isRequired, lowerLengthLimit, upperLengthLimit, mustBeUnique, objectClass, excludeId, excludedObject);
    }

    public static final StringValidator createStringValidator(String fieldName, boolean isRequired, boolean mustBeUnique, Class objectClass, Integer excludeId, Object excludedObject) {
        return new StringValidator(fieldName, isRequired, mustBeUnique, objectClass, excludeId, excludedObject);
    }

    public static final EmailValidator createEmailValidator(String fieldName, boolean isRequired, int upperLengthLimit) {
        return new EmailValidator(fieldName, isRequired, upperLengthLimit);
    }

    public static final IntegerValidator createNonNegativeIntegerValidator(String fieldName, boolean isRequired) {
        return new IntegerValidator(fieldName, isRequired, 0, Integer.MAX_VALUE);
    }

    public static final FloatValidator createNonNegativeFloatValidator(String fieldName, boolean isRequired) {
        return new FloatValidator(fieldName, isRequired, new Float(0.0).floatValue(), Float.MAX_VALUE);
    }
}

