/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.validators;

import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.RegexpHelper;
import org.infoglue.cms.util.validators.AbstractValidator;
import org.infoglue.cms.util.validators.Range;

public class StringValidator
extends AbstractValidator {
    private static final String INVALID_LENGTH_ERROR_CODE = "301";
    private Range range;
    private String pattern;
    private String patternErrorCode;

    public StringValidator(String fieldName) {
        this(fieldName, true);
    }

    public StringValidator(String fieldName, boolean isRequired) {
        this(fieldName, isRequired, new Range());
    }

    public StringValidator(String fieldName, boolean isRequired, int upperLengthLimit) {
        this(fieldName, isRequired, 0, upperLengthLimit);
    }

    public StringValidator(String fieldName, boolean isRequired, int lowerLengthLimit, int upperLengthLimit) {
        this(fieldName, isRequired, new Range(lowerLengthLimit, upperLengthLimit));
    }

    public StringValidator(String fieldName, boolean isRequired, boolean mustBeUnique, Class objectClass, Integer excludeId, Object excludedObject) {
        super(fieldName, isRequired, mustBeUnique, objectClass, excludeId, excludedObject);
        this.range = new Range();
    }

    public StringValidator(String fieldName, boolean isRequired, int lowerLengthLimit, int upperLengthLimit, boolean mustBeUnique, Class objectClass, Integer excludeId, Object excludedObject) {
        super(fieldName, isRequired, mustBeUnique, objectClass, excludeId, excludedObject);
        this.range = new Range(lowerLengthLimit, upperLengthLimit);
    }

    public StringValidator(String fieldName, boolean isRequired, Range range) {
        super(fieldName, isRequired);
        this.range = range;
    }

    public void validate(String value) throws ConstraintException {
        this.validateIsRequired(value);
        if (value == null) {
            return;
        }
        this.validateLength(value.trim());
        this.validatePattern(value.trim());
        try {
            this.validateUniqueness(value);
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        this.failIfAnyExceptionsFound();
    }

    public void validate(String value, ConstraintExceptionBuffer ceb) {
        try {
            this.validate(value);
        }
        catch (ConstraintException e) {
            ceb.add(e);
        }
    }

    private void validateLength(String value) {
        if (!this.range.isWithinLimits(value.length())) {
            this.addConstraintException(INVALID_LENGTH_ERROR_CODE);
        }
    }

    private void validatePattern(String value) {
        if (this.pattern != null && !RegexpHelper.match(this.pattern, value)) {
            this.addConstraintException(this.patternErrorCode);
        }
    }

    protected void validateIsRequired(Object value) throws ConstraintException {
        String stringValue;
        super.validateIsRequired(value);
        if (value != null && (stringValue = (String)value).trim().length() == 0) {
            super.validateIsRequired(null);
        }
    }

    protected void initializePattern(String pattern, String patternErrorCode) {
        this.pattern = pattern;
        this.patternErrorCode = patternErrorCode;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }
}

