/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.validators;

import org.infoglue.cms.exception.Bug;

public class Range {
    private int lowerLimit = 0;
    private int upperLimit = 0;
    private boolean hasUpperLimit = true;

    Range() {
        this.hasUpperLimit = false;
    }

    public Range(int upperLimit) {
        this(0, upperLimit);
    }

    public Range(int lowerLimit, int upperLimit) {
        if (lowerLimit < 0 || lowerLimit > upperLimit) {
            throw new Bug("Illegal arguments : lowerLimit=" + lowerLimit + ", upperLimit=" + upperLimit + ".");
        }
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    boolean isWithinLimits(int value) {
        return value >= this.lowerLimit && (!this.hasUpperLimit || value <= this.upperLimit);
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public boolean getHasUpperLimit() {
        return this.hasUpperLimit;
    }
}

